/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.exceptions.UnAuthorizedActionException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.mcp.background.JobsAction;
import oracle.dbtools.mcp.background.JobsHandler;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.raptor.backgroundTask.jobs.JobsProcessor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class RunSqlTool
implements McpTool {
    private static final String TOOL_NAME = "run-sql";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool(TOOL_NAME, "This tool executes SQL queries in an Oracle database. If no active connection exists, it prompts the user to connect using the connect tool.\n" + McpUtils.MCP_FIXED_ARGS_PROMPT + " Returns:\n        CSV-formatted results.\n" + McpUtils.MCP_MESSAGE_NOTE, Schemas.getSchema(Schemas.SchemaName.RUN_SQL_SCHEMA)), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents = new ArrayList<McpSchema.TextContent>();
            try {
                String command = McpUtils.optionalArgument(arguments, "command", null);
                int jobId = Integer.parseInt(McpUtils.optionalArgument(arguments, "job_id", "-1"));
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = exchange.getClientInfo().name();
                try {
                    QueryUtils.createDbtoolsMcpLogTable(ctx.getCurrentConnection());
                }
                catch (AuditTableException e) {
                    contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                }
                if (command != null && jobId != -1) {
                    JobsHandler handler = new JobsHandler();
                    JobsAction jobAction = JobsAction.valueOfIgnoreCase(command);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, McpUtils.McpCapabilities.TOOL, TOOL_NAME, McpMessages.format("JOB_LOG_MESSAGE", jobAction.displayName(), jobId));
                    JobsHandler.JobActionResult<?> result = handler.handle(jobId, jobAction);
                    if (result.isSuccess()) {
                        contents.add(new McpSchema.TextContent(result.result().toString()));
                    } else {
                        contents.add(new McpSchema.TextContent(result.message()));
                    }
                } else {
                    ParsedSql parsed;
                    ParseNode root;
                    String sql = McpUtils.requiredArgument(arguments, "sql");
                    boolean async = Boolean.parseBoolean(McpUtils.optionalArgument(arguments, "async", "false"));
                    String injectedComment = "/* LLM in use is " + McpUtils.sanitizeSqlComments(model) + " */";
                    String sanitizedQuery = McpUtils.injectAfterFirstWord(sql, injectedComment);
                    if (sanitizedQuery.toUpperCase().contains("DBTOOLS$MCP_LOG") && !(root = (parsed = new ParsedSql(sanitizedQuery)).getRoot()).contains("select")) {
                        throw new UnAuthorizedActionException(McpMessages.format("ONLY_SELECT_ALLOWED", "DBTOOLS$MCP_LOG"));
                    }
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, McpUtils.McpCapabilities.TOOL, TOOL_NAME, SqlRecognizer.reductPwd((String)sanitizedQuery));
                    ctx.putProperty("sql.format", (Object)McpUtils.MCP_RETURN_FORMAT);
                    if (async) {
                        Connection connection = ctx.getCurrentConnection();
                        JobsProcessor.init((ScriptRunnerContext)ctx);
                        JobsProcessor.Job job = JobsProcessor.run((ScriptRunnerContext)ctx, (Connection)connection, null, (String)sanitizedQuery, null, null);
                        contents.add(new McpSchema.TextContent(McpMessages.format("COMMAND_SET_IN_BACKGROUND", job.getId())));
                    } else if (ctx.getCurrentConnection() != null) {
                        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ctx).connection(ctx.getCurrentConnection()).build();
                        contents.add(new McpSchema.TextContent(sqlcl.run(sanitizedQuery)));
                    } else {
                        contents.add(new McpSchema.TextContent(McpMessages.getString("CONNECTION_NOT_ESTABLISHED")));
                    }
                }
            }
            catch (RuntimeException | SQLException e) {
                return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", e.getLocalizedMessage()))), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

