/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.ConnectionDetailsFactory;
import oracle.dbtools.extension.mcp.utils.ConnectionFilter;
import oracle.dbtools.extension.mcp.utils.ConnectionType;
import oracle.dbtools.extension.mcp.utils.ConnectionUtils;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ListConnectionsTool
implements McpTool {
    private final String toolName = "list-connections";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("list-connections", "Retrieves a list of connection names. A connection name can be used to connect to a database. The name of a connection may be arbitrary and should not be relied on to accurately describe the database connection, including the username provided for the connection or the database version. Listing connectionscan take a long time and you should wait for a response" + McpUtils.MCP_FIXED_ARGS_PROMPT, Schemas.getSchema(Schemas.SchemaName.LIST_CONNECTIONS_SCHEMA)), (exchange, arguments) -> {
            McpSchema.TextContent content;
            ConnectionType connType = ConnectionType.ALL;
            try {
                String name = McpUtils.optionalArgument(arguments, "name", "");
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String username = McpUtils.optionalArgument(arguments, "username", "");
                boolean showDetails = Boolean.parseBoolean(McpUtils.optionalArgument(arguments, "show_details", "false"));
                try {
                    connType = ConnectionType.valueOf(McpUtils.optionalArgument(arguments, "definition_type", "ALL"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String mcp_client = exchange.getClientInfo().name();
                ConnectionFilter[] filters = new ConnectionFilter[]{name.isEmpty() ? ConnectionFilter.DEFAULT_FILTER : ConnectionFilter.NameFilter.of(name), ConnectionFilter.ConnectionTypeFilter.of(connType), username.isEmpty() ? ConnectionFilter.DEFAULT_FILTER : ConnectionFilter.UserFilter.of(username)};
                List<ConnectionDetailsFactory.ConnectionDetails> connections = ConnectionUtils.listConnections(showDetails, filters);
                if (ctx.getCurrentConnection() != null) {
                    McpUtils.mcpLogs(ctx, "list-connections", model, mcp_client, McpUtils.McpCapabilities.TOOL, McpMessages.getString("LIST_CONNECTION_LOG_MESSAGE"));
                }
                content = new McpSchema.TextContent(String.join((CharSequence)",", connections.stream().map(ConnectionDetailsFactory.ConnectionDetails::getConnectionDisplay).toList()));
            }
            catch (SQLException | AuditTableException e) {
                return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", e.getLocalizedMessage()))), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(Collections.singletonList(content), Boolean.valueOf(false));
        });
    }
}

