/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketClientWithClientAuth {
    private static String a = "JKS";
    private static String b = "jks";

    public static TrustManager[] setupTrustManager(String string) throws Exception {
        KeyStore keyStore = null;
        keyStore = string.equals("JKS") ? KeyStore.getInstance(string) : KeyStore.getInstance(string, "OraclePKI");
        FileInputStream fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.trustStore"));
        keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
        String string2 = System.getProperty("test.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        System.out.println("  Using TrustManagerFactory = " + string2);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    public static KeyManager[] setupKeyManager(String string) throws Exception {
        KeyManager[] keyManagerArray = null;
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            KeyStore keyStore = null;
            keyStore = string.equals("JKS") ? KeyStore.getInstance(string) : KeyStore.getInstance(string, "OraclePKI");
            FileInputStream fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.keyStore"));
            keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
            String string2 = System.getProperty("test.keymanager.algorithm", KeyManagerFactory.getDefaultAlgorithm());
            System.out.println("  Using KeyManagerFactory   = " + string2);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
            keyManagerFactory.init(keyStore, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        return keyManagerArray;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        int n = -1;
        String string2 = null;
        String string3 = "JKS";
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        if (stringArray.length < 3) {
            System.out.println("USAGE: java SSLSocketClientWithClientAuth host port requestedfilepath");
            System.exit(-1);
        }
        try {
            string = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
            string2 = stringArray[2];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("USAGE: java SSLSocketClientWithClientAuth host port requestedfilepath");
            System.exit(-1);
        }
        try {
            String string4;
            Object object;
            SSLSocketFactory sSLSocketFactory = null;
            try {
                object = SSLContext.getInstance("TLS");
                TrustManager[] trustManagerArray = SSLSocketClientWithClientAuth.setupTrustManager(string3);
                KeyManager[] keyManagerArray = SSLSocketClientWithClientAuth.setupKeyManager(string3);
                ((SSLContext)object).init(keyManagerArray, trustManagerArray, null);
                sSLSocketFactory = ((SSLContext)object).getSocketFactory();
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            object = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            ((SSLSocket)object).setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            ((SSLSocket)object).startHandshake();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(((Socket)object).getOutputStream())));
            printWriter.println("GET " + string2 + " HTTP/1.1");
            printWriter.println();
            printWriter.flush();
            if (printWriter.checkError()) {
                System.out.println("SSLSocketClient: java.io.PrintWriter error");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object).getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                System.out.println(string4);
            }
            bufferedReader.close();
            printWriter.close();
            ((Socket)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

