/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.SyntaxErrors;
import oracle.dbtools.core.tns.Token;

class TokenParser
implements Consumer<Token> {
    private final Deque<OracleConfiguration.Builder> nodes = new ArrayDeque<OracleConfiguration.Builder>();
    private Token previousToken;
    private Context context;
    private int depth;

    private TokenParser(OracleConfiguration.Builder root) {
        this.nodes.push(root);
        this.context = Context.UNKNOWN;
    }

    TokenParser() {
        this(OracleConfiguration.builder());
    }

    OracleConfiguration configuration() {
        if (this.depth != 0) {
            throw SyntaxErrors.unbalancedParens(this.previousToken, null);
        }
        OracleConfiguration node = this.nodes.peek().build();
        if (node.size() == 0 && node.value() == null && node.name() != null) {
            return OracleConfiguration.builder().value(node.name()).build();
        }
        return node;
    }

    private void allowAtomOrStartList(Token token) {
        SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN);
    }

    private void allowAtomOrStartListOrEndList(Token token) {
        SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN, Token.Type.END);
    }

    private void allowAtom(Token token) {
        SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
    }

    private void allowEquals(Token token) {
        SyntaxErrors.allow(token, Token.Type.EQ);
    }

    private void allowSeparatorOrEndList(Token token) {
        SyntaxErrors.allow(token, Token.Type.SEPARATOR, Token.Type.END);
    }

    private void allowEndList(Token token) {
        SyntaxErrors.allow(token, Token.Type.END);
    }

    private void allowEndListOrStartList(Token token) {
        SyntaxErrors.allow(token, Token.Type.END, Token.Type.BEGIN);
    }

    private void allowUnquotedAtom(Token token) {
        SyntaxErrors.allow(token, Token.Type.UNQUOTED_ATOM);
    }

    @Override
    public void accept(Token token) {
        if (Context.UNKNOWN == this.context && Token.Type.UNQUOTED_ATOM == token.type()) {
            this.context = this.previousToken == null ? Context.LHS : Context.RHS;
        }
        OracleConfiguration.Builder builder = this.nodes.peek();
        if (this.previousToken == null) {
            this.allowAtomOrStartList(token);
        } else {
            switch (this.previousToken.type()) {
                case SINGLE_QUOTED_ATOM: 
                case DOUBLE_QUOTED_ATOM: {
                    if (Context.RHS == this.context) {
                        this.allowEndList(token);
                        break;
                    }
                    this.allowEquals(token);
                    break;
                }
                case UNQUOTED_ATOM: {
                    if (Context.RHS == this.context) {
                        this.allowSeparatorOrEndList(token);
                        break;
                    }
                    this.allowEquals(token);
                    break;
                }
                case SEPARATOR: {
                    this.allowUnquotedAtom(token);
                    break;
                }
                case EQ: {
                    this.allowAtomOrStartListOrEndList(token);
                    break;
                }
                case BEGIN: {
                    this.context = Context.LHS;
                    this.allowAtom(token);
                    break;
                }
                case END: {
                    this.allowEndListOrStartList(token);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected previous token: " + String.valueOf((Object)this.previousToken.type()));
                }
            }
        }
        switch (token.type()) {
            case EQ: {
                this.context = Context.RHS;
                break;
            }
            case SINGLE_QUOTED_ATOM: 
            case DOUBLE_QUOTED_ATOM: 
            case UNQUOTED_ATOM: {
                if (Context.RHS == this.context) {
                    builder.value(token.text());
                    break;
                }
                builder.name(token.text());
                break;
            }
            case SEPARATOR: {
                builder.value(",");
                break;
            }
            case BEGIN: {
                ++this.depth;
                if (this.previousToken == null) {
                    builder.renderMode(OracleConfiguration.RenderMode.REGULAR);
                }
                this.nodes.push(builder.begin());
                break;
            }
            case END: {
                --this.depth;
                if (this.depth < 0) {
                    throw SyntaxErrors.unbalancedParens(token, null);
                }
                builder.end();
                this.nodes.pop();
                break;
            }
            default: {
                throw SyntaxErrors.expected(token, Token.Type.EQ, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN, Token.Type.END);
            }
        }
        this.previousToken = token;
    }

    public String toString() {
        return this.nodes.getLast().toString();
    }

    private static enum Context {
        UNKNOWN,
        LHS,
        RHS;

    }
}

