/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import oracle.dbtools.core.io.Printable;
import oracle.dbtools.core.tns.EntryStream;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.SyntaxErrorReporter;

public class TnsValidate {
    private final Printable output;
    private final Printable error;
    private int entryCount;

    private TnsValidate(Builder builder) {
        this.error = builder.error;
        this.output = builder.output;
    }

    public static TnsValidate of(Appendable output, Appendable error) {
        return TnsValidate.builder().output(output).error(error).build();
    }

    public static void main(String ... args) throws Exception {
        Path path = Paths.get(args[0], new String[0]);
        TnsValidate validator = TnsValidate.of(System.out, System.out);
        validator.validate(path);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(Path path) throws IOException {
        boolean isFile = Files.isRegularFile(path, new LinkOption[0]);
        Path folder = isFile ? path.getParent() : path;
        Path file = isFile ? path : path.resolve("tnsnames.ora");
        this.validate(folder, file);
    }

    public void validate(Path folder, Path file) throws IOException {
        SyntaxErrorReporter errorReporter = SyntaxErrorReporter.of(this.error, file);
        OracleConfiguration.Parser parser = OracleConfiguration.Parser.builder(folder).errorHandler(errorReporter).build();
        try (EntryStream entries = parser.readEntries(file);){
            entries.forEach(entry -> {
                ++this.entryCount;
                this.summarize((OracleConfiguration.Entry)entry);
            });
        }
        this.summary(errorReporter.fileErrorCount());
    }

    private void summary(Map<URI, Integer> errorCounts) {
        Integer totalErrorCount = errorCounts.values().stream().reduce(0, Integer::sum);
        this.output.format("Validated %d entries, finding %d errors", this.entryCount, totalErrorCount);
    }

    private void summarize(OracleConfiguration.Entry entry) {
        OracleConfiguration.Position start = entry.start();
        OracleConfiguration.Position end = entry.end();
        if (start != null && end != null) {
            String range = String.valueOf(start.plus(1, 1)) + "-" + String.valueOf(end.plus(1, 1));
            for (String name : entry.names()) {
                this.output.println(range + name + " = " + entry.valueAsString(true));
            }
        }
    }

    public static final class Builder {
        private Printable error;
        private Printable output;

        private Builder() {
        }

        public Builder error(Appendable error) {
            this.error = Printable.of(error);
            return this;
        }

        public Builder output(Appendable output) {
            this.output = Printable.of(output);
            return this;
        }

        public TnsValidate build() {
            return new TnsValidate(this);
        }
    }
}

