/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Iterables;
import oracle.dbtools.core.collections.Slice;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.text.CharSequenceTrait;
import oracle.dbtools.core.tns.EntryParser;
import oracle.dbtools.core.tns.EntryStream;
import oracle.dbtools.core.tns.FileResolver;
import oracle.dbtools.core.tns.IncludeFiles;
import oracle.dbtools.core.tns.Lexer;
import oracle.dbtools.core.tns.OracleConfigurationDoesNotExistException;
import oracle.dbtools.core.tns.OracleConfigurationFileEncodingException;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;
import oracle.dbtools.core.tns.SyntaxErrors;
import oracle.dbtools.core.tns.Token;
import oracle.dbtools.core.tns.TokenParser;
import oracle.dbtools.core.tns.TokenStream;
import oracle.dbtools.core.util.Throwables;

public class OracleConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OracleConfiguration.class.getName());
    private static final Consumer<OracleConfigurationSyntaxException> DEFAULT_ERROR_HANDLER = Throwables::raise;
    private final RenderMode renderMode;
    private final List<OracleConfiguration> elements;
    private final Name name;
    private final String value;

    private OracleConfiguration(RenderMode renderMode, Name name, String value, List<OracleConfiguration> elements) {
        this.renderMode = renderMode;
        this.name = name;
        this.value = value;
        this.elements = elements;
    }

    private OracleConfiguration(Builder builder) {
        this(builder.renderMode, builder.name, builder.value.length() == 0 ? null : builder.value.toString(), List.copyOf(builder.elements));
    }

    private static Reader asReader(CharSequence content) {
        return InputOutputStreams.instance().asReader(content);
    }

    private static Reader asReader(Readable content) {
        return InputOutputStreams.instance().asReader(content);
    }

    private static void close(Closeable resource) {
        try {
            resource.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, Throwables.message(e), e);
        }
    }

    public static OracleConfiguration of(CharSequence content) {
        Builder builder = OracleConfiguration.builder();
        EntryStream entries = OracleConfiguration.read(OracleConfiguration.asReader(content), Throwables::raise);
        entries.forEach(entry -> entry.add(builder));
        return builder.build();
    }

    public static EntryStream read(Readable content, Consumer<OracleConfigurationSyntaxException> errorHandler) {
        return Entry.parser().parse(OracleConfiguration.asReader(content), errorHandler);
    }

    private static void render(StringBuilder text, OracleConfiguration node, RenderMode renderMode) {
        ValueType valueType;
        boolean isRoot;
        Name name = node.name();
        boolean bl = isRoot = name == null;
        if (RenderMode.REGULAR == renderMode && !isRoot) {
            text.append('(');
        }
        if (!isRoot) {
            text.append(name);
            text.append('=');
        }
        if (ValueType.ATOM == (valueType = node.valueType())) {
            String value = node.value().strip();
            boolean requiresQuoting = OracleConfiguration.requiresQuoting(value);
            if (requiresQuoting) {
                text.append("\"");
                text.append(value);
                text.append("\"");
            } else {
                text.append(value);
            }
        } else {
            for (OracleConfiguration element : node.elements()) {
                RenderMode childRenderMode = RenderMode.FILE == renderMode && isRoot ? RenderMode.TOP_LEVEL : RenderMode.REGULAR;
                OracleConfiguration.render(text, element, childRenderMode);
            }
        }
        if (RenderMode.REGULAR == renderMode && !isRoot) {
            text.append(')');
        } else if (RenderMode.TOP_LEVEL == renderMode && !isRoot) {
            text.append('\n');
        }
    }

    private static String render(OracleConfiguration element, RenderMode renderMode) {
        StringBuilder b = new StringBuilder();
        OracleConfiguration.render(b, element, renderMode);
        return b.toString();
    }

    private static boolean requiresQuoting(String text) {
        return !text.matches("\\S+") && (!text.startsWith("\"") || !text.endsWith("\""));
    }

    static OracleConfiguration of(Stream<Token> tokens) {
        Stream<Token> normalized = tokens.filter(OracleConfiguration::normalize);
        return normalized.collect(OracleConfiguration.toConfiguration());
    }

    static OracleConfiguration of(Collection<Token> tokens) {
        return OracleConfiguration.of(tokens.stream());
    }

    private static Collector<Token, TokenParser, OracleConfiguration> toConfiguration() {
        return new Collector<Token, TokenParser, OracleConfiguration>(){

            @Override
            public Supplier<TokenParser> supplier() {
                return TokenParser::new;
            }

            @Override
            public BiConsumer<TokenParser, Token> accumulator() {
                return TokenParser::accept;
            }

            @Override
            public BinaryOperator<TokenParser> combiner() {
                return (first, second) -> {
                    throw new UnsupportedOperationException();
                };
            }

            @Override
            public Function<TokenParser, OracleConfiguration> finisher() {
                return TokenParser::configuration;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of(Collector.Characteristics.UNORDERED);
            }
        };
    }

    private static boolean normalize(Token token) {
        switch (token.type()) {
            case COMMENT: 
            case EOL: 
            case WHITESPACE: {
                return false;
            }
        }
        return true;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    OracleConfiguration withName(CharSequence name) {
        Name n = Name.of(name);
        if (Objects.equals(this.name, n)) {
            return this;
        }
        return new OracleConfiguration(this.renderMode, n, this.value, this.elements);
    }

    OracleConfiguration withRenderMode(RenderMode renderMode) {
        if (Objects.equals((Object)this.renderMode, (Object)renderMode)) {
            return this;
        }
        return new OracleConfiguration(renderMode, this.name, this.value, this.elements);
    }

    public int size() {
        if (ValueType.ATOM == this.valueType()) {
            return -1;
        }
        return this.elements().size();
    }

    public OracleConfiguration get(int index) {
        if (ValueType.ATOM == this.valueType()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.elements().get(index);
    }

    public List<OracleConfiguration> elements() {
        return this.elements;
    }

    public Name name() {
        return this.name;
    }

    public String toString() {
        return this.toString(this.renderMode);
    }

    public String toString(RenderMode renderMode) {
        return OracleConfiguration.render(this, renderMode);
    }

    public String value() {
        return this.value;
    }

    public String valueToString() {
        switch (this.valueType().ordinal()) {
            case 0: {
                return this.value();
            }
        }
        StringBuilder text = new StringBuilder();
        this.elements().forEach(e -> OracleConfiguration.render(text, e, RenderMode.REGULAR));
        return text.toString();
    }

    public ValueType valueType() {
        return this.value == null ? ValueType.LIST : ValueType.ATOM;
    }

    public void write(Appendable output) throws IOException {
        output.append(this.toString());
    }

    public static enum RenderMode {
        FILE,
        REGULAR,
        TOP_LEVEL;

    }

    public static class Name
    implements CharSequenceTrait {
        private final String name;
        private final transient String normalized;

        private Name(String name) {
            this.name = name;
            this.normalized = name.toUpperCase(Locale.ROOT);
        }

        public static Name of(CharSequence name) {
            if (name == null) {
                return null;
            }
            if (name instanceof Name) {
                return (Name)name;
            }
            return new Name(name.toString());
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name name = (Name)o;
            return Objects.equals(this.normalized, name.normalized);
        }

        public int hashCode() {
            return Objects.hashCode(this.normalized);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final Function<OracleConfiguration, Builder> endListAction;
        private final List<OracleConfiguration> elements;
        private final StringBuilder value;
        private Name name;
        private RenderMode renderMode;

        private Builder(Function<OracleConfiguration, Builder> endListAction) {
            this.endListAction = endListAction;
            this.value = new StringBuilder();
            this.elements = new ArrayList<OracleConfiguration>();
            this.renderMode = RenderMode.FILE;
        }

        public Builder name(CharSequence name) {
            this.name = Name.of(name);
            return this;
        }

        public Builder renderMode(RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        public Builder value(CharSequence value) {
            if (value == null) {
                this.value.setLength(0);
            } else {
                this.elements.clear();
                this.value.append(value);
            }
            return this;
        }

        public Builder element(OracleConfiguration element) {
            this.value.setLength(0);
            this.elements.add(element);
            return this;
        }

        public Builder begin() {
            return new Builder(this::element);
        }

        public Builder end() {
            if (this.endListAction == null) {
                throw new IllegalStateException();
            }
            OracleConfiguration self = this.build();
            return this.endListAction.apply(self);
        }

        public Builder atom(CharSequence name, CharSequence value) {
            return this.element(OracleConfiguration.builder().name(name).value(value).build());
        }

        public OracleConfiguration build() {
            return new OracleConfiguration(this);
        }

        public String toString() {
            return this.build().toString();
        }
    }

    public static class Entry {
        private static final EntryParser ENTRY_PARSER = EntryParser.of(new Lexer());
        private final TokenStream lhs;
        private final TokenStream rhs;
        private transient OracleConfigurationSyntaxException error;
        private transient OracleConfiguration valueAsConfiguration;

        private Entry(TokenStream lhs, TokenStream rhs) {
            this.lhs = lhs.trim();
            this.rhs = rhs.trim();
        }

        static Entry of(Slice<Token> lhs, Slice<Token> rhs) {
            return new Entry(TokenStream.of(lhs), TokenStream.of(rhs));
        }

        static Entry of(Slice<Token> tokens) {
            int eq = Iterables.indexOf(tokens, token -> token.type() == Token.Type.EQ, 1);
            if (eq == -1) {
                if (tokens.size() == 1 && tokens.first().isValue()) {
                    return Entry.of(tokens, tokens);
                }
                return Entry.of(tokens, Slice.of());
            }
            Slice<Token> lhs = tokens.slice(0, eq);
            Slice<Token> rhs = tokens.slice(eq + 1);
            return Entry.of(lhs, rhs);
        }

        static EntryParser parser() {
            return ENTRY_PARSER;
        }

        public Set<String> names() {
            StringBuilder name = new StringBuilder();
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (Token token : this.lhs) {
                Token.Type type = token.type();
                if (Token.Type.SEPARATOR == type) {
                    names.add(name.toString());
                    name.setLength(0);
                    continue;
                }
                if (token.isValue()) {
                    name.append(token.text());
                    continue;
                }
                if (!token.isSemantic()) continue;
                name.append(token);
            }
            if (name.length() > 0) {
                names.add(name.toString());
            }
            return names;
        }

        private void validateName(Token token) {
            if (token.isSemantic()) {
                Token.Type type = token.type();
                if (Token.Type.BEGIN == type || Token.Type.END == type) {
                    throw SyntaxErrors.unbalancedParens(token, null);
                }
                SyntaxErrors.allow(token, Token.Type.UNQUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.SEPARATOR);
            }
        }

        public String name() {
            return (String)this.names().stream().findFirst().orElseThrow();
        }

        public String valueAsString() {
            return this.valueAsString(false);
        }

        public String valueAsString(boolean removeSpurious) {
            if (removeSpurious) {
                TokenStream tokens = this.rhs.filter(x$0 -> OracleConfiguration.normalize(x$0));
                return tokens.toString();
            }
            return this.rhs.toString();
        }

        public Position valuePosition() {
            return this.rhs.start();
        }

        void add(Builder builder) {
            OracleConfiguration configuration = this.valueAsConfiguration();
            for (String name : this.names()) {
                builder.element(configuration.withName(name));
            }
        }

        public OracleConfiguration valueAsConfiguration() {
            this.load();
            if (this.valueAsConfiguration == null) {
                throw this.error;
            }
            return this.valueAsConfiguration;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            boolean equal = Objects.equals(this.lhs, entry.lhs) && Objects.equals(this.rhs, entry.rhs);
            return equal;
        }

        public int hashCode() {
            return Objects.hash(this.lhs, this.rhs);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            if (!this.lhs.isEmpty()) {
                text.append(this.lhs);
                text.append("=");
            }
            if (!this.rhs.isEmpty()) {
                text.append(this.rhs);
            }
            return text.toString();
        }

        public String line(Position position) {
            return this.line(position.line());
        }

        public String line(int line) {
            int firstLine = -1;
            firstLine = !this.lhs.isEmpty() ? this.lhs.get(0).start().line() : (!this.rhs.isEmpty() ? this.rhs.get(0).start().line() : 0);
            int offset = line - firstLine;
            if (offset < 0) {
                throw new IndexOutOfBoundsException(line);
            }
            List lines = this.toString().lines().collect(Collectors.toList());
            return (String)lines.get(offset);
        }

        public boolean isValid() {
            return this.error() == null;
        }

        public OracleConfigurationSyntaxException error() {
            this.load();
            return this.error;
        }

        private void load() {
            if (this.error == null && this.valueAsConfiguration == null) {
                try {
                    this.lhs.forEach(this::validateName);
                    this.valueAsConfiguration = OracleConfiguration.of(this.rhs.stream());
                }
                catch (OracleConfigurationSyntaxException e) {
                    this.error = e;
                }
            }
        }

        public Position start() {
            return this.lhs.start();
        }

        public Position end() {
            return this.rhs.end();
        }
    }

    public static enum ValueType {
        ATOM,
        LIST;

    }

    public static class Position {
        int line;
        int column;

        private Position(Builder builder) {
            this.column = builder.column;
            this.line = builder.line;
        }

        static Builder builder() {
            return new Builder();
        }

        static Position of(int line, int column) {
            return Position.builder().line(line).column(column).build();
        }

        public int column() {
            return this.column;
        }

        public int line() {
            return this.line;
        }

        Position plus(int line, int column) {
            return Position.builder().line(this.line + line).column(this.column + column).build();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.line == position.line && this.column == position.column;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.column);
        }

        public String toString() {
            return "[" + this.line + ":" + this.column + "]";
        }

        static final class Builder {
            private int column;
            private int line;

            private Builder() {
            }

            Builder column(int column) {
                this.column = column;
                return this;
            }

            Builder line(int line) {
                this.line = line;
                return this;
            }

            Position build() {
                return new Position(this);
            }
        }
    }

    public static class SyntaxError {
        private final URI location;
        private final Kind kind;
        private final Position position;
        private final CharSequence message;

        private SyntaxError(Builder builder) {
            this.location = builder.location;
            this.kind = builder.kind;
            this.position = builder.position;
            this.message = builder.message;
        }

        static Builder builder() {
            return new Builder();
        }

        static SyntaxError of(Position position, String message) {
            return SyntaxError.builder().position(position).message(message).build();
        }

        Builder modify() {
            return SyntaxError.builder().location(this.location).kind(this.kind).position(this.position).message(this.message);
        }

        SyntaxError with(URI location) {
            if (Objects.equals(this.location, location)) {
                return this;
            }
            return this.modify().location(location).build();
        }

        SyntaxError with(Kind kind) {
            if (Objects.equals((Object)this.kind, (Object)kind)) {
                return this;
            }
            return this.modify().kind(kind).build();
        }

        public Kind kind() {
            return this.kind;
        }

        public URI location() {
            return this.location;
        }

        public CharSequence message() {
            return this.message;
        }

        public Position position() {
            return this.position;
        }

        static final class Builder {
            private URI location;
            private Position position;
            private CharSequence message;
            private Kind kind = Kind.GENERAL;

            private Builder() {
            }

            Builder position(Position position) {
                this.position = position;
                return this;
            }

            Builder message(CharSequence message) {
                this.message = message;
                return this;
            }

            Builder location(URI location) {
                this.location = location;
                return this;
            }

            Builder kind(Kind kind) {
                this.kind = Objects.requireNonNull(kind);
                return this;
            }

            SyntaxError build() {
                return new SyntaxError(this);
            }
        }

        public static enum Kind {
            GENERAL,
            UNBALANCED_PARENS,
            CONFIGURATION_DOES_NOT_EXIST,
            FILE_ENCODING,
            INVALID_FILENAME;


            static Kind of(Throwable cause) {
                if (cause instanceof MalformedInputException) {
                    return FILE_ENCODING;
                }
                if (cause instanceof NoSuchFileException) {
                    return CONFIGURATION_DOES_NOT_EXIST;
                }
                return GENERAL;
            }
        }
    }

    public static class Parser {
        private static final int DEFAULT_MAX_DEPTH = 4;
        private final Consumer<OracleConfigurationSyntaxException> errorHandler;
        private final Path folder;
        private final Charset platformCharset;
        private final int includeFilesMaximumDepth;

        private Parser(Builder builder) {
            this.errorHandler = builder.errorHandler;
            this.folder = builder.folder;
            this.platformCharset = builder.platformCharset;
            this.includeFilesMaximumDepth = builder.includeFilesMaximumDepth;
        }

        public static Builder builder(Path folder) {
            return Parser.builder().folder(folder);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Parser of(Path folder) {
            return Parser.builder(folder).build();
        }

        public EntryStream readEntries(Path file) throws IOException {
            try {
                return this.readEntries(file, StandardCharsets.UTF_8);
            }
            catch (OracleConfigurationFileEncodingException e) {
                return this.readEntries(file, this.platformCharset);
            }
        }

        public EntryStream readEntries(Path file, Charset charset) throws IOException {
            return this.readEntries(file, charset, 0);
        }

        private EntryStream readEntries(Path location, Charset charset, int currentDepth) throws IOException {
            if (currentDepth > this.includeFilesMaximumDepth) {
                return EntryStream.empty();
            }
            FolderResolver resolver = this.folder == null ? null : new FolderResolver(this.folder, charset, currentDepth + 1);
            IncludeFiles includeFiles = IncludeFiles.of(location.toUri(), resolver, this.errorHandler);
            BufferedReader content = Files.newBufferedReader(location, charset);
            try {
                EntryStream entries = Entry.parser().parse(OracleConfiguration.asReader(content), this.errorHandler).onClose(() -> OracleConfiguration.close(content));
                return includeFiles.read(entries);
            }
            catch (OracleConfigurationSyntaxException e) {
                OracleConfiguration.close(content);
                throw e.with(location.toUri());
            }
        }

        public OracleConfiguration readConfiguration(Path location) throws IOException {
            return this.readConfiguration(location, StandardCharsets.UTF_8);
        }

        public OracleConfiguration readConfiguration(Path location, Charset charset) throws IOException {
            oracle.dbtools.core.tns.OracleConfiguration$Builder builder = OracleConfiguration.builder();
            try (EntryStream entries2 = this.readEntries(location, charset);){
                entries2.forEach(entry -> entry.add(builder));
            }
            catch (OracleConfigurationDoesNotExistException entries2) {
            }
            catch (OracleConfigurationFileEncodingException e) {
                try (EntryStream entries3 = this.readEntries(location, this.platformCharset);){
                    entries3.forEach(entry -> entry.add(builder));
                }
            }
            return builder.build();
        }

        public static final class Builder {
            private Path folder;
            private Charset platformCharset = Charset.defaultCharset();
            private Consumer<OracleConfigurationSyntaxException> errorHandler = DEFAULT_ERROR_HANDLER;
            private int includeFilesMaximumDepth = 4;

            private Builder() {
            }

            public Builder platformCharset(Charset platformCharset) {
                this.platformCharset = platformCharset;
                return this;
            }

            public Builder errorHandler(Consumer<OracleConfigurationSyntaxException> errorHandler) {
                this.errorHandler = errorHandler;
                return this;
            }

            public Builder folder(Path folder) {
                this.folder = folder;
                return this;
            }

            public Builder includeFilesMaximumDepth(int includeFilesMaximumDepth) {
                this.includeFilesMaximumDepth = includeFilesMaximumDepth;
                return this;
            }

            public Parser build() {
                return new Parser(this);
            }
        }

        private class FolderResolver
        implements FileResolver {
            private final Path folder;
            private final Charset charset;
            private final int currentDepth;

            FolderResolver(Path folder, Charset charset, int currentDepth) {
                this.folder = folder;
                this.charset = charset;
                this.currentDepth = currentDepth;
            }

            @Override
            public EntryStream resolve(String fileName) throws IOException {
                Path path = this.folder.resolve(fileName);
                return Parser.this.readEntries(path, this.charset, this.currentDepth);
            }
        }
    }
}

