/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc.tns;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;

public final class TNSNames {
    private static final TNSNames EMPTY = new TNSNames(Collections.emptyMap());
    private static final InputOutputStreams STREAMS = InputOutputStreams.instance();
    private final Map<String, TNSEntry> tnsEntries;

    public static final TNSNames empty() {
        return EMPTY;
    }

    static final Builder builder() {
        return new Builder();
    }

    static final Builder builder(InputStream content) throws IOException {
        Builder b = TNSNames.builder();
        try (Reader r = STREAMS.reader(content);){
            NLParamParser parser = new NLParamParser(r);
            for (String serviceAlias : parser.getNLPAllNames()) {
                NVPair value = parser.getNLPListElement(serviceAlias);
                String connectionDescriptor = value.valueToString();
                TNSEntry tnsEntry = TNSEntry.builder(connectionDescriptor).build();
                b.set(serviceAlias, tnsEntry);
            }
        }
        catch (NLException e) {
            throw new IOException(e);
        }
        return b;
    }

    public static final TNSNames read(InputStream content) throws IOException {
        return TNSNames.builder(content).build();
    }

    private TNSNames(Map<String, TNSEntry> tnsEntries) {
        this.tnsEntries = Collections.unmodifiableMap(tnsEntries != null ? new TreeMap<String, TNSEntry>(tnsEntries) : new TreeMap());
    }

    public boolean isEmpty() {
        return this.tnsEntries.isEmpty();
    }

    public Set<String> nsNames() {
        return Collections.unmodifiableSet(this.tnsEntries.keySet());
    }

    public Collection<TNSEntry> tnsEntries() {
        return Collections.unmodifiableCollection(this.tnsEntries.values());
    }

    public TNSEntry getTNSEntry(String serviceAlias) {
        String normalized = serviceAlias.toUpperCase();
        TNSEntry tnsEntry = this.tnsEntries.get(normalized);
        return tnsEntry;
    }

    public Builder modify() {
        Builder b = new Builder(this.tnsEntries);
        return b;
    }

    public static final class Builder {
        private final Map<String, TNSEntry> tnsEntries = new LinkedHashMap<String, TNSEntry>();

        private Builder() {
            this(null);
        }

        private Builder(Map<String, TNSEntry> tnsEntries) {
            if (tnsEntries != null) {
                for (Map.Entry<String, TNSEntry> entry : tnsEntries.entrySet()) {
                    String key = entry.getKey().toString();
                    TNSEntry value = entry.getValue();
                    this.set(key, value);
                }
            }
        }

        public Builder set(String serviceAlias, TNSEntry tnsEntry) {
            if (tnsEntry == null) {
                this.tnsEntries.remove(serviceAlias.toUpperCase());
            } else {
                this.tnsEntries.put(serviceAlias.toUpperCase(), tnsEntry);
            }
            return this;
        }

        public TNSNames build() {
            return this.tnsEntries.isEmpty() ? EMPTY : new TNSNames(this.tnsEntries);
        }
    }
}

