/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc.configurators;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.DataSourceConfigurator;

public final class SessionConfiguration
implements DataSourceConfigurator {
    private final String programName;
    private final String terminal;
    private final String machine;
    private final String process;
    private final int timeout;

    public static Builder builder() {
        return new Builder();
    }

    private SessionConfiguration(String programName, String terminal, String machine, String process, int timeout) {
        this.programName = programName;
        this.terminal = terminal;
        this.machine = machine;
        this.process = process;
        this.timeout = timeout;
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws SQLException, IOException {
        Properties props = new Properties();
        if (this.programName != null) {
            props.setProperty("v$session.program", this.programName);
        }
        if (this.terminal != null) {
            props.setProperty("v$session.terminal", this.terminal);
        }
        if (this.machine != null) {
            props.setProperty("v$session.machine", this.machine);
        }
        if (this.process != null) {
            props.setProperty("v$session.process", this.process);
        }
        if (this.timeout > 0) {
            props.setProperty("oracle.net.CONNECT_TIMEOUT", String.valueOf(this.timeout));
        }
        dataSourceBuilder.connectionProperties(props);
    }

    public static final class Builder {
        private String programName;
        private String terminal;
        private String machine;
        private String process;
        private int timeout;

        private Builder() {
        }

        public Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public Builder terminal(String terminal) {
            this.terminal = terminal;
            return this;
        }

        public Builder machine(String machine) {
            this.machine = machine;
            return this;
        }

        public Builder process(String process) {
            this.process = process;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public SessionConfiguration build() {
            return new SessionConfiguration(this.programName, this.terminal, this.machine, this.process, this.timeout);
        }
    }
}

