/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io.file;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.dbtools.core.system.SystemContext;

public class HomeFolder {
    public static final String DBTOOLS_HOME_KEY = "oracle.dbtools.home";
    private static final String CONNECTIONS = "connections";
    private static final String SQLCL = "sqlcl";
    private static final String APP_DATA_ENVIRONMENT_VARIABLE = "APPDATA";
    private static final String WINDOWS_FOLDER = "DBTools";
    private static final String USER_HOME = "user.home";
    private static final String UNIX_FOLDER = ".dbtools";
    private static final String APP_DATA = "AppData";
    private static final String ROAMING = "Roaming";
    private final Path path;

    private HomeFolder(Builder builder) {
        this(HomeFolder.path(builder));
    }

    private HomeFolder(Path path) {
        this.path = path;
    }

    private static Path path(Builder builder) {
        Path explicit = builder.explicit;
        return explicit == null ? HomeFolder.path(builder.systemContext) : explicit;
    }

    private static Path path(SystemContext systemContext) {
        FileSystem fileSystem = systemContext.fileSystem();
        String toolsHome = systemContext.getSystemProperty(DBTOOLS_HOME_KEY);
        if (toolsHome != null && !toolsHome.isEmpty()) {
            return fileSystem.getPath(toolsHome, new String[0]);
        }
        switch (fileSystem.getSeparator()) {
            case "\\": {
                return HomeFolder.windowsPath(systemContext);
            }
        }
        return HomeFolder.unixPath(systemContext);
    }

    private static Path unixPath(SystemContext systemContext) {
        FileSystem fileSystem = systemContext.fileSystem();
        String userHome = systemContext.getSystemProperty(USER_HOME);
        Path unixPath = fileSystem.getPath(userHome, UNIX_FOLDER);
        return unixPath;
    }

    private static Path windowsPath(SystemContext systemContext) {
        Path appDataFolder;
        FileSystem fileSystem = systemContext.fileSystem();
        String appData = systemContext.getEnvironmentVariable(APP_DATA_ENVIRONMENT_VARIABLE);
        if (appData == null) {
            String userHome = systemContext.getSystemProperty(USER_HOME);
            appDataFolder = fileSystem.getPath(userHome, APP_DATA, ROAMING);
        } else {
            appDataFolder = fileSystem.getPath(appData, new String[0]);
        }
        Path windowsPath = appDataFolder.resolve(WINDOWS_FOLDER);
        return windowsPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HomeFolder ofSystem() {
        return HomeFolder.of(SystemContext.global());
    }

    public static HomeFolder of(SystemContext systemContext) {
        return HomeFolder.builder().systemContext(systemContext).build();
    }

    public static ValidationStatus validatePath(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return ValidationStatus.NOT_FOUND;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return ValidationStatus.NOT_FOLDER;
        }
        if (!Files.isWritable(path)) {
            return ValidationStatus.NOT_WRITABLE;
        }
        if (!Files.isReadable(path)) {
            return ValidationStatus.NOT_READABLE;
        }
        return ValidationStatus.VALID;
    }

    public Path path() {
        return this.path;
    }

    public Path connectionsPath() {
        return this.path().resolve(CONNECTIONS);
    }

    public Path sqlclPath() {
        return this.path().resolve(SQLCL);
    }

    public String toString() {
        return this.path.toString();
    }

    public Path resolve(String first, String ... more) {
        return this.path.resolve(this.path.getFileSystem().getPath(first, more));
    }

    public boolean isDefault() {
        return this.isDefault(SystemContext.global());
    }

    public boolean isDefault(SystemContext systemContext) {
        String customDBToolsHome = systemContext.getSystemProperty(DBTOOLS_HOME_KEY);
        return (customDBToolsHome == null || customDBToolsHome.isBlank()) && this.path().equals(HomeFolder.path(systemContext));
    }

    public static class Builder {
        private Path explicit;
        private SystemContext systemContext = SystemContext.global();

        private Builder() {
        }

        public Builder explicit(Path explicit) {
            this.explicit = explicit;
            return this;
        }

        public Builder systemContext(SystemContext systemContext) {
            this.systemContext = systemContext;
            return this;
        }

        public HomeFolder build() {
            return new HomeFolder(this);
        }
    }

    public static enum ValidationStatus {
        VALID,
        NOT_FOUND,
        NOT_FOLDER,
        NOT_READABLE,
        NOT_WRITABLE;

    }
}

