/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.Locale;
import oracle.dbtools.core.io.FormattedString;
import oracle.dbtools.core.io.PrintWriterAdaptor;

public interface PrintTrait<T extends PrintTrait<T>>
extends Appendable {
    public static final char NEW_LINE = '\n';

    default public T append(CharSequence csq) {
        return this.append(csq == null ? null : csq.toString());
    }

    default public T append(CharSequence csq, int start, int end) {
        CharSequence text = csq.subSequence(start, end);
        return (T)this.append(text);
    }

    default public T append(char c) {
        char[] buf = new char[]{c};
        CharBuffer csq = CharBuffer.wrap(buf);
        return (T)this.append(csq);
    }

    public T append(String var1) throws UncheckedIOException;

    default public PrintWriter asPrintWriter() {
        return PrintWriterAdaptor.of(this);
    }

    default public T format(Locale locale, String format, Object ... args) {
        return this.append(FormattedString.of(locale, format, args).toString());
    }

    default public T format(String format, Object ... args) {
        return this.format(this.locale(), format, args);
    }

    default public T indent(int n) {
        return this.print(" ".repeat(n));
    }

    default public Locale locale() {
        return Locale.getDefault();
    }

    default public T print(boolean value) {
        return this.write(String.valueOf(value));
    }

    default public T print(char value) {
        return (T)this.append(value);
    }

    default public T print(char[] value) {
        return this.write(String.valueOf(value));
    }

    default public T print(double value) {
        return this.write(String.valueOf(value));
    }

    default public T print(float value) {
        return this.write(String.valueOf(value));
    }

    default public T print(int value) {
        return this.write(String.valueOf(value));
    }

    default public T print(long value) {
        return this.write(String.valueOf(value));
    }

    default public T print(Object value) {
        return this.write(String.valueOf(value));
    }

    default public T print(String value) {
        return this.write(value == null ? "null" : value);
    }

    default public T printf(Locale locale, String format, Object ... args) throws IOException {
        return this.format(locale, format, args);
    }

    default public T printf(String format, Object ... args) {
        return this.format(format, args);
    }

    default public T println() {
        return this.write(10);
    }

    default public T println(boolean value) {
        return this.println(String.valueOf(value));
    }

    default public T println(char value) {
        return this.println(String.valueOf(value));
    }

    default public T println(char[] value) {
        return this.println(String.valueOf(value));
    }

    default public T println(double value) {
        return this.println(String.valueOf(value));
    }

    default public T println(float value) {
        return this.println(String.valueOf(value));
    }

    default public T println(int value) {
        return this.println(String.valueOf(value));
    }

    default public T println(long value) {
        return this.println(String.valueOf(value));
    }

    default public T println(Object value) {
        return this.println(String.valueOf(value));
    }

    default public T println(String value) {
        T self = this.print(value).println();
        return self;
    }

    default public T write(char[] text) {
        CharBuffer csq = CharBuffer.wrap(text);
        return (T)this.append(csq);
    }

    default public T write(char[] text, int offset, int length) {
        CharBuffer csq = CharBuffer.wrap(text, offset, length);
        return (T)this.append(csq);
    }

    default public T write(int character) {
        char c = (char)character;
        return (T)this.append(c);
    }

    default public T write(String text) {
        return this.append(text);
    }

    default public T write(String text, int offset, int length) {
        return (T)this.append(text, offset, offset + length);
    }
}

