/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers.ora;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.connections.helpers.BaseConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectCredentials;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ora.Constants;
import oracle.dbtools.core.connections.storage.Wallet;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.impl.OracleDataSource;

public abstract class BaseOracleConnectionHelper
extends BaseConnectionHelper
implements Constants {
    private static final String DEFAULT_WALLET_LOCATION = "(SOURCE=(METHOD=FILE)(METHOD_DATA=(DIRECTORY=${TNS_ADMIN})))";

    protected BaseOracleConnectionHelper(ConnectionHelperContext ctx) {
        super(ctx);
    }

    protected String getDriverType() {
        return "thin";
    }

    @Override
    public String getURL() {
        String url = this.getDbtoolsProperty("url");
        return url != null ? url : MessageFormat.format("jdbc:oracle:{0}:@//{1}", this.getDriverType(), this.getConnectionSpec());
    }

    private TextSecret getPasswordFromWallet() {
        Wallet wallet = this.definition.getWallet();
        return wallet.getPassword();
    }

    private boolean hasStoredPassword() {
        TextSecret pwd = this.getPasswordFromWallet();
        return pwd.isPresent();
    }

    @Override
    public String getUsername() {
        return BaseOracleConnectionHelper.getUsername(this.definition);
    }

    @Override
    public TextSecret getPassword() {
        return this.getPasswordFromWallet();
    }

    protected String getConnectionName() {
        return this.definition.getConnectionName();
    }

    protected String getDbtoolsProperty(String key) {
        return BaseOracleConnectionHelper.getDbtoolsProperty(this.definition, key);
    }

    protected String getAdvancedProperty(String key) {
        return this.definition.getOjdbcProperties().getProperty(key);
    }

    @Override
    public Connection createConnection(ConnectCredentials credentials, Properties productProperties) throws SQLException {
        OracleDataSource dataSource = new OracleDataSource();
        dataSource.setConnectionProperties(productProperties);
        Properties userProperties = this.configureCredentials(credentials);
        for (String key : userProperties.stringPropertyNames()) {
            dataSource.setConnectionProperty(key, userProperties.getProperty(key));
        }
        dataSource.setURL(this.getURL());
        this.configureDataSource((oracle.jdbc.datasource.OracleDataSource)dataSource);
        Connection conn = dataSource.getConnection();
        if (this.requiresProxySession()) {
            Connection orig = conn;
            try {
                conn = this.createProxySession(orig);
            }
            catch (SQLException e) {
                try {
                    orig.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
        }
        return conn;
    }

    protected Properties configureCredentials(ConnectCredentials credentials) {
        TextSecret password;
        String username;
        Properties userProperties = new Properties();
        String role = null;
        if (credentials == null) {
            username = this.getUsername();
            password = this.getPasswordFromWallet();
            role = this.getAdvancedProperty("internal_logon");
        } else {
            username = credentials.getUsername();
            password = credentials.getPassword();
            role = credentials.getRole();
        }
        if (this.isSet(username)) {
            userProperties.setProperty("user", username);
        }
        if (password.isPresent()) {
            userProperties.setProperty("password", password.map(String::new));
        }
        if (this.isSet(role)) {
            userProperties.setProperty("internal_logon", role);
        }
        return userProperties;
    }

    @Override
    public ConnectCredentials getCredentials() {
        String username = this.getUsername();
        TextSecret password = this.getPassword();
        String role = this.getAdvancedProperty("internal_logon");
        return ConnectCredentials.of(username, password, role);
    }

    protected void configureDataSource(oracle.jdbc.datasource.OracleDataSource datasource) throws SQLException {
        String walletLocation;
        Path connectionDir;
        ConfigurationProperties ojdbcProps = this.definition.getOjdbcProperties();
        for (String key : ojdbcProps.keySet()) {
            if ("internal_logon".equals(key) || datasource.getConnectionProperty(key) != null && !"oracle.net.tns_admin".equals(key)) continue;
            datasource.setConnectionProperty(key, ojdbcProps.getProperty(key));
        }
        if (!ojdbcProps.containsKey("oracle.net.tns_admin") && (connectionDir = this.definition.getConnectionDirectory()) != null && Files.isRegularFile(connectionDir.resolve("tnsnames.ora"), new LinkOption[0])) {
            String dirName = connectionDir.toString();
            datasource.setConnectionProperty("oracle.net.tns_admin", dirName);
        }
        if (this.definition.hasCertificateWallet() && (walletLocation = this.getAdvancedProperty("oracle.net.wallet_location")) == null) {
            datasource.setConnectionProperty("oracle.net.wallet_location", DEFAULT_WALLET_LOCATION);
        }
    }

    @Override
    public Collection<ConnectionHelper.DisplayEntry> getDisplayProperties() {
        ArrayList<ConnectionHelper.DisplayEntry> properties = new ArrayList<ConnectionHelper.DisplayEntry>();
        properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_NAME"), this.getConnectionName()));
        properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_CONN_SPEC"), this.getConnectionSpec(), false));
        properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_USER"), this.getUsername()));
        String pwdDisplay = this.hasStoredPassword() ? "******" : ConnectionsResources.getString("SHOW_PASSWORD_UNSAVED");
        properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_PASSWORD"), pwdDisplay));
        String proxyUser = this.getDbtoolsProperty("proxyUserName");
        if (BaseOracleConnectionHelper.hasLength(proxyUser)) {
            properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_PROXY_USER"), proxyUser));
            String proxyPwd = this.definition.getWallet().getProxyPassword().isPresent() ? "******" : ConnectionsResources.getString("SHOW_PROXY_PWD_NOT_PRESENT");
            properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_PROXY_PWD"), proxyPwd));
        } else {
            String proxyDN = this.getDbtoolsProperty("proxyDistinguishedName");
            if (BaseOracleConnectionHelper.hasLength(proxyDN)) {
                properties.add(BaseOracleConnectionHelper.createDisplayEntry(ConnectionsResources.getString("SHOW_PROXY_DN"), proxyDN));
            }
        }
        ConfigurationProperties ojdbcProperties = this.definition.getOjdbcProperties();
        ojdbcProperties.keySet().forEach(k -> properties.add(BaseOracleConnectionHelper.createDisplayEntry(k, ojdbcProperties.getProperty((CharSequence)k))));
        return properties;
    }

    protected boolean requiresProxySession() {
        return BaseOracleConnectionHelper.hasLength(this.getDbtoolsProperty("proxyUserName")) || BaseOracleConnectionHelper.hasLength(this.getDbtoolsProperty("proxyDistinguishedName"));
    }

    protected Connection createProxySession(Connection conn) throws SQLException {
        int proxyType = -1;
        Properties proxyProps = new Properties();
        String proxyUser = this.getDbtoolsProperty("proxyUserName");
        String proxyDU = this.getDbtoolsProperty("proxyDistinguishedName");
        if (BaseOracleConnectionHelper.hasLength(proxyUser)) {
            proxyType = 1;
            proxyProps.setProperty("PROXY_USER_NAME", proxyUser);
            TextSecret proxyPwd = this.definition.getWallet().getProxyPassword();
            if (proxyPwd.isPresent()) {
                proxyProps.setProperty("PROXY_USER_PASSWORD", proxyPwd.map(String::new));
            }
        } else if (BaseOracleConnectionHelper.hasLength(proxyDU)) {
            proxyType = 2;
            proxyProps.setProperty("PROXY_DISTINGUISHED_NAME", proxyDU);
        }
        if (proxyType < 0) {
            throw new SQLException(ConnectionsResources.getString("ERROR_INVALID_PROXY_SESSION_CONFIGURATION"));
        }
        ((OracleConnection)conn).openProxySession(proxyType, proxyProps);
        return conn;
    }
}

