/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.folder.utils;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.folder.Folder;
import oracle.dbtools.core.connections.folder.utils.PathsUtils;
import oracle.dbtools.core.connections.storage.ConnectionReference;
import oracle.dbtools.core.connections.storage.ConnectionStorage;

public final class FolderUtils {
    public static final String INVALID_FOLDER_NAME_REGEX = "^(\\.|\\.\\.|.*[/%].*|.*%[0-9a-fA-F]{2}.*)$";
    private static final Pattern INVALID_FOLDER_NAME_PATTERN = Pattern.compile("^(\\.|\\.\\.|.*[/%].*|.*%[0-9a-fA-F]{2}.*)$");

    private FolderUtils() {
    }

    public static Optional<Folder> findFolder(Folder rootFolder, String path) {
        Folder currentFolder;
        if (PathsUtils.isRoot(path)) {
            return Optional.ofNullable(currentFolder);
        }
        String[] pathSegments = PathsUtils.getPathSegments(path);
        int pathLength = pathSegments.length;
        int i = 0;
        for (currentFolder = rootFolder; i < pathLength && currentFolder != null; currentFolder = currentFolder.getSubFolder(pathSegments[i++])) {
        }
        return Optional.ofNullable(currentFolder);
    }

    public static Optional<Folder> findFolderByConnection(Folder root, Connections.Identifier connId) {
        return FolderUtils.findFolderByConnection(root, connId, true);
    }

    public static Optional<String> findConnectionPath(Folder rootFolder, String connId) {
        StringBuilder pathBuilder = new StringBuilder();
        if (FolderUtils.isConnectionPathFound(rootFolder, connId, pathBuilder)) {
            return Optional.of(pathBuilder.toString());
        }
        return Optional.empty();
    }

    public static Optional<Folder> findFolderByConnection(Folder root, Connections.Identifier connId, boolean includeFsSearch) {
        if (root == null || connId == null) {
            return Optional.empty();
        }
        Optional<Folder> folder = FolderUtils.findFirst(root, f -> f.getConnections().contains(connId));
        if (folder.isPresent()) {
            return folder;
        }
        if (includeFsSearch) {
            Optional<Connections.Identifier> fsConnection = ConnectionStorage.instance().listConnectionDirectories().stream().map(ConnectionStorage.instance()::loadConnectionReference).map(ConnectionReference::getConnectionIdentifier).filter(identifier -> Objects.equals(identifier, connId)).findFirst();
            if (fsConnection.isPresent()) {
                return Optional.of(root);
            }
        }
        return Optional.empty();
    }

    public static Optional<Folder> findFirst(Folder root, Predicate<Folder> condition) {
        if (root == null) {
            return Optional.empty();
        }
        if (condition.test(root)) {
            return Optional.of(root);
        }
        if (root.getSubFolders().isEmpty()) {
            return Optional.empty();
        }
        for (Folder subFolder : root.getSubFolders().values()) {
            Optional<Folder> f = FolderUtils.findFirst(subFolder, condition);
            if (!f.isPresent()) continue;
            return f;
        }
        return Optional.empty();
    }

    private static boolean isConnectionPathFound(Folder folder, String connId, StringBuilder pathBuilder) {
        pathBuilder.append(folder.getName() == null ? "" : folder.getName()).append("/");
        if (folder.getConnections().contains(connId)) {
            return true;
        }
        for (Folder subFolder : folder.getSubFolders().values()) {
            int originalLength = pathBuilder.length();
            if (FolderUtils.isConnectionPathFound(subFolder, connId, pathBuilder)) {
                return true;
            }
            pathBuilder.setLength(originalLength);
        }
        return false;
    }

    public static boolean isNotValidName(String folderName) {
        return folderName == null || INVALID_FOLDER_NAME_PATTERN.matcher(folderName).matches();
    }
}

