/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.collections;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Iterables {
    public static <T> List<T> list(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static <T> int indexOf(Iterable<T> items, Predicate<T> condition) {
        return Iterables.indexOf(items, condition, 0);
    }

    public static <T> int indexOf(Iterable<T> items, Predicate<T> condition, int fromIndex) {
        int index = 0;
        for (T item : items) {
            if (index >= fromIndex && condition.test(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

