/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.collections;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationProperties
extends AbstractMap<String, String> {
    private static final ConfigurationProperties EMPTY = new ConfigurationProperties(Collections.emptyMap());
    private final Map<String, String> values;

    private ConfigurationProperties(Builder builder) {
        this(new LinkedHashMap<String, String>(builder.values));
    }

    private ConfigurationProperties(Map<String, String> values) {
        this.values = values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConfigurationProperties of(Map<? extends Object, ? extends Object> properties) {
        if (properties instanceof ConfigurationProperties) {
            return (ConfigurationProperties)properties;
        }
        Builder builder = ConfigurationProperties.builder();
        if (properties != null) {
            for (Map.Entry<? extends Object, ? extends Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                builder.put(key.toString(), value.toString());
            }
        }
        return builder.build();
    }

    public static ConfigurationProperties read(InputStream content) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);){
            ConfigurationProperties configurationProperties = ConfigurationProperties.read(reader);
            return configurationProperties;
        }
    }

    public static ConfigurationProperties read(Reader content) throws IOException {
        Builder builder = ConfigurationProperties.builder();
        Properties props = new Properties();
        props.load(content);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            builder.set(name, value);
        }
        return builder.build();
    }

    public static ConfigurationProperties empty() {
        return EMPTY;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.values.entrySet();
    }

    public String getProperty(CharSequence name) {
        return (String)this.get(name.toString());
    }

    public Builder modify() {
        Builder b = ConfigurationProperties.builder();
        this.values.forEach(b::set);
        return b;
    }

    public ConfigurationProperties withProperty(CharSequence name, String value) {
        return this.modify().set(name, value).build();
    }

    public void write(OutputStream output) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            this.write(writer);
        }
    }

    public void write(Writer writer) throws IOException {
        OrderedProperties props = new OrderedProperties(this.values);
        props.store(new NoCommentsWriter(writer), null);
    }

    public static class Builder
    extends AbstractMap<String, String> {
        private final Map<String, String> values = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public ConfigurationProperties build() {
            if (this.values.isEmpty()) {
                return ConfigurationProperties.empty();
            }
            return new ConfigurationProperties(this);
        }

        @Override
        public String put(String key, String value) {
            return this.values.put(key, value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.values.entrySet();
        }

        public Builder remove(CharSequence name) {
            return this.set(name, null);
        }

        public Builder set(CharSequence name, String value) {
            String key = name.toString();
            if (value == null) {
                this.values.remove(key);
            } else {
                this.values.put(key, value);
            }
            return this;
        }
    }

    private static class OrderedProperties
    extends Properties {
        private final Map<String, String> properties;

        OrderedProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.properties.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public String toString() {
            return this.properties.toString();
        }
    }

    private static class NoCommentsWriter
    extends BufferedWriter {
        public NoCommentsWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(String line) throws IOException {
            if (!line.startsWith("#") && !line.trim().isBlank()) {
                super.write(line);
                super.write("\n");
            }
        }
    }
}

