/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Settings {
    public static final String NULL_STR = "null";
    public static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Logger LOGGER;
    private float loadedVersion = 1.1f;
    public static String fileVersion;
    public static final String SETTINGS_FILE_NAME = "settings.xml";
    public static final String DEFAULT_RDBMS_SITES_FILE = "defaultRDBMSSites.xml";
    public static final String DEFAULT_DOMAINS_FILE = "defaultdomains.xml";
    public static final String DEFAULT_TYPES_FILE = "types.xml";
    public static final String DEFAULT_MASK_TEMPLATES_FILE = "maskTemplates.xml";
    public static final String DEFAULT_SENSITIVE_TYPES_FILE = "sensitiveTypes.xml";
    public static final String DEFAULT_TSDP_POLICIES_FILE = "tsdpPolicies.xml";
    public static final String SETTINGS_ELEMENT = "settings";
    private static final String SETTINGS_VERSION = "version";
    public static final String DEFAULT_PROJECT_PATH_ELEMENT = "def_proj_path";
    public static final String DEFAULT_DDL_FILES_PATH_ELEMENT = "def_ddl_files_path";
    public static final String INCLUDE_DESIGN_NAME_IN_DDL_FILES_PATH = "incl_des_name_in_ddl_files_path";
    public static final String TAG_VALUE = "value";
    public static final String TAG_ID = "id";
    public static final String TAG_FILENAME = "filename";
    public static final char NEW_LINE = '\n';
    public static final char TAB = '\t';
    public static final String X = "x";
    public static final String Y = "y";
    public static final String W = "w";
    public static final String H = "h";
    public static final String TREE_PATH = "treepath";
    public static final String DIVIDER_LOCATION = "dividerLocation";
    public static final String SYNCHRONIZE_TREE_ELEMENT = "synchronize_tree";
    public static final String GRID_SIZE_ELEMENT = "grid_size";
    public static final String SHOW_IMPORT_LOG = "show_import_log";
    public static final String DEFAULT_IMPORT_PATH_ELEMENT = "def_import_path";
    public static final String DEFAULT_SAVE_PATH_ELEMENT = "def_save_path";
    public static final String DEFAULT_REPORTS_PATH_ELEMENT = "def_reports_path";
    public static final String DEFAULT_SAXON_PATH_ELEMENT = "def_saxon_path";
    public static final String COMPANY_NAME_ELEMENT = "company_name";
    public static final String USE_PAGE_BREAKS_ELEMENT = "use_page_breaks";
    public static final String EMBED_DIAGRAMS_IN_REPORTS = "embed_diagrams_in_reports";
    public static final String EMBED_MAIN_DIAGRAM_IN_REPORTS = "embed_main_diagram_in_reports";
    public static final String REMOVE_SCHEMA_NAME_FROM_REPORT = "remove_schema_name_from_report";
    public static final String GROUP_BY_SCHEMA_NAME_IN_REPORT = "group_by_schema_name_in_report";
    public static final String GENERATE_HTML_REPORT_TOC_IN_SEPARATE_FILE = "generate_html_report_toc_in_separate_file";
    public static final String INCLUDE_SELECT_STATEMENT_IN_VIEW_REPORT = "include_select_statement_in_view_report";
    public static final String DEFAULT_SEARCH_PROFILES_PATH_ELEMENT = "def_search_profiles_path";
    public static final String DEFAULT_SYS_TYPES_PATH_ELEMENT = "def_sys_types_path";
    public static final String DEFAULT_RDBMS_SITE = "default_rdbms_site";
    public static final String DEFAULT_RDBMS_TYPE = "default_rdbms_type";
    public static final String NULLS_ALLOWED = "nulls_allowed";
    public static final String ALLOW_SIMILAR_TYPES_FK = "allow_similar_types_fk";
    public static final String FK_COLUMN_ON_NEW_FK_OPTION = "fk_column_on_new_fk_option";
    public static final String COLUMN_DEFAULT_DATATYPE = "column_default_datatype";
    public static final String NEW_DB2_TABLESPACE_PER_TABLE = "new_db2_tablespace_per_table";
    public static final String NEW_DB2_STORAGETEMPLATE_PER_TABLESPACE = "new_db2_storagetemplate_per_tablesapce";
    public static final String NEW_DB2_STORAGETEMPLATE_PER_INDEX = "new_db2_storagetemplate_per_index";
    public static final String ONE_DB2_STORAGETEMPLATE_PER_TS = "one_db2_storagetemplate_per_ts";
    public static final String ONE_DB2_STORAGETEMPLATE_PER_INDEX = "one_db2_storagetemplate_per_index";
    public static final String DEFAULT_TS_STORAGETEMPLATE_NAME = "default_ts_storagetemplate_name";
    public static final String DEFAULT_INDEX_STORAGETEMPLATE_NAME = "default_index_storagetemplate_name";
    public static final String DEFAULT_DB2_OWNER = "db2_owner";
    public static final String DEFAULT_DB2_DATABASE = "db2_database";
    public static final String DEFAULT_DB2_TRIGGER_NAME = "db2_trigger_name";
    public static final String DEFAULT_DB2_SEQUENCE_NAME = "db2_sequence_name";
    public static final String DEFAULT_DB2_AUTO_INC_DDL = "db2_auto_inc_ddl";
    public static final String DEFAULT_DB2_IDENTITY_DDL = "db2_identity_ddl";
    public static final String NAMING_RULE_TABLESPACE = "naming_rule_tablespace_db2";
    public static final String NAMING_RULE_ST_TABLESPACE = "naming_rule_st_tablespace_db2";
    public static final String NAMING_RULE_ST_INDEX = "naming_rule_st_index_db2";
    public static final String DEFAULT_ORACLE_USER = "oracle_user";
    public static final String DEFAULT_ORACLE_TABLESPACE = "oracle_tablespace";
    public static final String DEFAULT_ORACLE_TRIGGER_NAME = "oracle_trigger_name";
    public static final String DEFAULT_ORACLE_SEQUENCE_NAME = "oracle_sequence_name";
    public static final String DEFAULT_ORACLE_AUTO_INC_DDL = "oracle_auto_inc_ddl";
    public static final String DEFAULT_ORACLE_IDENTITY_DDL = "oracle_identity_ddl";
    public static final String USE_ORACLE_TABLE_TEMPLATE = "use_oracle_table_template";
    public static final String USE_ORACLE_INDEX_TEMPLATE = "use_oracle_index_template";
    public static final String DEFAULT_SQL_SERVER_DATABASE = "sql_server_database";
    public static final String DEFAULT_SQL_SERVER_TRIGGER_NAME = "sql_server_trigger_name";
    public static final String DEFAULT_SQL_SERVER_SEQUENCE_NAME = "sql_server_sequence_name";
    public static final String DEFAULT_SQL_SERVER_AUTO_INC_DDL = "sql_server_auto_inc_ddl";
    public static final String DEFAULT_SQL_SERVER_IDENTITY_DDL = "sql_server_identity_ddl";
    public static final String DEFAULT_UDB_OWNER = "udb_owner";
    public static final String DEFAULT_UDB_TRIGGER_NAME = "udb_trigger_name";
    public static final String DEFAULT_UDB_SEQUENCE_NAME = "udb_sequence_name";
    public static final String DEFAULT_UDB_AUTO_INC_DDL = "udb_auto_inc_ddl";
    public static final String DEFAULT_UDB_IDENTITY_DDL = "udb_identity_ddl";
    public static final String SHOW_SELECT_RELATIONAL_MODEL_DIALOG = "show_select_rel_model_dialog";
    public static final String RESTORE_DL_SETTINGS_AFTER_CLOSE = "restore_dl_settings_after_close";
    public static final String SHOW_PROPERTIES_DIALOG_ON_NEW = "show_properties_dialog_on_new";
    public static final String SOURCE_OPTIONAL = "source_optional";
    public static final String TARGET_OPTIONAL = "target_optional";
    public static final String DELETE_FK_COLUMNS_STRATEGY = "delete_fk_columns_strategy";
    public static final String DEFAULT_ALLOW_COLUMNS_REORDER = "allow_columns_reorder";
    public static final String SYNC_REMOTE_OBJECTS_ON_LOAD = "sync_remote_objects_on_load";
    public static final String SURROGATE_KEY_LDT_PRECESION = "surrogate_key_ldt_precision";
    public static final String SURROGATE_KEY_DOMAIN = "surrogate_key_domain";
    public static final String DEFAULT_CREATE_SURROGATE_KEY = "def_create_surrogate_key";
    public static final String DEFAULT_USE_SURROGATE_KEY = "def_use_surrogate_key";
    public static final String CUSTOM_PREFIX = "customPrefix";
    public static final String RENAME_STRATEGY = "renameStrategy";
    public static final String DIALOGS_SETTINGS = "dialogs_settings";
    public static final String CUSTOM_SETTINGS = "custom_settings";
    public static final String ORACLE_TEMPLATES = "oracle_templates";
    public static final String ORACLE_TABLE_TEMPLATE = "oracle_table_template";
    public static final String ORACLE_INDEX_TEMPLATE = "oracle_index_template";
    public static final String OTT_TEMPORARY = "ott_temporary";
    public static final String OTT_PRESERVE_ROWS = "ott_preserve_rows";
    public static final String OTT_TABLESPACE = "ott_tableSpace";
    public static final String OTT_ORGANIZATION = "ott_organization";
    public static final String OTT_LOGGING = "ott_logging";
    public static final String OTT_SEGMENT = "ott_segment";
    public static final String OTT_CACHE = "ott_cache";
    public static final String OTT_MONITORING = "ott_monitoring";
    public static final String OTT_PARALLEL = "ott_parallel";
    public static final String OTT_DEGREE = "ott_degree";
    public static final String OTT_ROW_DEPENDENCY = "ott_row_dependency";
    public static final String OTT_PARTITIONED = "ott_partitioned";
    public static final String OTT_ROW_MOVEMENT = "ott_row_movement";
    public static final String OTT_DATA_COMPRESSION = "ott_data_compression";
    public static final String OTT_REJECT_LIMIT = "ott_reject_limit";
    public static final String OIT_BITMAP_INDEX = "oit_bitmap_index";
    public static final String OIT_PARTITIONED = "oit_partitioned";
    public static final String OIT_TABLESPACE = "oit_tablespace";
    public static final String OIT_LOGGING = "oit_logging";
    public static final String OIT_SEGMENT = "oit_segment";
    public static final String OIT_COMPRESS = "oit_compress";
    public static final String OIT_PARALLEL = "oit_parallel";
    public static final String OIT_DEGREE = "oit_degree";
    public static final String OIT_SORTED_ROWS = "oit_sorted_rows";
    public static final String OIT_COMPUTE_STATS = "oit_compute_stats";
    public static final String OIT_ONLINE = "oit_online";
    public static final String PK_IDENTIFYING_RELATION = "pk_identifying_relation";
    public static final String KEEP_FK_NAMES_SYNCHRONIZED = "keep_fk_names_syncronized";
    public static final String PROPAGATE_PK_ATTR_NOTES = "propagate_pk_attr_notes";
    public static final String NOTATION = "notation";
    public static final String FK_2_PK_ARROW = "fk2pkArrow";
    public static final String AUTO_JOIN_ON_FK = "autoJoinOnFK";
    public static final String BOX_IN_BOX = "box_in_box";
    public static final String DB2_TERM_CHAR = "db2_term_char";
    public static final String TYPE_SUBST_TRIGGERS = "type_subst_triggers";
    public static final String FKARC_TRIGGERS = "fkarct_triggers";
    public static final String FKNONETRANSF_TRIGGERS = "fk_none_transferable_triggers";
    public static final String SHOW_CHAR_BYTE_IN_DDL = "show_char_byte_in_ddl";
    public static final String EXTENDED_SIZE_FOR_CHARS = "extended_size_for_chars";
    public static final String USE_DATA_TYPE_KIND_IN_COMPARE = "use_data_type_kind_in_compare";
    public static final String USE_SCHEMA_PROPERTY_IN_COMPARE = "use_schema_property_in_compare";
    public static final String USE_COLUMNS_ORDER_PROPERTY_IN_COMPARE = "use_columns_order_property_in_compare";
    public static final String INCLUDE_PHYSICAL_PROPERTIES_IN_COMPARE = "include_physical_properties_in_compare";
    public static final String INCLUDE_STORAGE_PROPERTIES_IN_COMPARE = "include_storage_properties_in_compare";
    public static final String USE_CASE_SENSITIVE_NAMES_IN_COMPARE = "use_case_sensitive_names_in_compare";
    public static final String INCLUDE_SYSTEM_NAMES_IN_COMPARE = "include_system_names_in_compare";
    public static final String USE_GEN_IN_DDL_IN_COMPARE = "use_gen_in_ddl_in_compare";
    public static final String GENERATE_COMMENTS_IN_RDBMS = "generate_comments_in_rdbms";
    public static final String GENERATE_INLINE_COLUMN_CC = "generate_inline_column_cc";
    public static final String GENERATE_VALID_VALUE_CC = "generate_valid_value_cc";
    public static final String NOT_NULL_SHORT_FORM_GENERATION = "not_null_short_form_generation";
    public static final String USE_QUOTED_IDENTIFIERS = "use_quoted_identifiers";
    public static final String CREATE_DOMAINS_DURING_IMPORT = "create_domains_during_import";
    public static final String REPLACE_SYSTEM_NAMES_DURING_IMPORT = "replace_system_names_during_import";
    public static final String INCLUDE_DEFAULT_SETTINGS_IN_DDL = "include_default_settings_in_ddl";
    public static final String INCLUDE_LOGGING_IN_DDL = "include_logging_in_ddl";
    public static final String INCLUDE_SCHEMA_IN_DDL = "include_schema_in_ddl";
    public static final String INCLUDE_STORAGE_IN_DDL = "include_storage_in_ddl";
    public static final String INCLUDE_TABLESPACE_IN_DDL = "include_tablespace_in_ddl";
    public static final String INCLUDE_REDACTION_IN_DDL = "include_redaction_in_ddl";
    public static final String INCLUDE_TSDP_IN_DDL = "include_tsdp_in_ddl";
    public static final String INCLUDE_PROMPT_IN_DDL = "include_prompt";
    public static final String INCLUDE_PCTFREE_IN_DDL = "include_pctfree_in_ddl";
    public static final String INCLUDE_PCTUSED_IN_DDL = "include_pctused_in_ddl";
    public static final String INCLUDE_INITRANS_IN_DDL = "include_initrans_in_ddl";
    public static final String INCLUDE_INITIALEXTENT_IN_DDL = "include_initialextent_in_ddl";
    public static final String INCLUDE_NEXTEXTENT_IN_DDL = "include_nextextent_in_ddl";
    public static final String INCLUDE_MINEXTENTS_IN_DDL = "include_minextents_in_ddl";
    public static final String INCLUDE_MAXEXTENTS_IN_DDL = "include_maxextents_in_ddl";
    public static final String INCLUDE_PCTINCREASE_IN_DDL = "include_pctincrease_in_ddl";
    public static final String INCLUDE_BUFFERPOOL_IN_DDL = "include_bufferpool_in_ddl";
    public static final String INCLUDE_FREELISTGROUPS_IN_DDL = "include_freelistgroups_in_ddl";
    public static final String INCLUDE_FREELISTS_IN_DDL = "include_freelists_in_ddl";
    public static final String INCLUDE_OPTIMAL_IN_DDL = "include_optimal_in_ddl";
    public static final String INCLUDE_ENCRYPTION_IN_DDL = "include_encryption_in_ddl";
    public static final String USE_SQL_DEV_FORMATTING = "use_sql_dev_formatting";
    public static final String TYPE = "type";
    public static final String RULESET = "rule_set";
    public static final String DESIGN_RULE = "design_rule";
    public static final String DEFAULT_FK_RULE = "default_fk_rule";
    public static final String NAMING_STANDARD_RULE = "naming_standard_rules";
    public static final String LOGICAL = "logical";
    public static final String SEPARATOR = "separator";
    public static final String ENTITIES = "entities";
    public static final String ATTRIBUTES = "attributes";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";
    public static final String DOMAIN = "domain";
    public static final String URL = "url";
    public static final String LAST_EXPORT_FOLDER = "last_export_folder";
    public static final String VIEW_NAMING_RULE = "view_naming_rule";
    public static final String TABLE_NAMING_RULE = "table_naming_rule";
    public static final String PREFERRED_LOGICAL_TYPES = "preferred_logical_types";
    public static final String USE_PREFERRED_LOGICAL_TYPES = "use_preferred_logical_types";
    public static final String PREFERRED_DOMAINS = "preferred_domains";
    public static final String USE_PREFERRED_DOMAINS = "use_preferred_domains";
    public static final String THIRD_PARTY_JDBC_DRIVERS = "third_party_jdbc_drivers";
    public static final String JDBC_DRIVER = "jdbc_driver";
    public static final String SYNCHRONIZATION_TYPES = "synchronization_types";
    public static final String TAG_USED = "used";
    public static final String TAG_DB = "db";
    public static final String IMPORT_PARTITIONS = "import_partitions";
    public static final String IMPORT_TRIGGERS = "import_triggers";
    public static final String SCAN_FOR_USED_STRUCTURED_TYPES = "scan_for_used_structured_types";
    public static final String IMPORT_SECONDARY_TABLES = "import_secondary_tables";
    public static final String IMPORT_SPATIAL_PROPERTIES = "import_spatial_properties";
    public static final String DBM_CONNECTIONS = "dbmconnections";
    public static final String DB_ORACLE = "Oracle";
    public static final String DB_DB2 = "DB2";
    public static final String DB_SQLSERVER = "SQL Server";
    public static final String DB_UDB = "UDB";
    public static final String DBM_CONNECTION_ELEMENT = "connection";
    public static final String OD_CONNECTIONS = "odconnections";
    public static final String RS_CONNECTIONS = "rsconnections";
    public static final String OD_CONNECTION_ELEMENT = "connection";
    public static final String RS_CONNECTION_ELEMENT = "connection";
    public static final String CONNECTION_TYPE = "connection_type";
    public static final String CONNECTION_NAME = "connection_name";
    public static final String CONNECTION_HOST = "connection_host";
    public static final String CONNECTION_PORT = "connection_port";
    public static final String CONNECTION_SID = "connection_sid";
    public static final String CONNECTION_USER_NAME = "connection_username";
    public static final String CONNECTION_PASSWORD = "connection_password";
    public static final String CONNECTION_SAVE_PASSWORD = "connection_save_password";
    public static final String CONNECTION_DRIVER_CLASS = "connection_driver_class";
    public static final String CONNECTION_URL = "connection_url";
    public static final String CONNECTION_CANCELLED = "connection_cancelled";
    public static final String RULE_SETS = "rule_sets";
    public static final String RECENT_FILES_ELEMENT = "recent_files";
    public static final String TAG_NAME = "name";
    public static final String TAG_PATH = "path";
    public static final String TAG_MODEL_TYPE = "model_type";
    public static final String TAG_OBJECT = "object";
    public static final String TAG_DESCRIPTION = "description";
    public static final String RELOAD_LAST_STATE = "reload_last_state";
    public static final String USE_VERSIONING_FUNCTIONALITY = "use_versioning_functionality";
    public static final String LAST_OPEN_DESIGN = "last_open_design";
    public static final String LAST_OPEN_DPV = "last_open_dpv";
    public static final String PRINTER_NAME = "printer_name";
    public static final String PAPER_MEDIA_NAME = "paper_media_name";
    public static final String PAGE_ORIENTATION = "page_orientation";
    public static final String PAGE_WIDTH = "page_width";
    public static final String PAGE_HEIGHT = "page_height";
    public static final String PAGE_MARGIN_X = "page_margin_x";
    public static final String PAGE_MARGIN_Y = "page_margin_y";
    public static final String PAGE_MARGIN_WIDTH = "page_margin_width";
    public static final String PAGE_MARGIN_HEIGHT = "page_margin_height";
    private final Map dialogs = new TreeMap();
    private final Map custom_settings = new TreeMap();
    private final List jdbcDrivers = new ArrayList();
    private List<LogicalDatatype> preferredLogicaltypes = new ArrayList<LogicalDatatype>();
    private List<Domain> prefDomains = new ArrayList<Domain>();
    private boolean usePreferredLogicalTypes;
    private String settingsFileName = "settings.xml";
    private boolean importJSON_DataGuide = true;
    private List recents = new ArrayList();
    private ArrayList preferredLT = new ArrayList();
    private boolean reloadLastState = false;
    private boolean useVersioningFunctionality = true;
    private String lastOpenDesign = "";
    private String lastOpenDPV = "";
    public static final String SEARCH_AS_U_TYPE = "search_as_u_type";
    public static final String SEARCH_AS_U_TYPE_START = "search_as_u_type_start";
    private boolean searchAsUType = false;
    private int searchAsUTypeStart = 3;
    public static final String SEARCH_PROFILES_PATHS = "search_profiles_paths";
    public static final String SEARCH_PROFILES_PATH = "path";
    private List searchProfilesPaths = new ArrayList();
    private String defaultDesignsPath = "";
    private String defaultImportPath = "";
    private String defaultSavePath = "";
    private String defaultSystemTypesPath = "";
    private String defaultReportsPath = "";
    private String defaultSaxonPath = "";
    private String defaultSearchProfilesPath = "";
    private boolean synchronizeTree = false;
    private int gridSize = 10;
    private String printerName = "";
    private String paperMediaName = "iso-a4";
    private int pageOrientation = 1;
    private double pageWidth;
    private double pageHeight;
    private double pageMarginX = 0.0;
    private double pageMarginY = 0.0;
    private double pageMarginWidth;
    private double pageMarginHeight;
    private boolean showImportLog = true;
    private String defaultRDBMSSite = "";
    private int defaultRDBMSType = 9;
    private boolean nullsAllowed = true;
    private boolean allowSimilarTypesFK = true;
    public static int ON_NEW_FK_EXIST_BY_TEMPLATE;
    public static int ON_NEW_FK_NEW_COLUMN;
    private int fkColumnOnNewFKOption = ON_NEW_FK_EXIST_BY_TEMPLATE;
    private String columnDefaultDatatype = "";
    private boolean newDB2TableSpacePerTable = false;
    private boolean newDB2StorageTemplatePerTableSpace = false;
    private boolean newDB2StorageTemplatePerIndex = false;
    private boolean oneDB2StorageTemplatePerTS = false;
    private boolean oneDB2StorageTemplatePerIndex = false;
    private String defaultTSStorageTemplateName = "";
    private String defaultIndexStorageTemplateName = "";
    private String defaultDB2Owner = "[Implicit]";
    private String defaultDB2Database = "DSNDB04";
    private String namingRuleTablespaceDB2 = "";
    private String namingRuleStTablespaceDB2 = "";
    private String namingRuleStIndexDB2 = "";
    private String defaultDB2TriggerName = "";
    private String defaultDB2SequenceName = "";
    private String defaultDB2AutoIncDDL = "NONE";
    private String defaultDB2IdentityDDL = "IDENTITY_CLAUSE";
    private String defaultOracleUser = "";
    private String defaultOracleTablespace = "";
    private String defaultOracleTriggerName = "";
    private String defaultOracleSequenceName = "";
    private String defaultOracleAutoIncDDL = "TRIGGER";
    private String defaultOracleIdentityDDL = "IDENTITY_CLAUSE";
    public static final String TRIGGER = "TRIGGER";
    public static final String DEFAULT_CLAUSE = "DEFAULT_CLAUSE";
    public static final String IDENTITY_CLAUSE = "IDENTITY_CLAUSE";
    public static final String[] AUTOINCREMENT_DDL;
    public static final String[] IDENTITY_DDL;
    public static final String[] AUTOINCREMENT_DDL_DB2;
    public static final String[] IDENTITY_DDL_DB2;
    public static final String[] AUTOINCREMENT_DDL_SQLSERVER;
    public static final String[] IDENTITY_DDL_SQLSERVER;
    public static final String[] AUTOINCREMENT_DDL_UDB;
    public static final String[] IDENTITY_DDL_UDB;
    private String defaultSqlServerDatabase = "[None]";
    private String defaultSqlServerTriggerName = "";
    private String defaultSqlServerSequenceName = "";
    private String defaultSqlServerAutoIncDDL = "NONE";
    private String defaultSqlServerIdentityDDL = "IDENTITY_CLAUSE";
    private String defaultUDBOwner = "[Implicit]";
    private String defaultUDBTriggerName = "";
    private String defaultUDBSequenceName = "";
    private String defaultUDBAutoIncDDL = "NONE";
    private String defaultUDBIdentityDDL = "IDENTITY_CLAUSE";
    private boolean showSelectRelModelDialog = true;
    private boolean useOracleTableTemplate = false;
    private boolean useOracleIndexTemplate = false;
    private int deleteFKColumnStrategy = 2;
    private boolean sourceOptional = true;
    private boolean targetOptional = false;
    private String entityPrefix = "entity_";
    private String tablePrefix = "table_";
    private String tableViewPrefix = "view_";
    private String customPrefix = "imp_";
    private int renameStrategy = 1;
    private boolean useFirstUniqueForIdentifyingRelation = true;
    private boolean keepFKNamesSynchronized = true;
    private boolean propagatePKAttrNotes = false;
    private int notation = 1;
    private boolean fk2pkArrow = true;
    private boolean autoJoinOnFK = true;
    private boolean boxInBox = true;
    private boolean generateTypeSubstTriggers = true;
    private boolean generateFKArcTriggers = true;
    private boolean generateFKNoneTransferableTriggers = true;
    private boolean showByteCharInDDL = false;
    private boolean extendedSizeForCharacters = false;
    private boolean useDataTypeKindInCompare = false;
    private boolean useSchemaPropertyInCompare = true;
    private boolean useColumnsOrderPropertyInCompare = false;
    private boolean includePhysicalPropertiesInCompare = true;
    private boolean includeStoragePropertiesInCompare = true;
    private boolean caseSensitiveNamesInCompare;
    private boolean includeSystemNamesInCompare = true;
    private boolean useGenInDDLInCompare = false;
    private char db2TerminationCharacter = (char)32;
    private String defaultFKRule = "NO ACTION";
    private boolean showPropertiesDialogOnNew = true;
    private String lastExportFolder = "";
    private String viewNamingRule = "";
    private String tableNamingRule = "";
    private boolean notNullShortFormGeneration;
    private boolean useQuotedIdentifiers;
    private boolean createDomainsDuringImport = true;
    private boolean replaceSystemNamesDuringImport = true;
    private boolean generateCommentsInRDBMS = true;
    private boolean generateInlineColumnCC = false;
    private boolean generateValidValueCC = true;
    private boolean defaultAllowColumnsReorder = false;
    private boolean syncRemoteObjectsOnLoad = false;
    private String surrogateKeyLDTPrecision = "";
    private String surrogateKeyDomain;
    private boolean defaultCreateSurrogateKey = false;
    private boolean defaultUseSurrogateKey = false;
    private boolean includeDefaultSettingsInDDL = false;
    private boolean includeLoggingInDDL = true;
    private boolean includeSchemaInDDL = true;
    private boolean includeStorageInDDL = true;
    private boolean includeTablespaceInDDL = true;
    private boolean includeRedactionInDDL = false;
    private boolean includeSupplementalLogInDDL = false;
    private boolean includeTSDPInDDL = false;
    private boolean includePrompt = false;
    private boolean includePctFreeInDDL = true;
    private boolean includePctUsedInDDL = true;
    private boolean includeInitransInDDL = true;
    private boolean includeInitialExtentInDDL = true;
    private boolean includeNextExtentInDDL = true;
    private boolean includeMinExtentsInDDL = true;
    private boolean includeMaxExtentsInDDL = true;
    private boolean includePctIncreaseInDDL = true;
    private boolean includeBufferPoolInDDL = true;
    private boolean includeFreeListsInDDL = true;
    private boolean includeFreeListGroupsInDDL = true;
    private boolean includeOptimalInDDL = true;
    private boolean includeEncryptionInDDL = true;
    private boolean importPartitions = true;
    private boolean importTriggers = false;
    private boolean scanForUsedStructuredTypes = false;
    private boolean importSecondaryTables = false;
    private boolean importSpatialProperties = false;
    private boolean importColumnDetails = true;
    private boolean importColumnsOnly = false;
    private boolean importCommentsInRDBMS = false;
    private boolean checkForExternalTable = false;
    private boolean includeSystemNames = false;
    private boolean importObjectTypes = false;
    private boolean importTables = true;
    private boolean importMViews = true;
    private boolean importMVLogs = true;
    private boolean importIndexes = true;
    private boolean importConstraints = true;
    private boolean importSynonyms = true;
    private boolean importPublicSynonyms = true;
    private boolean importDB_Links = true;
    private boolean importPublicDB_Links = true;
    private boolean useSQLDevFormatting = true;
    private List syncObjects;
    private String defaultDDLFilesPath = "";
    boolean includeDesgnNameInDDLPath = true;
    private boolean useDBSyncSourceConnection = false;
    private boolean useDBSyncSourceSchema = true;
    private boolean UseDBSyncSourceObject = true;
    private boolean syncWholeSchema = true;
    public static final String USE_DB_SYNC_SRC_CONNECTION = "use_db_sync_src_connection";
    public static final String USE_DB_SYNC_SRC_SCHEMA = "use_db_sync_src_schema";
    public static final String USE_DB_SYNC_SRC_OBJECT = "use_db_sync_src_object";
    public static final String DB_SYNC_WHOLE_SCHEMA = "db_sync_whole_schema";
    private String reportsCompanyName = "";
    private boolean usePageBreaksInReports = true;
    private boolean embedDiagramsInReports = true;
    private boolean embedMainDiagramInReports = false;
    private boolean groupBySchemaNameInReports = true;
    private boolean generateHTMLReportTOCInSeparateFile = false;
    private boolean includeSelectStatementInViewReport = true;
    private TreeMap<String, String> userDefinedPreferences = new TreeMap();
    public static final String USER_DEFINED_PREFERENCES = "user_defined_preferences";
    public static final String USER_DEFINED_PREFERENCE = "preference";

    public Settings() {
        this.initDefaultSyncObjects();
    }

    public void loadSettings() {
        try {
            File file = new File(this.settingsFileName);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                fileVersion = doc.getDocumentElement().getAttribute(SETTINGS_VERSION);
                this.loadLocalSettings(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize Settings: ", e);
        }
    }

    public void loadSettings(File file) {
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                fileVersion = doc.getDocumentElement().getAttribute(SETTINGS_VERSION);
                this.loadLocalSettings(doc);
                this.loadUserLevelSettings(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load Settings: ", e);
        }
    }

    private void loadDBMConnections(Document doc) {
        this.loadConnections(doc, DBM_CONNECTIONS, "connection");
    }

    private void loadODConnections(Document doc) {
        this.loadConnections(doc, OD_CONNECTIONS, "connection");
    }

    private void loadRSConnections(Document doc) {
        this.loadConnections(doc, RS_CONNECTIONS, "connection");
    }

    private void loadConnections(Document doc, String connectionsName, String eleName) {
    }

    private String getValue(Document doc, String tagName) {
        Element element;
        NodeList list = doc.getElementsByTagName(tagName);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            return element.getAttribute(TAG_VALUE);
        }
        return "";
    }

    private void initJDBCDrivers(Document doc) {
        Element element;
        this.clearJDBCDrivers();
        NodeList list = doc.getElementsByTagName(THIRD_PARTY_JDBC_DRIVERS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList drivers = element.getElementsByTagName(JDBC_DRIVER);
            int driversLength = drivers.getLength();
            for (int i = 0; i < driversLength; ++i) {
                Element drvElm = (Element)drivers.item(i);
                if (drvElm == null) continue;
                String url = drvElm.getAttribute("drv_path");
                File file = new File(url);
                if (file.exists()) {
                    this.addJDBCDriver(url);
                    continue;
                }
                LOGGER.error("JDBC Driver does not exist: " + url);
            }
        }
    }

    public void saveSettings() {
        try {
            StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            buffer.append('\n');
            buffer.append('<').append(SETTINGS_ELEMENT).append(' ').append(SETTINGS_VERSION).append("=\"").append(this.loadedVersion).append("\">");
            this.addLocalSettings(buffer);
            this.addUserlevelSettings(buffer);
            buffer.append('\n');
            buffer.append("</").append(SETTINGS_ELEMENT).append('>');
            FileOutputStream fos = new FileOutputStream(new File(this.settingsFileName));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to Save Settings: ", e);
        }
    }

    private void appendElement(String elmName, String value, StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(elmName).append(' ').append(TAG_VALUE).append("=\"").append(value).append("\" />");
    }

    private void appendDialogsSettings(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(DIALOGS_SETTINGS).append('>');
        Object[] savedDialogs = this.dialogs.keySet().toArray();
        for (int i = 0; i < savedDialogs.length; ++i) {
            String key = (String)savedDialogs[i];
            DialogSettings ds = (DialogSettings)this.dialogs.get(key);
            buffer.append('\n');
            buffer.append('\t').append('\t');
            buffer.append('<').append(key).append(' ');
            buffer.append("x=\"").append(String.valueOf(ds.rec.getX())).append("\" ");
            buffer.append("y=\"").append(String.valueOf(ds.rec.getY())).append("\" ");
            buffer.append("w=\"").append(String.valueOf(ds.rec.getWidth())).append("\" ");
            buffer.append("h=\"").append(String.valueOf(ds.rec.getHeight())).append("\" ");
            buffer.append("treepath=\"").append(String.valueOf(StringUtilities.encodeAttributeValue(ds.treePath))).append("\" ");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(DIALOGS_SETTINGS).append(">");
    }

    private void appendCustomSettings(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(CUSTOM_SETTINGS).append('>');
        Object[] cs = this.custom_settings.keySet().toArray();
        for (int i = 0; i < cs.length; ++i) {
            String key = (String)cs[i];
            Map map = (Map)this.custom_settings.get(key);
            buffer.append('\n');
            buffer.append('\t').append('\t');
            buffer.append('<').append(key).append(' ');
            for (String name : map.keySet()) {
                String value = (String)map.get(name);
                buffer.append(name).append("=\"").append(value).append("\" ");
            }
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(CUSTOM_SETTINGS).append(">");
    }

    private void appendJDBCDrivers(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(THIRD_PARTY_JDBC_DRIVERS).append('>');
        for (String url : this.jdbcDrivers) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(JDBC_DRIVER).append(' ');
            buffer.append("drv_path=\"").append(url).append("\"");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(THIRD_PARTY_JDBC_DRIVERS).append(">");
    }

    public String getDefaultDesignsPath() {
        return this.defaultDesignsPath;
    }

    public void setDefaultDesignsPath(String defaultDesignsPath) {
        this.defaultDesignsPath = defaultDesignsPath;
    }

    public String getDefaultImportPath() {
        return this.defaultImportPath;
    }

    public void setDefaultImportPath(String defaultImportPath) {
        this.defaultImportPath = defaultImportPath;
    }

    public String getDefaultSavePath() {
        return this.defaultSavePath;
    }

    public void setDefaultSavePath(String defaultSavePath) {
        this.defaultSavePath = defaultSavePath;
    }

    public boolean synchronizeTree() {
        return this.synchronizeTree;
    }

    public void setSynchronizeTree(boolean synchronizeTree) {
        this.synchronizeTree = synchronizeTree;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setPrinterName(String name) {
        this.printerName = name;
    }

    public void setPaperMediaName(String paperMediaName) {
        this.paperMediaName = paperMediaName;
    }

    public boolean showImportLog() {
        return this.showImportLog;
    }

    public void setShowImportLog(boolean showImportLog) {
        this.showImportLog = showImportLog;
    }

    public String getDefaultRDBMSSite() {
        return this.defaultRDBMSSite;
    }

    public void setDefaultRDBMSSite(String defaultRDBMSSite) {
        this.defaultRDBMSSite = defaultRDBMSSite;
    }

    public int getDefaultRDBMSType() {
        return this.defaultRDBMSType;
    }

    public void setDefaultRDBMSType(int defaultRDBMSType) {
        this.defaultRDBMSType = defaultRDBMSType;
    }

    public boolean getNullsAllowed() {
        return this.nullsAllowed;
    }

    public void setNullsAllowed(boolean nullsAllowed) {
        this.nullsAllowed = nullsAllowed;
    }

    public boolean newDB2TableSpacePerTable() {
        return this.newDB2TableSpacePerTable;
    }

    public void setNewDB2TableSpacePerTable(boolean newDB2TableSpacePerTable) {
        this.newDB2TableSpacePerTable = newDB2TableSpacePerTable;
    }

    public String getDefaultDB2Owner() {
        return this.defaultDB2Owner;
    }

    public void setDefaultDB2Owner(String defaultDB2Owner) {
        if (defaultDB2Owner != null && !defaultDB2Owner.trim().equalsIgnoreCase("")) {
            this.defaultDB2Owner = defaultDB2Owner;
        }
    }

    public String getDefaultDB2Database() {
        return this.defaultDB2Database;
    }

    public void setDefaultDB2Database(String defaultDB2Database) {
        this.defaultDB2Database = defaultDB2Database;
    }

    public String getNamingRuleTablespaceDB2() {
        return this.namingRuleTablespaceDB2;
    }

    public void setNamingRuleTablespaceDB2(String namingRuleTablespaceDB2) {
        this.namingRuleTablespaceDB2 = namingRuleTablespaceDB2;
    }

    public String getNamingRuleStTablespaceDB2() {
        return this.namingRuleStTablespaceDB2;
    }

    public void setNamingRuleStTablespaceDB2(String namingRuleStTablespaceDB2) {
        this.namingRuleStTablespaceDB2 = namingRuleStTablespaceDB2;
    }

    public String getNamingRuleStIndexDB2() {
        return this.namingRuleStIndexDB2;
    }

    public void setNamingRuleStIndexDB2(String namingRuleStIndexDB2) {
        this.namingRuleStIndexDB2 = namingRuleStIndexDB2;
    }

    public String getDefaultDB2TriggerName() {
        return this.defaultDB2TriggerName;
    }

    public void setDefaultDB2TriggerName(String defaultDB2TriggerName) {
        this.defaultDB2TriggerName = defaultDB2TriggerName;
    }

    public String getDefaultDB2SequenceName() {
        return this.defaultDB2SequenceName;
    }

    public void setDefaultDB2SequenceName(String defaultDB2SequenceName) {
        this.defaultDB2SequenceName = defaultDB2SequenceName;
    }

    public String getDefaultDB2AutoIncDDL() {
        return this.defaultDB2AutoIncDDL;
    }

    public void setDefaultDB2AutoIncDDL(String defaultDB2AutoIncDDL) {
        this.defaultDB2AutoIncDDL = defaultDB2AutoIncDDL;
    }

    public String getDefaultDB2IdentityDDL() {
        return this.defaultDB2IdentityDDL;
    }

    public void setDefaultDB2IdentityDDL(String defaultDB2IdentityDDL) {
        this.defaultDB2IdentityDDL = defaultDB2IdentityDDL;
    }

    public String getDefaultOracleTablespace() {
        return this.defaultOracleTablespace;
    }

    public void setDefaultOracleTablespace(String defaultOracleTablespace) {
        this.defaultOracleTablespace = defaultOracleTablespace;
    }

    public String getDefaultOracleUser() {
        return this.defaultOracleUser;
    }

    public void setDefaultOracleUser(String defaultOracleUser) {
        this.defaultOracleUser = defaultOracleUser;
    }

    public String getDefaultOracleTriggerName() {
        return this.defaultOracleTriggerName;
    }

    public void setDefaultOracleTriggerName(String defaultOracleTriggerName) {
        this.defaultOracleTriggerName = defaultOracleTriggerName;
    }

    public String getDefaultOracleSequenceName() {
        return this.defaultOracleSequenceName;
    }

    public void setDefaultOracleSequenceName(String defaultOracleSequenceName) {
        this.defaultOracleSequenceName = defaultOracleSequenceName;
    }

    public String getDefaultOracleAutoIncDDL() {
        return this.defaultOracleAutoIncDDL;
    }

    public void setDefaultOracleAutoIncDDL(String defaultOracleAutoIncDDL) {
        this.defaultOracleAutoIncDDL = defaultOracleAutoIncDDL;
    }

    public String getDefaultOracleIdentityDDL() {
        return this.defaultOracleIdentityDDL;
    }

    public void setDefaultOracleIdentityDDL(String defaultOracleIdentityDDL) {
        this.defaultOracleIdentityDDL = defaultOracleIdentityDDL;
    }

    public String getDefaultSqlServerDatabase() {
        return this.defaultSqlServerDatabase;
    }

    public void setDefaultSqlServerDatabase(String defaultSqlServerDatabase) {
        this.defaultSqlServerDatabase = defaultSqlServerDatabase;
    }

    public String getDefaultSqlServerTriggerName() {
        return this.defaultSqlServerTriggerName;
    }

    public void setDefaultSqlServerTriggerName(String defaultSqlServerTriggerName) {
        this.defaultSqlServerTriggerName = defaultSqlServerTriggerName;
    }

    public String getDefaultSqlServerSequenceName() {
        return this.defaultSqlServerSequenceName;
    }

    public void setDefaultSqlServerSequenceName(String defaultSqlServerSequenceName) {
        this.defaultSqlServerSequenceName = defaultSqlServerSequenceName;
    }

    public String getDefaultSqlServerAutoIncDDL() {
        return this.defaultSqlServerAutoIncDDL;
    }

    public void setDefaultSqlServerAutoIncDDL(String defaultSqlServerAutoIncDDL) {
        this.defaultSqlServerAutoIncDDL = defaultSqlServerAutoIncDDL;
    }

    public String getDefaultSqlServerIdentityDDL() {
        return this.defaultSqlServerIdentityDDL;
    }

    public void setDefaultSqlServerIdentityDDL(String defaultSqlServerIdentityDDL) {
        this.defaultSqlServerIdentityDDL = defaultSqlServerIdentityDDL;
    }

    public String getDefaultUDBOwner() {
        return this.defaultUDBOwner;
    }

    public void setDefaultUDBOwner(String defaultUDBOwner) {
        this.defaultUDBOwner = defaultUDBOwner;
    }

    public String getDefaultUDBTriggerName() {
        return this.defaultUDBTriggerName;
    }

    public void setDefaultUDBTriggerName(String defaultUDBTriggerName) {
        this.defaultUDBTriggerName = defaultUDBTriggerName;
    }

    public String getDefaultUDBSequenceName() {
        return this.defaultUDBSequenceName;
    }

    public void setDefaultUDBSequenceName(String defaultUDBSequenceName) {
        this.defaultUDBSequenceName = defaultUDBSequenceName;
    }

    public String getDefaultUDBAutoIncDDL() {
        return this.defaultUDBAutoIncDDL;
    }

    public void setDefaultUDBAutoIncDDL(String defaultUDBAutoIncDDL) {
        this.defaultUDBAutoIncDDL = defaultUDBAutoIncDDL;
    }

    public String getDefaultUDBIdentityDDL() {
        return this.defaultUDBIdentityDDL;
    }

    public void setDefaultUDBIdentityDDL(String defaultUDBIdentityDDL) {
        this.defaultUDBIdentityDDL = defaultUDBIdentityDDL;
    }

    public boolean showSelectRelModelDialog() {
        return this.showSelectRelModelDialog;
    }

    public void setShowSelectRelModelDialog(boolean showSelectRelModelDialog) {
        this.showSelectRelModelDialog = showSelectRelModelDialog;
    }

    public boolean isSourceOptional() {
        return this.sourceOptional;
    }

    public void setSourceOptional(boolean sourceOptional) {
        this.sourceOptional = sourceOptional;
    }

    public boolean isTargetOptional() {
        return this.targetOptional;
    }

    public void setTargetOptional(boolean targetOptional) {
        this.targetOptional = targetOptional;
    }

    public boolean oneDB2StorageTemplatePerIndex() {
        return this.oneDB2StorageTemplatePerIndex;
    }

    public void setOneDB2StorageTemplatePerIndex(boolean oneDB2StorageTemplatePerIndex) {
        this.oneDB2StorageTemplatePerIndex = oneDB2StorageTemplatePerIndex;
    }

    public boolean oneDB2StorageTemplatePerTS() {
        return this.oneDB2StorageTemplatePerTS;
    }

    public void setOneDB2StorageTemplatePerTS(boolean oneDB2StorageTemplatePerTS) {
        this.oneDB2StorageTemplatePerTS = oneDB2StorageTemplatePerTS;
    }

    public String getDefaultIndexStorageTemplateName() {
        return this.defaultIndexStorageTemplateName;
    }

    public void setDefaultIndexStorageTemplateName(String defaultIndexStorageTemplateName) {
        this.defaultIndexStorageTemplateName = defaultIndexStorageTemplateName;
    }

    public String getDefaultTSStorageTemplateName() {
        return this.defaultTSStorageTemplateName;
    }

    public void setDefaultTSStorageTemplateName(String defaultTSStorageTemplateName) {
        this.defaultTSStorageTemplateName = defaultTSStorageTemplateName;
    }

    public boolean newDB2StorageTemplatePerIndex() {
        return this.newDB2StorageTemplatePerIndex;
    }

    public void setNewDB2StorageTemplatePerIndex(boolean newDB2StorageTemplatePerIndex) {
        this.newDB2StorageTemplatePerIndex = newDB2StorageTemplatePerIndex;
    }

    public boolean newDB2StorageTemplatePerTableSpace() {
        return this.newDB2StorageTemplatePerTableSpace;
    }

    public void setNewDB2StorageTemplatePerTableSpace(boolean newDB2StorageTemplatePerTableSpace) {
        this.newDB2StorageTemplatePerTableSpace = newDB2StorageTemplatePerTableSpace;
    }

    public int getDeleteFKColumnStrategy() {
        return this.deleteFKColumnStrategy;
    }

    public void setDeleteFKColumnStrategy(int deleteFKColumnStrategy) {
        this.deleteFKColumnStrategy = deleteFKColumnStrategy;
    }

    public String getEntityPrefix() {
        return this.entityPrefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getTableViewPrefix() {
        return this.tableViewPrefix;
    }

    public void setEntityPrefix(String entityPrefix) {
        this.entityPrefix = entityPrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setTableViewPrefix(String viewPrefix) {
        this.tableViewPrefix = viewPrefix;
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    public void setCustomPrefix(String customPrefix) {
        this.customPrefix = customPrefix;
    }

    public int getRenameStrategy() {
        return this.renameStrategy;
    }

    public void setRenameStrategy(int getRenameStrategy) {
        this.renameStrategy = getRenameStrategy;
    }

    public Map getDialogs() {
        return this.dialogs;
    }

    public void setDialogSettings(String className, Rectangle rectangle) {
        this.setDialogSettings(className, rectangle, "");
    }

    public void setDialogSettings(String className, Rectangle rectangle, String treePath) {
        DialogSettings ds = new DialogSettings(rectangle, treePath);
        this.dialogs.put(className, ds);
    }

    public void setDialogSettings(String className, Rectangle rectangle, String treePath, int dividerLocation) {
        DialogSettings ds = new DialogSettings(rectangle, treePath, dividerLocation);
        this.dialogs.put(className, ds);
    }

    public Map getCustomSettings(String className) {
        return (Map)this.custom_settings.get(className);
    }

    public void setCustomSettings(String className, Map map) {
        this.custom_settings.put(className, map);
    }

    public Map getCustomSettings() {
        return this.custom_settings;
    }

    public boolean isUseFirstUniqueForIdentifyingRelation() {
        return this.useFirstUniqueForIdentifyingRelation;
    }

    public void setUseFirstUniqueForIdentifyingRelation(boolean useFirstUniqueForIdentifyingRelation) {
        this.useFirstUniqueForIdentifyingRelation = useFirstUniqueForIdentifyingRelation;
    }

    public boolean useOracleIndexTemplate() {
        return this.useOracleIndexTemplate;
    }

    public void setUseOracleIndexTemplate(boolean useOracleIndexTemplate) {
        this.useOracleIndexTemplate = useOracleIndexTemplate;
    }

    public boolean useOracleTableTemplate() {
        return this.useOracleTableTemplate;
    }

    public void setUseOracleTableTemplate(boolean useOracleTableTemplate) {
        this.useOracleTableTemplate = useOracleTableTemplate;
    }

    public int getNotation() {
        return this.notation;
    }

    public void setNotation(int notation) {
        this.notation = notation;
    }

    public boolean isFk2pkArrow() {
        return this.fk2pkArrow;
    }

    public void setFk2pkArrow(boolean fk2pkArrow) {
        this.fk2pkArrow = fk2pkArrow;
    }

    public boolean isBoxInBox() {
        return this.boxInBox;
    }

    public void setBoxInBox(boolean boxInBox) {
        this.boxInBox = boxInBox;
    }

    public char getDB2TerminationCharacter() {
        return this.db2TerminationCharacter;
    }

    public boolean isGenerateTypeSubstTriggers() {
        return this.generateTypeSubstTriggers;
    }

    public void setGenerateTypeSubstTriggers(boolean typeSubstTriggers) {
        this.generateTypeSubstTriggers = typeSubstTriggers;
    }

    public String getSettingsFileName() {
        return this.settingsFileName;
    }

    public void setSettingsFileName(String settingsFileName) {
        this.settingsFileName = settingsFileName;
    }

    public List<LogicalDatatype> getPreferredLogicaltypes() {
        return this.preferredLogicaltypes;
    }

    public void setPreferredLogicaltypes(List<LogicalDatatype> preferredLogicaltypes) {
        this.preferredLogicaltypes = preferredLogicaltypes;
    }

    public List<Domain> getPrefDomains() {
        return this.prefDomains;
    }

    public void setPrefDomains(List<Domain> prefDomains) {
        this.prefDomains = prefDomains;
    }

    public boolean isUsePreferredLogicalTypes() {
        return this.usePreferredLogicalTypes;
    }

    public void setUsePreferredLogicalTypes(boolean usePreferredLogicalTypes) {
        this.usePreferredLogicalTypes = usePreferredLogicalTypes;
    }

    public boolean isUsePreferredDomains() {
        return this.isUsePreferredLogicalTypes();
    }

    public void setUsePreferredDomains(boolean usePreferredDomains) {
        this.setUsePreferredLogicalTypes(usePreferredDomains);
    }

    public String getDefaultFKDeleteRule() {
        return this.defaultFKRule;
    }

    public void setDefaultFKDeleteRule(String defaultRule) {
        this.defaultFKRule = defaultRule;
    }

    public boolean isKeepFKNamesSynchronized() {
        return this.keepFKNamesSynchronized;
    }

    public void setKeepFKNamesSynchronized(boolean keepFKNamesSynchronized) {
        this.keepFKNamesSynchronized = keepFKNamesSynchronized;
    }

    public Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    public boolean showPropertiesDialogOnNew() {
        return this.showPropertiesDialogOnNew;
    }

    public void setShowPropertiesDialogOnNew(boolean showPropertiesDialogOnNew) {
        this.showPropertiesDialogOnNew = showPropertiesDialogOnNew;
    }

    public boolean notNullShortFormGeneration() {
        return this.notNullShortFormGeneration;
    }

    public void setNotNullShortFormGeneration(boolean notNullShortFormGeneration) {
        this.notNullShortFormGeneration = notNullShortFormGeneration;
    }

    public void setUseQuotedIdentifiers(boolean useQuotedIdentifiers) {
        this.useQuotedIdentifiers = useQuotedIdentifiers;
    }

    public boolean isUseQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public void setCreateDomainsDuringImport(boolean createDomainsDuringImport) {
        this.createDomainsDuringImport = createDomainsDuringImport;
    }

    public boolean isCreateDomainsDuringImport() {
        return this.createDomainsDuringImport;
    }

    public void setReplaceSystemNamesDuringImport(boolean replaceSystemNamesDuringImport) {
        this.replaceSystemNamesDuringImport = replaceSystemNamesDuringImport;
    }

    public boolean isReplaceSystemNamesDuringImport() {
        return this.replaceSystemNamesDuringImport;
    }

    public String getLastExportFolder() {
        return this.lastExportFolder;
    }

    public void setLastExportFolder(String lastExportFolder) {
        this.lastExportFolder = lastExportFolder;
    }

    public String getViewNamingRule() {
        return this.viewNamingRule;
    }

    public void setViewNamingRule(String viewNamingRule) {
        this.viewNamingRule = viewNamingRule;
    }

    public String getTableNamingRule() {
        return this.tableNamingRule;
    }

    public void setTableNamingRule(String tableNamingRule) {
        this.tableNamingRule = tableNamingRule;
    }

    public boolean isGenerateFKArcTriggers() {
        return this.generateFKArcTriggers;
    }

    public void setGenerateFKArcTriggers(boolean generateFKArcTriggers) {
        this.generateFKArcTriggers = generateFKArcTriggers;
    }

    public boolean isGenerateFKNoneTransferableTriggers() {
        return this.generateFKNoneTransferableTriggers;
    }

    public void setGenerateFKNoneTransferableTriggers(boolean generateFKNoneTransferableTriggers) {
        this.generateFKNoneTransferableTriggers = generateFKNoneTransferableTriggers;
    }

    public List getJDBCDrivers() {
        return this.jdbcDrivers;
    }

    public void clearJDBCDrivers() {
        this.jdbcDrivers.clear();
    }

    public void addJDBCDriver(String url) {
        this.jdbcDrivers.add(url);
    }

    public List getRecentDesigns() {
        return this.recents;
    }

    public boolean isShowByteCharInDDL() {
        return this.showByteCharInDDL;
    }

    public void setShowByteCharInDDL(boolean showByteCharInDDL) {
        this.showByteCharInDDL = showByteCharInDDL;
    }

    public boolean isUseDataTypeKindInCompare() {
        return this.useDataTypeKindInCompare;
    }

    public void setUseDataTypeKindInCompare(boolean useDataTypeKindInCompare) {
        this.useDataTypeKindInCompare = useDataTypeKindInCompare;
    }

    public boolean isUseGenInDDLInCompare() {
        return this.useGenInDDLInCompare;
    }

    public void setUseGenInDDLInCompare(boolean useGenInDDLInCompare) {
        this.useGenInDDLInCompare = useGenInDDLInCompare;
    }

    private void addUserlevelSettings(StringBuffer buffer) {
        this.appendElement(DEFAULT_RDBMS_SITE, this.defaultRDBMSSite, buffer);
        this.appendElement(DEFAULT_RDBMS_TYPE, Integer.toString(this.defaultRDBMSType), buffer);
        this.appendElement(NULLS_ALLOWED, Boolean.toString(this.nullsAllowed), buffer);
        this.appendElement(ALLOW_SIMILAR_TYPES_FK, Boolean.toString(this.allowSimilarTypesFK), buffer);
        this.appendElement(FK_COLUMN_ON_NEW_FK_OPTION, Integer.toString(this.fkColumnOnNewFKOption), buffer);
        this.appendElement(COLUMN_DEFAULT_DATATYPE, this.columnDefaultDatatype, buffer);
        this.appendElement(SHOW_IMPORT_LOG, Boolean.toString(this.showImportLog), buffer);
        this.appendElement(SYNCHRONIZE_TREE_ELEMENT, Boolean.toString(this.synchronizeTree), buffer);
        this.appendElement(GRID_SIZE_ELEMENT, Integer.toString(this.gridSize), buffer);
        this.appendElement(NEW_DB2_TABLESPACE_PER_TABLE, Boolean.toString(this.newDB2TableSpacePerTable), buffer);
        this.appendElement(NEW_DB2_STORAGETEMPLATE_PER_TABLESPACE, Boolean.toString(this.newDB2StorageTemplatePerTableSpace), buffer);
        this.appendElement(NEW_DB2_STORAGETEMPLATE_PER_INDEX, Boolean.toString(this.newDB2StorageTemplatePerIndex), buffer);
        this.appendElement(ONE_DB2_STORAGETEMPLATE_PER_TS, Boolean.toString(this.oneDB2StorageTemplatePerTS), buffer);
        this.appendElement(ONE_DB2_STORAGETEMPLATE_PER_INDEX, Boolean.toString(this.oneDB2StorageTemplatePerIndex), buffer);
        this.appendElement(DEFAULT_TS_STORAGETEMPLATE_NAME, this.defaultTSStorageTemplateName, buffer);
        this.appendElement(DEFAULT_INDEX_STORAGETEMPLATE_NAME, this.defaultIndexStorageTemplateName, buffer);
        this.appendElement(DEFAULT_DB2_OWNER, this.defaultDB2Owner, buffer);
        this.appendElement(DEFAULT_DB2_DATABASE, this.defaultDB2Database, buffer);
        this.appendElement(DEFAULT_DB2_TRIGGER_NAME, this.defaultDB2TriggerName, buffer);
        this.appendElement(DEFAULT_DB2_SEQUENCE_NAME, this.defaultDB2SequenceName, buffer);
        this.appendElement(DEFAULT_DB2_AUTO_INC_DDL, this.defaultDB2AutoIncDDL, buffer);
        this.appendElement(DEFAULT_DB2_IDENTITY_DDL, this.defaultDB2IdentityDDL, buffer);
        this.appendElement(NAMING_RULE_TABLESPACE, this.namingRuleTablespaceDB2, buffer);
        this.appendElement(NAMING_RULE_ST_TABLESPACE, this.namingRuleStTablespaceDB2, buffer);
        this.appendElement(NAMING_RULE_ST_INDEX, this.namingRuleStIndexDB2, buffer);
        this.appendElement(DEFAULT_ORACLE_USER, this.defaultOracleUser, buffer);
        this.appendElement(DEFAULT_ORACLE_TABLESPACE, this.defaultOracleTablespace, buffer);
        this.appendElement(DEFAULT_ORACLE_TRIGGER_NAME, this.defaultOracleTriggerName, buffer);
        this.appendElement(DEFAULT_ORACLE_SEQUENCE_NAME, this.defaultOracleSequenceName, buffer);
        this.appendElement(DEFAULT_ORACLE_AUTO_INC_DDL, this.defaultOracleAutoIncDDL, buffer);
        this.appendElement(DEFAULT_ORACLE_IDENTITY_DDL, this.defaultOracleIdentityDDL, buffer);
        this.appendElement(USE_ORACLE_TABLE_TEMPLATE, Boolean.toString(this.useOracleTableTemplate), buffer);
        this.appendElement(USE_ORACLE_INDEX_TEMPLATE, Boolean.toString(this.useOracleIndexTemplate), buffer);
        this.appendElement(DEFAULT_SQL_SERVER_DATABASE, this.defaultSqlServerDatabase, buffer);
        this.appendElement(DEFAULT_SQL_SERVER_TRIGGER_NAME, this.defaultSqlServerTriggerName, buffer);
        this.appendElement(DEFAULT_SQL_SERVER_SEQUENCE_NAME, this.defaultSqlServerSequenceName, buffer);
        this.appendElement(DEFAULT_SQL_SERVER_AUTO_INC_DDL, this.defaultSqlServerAutoIncDDL, buffer);
        this.appendElement(DEFAULT_SQL_SERVER_IDENTITY_DDL, this.defaultSqlServerIdentityDDL, buffer);
        this.appendElement(DEFAULT_UDB_OWNER, this.defaultUDBOwner, buffer);
        this.appendElement(DEFAULT_UDB_TRIGGER_NAME, this.defaultUDBTriggerName, buffer);
        this.appendElement(DEFAULT_UDB_SEQUENCE_NAME, this.defaultUDBSequenceName, buffer);
        this.appendElement(DEFAULT_UDB_AUTO_INC_DDL, this.defaultUDBAutoIncDDL, buffer);
        this.appendElement(DEFAULT_UDB_IDENTITY_DDL, this.defaultUDBIdentityDDL, buffer);
        this.appendElement(SHOW_SELECT_RELATIONAL_MODEL_DIALOG, Boolean.toString(this.showSelectRelModelDialog), buffer);
        this.appendElement(PK_IDENTIFYING_RELATION, Boolean.toString(this.useFirstUniqueForIdentifyingRelation), buffer);
        this.appendElement(KEEP_FK_NAMES_SYNCHRONIZED, Boolean.toString(this.keepFKNamesSynchronized), buffer);
        this.appendElement(PROPAGATE_PK_ATTR_NOTES, Boolean.toString(this.propagatePKAttrNotes), buffer);
        this.appendElement(SOURCE_OPTIONAL, Boolean.toString(this.sourceOptional), buffer);
        this.appendElement(TARGET_OPTIONAL, Boolean.toString(this.targetOptional), buffer);
        this.appendElement(DELETE_FK_COLUMNS_STRATEGY, String.valueOf(this.deleteFKColumnStrategy), buffer);
        this.appendElement(NOTATION, String.valueOf(this.notation), buffer);
        this.appendElement(FK_2_PK_ARROW, Boolean.toString(this.fk2pkArrow), buffer);
        this.appendElement(BOX_IN_BOX, Boolean.toString(this.boxInBox), buffer);
        this.appendElement(AUTO_JOIN_ON_FK, Boolean.toString(this.autoJoinOnFK), buffer);
        this.appendElement(TYPE_SUBST_TRIGGERS, Boolean.toString(this.generateTypeSubstTriggers), buffer);
        this.appendElement(DB2_TERM_CHAR, String.valueOf(this.db2TerminationCharacter), buffer);
        this.appendElement(FKARC_TRIGGERS, Boolean.toString(this.generateFKArcTriggers), buffer);
        this.appendElement(FKNONETRANSF_TRIGGERS, Boolean.toString(this.generateFKNoneTransferableTriggers), buffer);
        this.appendElement(USE_DATA_TYPE_KIND_IN_COMPARE, Boolean.toString(this.useDataTypeKindInCompare), buffer);
        this.appendElement(USE_SCHEMA_PROPERTY_IN_COMPARE, Boolean.toString(this.useSchemaPropertyInCompare), buffer);
        this.appendElement(USE_COLUMNS_ORDER_PROPERTY_IN_COMPARE, Boolean.toString(this.useColumnsOrderPropertyInCompare), buffer);
        this.appendElement(INCLUDE_PHYSICAL_PROPERTIES_IN_COMPARE, Boolean.toString(this.includePhysicalPropertiesInCompare), buffer);
        this.appendElement(INCLUDE_STORAGE_PROPERTIES_IN_COMPARE, Boolean.toString(this.includeStoragePropertiesInCompare), buffer);
        this.appendElement(USE_CASE_SENSITIVE_NAMES_IN_COMPARE, Boolean.toString(this.caseSensitiveNamesInCompare), buffer);
        this.appendElement(INCLUDE_SYSTEM_NAMES_IN_COMPARE, Boolean.toString(this.includeSystemNamesInCompare), buffer);
        this.appendElement(USE_GEN_IN_DDL_IN_COMPARE, Boolean.toString(this.useGenInDDLInCompare), buffer);
        this.appendElement(SHOW_CHAR_BYTE_IN_DDL, Boolean.toString(this.showByteCharInDDL), buffer);
        this.appendElement(EXTENDED_SIZE_FOR_CHARS, Boolean.toString(this.extendedSizeForCharacters), buffer);
        this.appendElement(SHOW_PROPERTIES_DIALOG_ON_NEW, Boolean.toString(this.showPropertiesDialogOnNew), buffer);
        this.appendElement(NOT_NULL_SHORT_FORM_GENERATION, Boolean.toString(this.notNullShortFormGeneration), buffer);
        this.appendElement(USE_QUOTED_IDENTIFIERS, Boolean.toString(this.useQuotedIdentifiers), buffer);
        this.appendElement(CREATE_DOMAINS_DURING_IMPORT, Boolean.toString(this.createDomainsDuringImport), buffer);
        this.appendElement(REPLACE_SYSTEM_NAMES_DURING_IMPORT, Boolean.toString(this.replaceSystemNamesDuringImport), buffer);
        this.appendElement(GENERATE_COMMENTS_IN_RDBMS, Boolean.toString(this.generateCommentsInRDBMS), buffer);
        this.appendElement(GENERATE_INLINE_COLUMN_CC, Boolean.toString(this.generateInlineColumnCC), buffer);
        this.appendElement(GENERATE_VALID_VALUE_CC, Boolean.toString(this.generateValidValueCC), buffer);
        this.appendElement(INCLUDE_DEFAULT_SETTINGS_IN_DDL, Boolean.toString(this.includeDefaultSettingsInDDL), buffer);
        this.appendElement(INCLUDE_LOGGING_IN_DDL, Boolean.toString(this.includeLoggingInDDL), buffer);
        this.appendElement(INCLUDE_SCHEMA_IN_DDL, Boolean.toString(this.includeSchemaInDDL), buffer);
        this.appendElement(INCLUDE_STORAGE_IN_DDL, Boolean.toString(this.includeStorageInDDL), buffer);
        this.appendElement(INCLUDE_TABLESPACE_IN_DDL, Boolean.toString(this.includeTablespaceInDDL), buffer);
        this.appendElement(INCLUDE_REDACTION_IN_DDL, Boolean.toString(this.includeRedactionInDDL), buffer);
        this.appendElement(INCLUDE_TSDP_IN_DDL, Boolean.toString(this.includeTSDPInDDL), buffer);
        this.appendElement(INCLUDE_PROMPT_IN_DDL, Boolean.toString(this.includePrompt), buffer);
        this.appendElement(INCLUDE_PCTFREE_IN_DDL, Boolean.toString(this.includePctFreeInDDL), buffer);
        this.appendElement(INCLUDE_PCTUSED_IN_DDL, Boolean.toString(this.includePctUsedInDDL), buffer);
        this.appendElement(INCLUDE_INITRANS_IN_DDL, Boolean.toString(this.includeInitransInDDL), buffer);
        this.appendElement(INCLUDE_INITIALEXTENT_IN_DDL, Boolean.toString(this.includeInitialExtentInDDL), buffer);
        this.appendElement(INCLUDE_NEXTEXTENT_IN_DDL, Boolean.toString(this.includeNextExtentInDDL), buffer);
        this.appendElement(INCLUDE_MINEXTENTS_IN_DDL, Boolean.toString(this.includeMinExtentsInDDL), buffer);
        this.appendElement(INCLUDE_MAXEXTENTS_IN_DDL, Boolean.toString(this.includeMaxExtentsInDDL), buffer);
        this.appendElement(INCLUDE_PCTINCREASE_IN_DDL, Boolean.toString(this.includePctIncreaseInDDL), buffer);
        this.appendElement(INCLUDE_BUFFERPOOL_IN_DDL, Boolean.toString(this.includeBufferPoolInDDL), buffer);
        this.appendElement(INCLUDE_FREELISTS_IN_DDL, Boolean.toString(this.includeFreeListsInDDL), buffer);
        this.appendElement(INCLUDE_FREELISTGROUPS_IN_DDL, Boolean.toString(this.includeFreeListGroupsInDDL), buffer);
        this.appendElement(INCLUDE_OPTIMAL_IN_DDL, Boolean.toString(this.includeOptimalInDDL), buffer);
        this.appendElement(INCLUDE_ENCRYPTION_IN_DDL, Boolean.toString(this.includeEncryptionInDDL), buffer);
        this.appendElement(USE_SQL_DEV_FORMATTING, Boolean.toString(this.useSQLDevFormatting), buffer);
        this.appendDialogsSettings(buffer);
        this.appendElement(DEFAULT_FK_RULE, this.getDefaultFKDeleteRule(), buffer);
        this.appendElement(DEFAULT_ALLOW_COLUMNS_REORDER, Boolean.toString(this.isDefaultAllowColumnsReorder()), buffer);
        this.appendElement(SYNC_REMOTE_OBJECTS_ON_LOAD, Boolean.toString(this.isSyncRemoteObjectsOnLoad()), buffer);
        this.appendElement(SURROGATE_KEY_LDT_PRECESION, this.surrogateKeyLDTPrecision, buffer);
        this.appendElement(SURROGATE_KEY_DOMAIN, this.surrogateKeyDomain, buffer);
        this.appendElement(DEFAULT_CREATE_SURROGATE_KEY, Boolean.toString(this.isDefaultCreateSurrogateKey()), buffer);
        this.appendElement(DEFAULT_USE_SURROGATE_KEY, Boolean.toString(this.isDefaultUseSurrogateKey()), buffer);
        this.appendElement(USE_PREFERRED_LOGICAL_TYPES, Boolean.toString(this.isUsePreferredLogicalTypes()), buffer);
        this.appendPreferredLogicalTypes(buffer);
        this.appendElement(VIEW_NAMING_RULE, this.getViewNamingRule(), buffer);
        this.appendElement(TABLE_NAMING_RULE, this.getTableNamingRule(), buffer);
        this.appendElement(RELOAD_LAST_STATE, Boolean.toString(this.reloadLastState), buffer);
        this.appendElement(USE_VERSIONING_FUNCTIONALITY, Boolean.toString(this.useVersioningFunctionality), buffer);
        this.appendElement(LAST_OPEN_DESIGN, this.lastOpenDesign, buffer);
        this.appendElement(LAST_OPEN_DPV, this.lastOpenDPV, buffer);
        this.appendCustomSettings(buffer);
        this.appendSyncObjects(buffer);
        this.appendElement(SEARCH_AS_U_TYPE, Boolean.toString(this.isSearchAsUType()), buffer);
        this.appendElement(SEARCH_AS_U_TYPE_START, Integer.toString(this.searchAsUTypeStart), buffer);
        this.appendElement(USE_DB_SYNC_SRC_CONNECTION, Boolean.toString(this.isUseDBSyncSourceConnection()), buffer);
        this.appendElement(USE_DB_SYNC_SRC_SCHEMA, Boolean.toString(this.isUseDBSyncSourceSchema()), buffer);
        this.appendElement(USE_DB_SYNC_SRC_OBJECT, Boolean.toString(this.isUseDBSyncSourceObject()), buffer);
        this.appendElement(DB_SYNC_WHOLE_SCHEMA, Boolean.toString(this.isSyncWholeSchema()), buffer);
        this.appendElement(IMPORT_PARTITIONS, Boolean.toString(this.isImportPartitions()), buffer);
        this.appendElement(IMPORT_TRIGGERS, Boolean.toString(this.isImportTriggers()), buffer);
        this.appendElement(SCAN_FOR_USED_STRUCTURED_TYPES, Boolean.toString(this.isScanForUsedStructuredTypes()), buffer);
        this.appendElement(IMPORT_SECONDARY_TABLES, Boolean.toString(this.isImportSecondaryTables()), buffer);
        this.appendElement(IMPORT_SPATIAL_PROPERTIES, Boolean.toString(this.isImportSpatialProperties()), buffer);
        this.appendUserDefinedPreferences(buffer);
    }

    private void addLocalSettings(StringBuffer buffer) {
        this.appendElement(DEFAULT_PROJECT_PATH_ELEMENT, this.defaultDesignsPath, buffer);
        this.appendElement(DEFAULT_IMPORT_PATH_ELEMENT, this.defaultImportPath, buffer);
        this.appendElement(DEFAULT_SAVE_PATH_ELEMENT, this.defaultSavePath, buffer);
        this.appendElement(COMPANY_NAME_ELEMENT, this.reportsCompanyName, buffer);
        this.appendElement(USE_PAGE_BREAKS_ELEMENT, Boolean.toString(this.usePageBreaksInReports), buffer);
        this.appendElement(EMBED_DIAGRAMS_IN_REPORTS, Boolean.toString(this.embedDiagramsInReports), buffer);
        this.appendElement(EMBED_MAIN_DIAGRAM_IN_REPORTS, Boolean.toString(this.embedMainDiagramInReports), buffer);
        this.appendElement(GROUP_BY_SCHEMA_NAME_IN_REPORT, Boolean.toString(this.groupBySchemaNameInReports), buffer);
        this.appendElement(GENERATE_HTML_REPORT_TOC_IN_SEPARATE_FILE, Boolean.toString(this.generateHTMLReportTOCInSeparateFile), buffer);
        this.appendElement(INCLUDE_SELECT_STATEMENT_IN_VIEW_REPORT, Boolean.toString(this.includeSelectStatementInViewReport), buffer);
        this.appendElement(DEFAULT_REPORTS_PATH_ELEMENT, this.defaultReportsPath, buffer);
        this.appendElement(DEFAULT_SAXON_PATH_ELEMENT, this.defaultSaxonPath, buffer);
        this.appendElement(DEFAULT_SEARCH_PROFILES_PATH_ELEMENT, this.defaultSearchProfilesPath, buffer);
        this.appendElement(DEFAULT_SYS_TYPES_PATH_ELEMENT, this.defaultSystemTypesPath, buffer);
        this.appendElement(LAST_EXPORT_FOLDER, this.lastExportFolder, buffer);
        this.appendElement(DEFAULT_DDL_FILES_PATH_ELEMENT, this.defaultDDLFilesPath, buffer);
        this.appendElement(INCLUDE_DESIGN_NAME_IN_DDL_FILES_PATH, String.valueOf(this.includeDesgnNameInDDLPath), buffer);
        this.appendElement(PRINTER_NAME, this.printerName, buffer);
        this.appendElement(PAPER_MEDIA_NAME, this.paperMediaName, buffer);
        this.appendElement(PAGE_ORIENTATION, Integer.toString(this.pageOrientation), buffer);
        this.appendElement(PAGE_WIDTH, Double.toString(this.pageWidth), buffer);
        this.appendElement(PAGE_HEIGHT, Double.toString(this.pageHeight), buffer);
        this.appendElement(PAGE_MARGIN_X, Double.toString(this.pageMarginX), buffer);
        this.appendElement(PAGE_MARGIN_Y, Double.toString(this.pageMarginY), buffer);
        this.appendElement(PAGE_MARGIN_WIDTH, Double.toString(this.pageMarginWidth), buffer);
        this.appendElement(PAGE_MARGIN_HEIGHT, Double.toString(this.pageMarginHeight), buffer);
        this.appendJDBCDrivers(buffer);
    }

    private void loadUserLevelSettings(Document doc) {
        this.defaultRDBMSSite = this.getValue(doc, DEFAULT_RDBMS_SITE);
        String value = this.getValue(doc, DEFAULT_RDBMS_TYPE);
        if (!"".equalsIgnoreCase(value)) {
            try {
                this.defaultRDBMSType = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SYNCHRONIZE_TREE_ELEMENT))) {
            this.synchronizeTree = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, GRID_SIZE_ELEMENT))) {
            try {
                this.gridSize = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SHOW_IMPORT_LOG))) {
            this.showImportLog = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, NULLS_ALLOWED))) {
            this.nullsAllowed = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, ALLOW_SIMILAR_TYPES_FK))) {
            this.allowSimilarTypesFK = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, FK_COLUMN_ON_NEW_FK_OPTION))) {
            try {
                this.fkColumnOnNewFKOption = Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, COLUMN_DEFAULT_DATATYPE))) {
            this.columnDefaultDatatype = value;
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, NEW_DB2_TABLESPACE_PER_TABLE))) {
            this.newDB2TableSpacePerTable = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, NEW_DB2_STORAGETEMPLATE_PER_TABLESPACE))) {
            this.newDB2StorageTemplatePerTableSpace = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, NEW_DB2_STORAGETEMPLATE_PER_INDEX))) {
            this.newDB2StorageTemplatePerIndex = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, ONE_DB2_STORAGETEMPLATE_PER_TS))) {
            this.oneDB2StorageTemplatePerTS = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, ONE_DB2_STORAGETEMPLATE_PER_INDEX))) {
            this.oneDB2StorageTemplatePerIndex = Boolean.valueOf(value);
        }
        this.defaultTSStorageTemplateName = this.getValue(doc, DEFAULT_TS_STORAGETEMPLATE_NAME);
        this.defaultIndexStorageTemplateName = this.getValue(doc, DEFAULT_INDEX_STORAGETEMPLATE_NAME);
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_DB2_OWNER))) {
            this.defaultDB2Owner = this.getValue(doc, DEFAULT_DB2_OWNER);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_DB2_DATABASE))) {
            this.defaultDB2Database = this.getValue(doc, DEFAULT_DB2_DATABASE);
        }
        this.defaultDB2TriggerName = this.getValue(doc, DEFAULT_DB2_TRIGGER_NAME);
        this.defaultDB2SequenceName = this.getValue(doc, DEFAULT_DB2_SEQUENCE_NAME);
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_DB2_AUTO_INC_DDL))) {
            this.defaultDB2AutoIncDDL = this.getValue(doc, DEFAULT_DB2_AUTO_INC_DDL);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_DB2_IDENTITY_DDL))) {
            this.defaultDB2IdentityDDL = this.getValue(doc, DEFAULT_DB2_IDENTITY_DDL);
        }
        this.namingRuleTablespaceDB2 = this.getValue(doc, NAMING_RULE_TABLESPACE);
        this.namingRuleStTablespaceDB2 = this.getValue(doc, NAMING_RULE_ST_TABLESPACE);
        this.namingRuleStIndexDB2 = this.getValue(doc, NAMING_RULE_ST_INDEX);
        this.defaultOracleUser = this.getValue(doc, DEFAULT_ORACLE_USER);
        this.defaultOracleTablespace = this.getValue(doc, DEFAULT_ORACLE_TABLESPACE);
        this.defaultOracleTriggerName = this.getValue(doc, DEFAULT_ORACLE_TRIGGER_NAME);
        this.defaultOracleSequenceName = this.getValue(doc, DEFAULT_ORACLE_SEQUENCE_NAME);
        this.defaultOracleAutoIncDDL = this.getValue(doc, DEFAULT_ORACLE_AUTO_INC_DDL);
        this.defaultOracleIdentityDDL = this.getValue(doc, DEFAULT_ORACLE_IDENTITY_DDL);
        value = this.getValue(doc, USE_ORACLE_TABLE_TEMPLATE);
        if (!"".equalsIgnoreCase(value)) {
            this.useOracleTableTemplate = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_ORACLE_INDEX_TEMPLATE))) {
            this.useOracleIndexTemplate = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SOURCE_OPTIONAL))) {
            this.sourceOptional = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, TARGET_OPTIONAL))) {
            this.targetOptional = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_UDB_OWNER))) {
            this.defaultUDBOwner = this.getValue(doc, DEFAULT_UDB_OWNER);
        }
        this.defaultUDBTriggerName = this.getValue(doc, DEFAULT_UDB_TRIGGER_NAME);
        this.defaultUDBSequenceName = this.getValue(doc, DEFAULT_UDB_SEQUENCE_NAME);
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_UDB_AUTO_INC_DDL))) {
            this.defaultUDBAutoIncDDL = this.getValue(doc, DEFAULT_UDB_AUTO_INC_DDL);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_UDB_IDENTITY_DDL))) {
            this.defaultUDBIdentityDDL = this.getValue(doc, DEFAULT_UDB_IDENTITY_DDL);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SHOW_SELECT_RELATIONAL_MODEL_DIALOG))) {
            this.showSelectRelModelDialog = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PK_IDENTIFYING_RELATION))) {
            this.useFirstUniqueForIdentifyingRelation = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, KEEP_FK_NAMES_SYNCHRONIZED))) {
            this.keepFKNamesSynchronized = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PROPAGATE_PK_ATTR_NOTES))) {
            this.propagatePKAttrNotes = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, DELETE_FK_COLUMNS_STRATEGY))) {
            try {
                this.deleteFKColumnStrategy = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, CUSTOM_PREFIX))) {
            this.entityPrefix = this.getValue(doc, CUSTOM_PREFIX);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, RENAME_STRATEGY))) {
            try {
                this.renameStrategy = Integer.parseInt(this.getValue(doc, RENAME_STRATEGY));
            }
            catch (Exception e) {
                this.renameStrategy = 1;
            }
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, NOTATION))) {
            try {
                this.notation = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, FK_2_PK_ARROW))) {
            this.fk2pkArrow = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTO_JOIN_ON_FK))) {
            this.autoJoinOnFK = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, BOX_IN_BOX))) {
            this.boxInBox = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, TYPE_SUBST_TRIGGERS))) {
            this.generateTypeSubstTriggers = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, FKARC_TRIGGERS))) {
            this.generateFKArcTriggers = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, FKNONETRANSF_TRIGGERS))) {
            this.generateFKNoneTransferableTriggers = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SHOW_CHAR_BYTE_IN_DDL))) {
            this.showByteCharInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, EXTENDED_SIZE_FOR_CHARS))) {
            this.extendedSizeForCharacters = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_DATA_TYPE_KIND_IN_COMPARE))) {
            this.useDataTypeKindInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_SCHEMA_PROPERTY_IN_COMPARE))) {
            this.useSchemaPropertyInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_COLUMNS_ORDER_PROPERTY_IN_COMPARE))) {
            this.useColumnsOrderPropertyInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_PHYSICAL_PROPERTIES_IN_COMPARE))) {
            this.includePhysicalPropertiesInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_STORAGE_PROPERTIES_IN_COMPARE))) {
            this.includeStoragePropertiesInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_CASE_SENSITIVE_NAMES_IN_COMPARE))) {
            this.caseSensitiveNamesInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_SYSTEM_NAMES_IN_COMPARE))) {
            this.includeSystemNamesInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_GEN_IN_DDL_IN_COMPARE))) {
            this.useGenInDDLInCompare = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SHOW_PROPERTIES_DIALOG_ON_NEW))) {
            this.showPropertiesDialogOnNew = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, NOT_NULL_SHORT_FORM_GENERATION))) {
            this.notNullShortFormGeneration = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_QUOTED_IDENTIFIERS))) {
            this.useQuotedIdentifiers = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, CREATE_DOMAINS_DURING_IMPORT))) {
            this.createDomainsDuringImport = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, REPLACE_SYSTEM_NAMES_DURING_IMPORT))) {
            this.replaceSystemNamesDuringImport = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, GENERATE_COMMENTS_IN_RDBMS))) {
            this.generateCommentsInRDBMS = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, GENERATE_INLINE_COLUMN_CC))) {
            this.generateInlineColumnCC = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, GENERATE_VALID_VALUE_CC))) {
            this.generateValidValueCC = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_DEFAULT_SETTINGS_IN_DDL))) {
            this.includeDefaultSettingsInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_LOGGING_IN_DDL))) {
            this.includeLoggingInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_SCHEMA_IN_DDL))) {
            this.includeSchemaInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_STORAGE_IN_DDL))) {
            this.includeStorageInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_TABLESPACE_IN_DDL))) {
            this.includeTablespaceInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_REDACTION_IN_DDL))) {
            this.includeRedactionInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_TSDP_IN_DDL))) {
            this.includeTSDPInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_PROMPT_IN_DDL))) {
            this.includePrompt = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_PCTFREE_IN_DDL))) {
            this.includePctFreeInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_PCTUSED_IN_DDL))) {
            this.includePctUsedInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_INITRANS_IN_DDL))) {
            this.includeInitransInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_INITIALEXTENT_IN_DDL))) {
            this.includeInitialExtentInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_NEXTEXTENT_IN_DDL))) {
            this.includeNextExtentInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_MINEXTENTS_IN_DDL))) {
            this.includeMinExtentsInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_MAXEXTENTS_IN_DDL))) {
            this.includeMaxExtentsInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_PCTINCREASE_IN_DDL))) {
            this.includePctIncreaseInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_BUFFERPOOL_IN_DDL))) {
            this.includeBufferPoolInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_FREELISTS_IN_DDL))) {
            this.includeFreeListsInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_FREELISTGROUPS_IN_DDL))) {
            this.includeFreeListGroupsInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_OPTIMAL_IN_DDL))) {
            this.includeOptimalInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_ENCRYPTION_IN_DDL))) {
            this.includeEncryptionInDDL = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_SQL_DEV_FORMATTING))) {
            this.useSQLDevFormatting = Boolean.valueOf(value);
        }
        this.defaultFKRule = this.getValue(doc, DEFAULT_FK_RULE);
        this.viewNamingRule = this.getValue(doc, VIEW_NAMING_RULE);
        this.tableNamingRule = this.getValue(doc, TABLE_NAMING_RULE);
        value = this.getValue(doc, DEFAULT_ALLOW_COLUMNS_REORDER);
        if (!"".equalsIgnoreCase(value)) {
            this.defaultAllowColumnsReorder = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SYNC_REMOTE_OBJECTS_ON_LOAD))) {
            this.syncRemoteObjectsOnLoad = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, DEFAULT_CREATE_SURROGATE_KEY))) {
            this.defaultCreateSurrogateKey = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, DEFAULT_USE_SURROGATE_KEY))) {
            this.defaultUseSurrogateKey = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_PREFERRED_LOGICAL_TYPES))) {
            this.usePreferredLogicalTypes = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_SQL_SERVER_DATABASE))) {
            this.defaultSqlServerDatabase = this.getValue(doc, DEFAULT_SQL_SERVER_DATABASE);
        }
        this.defaultSqlServerTriggerName = this.getValue(doc, DEFAULT_SQL_SERVER_TRIGGER_NAME);
        this.defaultSqlServerSequenceName = this.getValue(doc, DEFAULT_SQL_SERVER_SEQUENCE_NAME);
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_SQL_SERVER_AUTO_INC_DDL))) {
            this.defaultSqlServerAutoIncDDL = this.getValue(doc, DEFAULT_SQL_SERVER_AUTO_INC_DDL);
        }
        if (!"".equalsIgnoreCase(this.getValue(doc, DEFAULT_SQL_SERVER_IDENTITY_DDL))) {
            this.defaultSqlServerIdentityDDL = this.getValue(doc, DEFAULT_SQL_SERVER_IDENTITY_DDL);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, RELOAD_LAST_STATE))) {
            this.reloadLastState = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_VERSIONING_FUNCTIONALITY))) {
            this.useVersioningFunctionality = Boolean.valueOf(value);
        }
        this.surrogateKeyLDTPrecision = this.getValue(doc, SURROGATE_KEY_LDT_PRECESION);
        this.surrogateKeyDomain = this.getValue(doc, SURROGATE_KEY_DOMAIN);
        this.lastOpenDesign = this.getValue(doc, LAST_OPEN_DESIGN);
        this.lastOpenDPV = this.getValue(doc, LAST_OPEN_DPV);
        value = this.getValue(doc, SEARCH_AS_U_TYPE);
        if (!"".equalsIgnoreCase(value)) {
            this.searchAsUType = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SEARCH_AS_U_TYPE_START))) {
            this.searchAsUTypeStart = Integer.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_DB_SYNC_SRC_CONNECTION))) {
            this.useDBSyncSourceConnection = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_DB_SYNC_SRC_SCHEMA))) {
            this.useDBSyncSourceSchema = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_DB_SYNC_SRC_OBJECT))) {
            this.UseDBSyncSourceObject = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, DB_SYNC_WHOLE_SCHEMA))) {
            this.syncWholeSchema = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, IMPORT_PARTITIONS))) {
            this.importPartitions = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, IMPORT_TRIGGERS))) {
            this.importTriggers = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, SCAN_FOR_USED_STRUCTURED_TYPES))) {
            this.scanForUsedStructuredTypes = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, IMPORT_SECONDARY_TABLES))) {
            this.importSecondaryTables = Boolean.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, IMPORT_SPATIAL_PROPERTIES))) {
            this.importSpatialProperties = Boolean.valueOf(value);
        }
    }

    private void loadLocalSettings(Document doc) {
        this.defaultDesignsPath = this.getValue(doc, DEFAULT_PROJECT_PATH_ELEMENT);
        this.defaultImportPath = this.getValue(doc, DEFAULT_IMPORT_PATH_ELEMENT);
        this.defaultSavePath = this.getValue(doc, DEFAULT_SAVE_PATH_ELEMENT);
        this.reportsCompanyName = this.getValue(doc, COMPANY_NAME_ELEMENT);
        this.usePageBreaksInReports = Boolean.valueOf(this.getValue(doc, USE_PAGE_BREAKS_ELEMENT));
        this.embedDiagramsInReports = Boolean.valueOf(this.getValue(doc, EMBED_DIAGRAMS_IN_REPORTS));
        this.embedMainDiagramInReports = Boolean.valueOf(this.getValue(doc, EMBED_MAIN_DIAGRAM_IN_REPORTS));
        this.groupBySchemaNameInReports = Boolean.valueOf(this.getValue(doc, GROUP_BY_SCHEMA_NAME_IN_REPORT));
        this.generateHTMLReportTOCInSeparateFile = Boolean.valueOf(this.getValue(doc, GENERATE_HTML_REPORT_TOC_IN_SEPARATE_FILE));
        this.includeSelectStatementInViewReport = Boolean.valueOf(this.getValue(doc, INCLUDE_SELECT_STATEMENT_IN_VIEW_REPORT));
        this.defaultReportsPath = this.getValue(doc, DEFAULT_REPORTS_PATH_ELEMENT);
        this.defaultSaxonPath = this.getValue(doc, DEFAULT_SAXON_PATH_ELEMENT);
        this.defaultSearchProfilesPath = this.getValue(doc, DEFAULT_SEARCH_PROFILES_PATH_ELEMENT);
        this.defaultSystemTypesPath = this.getValue(doc, DEFAULT_SYS_TYPES_PATH_ELEMENT);
        this.lastExportFolder = this.getValue(doc, LAST_EXPORT_FOLDER);
        this.defaultDDLFilesPath = this.getValue(doc, DEFAULT_DDL_FILES_PATH_ELEMENT);
        String value = this.getValue(doc, PRINTER_NAME);
        if (!"".equalsIgnoreCase(value)) {
            this.printerName = value;
        }
        this.includeDesgnNameInDDLPath = "true".equalsIgnoreCase(value = this.getValue(doc, INCLUDE_DESIGN_NAME_IN_DDL_FILES_PATH));
        value = this.getValue(doc, PAPER_MEDIA_NAME);
        if (!"".equalsIgnoreCase(value)) {
            this.paperMediaName = value;
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_ORIENTATION))) {
            this.pageOrientation = Integer.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_WIDTH))) {
            this.pageWidth = Double.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_HEIGHT))) {
            this.pageHeight = Double.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_MARGIN_X))) {
            this.pageMarginX = Double.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_MARGIN_Y))) {
            this.pageMarginY = Double.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_MARGIN_WIDTH))) {
            this.pageMarginWidth = Double.valueOf(value);
        }
        if (!"".equalsIgnoreCase(value = this.getValue(doc, PAGE_MARGIN_HEIGHT))) {
            this.pageMarginHeight = Double.valueOf(value);
        }
        this.initJDBCDrivers(doc);
        this.loadDBMConnections(doc);
        this.loadODConnections(doc);
        this.loadRSConnections(doc);
    }

    public static Document getDocument(String xmlString) {
        try {
            StringReader sr = new StringReader(xmlString);
            InputSource inputSource = new InputSource(sr);
            Document doc = DOCUMENT_BUILDER.parse(inputSource);
            sr.close();
            return doc;
        }
        catch (Exception e) {
            LOGGER.error("Settings: problem parsing settings: \n ", e);
            return null;
        }
    }

    public String getColumnDefaultDatatype() {
        return this.columnDefaultDatatype;
    }

    public void setColumnDefaultDatatype(String columnDefaultDatatype) {
        this.columnDefaultDatatype = columnDefaultDatatype;
    }

    public boolean isGenerateCommentsInRDBMS() {
        return this.generateCommentsInRDBMS;
    }

    public void setGenerateCommentsInRDBMS(boolean generateCommentsInRDBMS) {
        this.generateCommentsInRDBMS = generateCommentsInRDBMS;
    }

    public boolean isGenerateInlineColumnCC() {
        return this.generateInlineColumnCC;
    }

    public void setGenerateInlineColumnCC(boolean generateInlineColumnCC) {
        this.generateInlineColumnCC = generateInlineColumnCC;
    }

    public boolean isGenerateValidValueCC() {
        return this.generateValidValueCC;
    }

    public void setGenerateValidValueCC(boolean generateValidValueCC) {
        this.generateValidValueCC = generateValidValueCC;
    }

    public float getLoadedVersion() {
        return 1.1f;
    }

    public boolean isUseSchemaPropertyInCompare() {
        return this.useSchemaPropertyInCompare;
    }

    public void setUseSchemaPropertyInCompare(boolean useSchemaPropertyInCompare) {
        this.useSchemaPropertyInCompare = useSchemaPropertyInCompare;
    }

    public boolean isUseColumnsOrderPropertyInCompare() {
        return this.useColumnsOrderPropertyInCompare;
    }

    public void setUseColumnsOrderPropertyInCompare(boolean useColumnsOrderPropertyInCompare) {
        this.useColumnsOrderPropertyInCompare = useColumnsOrderPropertyInCompare;
    }

    public boolean isIncludePhysicalPropertiesInCompare() {
        return this.includePhysicalPropertiesInCompare;
    }

    public void setIncludePhysicalPropertiesInCompare(boolean includePhysicalPropertiesInCompare) {
        this.includePhysicalPropertiesInCompare = includePhysicalPropertiesInCompare;
    }

    public boolean isIncludeStoragePropertiesInCompare() {
        return this.includeStoragePropertiesInCompare;
    }

    public void setIncludeStoragePropertiesInCompare(boolean includeStoragePropertiesInCompare) {
        this.includeStoragePropertiesInCompare = includeStoragePropertiesInCompare;
    }

    public boolean isCaseSensitiveNamesInCompare() {
        return this.caseSensitiveNamesInCompare;
    }

    public void setCaseSensitiveNamesInCompare(boolean caseSensitiveNamesInCompare) {
        this.caseSensitiveNamesInCompare = caseSensitiveNamesInCompare;
    }

    public boolean isIncludeSystemNamesInCompare() {
        return this.includeSystemNamesInCompare;
    }

    public void setIncludeSystemNamesInCompare(boolean includeSystemNamesInCompare) {
        this.includeSystemNamesInCompare = includeSystemNamesInCompare;
    }

    public boolean isIncludeDefaultSettingsInDDL() {
        return this.includeDefaultSettingsInDDL;
    }

    public void setIncludeDefaultSettingsInDDL(boolean includeDefaultSettingsInDDL) {
        this.includeDefaultSettingsInDDL = includeDefaultSettingsInDDL;
    }

    public boolean isIncludeLoggingInDDL() {
        return this.includeLoggingInDDL;
    }

    public void setIncludeLoggingInDDL(boolean includeLoggingInDDL) {
        this.includeLoggingInDDL = includeLoggingInDDL;
    }

    public boolean isIncludeSchemaInDDL() {
        return this.includeSchemaInDDL;
    }

    public void setIncludeSchemaInDDL(boolean includeSchemaInDDL) {
        this.includeSchemaInDDL = includeSchemaInDDL;
    }

    public boolean isIncludeStorageInDDL() {
        return this.includeStorageInDDL;
    }

    public void setIncludeStorageInDDL(boolean includeStorageInDDL) {
        this.includeStorageInDDL = includeStorageInDDL;
    }

    public boolean isIncludeTablespaceInDDL() {
        return this.includeTablespaceInDDL;
    }

    public void setIncludeTablespaceInDDL(boolean includeTablespaceInDDL) {
        this.includeTablespaceInDDL = includeTablespaceInDDL;
    }

    public boolean isIncludeRedactionInDDL() {
        return this.includeRedactionInDDL;
    }

    public void setIncludeRedactionInDDL(boolean includeRedactionInDDL) {
        this.includeRedactionInDDL = includeRedactionInDDL;
    }

    public boolean isIncludeTSDPInDDL() {
        return this.includeTSDPInDDL;
    }

    public void setIncludeTSDPInDDL(boolean includeTSDPInDDL) {
        this.includeTSDPInDDL = includeTSDPInDDL;
    }

    public boolean isIncludePromptInDDL() {
        return this.includePrompt;
    }

    public void setIncludePromptInDDL(boolean includePromptInDDL) {
        this.includePrompt = includePromptInDDL;
    }

    public boolean isIncludePctFreeInDDL() {
        return this.includePctFreeInDDL;
    }

    public void setIncludePctFreeInDDL(boolean includePctFree) {
        this.includePctFreeInDDL = includePctFree;
    }

    public boolean isIncludePctUsedInDDL() {
        return this.includePctUsedInDDL;
    }

    public void setIncludePctUsedInDDL(boolean includePctUsed) {
        this.includePctUsedInDDL = includePctUsed;
    }

    public boolean isIncludeInitransInDDL() {
        return this.includeInitransInDDL;
    }

    public void setIncludeInitransInDDL(boolean includeInitrans) {
        this.includeInitransInDDL = includeInitrans;
    }

    public boolean isIncludeInitialExtentInDDL() {
        return this.includeInitialExtentInDDL;
    }

    public void setIncludeInitialExtentInDDL(boolean includeInitialExtent) {
        this.includeInitialExtentInDDL = includeInitialExtent;
    }

    public boolean isIncludeNextExtentInDDL() {
        return this.includeNextExtentInDDL;
    }

    public void setIncludeNextExtentInDDL(boolean includeNextExtent) {
        this.includeNextExtentInDDL = includeNextExtent;
    }

    public boolean isIncludeMinExtentsInDDL() {
        return this.includeMinExtentsInDDL;
    }

    public void setIncludeMinExtentsInDDL(boolean includeMinExtents) {
        this.includeMinExtentsInDDL = includeMinExtents;
    }

    public boolean isIncludeMaxExtentsInDDL() {
        return this.includeMaxExtentsInDDL;
    }

    public void setIncludeMaxExtentsInDDL(boolean includeMaxExtents) {
        this.includeMaxExtentsInDDL = includeMaxExtents;
    }

    public boolean isIncludePctIncreaseInDDL() {
        return this.includePctIncreaseInDDL;
    }

    public void setIncludePctIncreaseInDDL(boolean includePctIncrease) {
        this.includePctIncreaseInDDL = includePctIncrease;
    }

    public boolean isIncludeBufferPoolInDDL() {
        return this.includeBufferPoolInDDL;
    }

    public void setIncludeBufferPoolInDDL(boolean includeBufferPool) {
        this.includeBufferPoolInDDL = includeBufferPool;
    }

    public boolean isIncludeFreeListsInDDL() {
        return this.includeFreeListsInDDL;
    }

    public void setIncludeFreeListsInDDL(boolean includeFreeLists) {
        this.includeFreeListsInDDL = includeFreeLists;
    }

    public boolean isIncludeFreeListGroupsInDDL() {
        return this.includeFreeListGroupsInDDL;
    }

    public void setIncludeFreeListGroupsInDDL(boolean includeFreeListGroups) {
        this.includeFreeListGroupsInDDL = includeFreeListGroups;
    }

    public boolean isIncludeOptimalInDDL() {
        return this.includeOptimalInDDL;
    }

    public void setIncludeOptimalInDDL(boolean includeOptimal) {
        this.includeOptimalInDDL = includeOptimal;
    }

    public boolean isIncludeEncryptionInDDL() {
        return this.includeEncryptionInDDL;
    }

    public void setIncludeEncryptionInDDL(boolean includeEncryptionInDDL) {
        this.includeEncryptionInDDL = includeEncryptionInDDL;
    }

    public boolean useSQLDevFormatting() {
        return this.useSQLDevFormatting;
    }

    public void setUseSQLDevFormatting(boolean useSQLDevFormatting) {
        this.useSQLDevFormatting = useSQLDevFormatting;
    }

    public String saveSettingsToString() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append('\n');
        buffer.append('<').append(SETTINGS_ELEMENT).append(' ').append(SETTINGS_VERSION).append("=\"").append(this.loadedVersion).append("\">");
        this.addLocalSettings(buffer);
        this.addUserlevelSettings(buffer);
        buffer.append('\n');
        buffer.append("</").append(SETTINGS_ELEMENT).append('>');
        return buffer.toString();
    }

    private void appendPreferredLogicalTypes(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append(PREFERRED_LOGICAL_TYPES).append(">");
        for (LogicalDatatype ld : this.getPreferredLogicaltypes()) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(TYPE).append(' ');
            buffer.append("name=\"").append(ld.getName()).append("\"").append(' ');
            buffer.append("id=\"").append(ld.getObjectID()).append("\"");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(PREFERRED_LOGICAL_TYPES).append(">");
    }

    public String getDefaultSystemTypesPath() {
        return this.defaultSystemTypesPath;
    }

    public void initDefaultSystemTypesPath(String defaultSystemTypesPath) {
        this.defaultSystemTypesPath = defaultSystemTypesPath;
    }

    public String getDefaultReportsPath() {
        return this.defaultReportsPath;
    }

    public void setDefaultReportsPath(String defaultReportsPath) {
        this.defaultReportsPath = defaultReportsPath;
    }

    public String getDefaultSaxonPath() {
        return this.defaultSaxonPath;
    }

    public void setDefaultSaxonPath(String defaultSaxonPath) {
        this.defaultSaxonPath = defaultSaxonPath;
    }

    public String getDefaultSearchProfilesPath() {
        return this.defaultSearchProfilesPath;
    }

    public void setDefaultSearchProfilesPath(String defaultSearchProfilesPath) {
        this.defaultSearchProfilesPath = defaultSearchProfilesPath;
    }

    public ArrayList getPreferredLT() {
        return this.preferredLT;
    }

    public boolean isReloadLastState() {
        return this.reloadLastState;
    }

    public void setReloadLastState(boolean reloadLastState) {
        this.reloadLastState = reloadLastState;
    }

    public boolean isUseVersioningFunctionality() {
        return this.useVersioningFunctionality;
    }

    public void setUseVersioningFunctionality(boolean useVersioningFunctionality) {
        this.useVersioningFunctionality = useVersioningFunctionality;
    }

    public String getLastOpenDesign() {
        return this.lastOpenDesign;
    }

    public void setLastOpenDesign(String lastOpenDesign) {
        this.lastOpenDesign = lastOpenDesign;
    }

    public String getLastOpenDPV() {
        return this.lastOpenDPV;
    }

    public void setLastOpenDPV(String lastOpenDPV) {
        this.lastOpenDPV = lastOpenDPV;
    }

    public List getSyncObjects() {
        return this.syncObjects;
    }

    public SyncObject getSyncObject(String type, String db) {
        for (SyncObject so : this.syncObjects) {
            if (!so.getDatabase().equals(db) || !so.getType().equals(type)) continue;
            return so;
        }
        return null;
    }

    private void initDefaultSyncObjects() {
        if (this.syncObjects == null) {
            this.syncObjects = new ArrayList();
        }
        this.syncObjects.add(new SyncObject("CLUSTER", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("CONTEXT", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("DIMENSION", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("DIRECTORY", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("FUNCTION", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("PACKAGE", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("PROCEDURE", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("ROLE", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("SEQUENCE", true, DB_ORACLE));
        this.syncObjects.add(new SyncObject("SYNONYM", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("TABLESPACE", true, DB_ORACLE));
        this.syncObjects.add(new SyncObject("TEMP TABLESPACE", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("UNDO TABLESPACE", false, DB_ORACLE));
        this.syncObjects.add(new SyncObject("USER", false, DB_ORACLE));
    }

    private void appendSyncObjects(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(SYNCHRONIZATION_TYPES).append('>');
        for (SyncObject so : this.getSyncObjects()) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(TYPE).append(' ');
            buffer.append("db=\"").append(so.getDatabase()).append("\" ");
            buffer.append("name=\"").append(so.getType()).append("\" ");
            buffer.append("used=\"").append(so.isUsed()).append("\" ");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(SYNCHRONIZATION_TYPES).append(">");
    }

    public boolean isDefaultAllowColumnsReorder() {
        return this.defaultAllowColumnsReorder;
    }

    public void setDefaultAllowColumnsReorder(boolean defaultAllowColumnsReorder) {
        this.defaultAllowColumnsReorder = defaultAllowColumnsReorder;
    }

    public boolean isDefaultCreateSurrogateKey() {
        return this.defaultCreateSurrogateKey;
    }

    public void setDefaultCreateSurrogateKey(boolean defaultCreateSurrogateKey) {
        this.defaultCreateSurrogateKey = defaultCreateSurrogateKey;
    }

    public boolean isDefaultUseSurrogateKey() {
        return this.defaultUseSurrogateKey;
    }

    public void setDefaultUseSurrogateKey(boolean defaultUseSurrogateKey) {
        this.defaultUseSurrogateKey = defaultUseSurrogateKey;
    }

    public boolean isPropagatePKAttrNotes() {
        return this.propagatePKAttrNotes;
    }

    public void setPropagatePKAttrNotes(boolean propagatePKAttrNotes) {
        this.propagatePKAttrNotes = propagatePKAttrNotes;
    }

    public boolean isSyncRemoteObjectsOnLoad() {
        return this.syncRemoteObjectsOnLoad;
    }

    public void setSyncRemoteObjectsOnLoad(boolean syncRemoteObjectsOnLoad) {
        this.syncRemoteObjectsOnLoad = syncRemoteObjectsOnLoad;
    }

    public String getSurrogateKeyLDTPrecision() {
        return this.surrogateKeyLDTPrecision;
    }

    public void setSurrogateKeyLDTPrecision(String surrogateKeyLDTPrecision) {
        this.surrogateKeyLDTPrecision = surrogateKeyLDTPrecision;
    }

    public void setSurrogateKeyDomain(String surrogateKeyDomainObjId) {
        this.surrogateKeyDomain = surrogateKeyDomainObjId;
    }

    public boolean isSearchAsUType() {
        return this.searchAsUType;
    }

    public void setSearchAsUType(boolean searchAsUType) {
        this.searchAsUType = searchAsUType;
    }

    public int getSearchAsUTypeStart() {
        return this.searchAsUTypeStart;
    }

    public void setSearchAsUTypeStart(int searchAsUTypeStart) {
        this.searchAsUTypeStart = searchAsUTypeStart;
    }

    public boolean isAutoJoinOnFK() {
        return this.autoJoinOnFK;
    }

    public void setAutoJoinOnFK(boolean autoJoinOnFK) {
        this.autoJoinOnFK = autoJoinOnFK;
    }

    public boolean isUseDBSyncSourceConnection() {
        return this.useDBSyncSourceConnection;
    }

    public void setUseDBSyncSourceConnection(boolean useDBSyncSourceConnection) {
        this.useDBSyncSourceConnection = useDBSyncSourceConnection;
    }

    public boolean isUseDBSyncSourceSchema() {
        return this.useDBSyncSourceSchema;
    }

    public void setUseDBSyncSourceSchema(boolean useDBSyncSourceSchema) {
        this.useDBSyncSourceSchema = useDBSyncSourceSchema;
    }

    public boolean isUseDBSyncSourceObject() {
        return this.UseDBSyncSourceObject;
    }

    public void setUseDBSyncSourceObject(boolean useDBSyncSourceObject) {
        this.UseDBSyncSourceObject = useDBSyncSourceObject;
    }

    public String getDefaultDDLFilesPath() {
        return this.defaultDDLFilesPath;
    }

    public void setDefaultDDLFilesPath(String defaultDDLFilesPath) {
        this.defaultDDLFilesPath = defaultDDLFilesPath;
    }

    public List getSearchProfilesPaths() {
        return this.searchProfilesPaths;
    }

    public void setSearchProfilesPaths(List searchProfilesPaths) {
        this.searchProfilesPaths = searchProfilesPaths;
    }

    public String getReportsCompanyName() {
        return this.reportsCompanyName;
    }

    public void setReportsCompanyName(String reportsCompanyName) {
        this.reportsCompanyName = reportsCompanyName;
    }

    public boolean isUsePageBreaksInReports() {
        return this.usePageBreaksInReports;
    }

    public void setUsePageBreaksInReports(boolean usePageBreaksInReports) {
        this.usePageBreaksInReports = usePageBreaksInReports;
    }

    public boolean isExtendedSizeForCharacters() {
        return this.extendedSizeForCharacters;
    }

    public void setExtendedSizeForCharacters(boolean extendedSizeForCharacters) {
        this.extendedSizeForCharacters = extendedSizeForCharacters;
    }

    public boolean isIncludeDesgnNameInDDLPath() {
        return this.includeDesgnNameInDDLPath;
    }

    public void setIncludeDesgnNameInDDLPath(boolean includeDesgnNameInDDLPath) {
        this.includeDesgnNameInDDLPath = includeDesgnNameInDDLPath;
    }

    public boolean isSyncWholeSchema() {
        return this.syncWholeSchema;
    }

    public void setSyncWholeSchema(boolean syncWholeSchema) {
        this.syncWholeSchema = syncWholeSchema;
    }

    public boolean isImportPartitions() {
        return this.importPartitions;
    }

    public void setImportPartitions(boolean importPartitions) {
        this.importPartitions = importPartitions;
    }

    public boolean isImportTriggers() {
        return this.importTriggers;
    }

    public void setImportTriggers(boolean importTriggers) {
        this.importTriggers = importTriggers;
    }

    public boolean isScanForUsedStructuredTypes() {
        return this.scanForUsedStructuredTypes;
    }

    public void setScanForUsedStructuredTypes(boolean scanForUsedStructuredTypes) {
        this.scanForUsedStructuredTypes = scanForUsedStructuredTypes;
    }

    public boolean isImportSecondaryTables() {
        return this.importSecondaryTables;
    }

    public void setImportSecondaryTables(boolean importSecondaryTables) {
        this.importSecondaryTables = importSecondaryTables;
    }

    public boolean isImportSpatialProperties() {
        return this.importSpatialProperties;
    }

    public void setImportSpatialProperties(boolean importSpatialProperties) {
        this.importSpatialProperties = importSpatialProperties;
    }

    public boolean isAllowSimilarTypesFK() {
        return this.allowSimilarTypesFK;
    }

    public void setAllowSimilarTypesFK(boolean allowSimilarTypesFK) {
        this.allowSimilarTypesFK = allowSimilarTypesFK;
    }

    public int getFkColumnOnNewFKOption() {
        return this.fkColumnOnNewFKOption;
    }

    public void setFkColumnOnNewFKOption(int fkColumnOnNewFKOption) {
        this.fkColumnOnNewFKOption = fkColumnOnNewFKOption;
    }

    public boolean isEmbedDiagramsInReports() {
        return this.embedDiagramsInReports;
    }

    public void setEmbedDiagramsInReports(boolean embedDiagramsInReports) {
        this.embedDiagramsInReports = embedDiagramsInReports;
    }

    public boolean isEmbedMainDiagramInReports() {
        return this.embedMainDiagramInReports;
    }

    public void setEmbedMainDiagramInReports(boolean embedMainDiagramInReports) {
        this.embedMainDiagramInReports = embedMainDiagramInReports;
    }

    public String getUserDefinedPreferenceValue(String name) {
        return this.getUserDefinedPreferences().get(name);
    }

    public void addUserDefinedPreference(String name, String value) {
        this.getUserDefinedPreferences().put(name, value);
    }

    public TreeMap<String, String> getUserDefinedPreferences() {
        return this.userDefinedPreferences;
    }

    public boolean isGenerateHTMLReportTOCInSeparateFile() {
        return this.generateHTMLReportTOCInSeparateFile;
    }

    public void setGenerateHTMLReportTOCInSeparateFile(boolean generateHTMLReportTOCInSeparateFile) {
        this.generateHTMLReportTOCInSeparateFile = generateHTMLReportTOCInSeparateFile;
    }

    public boolean isIncludeSelectStatementInViewReport() {
        return this.includeSelectStatementInViewReport;
    }

    public void setIncludeSelectStatementInViewReport(boolean includeSelectStatementInViewReport) {
        this.includeSelectStatementInViewReport = includeSelectStatementInViewReport;
    }

    private void appendUserDefinedPreferences(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(USER_DEFINED_PREFERENCES).append('>');
        buffer.append('\n');
        TreeMap<String, String> udpMap = this.getUserDefinedPreferences();
        Set<Map.Entry<String, String>> set = udpMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            buffer.append('\t');
            buffer.append('<').append(USER_DEFINED_PREFERENCE).append(' ').append(TAG_NAME).append("=\"").append(entry.getKey()).append("\"").append(' ').append(TAG_VALUE).append("=\"").append(entry.getValue()).append("\"/>");
            buffer.append('\n');
        }
        buffer.append('\t').append("</").append(USER_DEFINED_PREFERENCES).append(">");
    }

    public boolean isImportColumnDetails() {
        return this.importColumnDetails;
    }

    public void setImportColumnDetails(boolean importColumnDetails) {
        this.importColumnDetails = importColumnDetails;
    }

    public boolean isImportCommentsInRDBMS() {
        return this.importCommentsInRDBMS;
    }

    public void setImportCommentsInRDBMS(boolean importCommentsInRDBMS) {
        this.importCommentsInRDBMS = importCommentsInRDBMS;
    }

    public boolean isCheckForExternalTable() {
        return this.checkForExternalTable;
    }

    public void setCheckForExternalTable(boolean checkForExternalTable) {
        this.checkForExternalTable = checkForExternalTable;
    }

    public boolean isIncludeSystemNames() {
        return this.includeSystemNames;
    }

    public void setIncludeSystemNames(boolean includeSystemNames) {
        this.includeSystemNames = includeSystemNames;
    }

    public boolean isImportObjectTypes() {
        return this.importObjectTypes;
    }

    public void setImportObjectTypes(boolean importObjectTypes) {
        this.importObjectTypes = importObjectTypes;
    }

    public boolean isImportTables() {
        return this.importTables;
    }

    public void setImportTables(boolean importTables) {
        this.importTables = importTables;
    }

    public boolean isImportMViews() {
        return this.importMViews;
    }

    public void setImportMViews(boolean importMViews) {
        this.importMViews = importMViews;
    }

    public boolean isImportIndexes() {
        return this.importIndexes;
    }

    public void setImportIndexes(boolean importIndexes) {
        this.importIndexes = importIndexes;
    }

    public boolean isImportConstraints() {
        return this.importConstraints;
    }

    public void setImportConstraints(boolean importConstraintss) {
        this.importConstraints = importConstraintss;
    }

    public boolean isImportSynonyms() {
        return this.importSynonyms;
    }

    public void setImportSynonyms(boolean importSynonyms) {
        this.importSynonyms = importSynonyms;
    }

    public boolean isImportPublicSynonyms() {
        return this.importPublicSynonyms;
    }

    public void setImportPublicSynonyms(boolean importPublicSynonyms) {
        this.importPublicSynonyms = importPublicSynonyms;
    }

    public boolean isIncludeSupplementalLogInDDL() {
        return this.includeSupplementalLogInDDL;
    }

    public void setIncludeSupplementalLogInDDL(boolean includeSupplementalLogInDDL) {
        this.includeSupplementalLogInDDL = includeSupplementalLogInDDL;
    }

    public boolean isImportDB_Links() {
        return this.importDB_Links;
    }

    public void setImportDB_Links(boolean importDB_Links) {
        this.importDB_Links = importDB_Links;
    }

    public boolean isImportPublicDB_Links() {
        return this.importPublicDB_Links;
    }

    public void setImportPublicDB_Links(boolean importPublicDB_Links) {
        this.importPublicDB_Links = importPublicDB_Links;
    }

    public boolean isImportColumnsOnly() {
        return this.importColumnsOnly;
    }

    public void setImportColumnsOnly(boolean importColumnsOnly) {
        this.importColumnsOnly = importColumnsOnly;
    }

    public boolean isImportMVLogs() {
        return this.importMVLogs;
    }

    public void setImportMVLogs(boolean importMVLogs) {
        this.importMVLogs = importMVLogs;
    }

    public boolean isImportJSON_DataGuide() {
        return this.importJSON_DataGuide;
    }

    public void setImportJSON_DataGuide(boolean importJSON_DataGuide) {
        this.importJSON_DataGuide = importJSON_DataGuide;
    }

    public boolean isGroupBySchemaNameInReports() {
        return this.groupBySchemaNameInReports;
    }

    public void setGroupBySchemaNameInReports(boolean groupBySchemaNameInReports) {
        this.groupBySchemaNameInReports = groupBySchemaNameInReports;
    }

    static {
        LOGGER = new Logger(Settings.class);
        DocumentBuilder temp = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            temp = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not instantiate XML parser in Settings (DOCUMENT_BUILDER) " + String.valueOf(e));
        }
        DOCUMENT_BUILDER = temp;
        fileVersion = "";
        ON_NEW_FK_EXIST_BY_TEMPLATE = 0;
        ON_NEW_FK_NEW_COLUMN = 1;
        AUTOINCREMENT_DDL = new String[]{"NONE", TRIGGER, DEFAULT_CLAUSE};
        IDENTITY_DDL = new String[]{"NONE", TRIGGER, DEFAULT_CLAUSE, IDENTITY_CLAUSE};
        AUTOINCREMENT_DDL_DB2 = new String[]{"NONE", TRIGGER};
        IDENTITY_DDL_DB2 = new String[]{"NONE", TRIGGER, IDENTITY_CLAUSE};
        AUTOINCREMENT_DDL_SQLSERVER = new String[]{"NONE", TRIGGER, DEFAULT_CLAUSE};
        IDENTITY_DDL_SQLSERVER = new String[]{"NONE", TRIGGER, DEFAULT_CLAUSE, IDENTITY_CLAUSE};
        AUTOINCREMENT_DDL_UDB = new String[]{"NONE", TRIGGER};
        IDENTITY_DDL_UDB = new String[]{"NONE", TRIGGER, IDENTITY_CLAUSE};
    }

    public class DialogSettings {
        public Rectangle rec;
        public String treePath = "";
        public int dividerLocation;

        public DialogSettings(Rectangle rec, String treePath) {
            this.rec = rec;
            this.treePath = treePath;
        }

        public DialogSettings(Rectangle rec, String treePath, int dividerLocation) {
            this.rec = rec;
            this.treePath = treePath;
            this.dividerLocation = dividerLocation;
        }
    }
}

