/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Font;
import java.awt.FontMetrics;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.FontParams;

public class StringDimension {
    static boolean USE_FONT_METRICS = true;
    Font font = null;
    int height = 13;
    int maxAscent = 10;
    int maxDescent = 3;
    double increase = 1.0;
    int kwn = 23;
    int kw = 16;
    double csl = 4.81;
    double csu = 6.2;
    FontMetrics fm = null;

    public StringDimension(Font font) {
        this.font = font;
        try {
            this.fm = DesignPartView.getFontMetrics(font);
        }
        catch (Throwable e) {
            USE_FONT_METRICS = false;
        }
        FontParams.FontSizes fs = FontParams.getSizes(font);
        this.height = fs.height;
        this.maxAscent = fs.maxAscent;
        this.maxDescent = fs.maxDescent;
        this.kwn = fs.kwn;
        this.kw = fs.kw;
        this.csl = fs.csl;
        this.csu = fs.csu;
    }

    public int getHeight() {
        if (this.fm != null && USE_FONT_METRICS) {
            return this.fm.getHeight();
        }
        return this.height;
    }

    public int getMaxAscent() {
        if (this.fm != null && USE_FONT_METRICS) {
            return this.fm.getMaxAscent();
        }
        return this.maxAscent;
    }

    public int getMaxDescent() {
        if (this.fm != null && USE_FONT_METRICS) {
            return this.fm.getMaxDescent();
        }
        return this.maxDescent;
    }

    public int stringWidth(String string) {
        if (this.fm != null && USE_FONT_METRICS) {
            return this.fm.stringWidth(string);
        }
        if (string != null && !string.isEmpty()) {
            if ("KWN".equals(string)) {
                return this.kwn;
            }
            if ("KW".equals(string)) {
                return this.kw;
            }
            return (int)(this.csu * (double)string.length() * this.increase);
        }
        return 0;
    }

    public static void main(String[] args) {
    }
}

