/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling.compare;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.compare.ArgumentsCollectionCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class SchedulerJobCompare
extends SchedulerObjectCompare {
    ArgumentsCollectionCompare comp = null;

    public SchedulerJobCompare(SchedulerObject source, SchedulerObject target) {
        super(source, target);
        if (source instanceof SchedulerJob && target instanceof SchedulerJob) {
            this.comp = new ArgumentsCollectionCompare(((SchedulerJob)source).getSortedArguments(), ((SchedulerJob)target).getSortedArguments());
        }
    }

    @Override
    public boolean hasAttributesToSetNull() {
        boolean has = super.hasAttributesToSetNull();
        if (has) {
            return true;
        }
        Map<String, String> diff = this.getDiffMap();
        if (diff.get("PROGRAM_NAME") != null) {
            return true;
        }
        if (diff.get("JOB_TYPE") != null) {
            return true;
        }
        return diff.get("JOB_ACTION") != null;
    }

    public List<SchedulerArgument> getArgsToRemove() {
        if (this.comp == null) {
            return Collections.emptyList();
        }
        return this.comp.getToRemove();
    }

    public List<SchedulerArgument> getArgsToAdd() {
        if (this.comp == null) {
            return Collections.emptyList();
        }
        return this.comp.getToAdd();
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.comp.isModified();
    }

    @Override
    public boolean equalPropertiess(String prop, String sval, String tval) {
        if ("REPEAT_INTERVAL".equalsIgnoreCase(prop)) {
            return sval.equalsIgnoreCase(tval);
        }
        if (!"JOB_ACTION".equalsIgnoreCase(prop)) {
            return super.equalPropertiess(prop, sval, tval);
        }
        if (!sval.equals(tval)) {
            sval = Token.removeQuotes(sval);
            tval = Token.removeQuotes(tval);
            return sval.equalsIgnoreCase(tval);
        }
        return true;
    }
}

