/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifierAbstract;

public class PVStringStartsChar
extends PropertyVerifierAbstract {
    @Override
    public boolean accept(Object object) {
        if (object instanceof String) {
            String value = (String)object;
            if (value.length() > 0) {
                return Character.isLetter(value.charAt(0));
            }
            return false;
        }
        return false;
    }

    @Override
    public String error(Object rejectedValue) {
        if (rejectedValue instanceof String) {
            String value = (String)rejectedValue;
            if (value.length() > 0) {
                return MessageFormat.format(Messages.getString("PVStringStartsChar.CharacterNotALetter"), Character.getNumericValue(value.charAt(0)));
            }
            return Messages.getString("PVStringStartsChar.EmptyStringDoesNotStartWithCharacter");
        }
        if (rejectedValue == null) {
            return Messages.getString("PVStringStartsChar.NullValueNotAccepted");
        }
        return Messages.getString("PVStringStartsChar.StringValueExpected");
    }

    @Override
    public boolean acceptNullValues() {
        return false;
    }
}

