/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.util.ResourceProvider;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LogicalDataTypesReader
implements XMLConstants {
    private ResourceProvider resourceProvider;
    private String fileExtension = "xml";
    private static final String TRUE = "true";
    private static final Logger LOGGER = new Logger(LogicalDataTypesReader.class);
    private static final DocumentBuilderFactory DOC_BUILD_FACTORY;

    public static void main(String[] args) {
        Design.dmInternalsDistDir = "D:/tmp/JSclasseGenTest/datamodeler";
        MetaFileLoader.DMWEB = true;
        Design des = new Design();
        LogicalDataTypesReader lr = new LogicalDataTypesReader();
        lr.recreateLogicalTypes(des);
        int s = des.getLogicalDatatypeSet().size();
        ++s;
    }

    public Object recreateLogicalTypes(Design design) {
        String name = "types";
        InputStream is = this.getInputStreamFor(name);
        if (is != null) {
            try {
                Document doc = LogicalDataTypesReader.parse(is, this.getFilename(name), design);
                return this.recreateObject(doc, design);
            }
            catch (Throwable th) {
                LOGGER.error("Error recreating object from XML: " + name + " \n" + th.toString());
                return null;
            }
        }
        return null;
    }

    public Object recreateObject(Document doc, Design design) {
        LogicalDatatype ldt;
        String log_id;
        String log_name;
        String native_type;
        Element mapp_el;
        int j;
        int l2;
        NodeList mappings;
        RDBMSType db_type;
        Element db_type_el;
        int l1;
        NodeList rdbms_types;
        Element nl_mappings;
        HashMap<String, String> map = new HashMap<String, String>();
        LogicalDatatypeSet logSet = design.getLogicalDatatypeSet();
        RDBMSType[] rdbms = Design.getDefaultRDBMSTypeSet().toTypeArray();
        Element docElm = doc.getDocumentElement();
        NodeList types = docElm.getElementsByTagName("logicaltype");
        int length = types.getLength();
        Element type = null;
        Element mapping = null;
        LogicalDatatype logType = null;
        for (int i = 0; i < length; ++i) {
            type = (Element)types.item(i);
            String oid = type.getAttribute("objectid");
            String name = type.getAttribute("name");
            logType = (LogicalDatatype)logSet.getObjectByID(oid);
            if (logType == null) {
                logType = logSet.createLogicalDatatype(oid);
            }
            map.put(oid, oid);
            logType.setName(name);
            NodeList mappings2 = type.getElementsByTagName("mapping");
            int lengthmappings = mappings2.getLength();
            for (int j2 = 0; j2 < lengthmappings; ++j2) {
                mapping = (Element)mappings2.item(j2);
                String rdbmsName = mapping.getAttribute("rdbms");
                logType.put(rdbmsName, mapping.getFirstChild().getNodeValue());
                TreeMap<String, String> defaults = new TreeMap<String, String>();
                defaults.put("precision_default_value", mapping.getAttribute("precision_default_value"));
                defaults.put("size_default_value", mapping.getAttribute("size_default_value"));
                defaults.put("scale_default_value", mapping.getAttribute("scale_default_value"));
                logType.addDefaults(rdbmsName, defaults);
            }
            String defaultType = type.getAttribute("default");
            if (defaultType != null && defaultType.equals(TRUE)) {
                logSet.setDefaultType(logType);
            }
            if ("UNKNOWN".equalsIgnoreCase(logType.getName())) continue;
            this.fixRDBMSMappings(logType, rdbms);
        }
        Object[] objects = logSet.toArray();
        for (int p = 0; p < objects.length; ++p) {
            DesignObject dobj = (DesignObject)objects[p];
            if (map.get(dobj.getObjectID()) != null) continue;
            dobj.remove();
        }
        NodeList nat_log = docElm.getElementsByTagName("native_to_logical_mappings");
        length = nat_log.getLength();
        if (length == 1) {
            MappingDatatypeNameLogicalDataType.clearMappings();
            nl_mappings = (Element)nat_log.item(0);
            rdbms_types = nl_mappings.getElementsByTagName("mappings_for_RDBMS_type");
            l1 = rdbms_types.getLength();
            for (int i = 0; i < l1; ++i) {
                db_type_el = (Element)rdbms_types.item(i);
                String name = LogicalDataTypesReader.decodeAttributeValue(db_type_el.getAttribute("rdbms_type"));
                db_type = this.getRDBMSType(rdbms, name);
                if (db_type == null) continue;
                mappings = db_type_el.getElementsByTagName("mapping");
                l2 = mappings.getLength();
                for (j = 0; j < l2; ++j) {
                    mapp_el = (Element)mappings.item(j);
                    native_type = LogicalDataTypesReader.decodeAttributeValue(mapp_el.getAttribute("native_type"));
                    log_name = LogicalDataTypesReader.decodeAttributeValue(mapp_el.getAttribute("logicaltype"));
                    log_id = LogicalDataTypesReader.decodeAttributeValue(mapp_el.getAttribute("log_type_id"));
                    ldt = (LogicalDatatype)design.getDesignObject(log_id);
                    if (ldt == null) {
                        ldt = logSet.getLogTypeByName(log_name);
                    }
                    if (ldt == null) continue;
                    MappingDatatypeNameLogicalDataType.addNativeToLogicalMapping(db_type, native_type, ldt);
                }
            }
        }
        nat_log = docElm.getElementsByTagName("ud_native_db_types");
        StandardDatatypeNames.clearUD_NativeTypes();
        length = nat_log.getLength();
        if (length == 1) {
            nl_mappings = (Element)nat_log.item(0);
            rdbms_types = nl_mappings.getElementsByTagName("ud_native_for_db_type");
            l1 = rdbms_types.getLength();
            for (int i = 0; i < l1; ++i) {
                db_type_el = (Element)rdbms_types.item(i);
                String dbname = LogicalDataTypesReader.decodeAttributeValue(db_type_el.getAttribute("rdbms_type"));
                db_type = this.getRDBMSType(rdbms, dbname);
                if (db_type == null) continue;
                mappings = db_type_el.getElementsByTagName("ud_db_type");
                l2 = mappings.getLength();
                for (j = 0; j < l2; ++j) {
                    String value;
                    mapp_el = (Element)mappings.item(j);
                    native_type = LogicalDataTypesReader.decodeAttributeValue(mapp_el.getAttribute("native_type"));
                    log_name = LogicalDataTypesReader.decodeAttributeValue(mapp_el.getAttribute("logicaltype"));
                    log_id = LogicalDataTypesReader.decodeAttributeValue(mapp_el.getAttribute("log_type_id"));
                    ldt = (LogicalDatatype)design.getDesignObject(log_id);
                    if (ldt == null) {
                        ldt = logSet.getLogTypeByName(log_name);
                    }
                    NativeDBType nt = new NativeDBType();
                    nt.setName(native_type);
                    if (ldt != null) {
                        nt.setLogicalDatatype(ldt);
                    }
                    if ((value = mapp_el.getAttribute("has_size")) != null && TRUE.equals(value)) {
                        nt.setHasSize(true);
                    } else {
                        value = mapp_el.getAttribute("has_precision");
                        if (value != null && TRUE.equals(value)) {
                            nt.setHasPrecision(true);
                            value = mapp_el.getAttribute("has_scale");
                            if (value != null && TRUE.equals(value)) {
                                nt.setHasScale(true);
                            }
                        }
                    }
                    value = mapp_el.getAttribute("ud_native_kind");
                    if (value != null && !"".equals(value)) {
                        nt.setTypeKind(value);
                    }
                    StandardDatatypeNames.addUD_NativeType(db_type, nt);
                }
            }
        }
        return logSet;
    }

    private void fixRDBMSMappings(LogicalDatatype logType, RDBMSType[] rdbms) {
        Map map = logType.getToPhysical();
        for (RDBMSType dbtype : rdbms) {
            String enc_type = (String)map.get(dbtype.getName());
            if (enc_type != null) continue;
            RDBMSType parent = dbtype;
            while (parent.getParentType() != null && (enc_type = (String)map.get((parent = parent.getParentType()).getName())) == null) {
            }
            if (enc_type == null) continue;
            map.put(dbtype.getName(), enc_type);
            TreeMap def = (TreeMap)logType.getDefaultValues().get(parent.getName());
            if (def == null) continue;
            TreeMap ndef = new TreeMap(def);
            logType.addDefaults(dbtype.getName(), ndef);
        }
    }

    public InputStream getInputStreamFor(Object name) {
        InputStream is = null;
        if (MetaFileLoader.DMWEB) {
            File dir;
            if (Design.systemTypesDir != null && (dir = new File(Design.systemTypesDir)).exists()) {
                File typesFile = new File(dir, "types.xml");
                return this.getResourceProvider().getResourceAsStriam(typesFile.getAbsolutePath());
            }
            String location = "datamodeler/types/types.xml";
            is = this.getClass().getClassLoader().getResourceAsStream(location);
        } else {
            String location = Design.dmInternalsDistDir + "/types/types.xml";
            is = this.getResourceProvider().getResourceAsStriam(location);
            if (is == null && !"defaultdomains".equals(name)) {
                LOGGER.error("Data inputstream is null (path: " + location + ")");
            }
        }
        return is;
    }

    private RDBMSType getRDBMSType(RDBMSType[] rdbms_types, String longName) {
        for (int i = 0; i < rdbms_types.length; ++i) {
            if (!rdbms_types[i].getLongName().equals(longName)) continue;
            return rdbms_types[i];
        }
        return null;
    }

    public String getFilename(Object name) {
        return String.valueOf(name);
    }

    public File getAbsolutePath(String location, String name, boolean makeDirs) {
        return new File(location + "/" + name);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String extension) {
        this.fileExtension = extension;
    }

    public String getRelativePath() {
        return "types";
    }

    public static String encodeAttributeValue(String unencoded) {
        return StringUtilities.encodeAttributeValue(unencoded);
    }

    public static String decodeAttributeValue(String encoded) {
        return StringUtilities.decodeAttributeValue(encoded);
    }

    public static Document parse(InputStream data, String description, Design design) {
        if (data == null) {
            LOGGER.error("InputStream is null, Can not parse XML for: " + description);
        } else {
            try {
                InputStreamReader reader = new InputStreamReader(data, "UTF-8");
                InputSource inputSource = new InputSource(reader);
                Document doc = DOC_BUILD_FACTORY.newDocumentBuilder().parse(inputSource);
                reader.close();
                return doc;
            }
            catch (Exception e) {
                LOGGER.error("problem parsing document for:" + description + "\n AbstractXMLReader.parse: ", e);
            }
        }
        return null;
    }

    public ResourceProvider getResourceProvider() {
        if (this.resourceProvider == null) {
            this.resourceProvider = new ResourceProvider("");
        }
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    static {
        DocumentBuilderFactory dbf = null;
        DOC_BUILD_FACTORY = dbf = DocumentBuilderFactory.newInstance();
    }
}

