/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLMapToObjTransformer
extends MDTransformer
implements MDXMLConstants {
    public static Document transformFromMap(Map object) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf;
            DocumentBuilder db;
            Element rootElement;
            XMLFromMapTransformer tr;
            ClassDescription cd;
            String className = XMLMapToObjTransformer.getObjectClassName(object);
            if (className != null && !"".equals(className) && (cd = XMLMapToObjTransformer.getClassDecription(object)) != null && (tr = XMLMapToObjTransformer.getXMLFromMapTransformer(className)) != null && (rootElement = tr.transformFromMap(object, null, doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).newDocument())) != null) {
                doc.appendChild(rootElement);
            }
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
        }
        return doc;
    }

    public static XMLFromMapTransformer getXMLFromMapTransformer(String className) {
        MDTransformationManager transformationManager = XMLTransformationManager.getInstance().getXMLMapTransformationManager();
        XMLFromMapTransformer tr = (XMLFromMapTransformer)transformationManager.getFromObjectTransformerFor(className);
        return tr;
    }

    public static XMLMapToObjTransformer getObjectFromMapTransformer(String className) {
        MDTransformationManager transformationManager = XMLTransformationManager.getInstance().getObjectMapTransformationManager();
        XMLMapToObjTransformer tr = (XMLMapToObjTransformer)transformationManager.getToObjectTransformerFor(className);
        return tr;
    }

    public void transformFromMap(Object object, Map map) {
        this.transformFromMap(object, map, false, null, null);
    }

    public void transformFromMap(Object object, Map map, boolean skipClassName, List inludeProps, List includeCollections) {
        try {
            ClassDescription cd = XMLMapToObjTransformer.getClassDecription(map);
            if (cd != null) {
                this.processProperties(object, map, cd, inludeProps);
                if (inludeProps == null || inludeProps.contains("propertyMap")) {
                    this.processClassPropertyMap(object, map, cd);
                }
                this.processCollections(object, map, cd, includeCollections);
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private void processProperties(Object object, Map map, ClassDescription cd, List inludeProps) {
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            if (inludeProps != null && !inludeProps.contains(pd.xmlName)) continue;
            Object obj = map.get(pd.xmlName);
            if (pd.isRectangle) {
                obj = map.get(pd.xmlName);
                if (obj != null && obj instanceof Map) {
                    this.appendBounds(object, pd.xmlName, (Map)obj, pd);
                }
            } else if (pd.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, map, pd);
            } else if (pd.isMap) {
                this.processMapProperty(object, map, pd);
            } else if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                String value = (String)map.get(pd.xmlName);
                if (!(value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue))) {
                    if ((pd.isID || pd.isListOfRefs) && object instanceof ModelIDObject) {
                        value = ((ModelIDObject)object).replaceIDsInValue(value);
                    }
                    this.setProperty(object, value, pd);
                }
            } else {
                Map nestedMap = (Map)map.get(pd.xmlName);
                if (nestedMap != null) {
                    String className;
                    XMLMapToObjTransformer xmltr;
                    Object nested = XMLMapToObjTransformer.getObjectForProperty(object, pd);
                    if (nested == null && pd.createProperty != null) {
                        nested = this.createObject(object, pd.createProperty);
                    }
                    if (nested != null && (xmltr = XMLMapToObjTransformer.getObjectFromMapTransformer(className = XMLMapToObjTransformer.getObjectClassName(nestedMap))) != null) {
                        xmltr.transformFromMap(nested, nestedMap);
                        if (pd.setter != null) {
                            this.setObjectForProperty(object, pd, nested);
                        }
                    }
                }
            }
            if (obj != null || SKP_DEFAULTS) continue;
            this.setDefaultProperty(object, pd);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Map map, ClassDescription.PropertyDescription pd) {
        Object pmap;
        if (pd.isPropertyMap && (pmap = map.get(pd.xmlName)) != null && pmap instanceof List) {
            Object obj = XMLMapToObjTransformer.getObjectForProperty(object, pd);
            boolean created = false;
            if (obj == null) {
                obj = this.createObject(object, pd.createPMap);
                created = true;
            }
            if (obj != null && obj instanceof PropertyMap) {
                PropertyMap pm = (PropertyMap)obj;
                if (!created) {
                    pm.clearProperties();
                }
                for (XMLObjToMapTransformer.PM_Pair pair : (List)pmap) {
                    pm.setProperty(pair.key, pair.value);
                }
                if (created) {
                    this.setObjectForProperty(object, pd, obj);
                }
            }
        }
    }

    private void processMapProperty(Object object, Map map, ClassDescription.PropertyDescription pd) {
        Object obj = XMLMapToObjTransformer.getObjectForProperty(object, pd);
        if (obj != null && obj instanceof Map && pd.isMap) {
            Map omap = (Map)obj;
            Object list = map.get(pd.xmlName);
            if (list != null && list instanceof List) {
                for (XMLObjToMapTransformer.PM_Pair pair : (List)list) {
                    omap.put(pair.key, pair.value);
                }
            }
        }
    }

    private void processClassPropertyMap(Object object, Map map, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap pmap = (PropertyMap)object;
            pmap.clearProperties();
            List list = (List)map.get("propertyMap");
            if (list != null) {
                for (XMLObjToMapTransformer.PM_Pair pair : list) {
                    if (this.skipProperty(pair.key)) continue;
                    pmap.setProperty(pair.key, pair.value);
                }
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Object container, Map map, ClassDescription cd, List includeCollections) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            List oldItems;
            if (includeCollections != null && !includeCollections.contains(cold.xmlName)) continue;
            Object col = map.get(cold.xmlName);
            if (col != null && col instanceof Collection) {
                if (this.canProcessCollectionItem(cold)) {
                    if (SKP_DEFAULTS && ((Collection)col).size() <= 0) continue;
                    oldItems = this.getListWithElements(container, cold);
                    ArrayList newItems = new ArrayList();
                    if (cold.itemIsRef) {
                        this.processCollectionWithRefs(map, (Collection)col, cold, newItems);
                    } else {
                        this.processCollectionWithContained(container, (Collection)col, cold, newItems, oldItems, false);
                    }
                    if (cold.applyList == null) {
                        XMLMapToObjTransformer.orderAndClearList(container, cold, oldItems, newItems);
                        continue;
                    }
                    XMLMapToObjTransformer.applyList(container, cold.applyList, newItems);
                    continue;
                }
                if (!cold.isMapItem || cold.applyList == null || ((Collection)col).size() <= 0) continue;
                ArrayList list = new ArrayList((Collection)col);
                XMLMapToObjTransformer.applyList(container, cold.applyList, list);
                continue;
            }
            if (col != null) continue;
            if (this.canProcessCollectionItem(cold)) {
                oldItems = this.getListWithElements(container, cold);
                XMLMapToObjTransformer.orderAndClearList(container, cold, oldItems, Collections.EMPTY_LIST);
                continue;
            }
            if (!cold.isMapItem || cold.applyList == null) continue;
            XMLMapToObjTransformer.applyList(container, cold.applyList, Collections.EMPTY_LIST);
        }
    }

    private void processCollectionWithRefs(Object container, Collection col, ClassDescription.CollectionDescription cold, List newItems) {
        Object obj;
        List target = null;
        if (cold.nativeList && cold.addItem == null && (obj = XMLMapToObjTransformer.getCollection(container, cold)) instanceof List) {
            target = (List)obj;
        }
        for (String id : col) {
            Object object = this.getItemByID(container, cold.getItemByID, id);
            if (object == null && container instanceof ID_ObjectPropertyTranslator && (object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.xmlName, id)) != null) {
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                } else if (cold.nativeList && target != null) {
                    target.add(object);
                }
            }
            if (object == null) continue;
            newItems.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectionWithContained(Object container, Collection col, ClassDescription.CollectionDescription cold, List newItems, List oldItems, boolean processExternals) {
        XMLMapToObjTransformer tr = null;
        for (Map item : col) {
            Object object = this.getOrCreateObject(container, item, cold, oldItems);
            if (object == null) continue;
            try {
                if (object instanceof StorageDesign) {
                    ((StorageDesign)object).setLoading(true);
                }
                if (tr == null) {
                    tr = XMLMapToObjTransformer.getObjectFromMapTransformer(object.getClass().getName());
                }
                if (tr != null) {
                    tr.transformFromMap(object, item, processExternals, null, null);
                }
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                }
                newItems.add(object);
            }
            finally {
                if (!(object instanceof StorageDesign)) continue;
                ((StorageDesign)object).setLoading(false);
                ((StorageDesign)object).setOpen(true);
            }
        }
    }

    private void appendBounds(Object object, String elemName, Map map, ClassDescription.PropertyDescription pd) {
        if (map != null) {
            Integer x = (Integer)map.get("x");
            Integer y = (Integer)map.get("y");
            Integer w = (Integer)map.get("width");
            Integer h = (Integer)map.get("height");
            if (x != null) {
                Rectangle rect = new Rectangle(x, y, w, h);
                this.setObjectForProperty(object, pd, rect);
            }
        }
    }

    public static String transformFromObjectToString(Map object) {
        try {
            Document doc = XMLMapToObjTransformer.transformFromMap(object);
            TransformerFactory transformerFactory = XMLMapToObjTransformer.transformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            Logger.error(e);
        }
        catch (TransformerException e) {
            Logger.error(e);
        }
        return null;
    }

    public static String getObjectClassName(Map metaMap) {
        if (metaMap == null) {
            return null;
        }
        return (String)metaMap.get("class");
    }

    public static ClassDescription getClassDecription(Map metaMap) {
        String className = XMLMapToObjTransformer.getObjectClassName(metaMap);
        if (className != null && !"".equals(className)) {
            return XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(className);
        }
        return null;
    }

    public Class getObjectClass(Map metaMap) {
        String name = XMLMapToObjTransformer.getObjectClassName(metaMap);
        Class<?> objectClass = null;
        if (name != null && !"".equals(name)) {
            try {
                objectClass = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                Logger.error(e);
            }
        }
        return objectClass;
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        if (object instanceof Map) {
            return XMLMapToObjTransformer.transformFromObjectToString((Map)object);
        }
        return null;
    }

    public static void transformMapToXMLFile(Map map, String fileName, boolean compressed) {
        Document doc = XMLMapToObjTransformer.transformFromMap(map);
        XMLTransformationManager.saveDocument(fileName, doc, compressed);
    }

    private Object getOrCreateObject(Object container, Map item, ClassDescription.CollectionDescription cold, List oldItems) {
        if (cold.isPhysicalModelItem && container instanceof RelationalDesign) {
            return this.getOrCreateStorageDesign((RelationalDesign)container, item, cold);
        }
        String id = this.getID(item);
        Object object = null;
        if (id != null) {
            object = cold.getItemByID != null ? this.getItemByID(container, cold.getItemByID, id) : (container instanceof DesignObject || container instanceof DesignPart ? ((ModelIDObject)container).getDesign().getDesignObject(id) : (container instanceof StorageObject ? ((StorageObject)container).getStorageDesign().getStorageObject(id) : (container instanceof StorageDesign ? ((StorageDesign)container).getStorageObject(id) : this.getItemByID(oldItems, id, cold))));
        }
        if (object == null) {
            if (cold.isProxyitem) {
                if (container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(null, id);
                }
            } else {
                if (cold.getItemByID == null && container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.itemXmlName, id);
                }
                if (object == null) {
                    object = this.createItem(container, cold.createItem);
                }
            }
        }
        if (object instanceof TableProxyOracle) {
            ((TableProxyOracle)object).setUser(null);
        }
        if (object instanceof ModelIDObject && MDTransformer.includeID) {
            ((ModelIDObject)object).setObjectID(id);
        }
        return object;
    }

    private Object getOrCreateStorageDesign(RelationalDesign rd, Map item, ClassDescription.CollectionDescription cold) {
        String siteType;
        String siteID = (String)item.get("siteID");
        RDBMSSite site = rd.getDesign().getRDBMSSiteSet().getByObjectID(siteID);
        if (site == null && (siteType = (String)item.get("siteType")) != null) {
            String siteOID = (String)item.get("siteID");
            String siteName = (String)item.get("siteName");
            site = rd.getDesign().getRDBMSSiteSet().createSite(siteName, rd.getDesign());
            int type = 9;
            try {
                type = Integer.parseInt(siteType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(type);
            site.setType(rdbmsType);
            site.setObjectID(siteOID);
            site.setPathID(rd.getDesign().getRDBMSSiteSet().nextIndex());
        }
        if (site != null) {
            boolean exists = rd.getStorageDesignFactory().existStorageDesign(site);
            StorageDesign stoDes = rd.getStorageDesign(site);
            if (stoDes != null) {
                stoDes.setTempModel(false);
                if (exists && !rd.getDesign().isNewDesign()) {
                    stoDes.openStorageDesign();
                }
            }
            return stoDes;
        }
        return null;
    }

    private String getID(Map element) {
        String id = (String)element.get("id");
        if ((id == null || "".equals(id)) && (id = (String)element.get("objectID")) != null && "".equals(id) && (id = (String)element.get("IDREF")) != null && "".equals(id)) {
            return null;
        }
        return id;
    }
}

