/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.ResourceProvider;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetaFileLoader {
    private static final Logger LOGGER;
    public static boolean standalone;
    public static boolean DMWEB;
    public static String standaloneBaseDir;
    private static ResourceProvider resourceProvider;
    private static final DocumentBuilderFactory DOC_BUILD_FACTORY;

    public static void main(String[] args) {
    }

    public static String getHTMLresurceAsString(String fileName) {
        InputStream is = null;
        try {
            String fname = MetaFileLoader.getHTMLFileName(fileName);
            is = DMWEB ? MetaFileLoader.class.getClassLoader().getResourceAsStream(fname) : MetaFileLoader.getResourceProvider().getResourceAsStriam(fname);
            if (is != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                return out.toString();
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return null;
    }

    public static Document loadFile(String className) {
        Document doc = null;
        if (DOC_BUILD_FACTORY != null) {
            InputStream is = null;
            try {
                String fname = MetaFileLoader.getFileName(className);
                is = DMWEB ? MetaFileLoader.class.getClassLoader().getResourceAsStream(fname) : MetaFileLoader.getResourceProvider().getResourceAsStriam(fname);
            }
            catch (Exception e) {
                Logger.error(e);
            }
            if (is != null) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(is, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("MetaFileLoader: InputStreamReader(is, XMLConstants.ENCODING_UTF8)", e);
                }
                if (reader != null) {
                    InputSource inputSource = new InputSource(reader);
                    try {
                        doc = DOC_BUILD_FACTORY.newDocumentBuilder().parse(inputSource);
                    }
                    catch (SAXException e) {
                        LOGGER.error("MetaFileLoader: DOCUMENT_BUILDER.parse(inputSource)", e);
                    }
                    catch (IOException e) {
                        LOGGER.error("MetaFileLoader: InputSource(reader)", e);
                    }
                    catch (ParserConfigurationException e) {
                        Logger.error(e);
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("MetaFileLoader: reader.close()", e);
                    }
                }
            }
        }
        return doc;
    }

    public static Document loadDocForFile(String fileName) {
        Document doc = null;
        if (DOC_BUILD_FACTORY != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (is != null) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)is, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("MetaFileLoader: InputStreamReader(is, XMLConstants.ENCODING_UTF8)", e);
                }
                if (reader != null) {
                    InputSource inputSource = new InputSource(reader);
                    try {
                        try {
                            doc = DOC_BUILD_FACTORY.newDocumentBuilder().parse(inputSource);
                        }
                        catch (SAXException e) {
                            LOGGER.error("MetaFileLoader: DOCUMENT_BUILDER.parse(inputSource)", e);
                        }
                        catch (IOException e) {
                            LOGGER.error("MetaFileLoader: InputSource(reader)", e);
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("MetaFileLoader: reader.close()", e);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("MetaFileLoader: exception in file " + fileName + "\n", e);
                    }
                }
            }
        }
        return doc;
    }

    private static String getHTMLFileName(String fileName) {
        String fname = fileName;
        if (DMWEB) {
            return "datamodeler/html/" + fname;
        }
        String rootPath = !standalone ? Design.dmInternalsDistDir : standaloneBaseDir;
        File fPath = new File(rootPath);
        fPath = new File(fPath, "html");
        return new File(fPath, fname).getAbsolutePath();
    }

    public static String getCSSresurceAsString(String fileName) {
        InputStream is = null;
        try {
            String fname = MetaFileLoader.getCSSFileName(fileName);
            is = DMWEB ? MetaFileLoader.class.getClassLoader().getResourceAsStream(fname) : MetaFileLoader.getResourceProvider().getResourceAsStriam(fname);
            if (is != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                return out.toString();
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return null;
    }

    private static String getCSSFileName(String fileName) {
        String fname = fileName;
        if (DMWEB) {
            return "datamodeler/reports/css/" + fname;
        }
        String rootPath = !standalone ? Design.dmInternalsDistDir : standaloneBaseDir;
        File fPath = new File(rootPath);
        fPath = new File(fPath, "reports/css");
        return new File(fPath, fname).getAbsolutePath();
    }

    private static String getFileName(String className) {
        int ind = className.lastIndexOf(46) + 1;
        String fname = className.substring(ind);
        if ((ind = fname.indexOf(36)) > -1) {
            fname = fname.replace('$', '.');
        }
        if (DMWEB) {
            return "datamodeler/xmlmetadata/" + fname + ".xml";
        }
        String rootPath = !standalone ? Design.dmInternalsDistDir : standaloneBaseDir;
        File fPath = new File(rootPath);
        fPath = new File(fPath, "xmlmetadata");
        return new File(fPath, fname + ".xml").getAbsolutePath();
    }

    public static ResourceProvider getResourceProvider() {
        if (resourceProvider == null) {
            resourceProvider = new ResourceProvider("");
        }
        return resourceProvider;
    }

    public static void setResourceProvider(ResourceProvider resourceProvider) {
        MetaFileLoader.resourceProvider = resourceProvider;
    }

    static {
        DocumentBuilderFactory dbf;
        standalone = false;
        DMWEB = false;
        standaloneBaseDir = "D:/Projects/Crest/ide/datamodeler";
        LOGGER = new Logger(MetaFileLoader.class);
        DOC_BUILD_FACTORY = dbf = DocumentBuilderFactory.newInstance();
    }
}

