/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;

public class UniqueOraclev9i
extends UniqueOracle {
    private String createIndexStatement = "";
    public static final String NO = "NO";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    public static final String LOCAL_PARTITIONED = "LOCAL PARTITIONED";
    public static final String GLOBAL_PARTITIONED = "GLOBAL PARTITIONED";
    public static final String BY_INDEX_NAME = "BY INDEX NAME";
    public static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    private static final String[] INDEX_SORT = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set indexSortSet = null;
    private String indexSort = "SORTED";
    private String computeStatistics = "NO";
    private static final String[] USING_INDEX = new String[]{"NO", "LOCAL PARTITIONED", "GLOBAL PARTITIONED", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static Set usingIndexSet = null;
    private String usingIndex = "NO";

    public static String[] getIndexSortChoices() {
        return INDEX_SORT;
    }

    private boolean checkIndexSort(String value) {
        if (indexSortSet == null) {
            indexSortSet = new HashSet();
            indexSortSet.addAll(Arrays.asList(UniqueOraclev9i.getIndexSortChoices()));
        }
        return indexSortSet.contains(value);
    }

    @Override
    public void setIndexSort(String using) {
        if (this.checkIndexSort(using)) {
            this.indexSort = using;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getIndexSort() {
        return this.indexSort;
    }

    public UniqueOraclev9i(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public UniqueOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getCreateIndexStatement() {
        return this.createIndexStatement;
    }

    public void setCreateIndexStatement(String createIndexStatement) {
        this.createIndexStatement = createIndexStatement;
        this.fireDataFieldChange();
    }

    @Override
    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public void setComputeStatistics(String computeStatistics) {
        if (ConstantsOracle.checkYesNo(computeStatistics)) {
            this.computeStatistics = computeStatistics;
            this.fireDataFieldChange();
        }
    }

    public static String[] getUsingIndexChoices() {
        return USING_INDEX;
    }

    private boolean checkUsingIndex(String value) {
        if (usingIndexSet == null) {
            usingIndexSet = new HashSet();
            usingIndexSet.addAll(Arrays.asList(UniqueOraclev9i.getUsingIndexChoices()));
        }
        return usingIndexSet.contains(value);
    }

    @Override
    public void setUsingIndex(String using) {
        if (this.checkUsingIndex(using)) {
            this.usingIndex = using;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getUsingIndex() {
        return this.usingIndex;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index unIndex = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        UniqueOraclev9i unique = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev9i)targetDesign).getUniqueSet().getProxy(unIndex.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            unique = (UniqueOraclev9i)storageObject;
        }
        if (unique != null) {
            unique.setName(this.getName());
            unique.setDeferrable(this.getDeferrable());
            unique.setInitially(this.getInitially());
            unique.setEnable(this.getEnable());
            unique.setValidate(this.getValidate());
            unique.setRely(this.getRely());
            unique.setUsingIndex(this.getUsingIndex());
            if (this.getExceptionsTable() != null) {
                Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getExceptionsTable().getObject().getName());
                TableProxyOraclev9i tableProxy = (TableProxyOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet().getProxy(table.getObjectID());
                if (tableProxy == null) {
                    TableProxyOraclev9i newTableProxy = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet()).createProxy(table);
                    newTableProxy.setName(this.getExceptionsTable().getName());
                    newTableProxy.setRawObject(true);
                    unique.setExceptionsTable(newTableProxy);
                } else {
                    unique.setExceptionsTable(tableProxy);
                }
            }
            if (this.getUsingIndexGlobalPL() != null) {
                IndexGlobalPartitionsListOraclev9i list = (IndexGlobalPartitionsListOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getUsingIndexGlobalPL().getName());
                if (list == null) {
                    IndexGlobalPartitionsListOraclev9i newList = (IndexGlobalPartitionsListOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newList.setName(this.getName());
                    newList.setRawObject(true);
                    unique.setUsingIndexGlobalPL(newList);
                } else {
                    unique.setUsingIndexGlobalPL(list);
                }
            }
            unique.setIndexSort(this.getIndexSort());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev9i tablespace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    TableSpaceOraclev9i newTablespace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    unique.setTableSpace(newTablespace);
                } else {
                    unique.setTableSpace(tablespace);
                }
            }
            unique.setLogging(this.getLogging());
            if (this.getIndexSegment() != null) {
                SegmentOraclev9i segment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().getByName(this.getIndexSegment().getName());
                if (segment == null) {
                    SegmentOraclev9i newSegment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getIndexSegment().getName());
                    newSegment.setRawObject(true);
                    unique.setIndexSegment(newSegment);
                } else {
                    unique.setIndexSegment(segment);
                }
            }
            unique.setComment(this.getComment());
            unique.setCommentInRDBMS(this.getCommentInRDBMS());
            unique.setRawObject(false);
        }
    }
}

