/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class UniqueOracle
extends IndexProxyOracle
implements StorageObjectListener,
ModelObjectSetListener {
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static List initiallyList = Arrays.asList(INITIALLY);
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String deferrable = "NO";
    private String enable = "YES";
    private String validate = "YES";
    private String rely = "NO";
    protected IndexGlobalPartitionsListOracle indexGlobalPartitionList = null;
    private TableProxyOracle exceptionsTable = null;
    protected IndexProxyOracle existingIndexProxy = null;
    private String existingIndexName = "";

    public UniqueOracle(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    public UniqueOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            ((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().add(object);
            this.fireChangeNoDirty(event);
        }
    }

    @Override
    public String getIDPrefix() {
        return "Unique";
    }

    @Override
    public String getObjectTypeName() {
        return "Unique";
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    private boolean checkInitially(String value) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(UniqueOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(value);
    }

    public void setInitially(String initially) {
        if (this.checkInitially(initially)) {
            this.initially = initially;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String deferrable) {
        if (ConstantsOracle.checkYesNo(deferrable)) {
            this.deferrable = deferrable;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String enable) {
        if (ConstantsOracle.checkYesNo(enable)) {
            this.enable = enable;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String validate) {
        if (ConstantsOracle.checkYesNo(validate)) {
            this.validate = validate;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public void setRely(String rely) {
        if (ConstantsOracle.checkYesNo(rely)) {
            this.rely = rely;
            this.fireDataFieldChange();
        }
    }

    public String getRely() {
        return this.rely;
    }

    public abstract void setIndexSort(String var1);

    public abstract String getIndexSort();

    public IndexGlobalPartitionsListOracle getUsingIndexGlobalPL() {
        return this.indexGlobalPartitionList;
    }

    public void setUsingIndexGlobalPL(IndexGlobalPartitionsListOracle indexGlobalPartitionList) {
        if (this.indexGlobalPartitionList != null && this.indexGlobalPartitionList != indexGlobalPartitionList) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        this.indexGlobalPartitionList = indexGlobalPartitionList;
        if (this.indexGlobalPartitionList != null) {
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionList);
            this.addIGPFromDesign(((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionSet());
        }
        this.fireDataFieldChange();
    }

    @Override
    public IndexGlobalPartitionsListOracle getIndexGlobalPartitionsList() {
        return this.getUsingIndexGlobalPL();
    }

    @Override
    public void setIndexGlobalPartitionsList(IndexGlobalPartitionsListOracle indexGlobalPartList) {
        this.setUsingIndexGlobalPL(indexGlobalPartList);
    }

    public SegmentOracle getIndexSegment() {
        return this.segment;
    }

    public void setIndexSegment(SegmentOracle indexSegment) {
        this.segment = indexSegment;
        this.fireDataFieldChange();
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle exceptionsTable) {
        this.exceptionsTable = exceptionsTable;
        this.fireDataFieldChange();
    }

    public static List getInitiallyValues() {
        return initiallyList;
    }

    public abstract void setUsingIndex(String var1);

    public abstract String getUsingIndex();

    private void removeNonExistingIndex() {
        Index existingIndex;
        if (!(this.existingIndexProxy == null || (existingIndex = this.existingIndexProxy.getIndex()) != null && this.getTable().getKeySet().contains(existingIndex))) {
            this.existingIndexProxy = null;
        }
    }

    public IndexProxyOracle getExistingIndex() {
        this.removeNonExistingIndex();
        return this.existingIndexProxy;
    }

    public void setExistingIndex(IndexProxyOracle existingIndexProxy) {
        this.existingIndexProxy = existingIndexProxy;
        this.fireDataFieldChange();
    }

    public IndexGlobalPartitionsListOracle createIndexGlobalPL() {
        IndexGlobalPartitionsListOracle igpl = (IndexGlobalPartitionsListOracle)((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionsListSet().createElement(null);
        igpl.setIndex(this);
        return igpl;
    }

    public void clearIndexGlobalPL() {
        IndexGlobalPartitionsListOracle indexGlobalPartitionList = this.indexGlobalPartitionList;
        if (indexGlobalPartitionList != null) {
            this.setUsingIndexGlobalPL(null);
            indexGlobalPartitionList.remove();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.Initially"), this, "getInitially", "setInitially", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.Deferrable"), this, "getDeferrable", "setDeferrable", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.Enable"), this, "getEnable", "setEnable", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.Validate"), this, "getValidate", "setValidate", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("FKPropertyDialogOraclev9i.Rely"), this, "getRely", "setRely", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.UsingIndexL"), this, "getUsingIndex", "setUsingIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.ExceptionsTable"), this, "getExceptionsTable", "setExceptionsTable", TableProxyOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.TableSpace"), this, "getTableSpace", "setTableSpace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.Logging"), this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.Segment"), this, "getIndexSegment", "setIndexSegment", SegmentOracle.class));
            if (this instanceof UniqueOraclev10g) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Compress"), this, "getCompress", "setCompress", Integer.TYPE));
            }
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.IndexSort"), this, "getIndexSort", "setIndexSort", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("UniqueConstraintPropertyDialogOracle.ComputeStatistics"), this, "getComputeStatistics", "setComputeStatistics", String.class));
        }
        return this.propertyWrapperList;
    }

    public String getExistingIndexName() {
        IndexProxyOracle ip = this.getExistingIndex();
        if (ip != null) {
            return ((RelationalObjectProxy)ip).getName();
        }
        return this.existingIndexName;
    }

    public void setExistingIndexName(String existingIndexName) {
        String string = this.existingIndexName = existingIndexName == null ? "" : existingIndexName;
        if (existingIndexName != null) {
            String tableName = this.getTableName();
            IndexProxy ip = this.getStorageDesign().getIndexProxySet().getByNameAndTableName(existingIndexName, tableName);
            if (ip != null) {
                this.setExistingIndex((IndexProxyOracle)ip);
            }
        }
    }

    @Override
    public String getExtendedObjectTypeName() {
        String suffix = "UK";
        return this.getObjectTypeName() + suffix;
    }

    @Override
    public TableSpaceOracle getTableSpace() {
        if (this.getIndex() != null) {
            return null;
        }
        return super.getTableSpace();
    }
}

