/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public abstract class HashPartitionLobItemOracle
extends AbstractStorageObjectOracle {
    private HashPartitionOracle hashPartition = null;
    private ListStorageTemplatePartitionOracle listTemplatePartition = null;
    private PartitionOracle rangePartition = null;
    private ColumnProxy lobColumn = null;
    private TableSpaceOracle tableSpace = null;
    public static final String TYPE_NAME = "HashPartitionLobItem";

    @Override
    public String getIDPrefix() {
        return "LobStorage";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setHashPartition(HashPartitionOracle hashPartition) {
        if (this.hashPartition != hashPartition) {
            this.hashPartition = hashPartition;
            if (hashPartition != null) {
                this.setPAC_Element(hashPartition.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public HashPartitionOracle getHashPartition() {
        return this.hashPartition;
    }

    public void setListTemplatePartition(ListStorageTemplatePartitionOracle listTemplatePartition) {
        if (this.listTemplatePartition != listTemplatePartition) {
            this.listTemplatePartition = listTemplatePartition;
            if (listTemplatePartition != null) {
                this.setPAC_Element(listTemplatePartition.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public ListStorageTemplatePartitionOracle getListTemplatePartition() {
        return this.listTemplatePartition;
    }

    public void setRangePartition(PartitionOracle rangePartition) {
        if (this.rangePartition != rangePartition) {
            this.rangePartition = rangePartition;
            if (rangePartition != null) {
                this.setPAC_Element(rangePartition.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public PartitionOracle getRangePartition() {
        return this.rangePartition;
    }

    public ColumnProxy getLobColumn() {
        return this.lobColumn;
    }

    public void setLobColumn(ColumnProxy lobColumn) {
        this.lobColumn = lobColumn;
        this.fireDataFieldChange();
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        this.tableSpace = tableSpace;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        HashPartitionLobItemOracle hashPartLobItem = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)targetDesign).getHashPartitionLobItemSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                hashPartLobItem = (HashPartitionLobItemOracle)storageObject;
            }
        } else {
            hashPartLobItem = ((StorageDesignOracle)targetDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
        }
        if (hashPartLobItem != null) {
            hashPartLobItem.setName(this.getName());
            if (this.getLobColumn() != null) {
                Column lobColumn = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getLobColumn().getName());
                ColumnProxyOracle lobColumnProxy = (ColumnProxyOracle)((StorageDesignOracle)targetDesign).getColumnProxySet().getProxy(lobColumn.getObjectID());
                if (lobColumnProxy == null) {
                    ColumnProxyOracle newLobColumnProxy = (ColumnProxyOracle)((ColumnProxySetOracle)((StorageDesignOracle)targetDesign).getColumnProxySet()).createProxy(lobColumn);
                    newLobColumnProxy.setName(this.getLobColumn().getName());
                    newLobColumnProxy.setRawObject(true);
                    hashPartLobItem.setLobColumn(newLobColumnProxy);
                } else {
                    hashPartLobItem.setLobColumn(lobColumnProxy);
                }
            }
            if (this.getTableSpace() != null) {
                TableSpaceOracle tableSpace = (TableSpaceOracle)((StorageDesignOracle)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tableSpace == null) {
                    TableSpaceOracle newTableSpace = ((StorageDesignOracle)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    hashPartLobItem.setTableSpace(newTableSpace);
                } else {
                    hashPartLobItem.setTableSpace(tableSpace);
                }
            }
            hashPartLobItem.setComment(this.getComment());
            hashPartLobItem.setRawObject(false);
        }
    }
}

