/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class ClusterIndexOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private UserOracle user = null;
    private ClusterOracle cluster = null;
    private TableSpaceOracle tableSpace = null;
    private String logging = "YES";
    private SegmentOracle segment = null;
    private int compress = 0;
    private String parallel = "NO";
    private String degree = "";
    private String reverse = "NO";
    private String computeStatistics = "NO";
    private String online = "NO";
    public static final String TYPE_NAME = "ClIndex";
    public static final String OLD_TYPE_NAME = "ClusterIndex";

    @Override
    public String getIDPrefix() {
        return "CI";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterOracle cluster) {
        this.cluster = cluster;
        this.setPAC_Element(cluster);
        this.fireDataFieldChange();
    }

    public String getClusterUser() {
        if (this.cluster != null && this.cluster.getUser() != null) {
            return this.cluster.getUser().getName();
        }
        return "";
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public void setLogging(String value) {
        if (!this.logging.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.logging = value;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int compress) {
        this.compress = compress;
    }

    public void setParallel(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.parallel = value;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setReverse(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.reverse = value;
            this.fireDataFieldChange();
        }
    }

    public String getReverse() {
        return this.reverse;
    }

    public void setComputeStatistics(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.computeStatistics = value;
            this.fireDataFieldChange();
        }
    }

    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setOnline(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.online = value;
            this.fireDataFieldChange();
        }
    }

    public String getOnline() {
        return this.online;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null) {
            name = this.getUser().getLongName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        block5: {
            if (!"".equalsIgnoreCase(degree)) {
                try {
                    int intVal = Integer.parseInt(degree);
                    if (intVal > 0) {
                        this.degree = degree;
                        break block5;
                    }
                    this.degree = "";
                }
                catch (NumberFormatException e) {
                    this.degree = "";
                }
            } else {
                this.degree = "";
            }
        }
        this.fireDataFieldChange();
    }
}

