/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnUsage;

public class Join
extends ColumnUsage {
    private Column refColumn;
    private String refColumnName;
    private String refColumnID;
    private String refTable;
    private String refSchema;
    public String discoverySource;

    public Join() {
        this.refColumnName = this.EMPTY;
        this.refColumnID = this.EMPTY;
        this.refTable = this.EMPTY;
        this.refSchema = this.EMPTY;
        this.discoverySource = this.EMPTY;
    }

    public Join(String schema, String tableName, String columnName, String refSchema, String refTableName, String refColumnName) {
        super(schema, tableName, columnName);
        this.refColumnName = this.EMPTY;
        this.refColumnID = this.EMPTY;
        this.refTable = this.EMPTY;
        this.refSchema = this.EMPTY;
        this.discoverySource = this.EMPTY;
        this.refSchema = refSchema;
        this.refTable = refTableName;
        this.refColumnName = refColumnName;
    }

    public static void main(String[] args) {
    }

    public Column getRefColumn() {
        return this.refColumn;
    }

    public void setRefColumn(Column refColumn) {
        this.refColumn = refColumn;
    }

    public String getRefColumnName() {
        return this.refColumnName;
    }

    public void setRefColumnName(String refColumnName) {
        this.refColumnName = refColumnName;
    }

    public String getRefColumnID() {
        return this.refColumnID;
    }

    public void setRefColumnID(String refColumnID) {
        this.refColumnID = refColumnID;
    }

    public String getRefTable() {
        return this.refTable;
    }

    public void setRefTable(String refTable) {
        this.refTable = refTable;
    }

    public String getRefSchema() {
        return this.refSchema;
    }

    public void setRefSchema(String refSchema) {
        this.refSchema = refSchema;
    }

    public String getRefColumnLongName() {
        Object ln = "";
        if (this.refSchema != null && !this.refSchema.isEmpty()) {
            ln = this.refSchema + ".";
        }
        if (this.refTable != null && !this.refTable.isEmpty()) {
            ln = (String)ln + this.refTable + ".";
        }
        if (this.refColumnName != null && !this.refColumnName.isEmpty()) {
            ln = (String)ln + this.refColumnName;
        }
        return ln;
    }

    public String getRefTableLongName() {
        Object ln = "";
        if (this.refSchema != null && !this.refSchema.isEmpty()) {
            ln = this.refSchema + ".";
        }
        if (this.refTable != null && !this.refTable.isEmpty()) {
            ln = (String)ln + this.refTable;
        }
        return ln;
    }

    @Override
    public String getID() {
        return super.getID() + " - " + this.getRefColumnLongName();
    }

    @Override
    public String toString() {
        return this.getID();
    }

    public String getDiscoverySource() {
        return this.discoverySource;
    }

    public String getFormattedDiscoverySource() {
        String[] parts;
        if (this.discoverySource != null && !this.discoverySource.isEmpty() && (parts = this.discoverySource.split(";")).length > 1) {
            Object res = null;
            for (String p : parts) {
                res = res == null ? p : (String)res + "\n" + p;
            }
            return res;
        }
        return this.discoverySource;
    }

    public void setDiscoverySource(String discoverySource) {
        this.discoverySource = discoverySource;
    }

    public void addDiscoverySource(String source) {
        if (this.discoverySource == null || this.discoverySource.isEmpty()) {
            this.discoverySource = source;
        }
        if (!this.containsSource(source)) {
            this.discoverySource = this.discoverySource + ";" + source;
        }
    }

    public boolean containsSource(String source) {
        String[] parts;
        if (this.discoverySource == null || this.discoverySource.isEmpty()) {
            return false;
        }
        for (String s : parts = this.discoverySource.split(";")) {
            if (!s.equals(source)) continue;
            return true;
        }
        return false;
    }

    public void normalizeColumns(String ownerSchema, String ownerTable) {
        if (ownerSchema.equals(this.schema) && ownerTable.equals(this.tableName)) {
            return;
        }
        String sch = this.schema;
        String tname = this.tableName;
        String cname = this.columnName;
        this.schema = this.refSchema;
        this.tableName = this.refTable;
        this.columnName = this.refColumnName;
        this.refSchema = sch;
        this.refTable = tname;
        this.refColumnName = cname;
    }
}

