/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;

public class StructuredTypeSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new StructuredType[0];

    public StructuredTypeSet(DesignPart designPart) {
        super(designPart);
    }

    public StructuredType createStructuredType(String oldID, boolean isVisible) {
        StructuredType structuredType = new StructuredType(this.getDesignPart());
        structuredType.setObjectID(oldID);
        structuredType.setDesign(this.getDesign());
        structuredType.setParent(this);
        this.getDesign().addDesignObject(structuredType);
        structuredType.setVisible(isVisible);
        this.add(structuredType);
        return structuredType;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "StructuredType";
    }

    public List getDirectSubtypes(StructuredType st) {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            StructuredType stype = (StructuredType)it.next();
            if (stype.getParentType() != st) continue;
            list.add(stype);
        }
        return list;
    }

    public StructuredType findEqualOnProps(StructuredType st) {
        List stList = st.getAttributesList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            StructuredType ste = (StructuredType)it.next();
            if (ste == st) continue;
            List steList = ste.getAttributesList();
            if (stList.size() != steList.size()) continue;
            boolean diff = false;
            for (int i = 0; i < stList.size(); ++i) {
                TypeElement te1 = (TypeElement)stList.get(i);
                TypeElement te2 = (TypeElement)steList.get(i);
                if (!te1.getName().equals(te2.getName()) || te1.getType() != te2.getType()) {
                    diff = true;
                    continue;
                }
                if (te1.getSize().equals(te2.getSize()) && te1.getPrecision() == te2.getPrecision() && te1.getScale() == te2.getScale()) continue;
                diff = true;
            }
            if (diff) continue;
            return ste;
        }
        return null;
    }

    public StructuredType findByChangedHiveType(String hiveType) {
        if (hiveType != null && !"".equals(hiveType)) {
            String type = hiveType.toUpperCase();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                StructuredType stype = (StructuredType)it.next();
                String tt = stype.getDataTypePresentationForHive().toUpperCase();
                tt = tt.replaceAll("<", "(");
                if (!(tt = tt.replaceAll(">", ")")).equals(type)) continue;
                return stype;
            }
        }
        return null;
    }
}

