/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public class SequenceComparatorOracle
extends StoragePropertiesComparator {
    private SequenceOracle sourceSequence;
    private SequenceOracle targetSequence;
    private String defaultCache = "20";

    public SequenceComparatorOracle(SequenceOracle sourceSequence, SequenceOracle targetSequence) {
        super(sourceSequence, targetSequence);
        this.sourceSequence = sourceSequence;
        this.targetSequence = targetSequence;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        StorageDesign storageDesign = null;
        if (this.sourceSequence != null) {
            storageDesign = this.sourceSequence.getStorageDesign();
        } else if (this.targetSequence != null) {
            storageDesign = this.targetSequence.getStorageDesign();
        }
        this.initNameProperty();
        this.initCommentProperty();
        this.initNotesProperty();
        PropertyHolder userProperty = this.initProperty(USER_NAME, "user");
        if (userProperty.isModified() && !this.useSchema) {
            userProperty.setSelected(false);
            userProperty.setFiltered(true);
        }
        this.initProperty(START_WITH, "startWith");
        this.initProperty(INCREMENT_BY, "incrementBy");
        this.initProperty(MAX_VALUE, "maxValue");
        this.initProperty(MIN_VALUE, "minValue");
        this.initProperty(CYCLE, "cycle");
        this.initProperty(NOCACHE, "noCache");
        this.initProperty(CACHE, "cache");
        this.initProperty(ORDER, "order");
        if (storageDesign instanceof StorageDesignOraclev12c) {
            this.initProperty(SESSION, "session");
        }
    }

    public SequenceOracle getSequenceForProperty(String propertyName) {
        if (this.isTargetSelected(propertyName)) {
            return this.targetSequence;
        }
        return this.sourceSequence;
    }

    @Override
    protected boolean isExcludedFromComparison(String propertyName) {
        if (this.settings == null) {
            return true;
        }
        List propertiesFilterList = this.getPropertiesFilterList();
        for (int i = 0; i < propertiesFilterList.size(); ++i) {
            PropertyFilter pf = (PropertyFilter)propertiesFilterList.get(i);
            if (!propertyName.equalsIgnoreCase(pf.getName())) continue;
            return !pf.isSelected();
        }
        return false;
    }

    public String getDefaultCache() {
        return this.defaultCache;
    }

    public void setDefaultCache(String defaultCache) {
        this.defaultCache = defaultCache;
    }
}

