/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.ArrayList;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public class RoleComparatorOracle
extends StoragePropertiesComparator {
    public static final String IDENTIFIED = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.Identified");
    public static final String IDENTIFICATION_TYPE = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.IdentificationType");
    public static final String PASSWORD = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.Password");
    public static final String SCHEMA = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.Schema");
    public static final String PACKAGE = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.Package");
    public static final String ROLES = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.Roles");
    public static final String ROLES_WITH_ADMIN = RoleComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.RolesAdmin");
    public static final String PRIVILEGES = RoleComparatorOracle.getPropertyNameOracle("RolePropertyDialogOracle.SystemPrivileges");
    public static final String PRIVILEGES_WITH_ADMIN = RoleComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.PrivilegesAdmin");
    private RoleOracle sourceRole;
    private RoleOracle targetRole;

    public RoleComparatorOracle(RoleOracle sourceRole, RoleOracle targetRole) {
        super(sourceRole, targetRole);
        this.sourceRole = sourceRole;
        this.targetRole = targetRole;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(IDENTIFIED, "identified");
        this.initProperty(IDENTIFICATION_TYPE, "authType");
        this.initProperty(SCHEMA, "schema");
        this.initProperty(PACKAGE, "pack");
        this.initProperty(PRIVILEGES, this.getPrivileges(this.sourceRole), this.getPrivileges(this.targetRole), "privileges");
        this.initProperty(PRIVILEGES_WITH_ADMIN, this.getPrivilegesWithAdmin(this.sourceRole), this.getPrivilegesWithAdmin(this.targetRole), "privilegesWithAdminOption");
        this.initProperty(ROLES, this.getRoles(this.sourceRole), this.getRoles(this.targetRole), "roles");
        this.initProperty(ROLES_WITH_ADMIN, this.getRolesWithAdmin(this.sourceRole), this.getRolesWithAdmin(this.targetRole), "rolesWithAdminOption");
    }

    private String getPrivileges(RoleOracle role) {
        RoleOracle.InlineList privList;
        if (role != null && (privList = role.getPrivilegesSet()).size() > 0) {
            return this.listToString(privList);
        }
        return "";
    }

    private String getPrivilegesWithAdmin(RoleOracle role) {
        RoleOracle.InlineList privList;
        if (role != null && (privList = role.getPrivilegesWithAdminOptionSet()).size() > 0) {
            return this.listToString(privList);
        }
        return "";
    }

    private String getRoles(RoleOracle role) {
        RoleOracle.InlineList roleIdList;
        if (role != null && (roleIdList = role.getRolesSet()).size() > 0) {
            ArrayList<String> roleNameList = new ArrayList<String>(roleIdList.size());
            StorageDesignOracle sd = (StorageDesignOracle)role.getStorageDesign();
            for (String roleId : roleIdList) {
                ModelIDObject refRole = sd.getRoleSet().getObjectByID(roleId);
                if (refRole == null) continue;
                roleNameList.add(refRole.getName());
            }
            return this.listToString(roleNameList);
        }
        return "";
    }

    private String getRolesWithAdmin(RoleOracle role) {
        RoleOracle.InlineList roleIdList;
        if (role != null && (roleIdList = role.getRolesWithAdminOptionSet()).size() > 0) {
            ArrayList<String> roleNameList = new ArrayList<String>(roleIdList.size());
            StorageDesignOracle sd = (StorageDesignOracle)role.getStorageDesign();
            for (String roleId : roleIdList) {
                ModelIDObject refRole = sd.getRoleSet().getObjectByID(roleId);
                if (refRole == null) continue;
                roleNameList.add(refRole.getName());
            }
            return this.listToString(roleNameList);
        }
        return "";
    }
}

