/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;

public class PermissionsComparatorOracle
extends StoragePropertiesComparator {
    public static final String PERMISSIONS = Messages.getString("PermissionsComparatorOracle.Permissions");
    public static final String PERMISSIONS_WITH_GRANT_OPTION = Messages.getString("PermissionsComparatorOracle.PermissionsWithGrantOption");
    public static final String TABLE = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectTableOrObjectTable");
    public static final String VIEW = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectViewOrObjectView");
    public static final String MATERIALIZED_VIEW = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectMaterializedView");
    public static final String SEQUENCE = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectSequence");
    public static final String PACKAGE = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectPackage");
    public static final String PROCEDURE = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectStoredProcedure");
    public static final String FUNCTION = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectFunction");
    public static final String DIRECTORY = Messages.getString("PermissionsComparatorOracle.Directory");
    public static final String STRUCTURED_TYPE = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectStructuredType");
    public static final String COLLECTION_TYPE = PermissionsComparatorOracle.getPropertyNameOracle("SynonymPropertyDialogOraclev9i.ObjectCollectionType");
    public static final String COLUMNS_TABLE = Messages.getString("PermissionsComparatorOracle.ColumnsTable");
    public static final String COLUMNS = PermissionsComparatorOracle.getPropertyNameOracle("UserAndRolePermissionsDialogOracle.Columns");
    public static final String COLUMNS_WITH_GRANT_OPTION = Messages.getString("PermissionsComparatorOracle.ColumnsWithGrantOption");
    private PermissionsOracle sourcePermissions;
    private PermissionsOracle targetPermissions;

    public PermissionsComparatorOracle(PermissionsOracle sourcePermissions, PermissionsOracle targetPermissions) {
        super(sourcePermissions, targetPermissions);
        this.sourcePermissions = sourcePermissions;
        this.targetPermissions = targetPermissions;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initProperty(PERMISSIONS, this.getPrivileges(this.sourcePermissions), this.getPrivileges(this.targetPermissions), "privileges");
        this.initProperty(PERMISSIONS_WITH_GRANT_OPTION, this.getPrivilegesWithGrant(this.sourcePermissions), this.getPrivilegesWithGrant(this.targetPermissions), "privilegesWithGrantOption");
        this.initProperty(TABLE, "table");
        this.initProperty(VIEW, "view");
        this.initProperty(MATERIALIZED_VIEW, "materializedView");
        this.initProperty(SEQUENCE, "sequence");
        this.initProperty(PACKAGE, "package");
        this.initProperty(PROCEDURE, "proc");
        this.initProperty(FUNCTION, "function");
        this.initProperty(DIRECTORY, "directoryOracle");
        this.initProperty(STRUCTURED_TYPE, "structuredTypeOracle");
        this.initProperty(COLLECTION_TYPE, "collectionTypeOracle");
        this.initProperty(COLUMNS_TABLE, "columnsTable");
        this.initProperty(COLUMNS, "columnList");
        this.initProperty(COLUMNS_WITH_GRANT_OPTION, "columnWithGrantOptionList");
    }

    private String getPrivileges(PermissionsOracle permission) {
        PermissionsOracle.PermissionsSet privList;
        if (permission != null && (privList = permission.getPrivilegesSet()).size() > 0) {
            return this.listToString(privList);
        }
        return "";
    }

    private String getPrivilegesWithGrant(PermissionsOracle permission) {
        PermissionsOracle.PermissionsSet privList;
        if (permission != null && (privList = permission.getPrivilegesWithGrantOptionSet()).size() > 0) {
            return this.listToString(privList);
        }
        return "";
    }
}

