/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.lang.reflect.Method;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class BitmapJoinIndexComparatorOracle
extends StoragePropertiesComparator {
    public static final String USER = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.User");
    public static final String LOCAL_PARTITIONING = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.LocalPartitioning");
    public static final String TABLESPACE = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.Tablespace");
    public static final String LOGGING = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.Logging");
    public static final String COMPRESS = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.Compress");
    public static final String PARALLEL = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.Parallel");
    public static final String DEGREE = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.Degree");
    public static final String COMPUTE_STATISTICS = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.ComputeStatistics");
    public static final String ONLINE = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.Online");
    public static final String INDEX_COLUMNS = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.IndexColumns");
    public static final String DIMENSION_TABLES_KEYS = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.DimensionTablesKeys");
    public static final String BASE_TABLE_COLUMNS = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.BaseTableColumns");
    public static final String HASH_TABLESPACES = BitmapJoinIndexComparatorOracle.getPropertyNameOracle("BitmapJoinIndexPropertyDialogOracle.HashCompositeByHashTablespaces");
    private BitmapJoinIndexOracle sourceIndex;
    private BitmapJoinIndexOracle targetIndex;

    public BitmapJoinIndexComparatorOracle(BitmapJoinIndexOracle sourceIndex, BitmapJoinIndexOracle targetIndex) {
        super(sourceIndex, targetIndex);
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.initPropertiesList();
        this.initStoragePropertiesList();
        this.initPropertiesFilterList();
        this.initStoragePropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(USER, "user");
        this.initProperty(LOCAL_PARTITIONING, "localPartitioning");
        this.initProperty(TABLESPACE, "tablespace");
        this.initProperty(LOGGING, "logging");
        this.initProperty(COMPRESS, "compress");
        this.initProperty(PARALLEL, "parallel");
        this.initProperty(DEGREE, "degree");
        this.initProperty(COMPUTE_STATISTICS, "computeStatistics");
        this.initProperty(ONLINE, "online");
        this.initProperty(INDEX_COLUMNS, "indexColumnNames", "indexColumns");
        this.initProperty(DIMENSION_TABLES_KEYS, "dimensionKeyNames", "dimensionKeys");
        this.initProperty(BASE_TABLE_COLUMNS, "joinColumnNames", "joinColumns");
        this.initProperty(HASH_TABLESPACES, "allHashSubPartitionsTableSpaces", "hashSubPartitionsTableSpaces");
    }

    protected void initStoragePropertiesList() {
        SegmentOracle sourceSegment = null;
        SegmentOracle targetSegment = null;
        Method templateSetter = null;
        if (this.sourceIndex != null) {
            sourceSegment = this.sourceIndex.getSegment();
            try {
                templateSetter = BitmapJoinIndexOracle.class.getMethod("setSegment", SegmentOracle.class);
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        if (this.targetIndex != null) {
            targetSegment = this.targetIndex.getSegment();
        }
        if (sourceSegment != null || targetSegment != null) {
            this.templateComparator = new StorageTemplateComparator(this.sourceIndex, this.targetIndex, sourceSegment, targetSegment, null, null, templateSetter, null);
            this.templateComparator.filterStoragePropertiesList(this.getStoragePropertiesFilterList());
        }
    }
}

