/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;

public class CSSBFKIndexOraclev10g
extends AbstractCSSBOracle {
    private Map fkMap;
    private StorageDesignOraclev10g storageDesign;
    private boolean isRenamedTable = true;
    private List pkColumns;
    private List fkColumns;

    public CSSBFKIndexOraclev10g(Map fkMap) {
        this.fkMap = fkMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        FKIndexAssociation fkObj = (FKIndexAssociation)obj.getObject();
        FKIndexAssociation tfkObj = (FKIndexAssociation)tobj.getObject();
        boolean containercaneBerenamed = false;
        try {
            containercaneBerenamed = ((CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent()).canBeRename();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tfkObj != null && this.fkMap.get(tfkObj.getObjectID()) != null) {
            this.isRenamedTable = true;
            if (obj.isSelected() && tobj.canBeDrop()) return;
            FKContainer targetTable = tfkObj.getTable();
            this.appendRenameFK(oldbuffer, prettyPrint, tfkObj, targetTable, tobj);
            return;
        } else if (fkObj != null) {
            this.isRenamedTable = false;
            FKContainer table = fkObj.getTable();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
            KeyObject remoteIndex = fkObj.getRemoteIndex();
            if (containercaneBerenamed && table.shouldBeMerge() || remoteIndex != null && (this.fkMap.get(remoteIndex.getObjectID()) != null || this.fkMap.get("created_" + remoteIndex.getObjectID()) != null)) {
                this.appendFK(oldbuffer, prettyPrint, fkObj, table, obj);
                return;
            } else {
                if (!fkObj.shouldBeMerge() || !table.shouldBeMerge() || !obj.isModified()) return;
                if (!obj.canBeCreate()) {
                    boolean dropAndRecreate = false;
                    String formattedNewName = null;
                    String formattedOldName = null;
                    for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
                        if (!ph.isSelected()) continue;
                        String propertyName = ph.getName();
                        if (propertyName.equals(PropertiesComparator.NAME)) {
                            formattedNewName = this.storageDesign.getFormatedName(obj.getObject());
                            formattedOldName = this.storageDesign.getFormatedName(obj.getCorrespondentNode().getObject());
                            continue;
                        }
                        if (propertyName.equals(PropertiesComparator.COLUMN_ASSOCIATION)) {
                            CompareObjectSelection sourcePkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
                            if (sourcePkIndObject != null && sourcePkIndObject.isModified() && !sourcePkIndObject.isSelected()) continue;
                            dropAndRecreate = true;
                            continue;
                        }
                        if (!propertyName.equals(PropertiesComparator.REFERRED_COLUMNS) && !propertyName.equals(PropertiesComparator.DELETE_RULE)) continue;
                        dropAndRecreate = true;
                    }
                    if (dropAndRecreate) {
                        KeyObject tfkRemoteIndex;
                        if (obj.isSelected() && tfkObj != null && ((tfkRemoteIndex = tfkObj.getRemoteIndex()) == null || this.fkMap.get(tfkRemoteIndex.getObjectID()) == null)) {
                            this.appendDropFK(oldbuffer, fkObj, obj, prettyPrint);
                        }
                    } else {
                        if (formattedNewName == null) return;
                        if (table instanceof TableView) {
                            this.appendDropFK(oldbuffer, fkObj, obj, prettyPrint);
                        } else {
                            this.renameConstraint(oldbuffer, formattedOldName, formattedNewName, table, obj, prettyPrint);
                            return;
                        }
                    }
                }
                this.appendFK(oldbuffer, prettyPrint, fkObj, table, obj);
            }
            return;
        } else {
            KeyObject remoteIndex;
            if (tfkObj == null || !obj.isSelected() || (remoteIndex = tfkObj.getRemoteIndex()) != null && this.fkMap.get(remoteIndex.getObjectID()) != null) return;
            this.appendDropFK(oldbuffer, tfkObj, obj, prettyPrint);
        }
    }

    private void renameConstraint(StringBuffer oldbuffer, String formattedOldName, String formattedNewName, FKContainer table, CompareObjectSelection obj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
        if (table instanceof TableView) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VIEW");
        } else {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
        }
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
        String advancedComment = buffer.toString() + "RENAME CONSTRAINT " + formattedOldName;
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "RENAME");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, formattedOldName);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TO");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, formattedNewName);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
    }

    private void appendDropFK(StringBuffer oldbuffer, FKIndexAssociation fkObj, CompareObjectSelection obj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        FKContainer table = fkObj.getTable();
        FKIndexAssociation fkModObj = (FKIndexAssociation)obj.getCorrespondentNode().getObject();
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
        if (table instanceof TableView) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VIEW");
        } else {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
        }
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DROP");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkModObj));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
        this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
    }

    private void appendFK(StringBuffer oldbuffer, boolean prettyPrint, FKIndexAssociation fkObj, FKContainer table, CompareObjectSelection obj) {
        this.pkColumns = null;
        CompareObjectSelection tableSelection = (CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent();
        CompareObjectSelection sourcePkIndObject = null;
        String remoteTableLongName = null;
        KeyObject localFKIndex = fkObj.getLocalFKIndex();
        KeyObject remoteKey = fkObj.getKeyObject();
        if (remoteKey != null) {
            sourcePkIndObject = this.getPKObjectSelection(obj, remoteKey);
            if (sourcePkIndObject == null) {
                this.initFKandRefColumns(fkObj, tableSelection);
            } else if (sourcePkIndObject.isSelected() || !sourcePkIndObject.isModified()) {
                this.initFKandRefColumns(sourcePkIndObject, fkObj, tableSelection);
            }
        } else {
            this.fkColumns = new ArrayList();
            ContainedObject[] fkCols = localFKIndex.getElements();
            for (int i = 0; i < fkCols.length; ++i) {
                CompareObjectSelection cs = tableSelection.getChildNested(fkCols[i], 2);
                if (cs == null) continue;
                this.fkColumns.add(cs);
            }
            remoteTableLongName = fkObj.getReferredTableLongName();
        }
        if (localFKIndex instanceof ViewIndex) {
            this.appendViewFK(oldbuffer, fkObj, obj, prettyPrint);
        } else {
            FKProxyOraclev10g fk = (FKProxyOraclev10g)localFKIndex.getProxyObject();
            if (fk == null) {
                fk = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fkObj.getObjectID());
            }
            if (fk == null) {
                fk = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(localFKIndex.getObjectID());
            }
            if (fk != null) {
                TableProxyOracle tableProxy;
                boolean ext_table = false;
                if (table instanceof Table && (tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getObjectByID(table.getObjectID())) != null) {
                    ext_table = "EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization());
                }
                boolean ora12_2 = this.storageDesign instanceof StorageDesignOraclev12cR2;
                StringBuffer buffer = new StringBuffer();
                Object advancedComment = "";
                this.appendComment(oldbuffer, fk);
                CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
                if (this.pkColumns != null && !this.pkColumns.isEmpty() || remoteTableLongName != null && !remoteTableLongName.isEmpty()) {
                    if (ora12_2 || !ext_table) {
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                        advancedComment = buffer.toString() + "ADD CONSTRAINT " + this.storageDesign.getFormatedName(fk);
                        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
                        if (!fk.getName().startsWith("SYS_")) {
                            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                        }
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
                        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        this.appendColumnsSelection(buffer, this.fkColumns);
                        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
                        this.appendReferences(buffer, fk, prettyPrint);
                        boolean referencesView = fk.getFKTable() instanceof TableView;
                        if (ext_table) {
                            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "RELY");
                            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                        } else if (referencesView) {
                            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                        } else {
                            this.appendOnDelete(buffer, obj, prettyPrint);
                            if (this.isRenamedTable) {
                                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                            } else {
                                this.appendConstraintState(buffer, fk, prettyPrint);
                            }
                        }
                        this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
                        this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                        this.getStatus().incrementAlterTable();
                        if (!ext_table) {
                            String relyValue = null;
                            if (referencesView) {
                                if (fkObj.isRely() || fk.getRely().equals("YES")) {
                                    relyValue = "RELY";
                                }
                            } else if (fk.getValidate().equals("NO")) {
                                if (fk.getRely().equals("YES")) {
                                    relyValue = "RELY";
                                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                                    relyValue = "NORELY";
                                }
                            }
                            if (relyValue != null) {
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                                advancedComment = buffer.toString();
                                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, relyValue);
                                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                                CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
                                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                                this.getStatus().incrementAlterTable();
                            }
                        }
                    }
                    this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
                }
            }
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyOraclev10g fk, boolean prettyPrint) {
        boolean refStructType = false;
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
        FKContainer refTable = fk.getFKTable();
        if (refTable == null) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk.getIndex().getFKAssociation().getFormattedReferredTableLongName()));
        } else {
            ModelIDObject refTableObj = null;
            refTableObj = refTable instanceof TableView ? this.storageDesign.getTableViewProxySet().getProxy(refTable.getObjectID()) : this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObj == null) {
                refTableObj = refTable;
            }
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObj));
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
        }
        if (!refStructType) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (refTable == null) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fk.getIndex().getFKAssociation().getReferredColumnNames()));
            } else {
                this.appendColumns(buffer, this.pkColumns);
            }
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendOnDelete(StringBuffer buffer, CompareObjectSelection obj, boolean prettyPrint) {
        String onDelete = obj.getChoosedPropertyValue(PropertiesComparator.DELETE_RULE);
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            String mandatory = obj.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
            boolean isMandatory = Boolean.parseBoolean(mandatory);
            onDelete = isMandatory ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DELETE");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, onDelete);
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOraclev10g fk, boolean prettyPrint) {
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        } else {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        }
        if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(fk.getEnable())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(fk.getValidate())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (fk.getExceptionsTable() != null) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof FKIndexAssociation || ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof FKIndexAssociation;
    }

    private CompareObjectSelection getPKObjectSelection(CompareObjectSelection object, KeyObject pkIndex) {
        CompareObjectSelection pkIndexObj = null;
        if (pkIndex != null) {
            ContainerWithKeyObject table = pkIndex.getContainerWithKeyObject();
            CompareObjectSelection fkParent = (CompareObjectSelection)object.getParent();
            CompareObjectSelection rootTables = (CompareObjectSelection)((CompareObjectSelection)fkParent.getParent()).getParent();
            CompareObjectSelection tableObj = rootTables.getChild(table);
            if (tableObj == null) {
                return null;
            }
            CompareObjectSelection pkIndexes = (CompareObjectSelection)tableObj.getChild(2);
            if (pkIndexes == null) {
                return null;
            }
            pkIndexObj = pkIndexes.getChild(pkIndex);
        }
        return pkIndexObj;
    }

    private void initFKandRefColumns(CompareObjectSelection pkObject, FKIndexAssociation fkIndAss, CompareObjectSelection tableSelection) {
        this.pkColumns = this.getColumnsForRestore(pkObject);
        this.fkColumns = new ArrayList();
        FKContainer fkTable = (FKContainer)fkIndAss.getContainerWithKeyObject();
        for (FKElement pkColumn : this.pkColumns) {
            CompareObjectSelection cs;
            FKElement fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
            if (fkColumn == null || (cs = tableSelection.getChildNested(fkColumn, 2)) == null) continue;
            this.fkColumns.add(cs);
        }
    }

    private void initFKandRefColumns(CompareObjectSelection pkObject, FKIndexAssociation fkIndAss) {
        this.pkColumns = this.getColumnsForRestore(pkObject);
        this.fkColumns = new ArrayList();
        FKContainer fkTable = (FKContainer)fkIndAss.getContainerWithKeyObject();
        for (FKElement pkColumn : this.pkColumns) {
            FKElement fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
            if (fkColumn == null) continue;
            this.fkColumns.add(fkColumn);
        }
    }

    private void initFKandRefColumns(FKIndexAssociation fkIndAss, CompareObjectSelection tableSelection) {
        this.pkColumns = new ArrayList();
        this.fkColumns = new ArrayList();
        if (fkIndAss.getRemoteIndex() != null) {
            this.pkColumns.addAll(fkIndAss.getRemoteIndex().getElementsCollection());
            FKContainer fkTable = (FKContainer)fkIndAss.getContainerWithKeyObject();
            for (FKElement pkColumn : this.pkColumns) {
                CompareObjectSelection cs;
                FKElement fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
                if (fkColumn == null || (cs = tableSelection.getChildNested(fkColumn, 2)) == null) continue;
                this.fkColumns.add(cs);
            }
        }
    }

    private List getColumnsForRestore(CompareObjectSelection object) {
        CompareObjectSelection pkIndexes;
        CompareObjectSelection tableObj;
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        KeyObject pkIndex = (KeyObject)object.getObject();
        if (pkIndex != null && (tableObj = (CompareObjectSelection)(pkIndexes = (CompareObjectSelection)object.getParent()).getParent()) != null) {
            List sourceColumns = tableObj.getChildObjects(0);
            block0: for (FKElement pkCol : pkIndex.getElementsCollection()) {
                for (CompareObjectSelection obj : sourceColumns) {
                    if (pkCol != obj.getObject()) continue;
                    if (obj.canBeCreate() && !obj.isSelected() || obj.canBeDrop() && obj.getCorrespondentNode().isSelected()) continue block0;
                    list.add(pkCol);
                    continue block0;
                }
            }
        }
        return list;
    }

    private void appendColumns(StringBuffer buffer, List fkColumns) {
        Iterator it = fkColumns.iterator();
        boolean first = true;
        while (it.hasNext()) {
            FKElement col = (FKElement)it.next();
            if (!first) {
                CSSBFKIndexOraclev10g.appendString(buffer, ',');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            }
            CSSBFKIndexOraclev10g.appendString(buffer, ' ');
            if (col != null) {
                CSSBFKIndexOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(col));
            }
            first = false;
        }
    }

    private void appendColumnsSelection(StringBuffer buffer, List fkColSele) {
        Iterator it = this.fkColumns.iterator();
        boolean first = true;
        while (it.hasNext()) {
            CompareObjectSelection col = (CompareObjectSelection)it.next();
            if (!first) {
                CSSBFKIndexOraclev10g.appendString(buffer, ',');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            }
            CSSBFKIndexOraclev10g.appendString(buffer, ' ');
            if (col != null) {
                CSSBFKIndexOraclev10g.appendString(buffer, CSSBFKIndexOraclev10g.getFormattedSelectedName(col, this.storageDesign));
            }
            first = false;
        }
    }

    private void appendRenameFK(StringBuffer oldbuffer, boolean prettyPrint, FKIndexAssociation fkObj, FKContainer table, CompareObjectSelection obj) {
        this.pkColumns = null;
        StringBuffer buffer = new StringBuffer();
        Object advancedComment = "";
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        FKProxyOraclev10g fk = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fkObj.getLocalFKIndex().getObjectID());
        if (fk != null) {
            ModelIDObject sFKInd;
            CompareObjectSelection sourcePKIndObj;
            this.appendComment(oldbuffer, fk);
            CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CompareObjectSelection targetPkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
            if (targetPkIndObject != null && ((sourcePKIndObj = targetPkIndObject.getCorrespondentNode()).isSelected() || !sourcePKIndObj.isModified()) && (sFKInd = obj.getCorrespondentNode().getObject()) != null) {
                this.initFKandRefColumns(sourcePKIndObj, (FKIndexAssociation)sFKInd);
            }
            if (this.pkColumns != null && this.pkColumns.size() > 0) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                if (table instanceof TableView) {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VIEW");
                } else {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                }
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                String fkName = obj.getCorrespondentNode().isSelected() ? CSSBFKIndexOraclev10g.getFormattedSelectedName(obj, this.storageDesign) : this.storageDesign.getFormatedName(fk);
                advancedComment = buffer.toString() + "ADD CONSTRAINT " + fkName;
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
                if (!fkName.startsWith("SYS_")) {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, fkName);
                }
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                this.appendColumns(buffer, this.fkColumns);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendReferences(buffer, fk, prettyPrint);
                this.appendOnDelete(buffer, obj, prettyPrint);
                TableProxyOracle targetProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fk.getFKTable().getObjectID());
                if (this.isRenamedTable && (targetProxy.getBackupOption().equals(TableProxy.NONE) || targetProxy.getRestoreOption().equals(TableProxy.NONE))) {
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                } else {
                    this.appendConstraintState(buffer, fk, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                this.getStatus().incrementAlterTable();
                this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            }
        }
    }

    private String getTableName(CompareObjectSelection index) {
        CompareObjectSelection table = index.getTableNode();
        if (table != null) {
            return CSSBFKIndexOraclev10g.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }

    protected void appendViewFK(StringBuffer oldbuffer, FKIndexAssociation fk, CompareObjectSelection obj, boolean prettyPrint) {
        if (fk.getLocalFKIndex().getElements().length > 0) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            this.appendComment(oldbuffer, fk);
            CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VIEW");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!fk.getName().startsWith("SYS_")) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
            }
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
            advancedComment = buffer.toString();
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBFKIndexOraclev10g.appendString(buffer, this.getViewFKColumns(fk));
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendViewFKReferences(buffer, fk);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterView();
            if (fk.isRely()) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VIEW");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                advancedComment = buffer.toString();
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBFKIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterView();
            }
        } else {
            CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - Foreign Key ");
            oldbuffer.append(this.storageDesign.getFormatedName(fk));
            oldbuffer.append(" has no columns");
            CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.getStatus().incrementErrors();
        }
    }

    public String getViewFKColumns(FKIndexAssociation fk) {
        StringBuffer result = new StringBuffer();
        ContainedObject[] columns = fk.getLocalFKIndex().getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                result.append(",\n");
            }
            result.append("     ").append(this.storageDesign.getFormatedName(columns[i]));
        }
        return result.toString();
    }

    private void appendViewFKReferences(StringBuffer buffer, FKIndexAssociation fk) {
        boolean refStructType = false;
        CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
        FKContainer refTable = fk.getRemoteTable();
        if (refTable == null) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk.getFormattedReferredTableLongName()));
        } else {
            ModelIDObject refTableObject = null;
            refTableObject = refTable instanceof TableView ? this.storageDesign.getTableViewProxySet().getProxy(refTable.getObjectID()) : this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            if (refTable.isBST()) {
                ContainedObject[] columns = fk.getLocalFKIndex().getElements();
                for (int i = 0; i < columns.length; ++i) {
                    FKElement column = (FKElement)columns[i];
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
        }
        if (!refStructType) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            if (refTable == null) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fk.getReferredColumnNames()));
            } else {
                this.appendColumns(buffer, this.pkColumns);
            }
            CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }
}

