/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBStructuredTypeBodyOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBStructuredTypeOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBStructuredTypeBodyOraclev9i;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBStructuredTypeOraclev9i;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropType;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StructuredTypeComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;

public class CSSBStructuredType
extends AbstractCSSBOracle {
    private SSBStructuredTypeOraclev10g ssbStructuredTypeOraclev10g = null;
    private SSBStructuredTypeBodyOraclev10g ssbStructuredTypeBodyOraclev10g = null;
    private SSBStructuredTypeOraclev9i ssbStructuredTypeOraclev9i = null;
    private SSBStructuredTypeBodyOraclev9i ssbStructuredTypeBodyOraclev9i = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StorageDesign sourceSD;
        StructuredTypeProxyOracle sourceSTProxy;
        CompareObjectSelection sourceTypeSel = (CompareObjectSelection)object;
        StructuredType sourceStructType = (StructuredType)sourceTypeSel.getObject();
        boolean drop = false;
        boolean generate = false;
        if (sourceTypeSel.canBeCreate()) {
            generate = true;
        } else {
            for (EngPropertyHolder ph : sourceTypeSel.getPropertiesComparator().getPropertiesList()) {
                if (!ph.isSelected() || !ph.isDDLHolder()) continue;
                if (ph.getName().equals(PropertyNames.NAME)) {
                    drop = true;
                }
                generate = true;
            }
            for (EngPropertyHolder ph : sourceTypeSel.getPropertiesComparator().getPhysicalPropertiesList()) {
                if (!ph.isSelected() || !ph.isDDLHolder()) continue;
                if (ph.getName().equals(StructuredTypeComparatorOracle.OWNER)) {
                    if (!sourceTypeSel.getDesign().getSettings().isIncludeSchemaInDDL()) continue;
                    drop = true;
                    generate = true;
                    continue;
                }
                if (ph.getName().equals(PropertyNames.NAME)) {
                    drop = true;
                }
                generate = true;
            }
            if (!generate) {
                generate = sourceTypeSel.hasDDLModifiedChildren();
            }
        }
        if (generate && (sourceSTProxy = (StructuredTypeProxyOracle)(sourceSD = this.getStorageDesign(sourceStructType)).getStructuredTypeProxySet().getProxy(sourceStructType.getObjectID())) != null) {
            if (drop) {
                CSSBDropType cssbDropType = new CSSBDropType();
                cssbDropType.doAppend(oldbuffer, object, prettyPrint);
            }
            if (sourceSTProxy instanceof StructuredTypeProxyOraclev10g) {
                if (this.ssbStructuredTypeOraclev10g == null) {
                    this.ssbStructuredTypeOraclev10g = new SSBStructuredTypeOraclev10g();
                    this.ssbStructuredTypeBodyOraclev10g = new SSBStructuredTypeBodyOraclev10g();
                    this.ssbStructuredTypeOraclev10g.setDDLGenerator(this.getDDLGenerator());
                    this.ssbStructuredTypeBodyOraclev10g.setDDLGenerator(this.getDDLGenerator());
                }
                this.ssbStructuredTypeOraclev10g.doAppend(oldbuffer, sourceSTProxy, prettyPrint);
                this.ssbStructuredTypeBodyOraclev10g.doAppend(oldbuffer, sourceSTProxy, prettyPrint);
            } else {
                if (this.ssbStructuredTypeOraclev9i == null) {
                    this.ssbStructuredTypeOraclev9i = new SSBStructuredTypeOraclev9i();
                    this.ssbStructuredTypeBodyOraclev9i = new SSBStructuredTypeBodyOraclev9i();
                    this.ssbStructuredTypeOraclev9i.setDDLGenerator(this.getDDLGenerator());
                    this.ssbStructuredTypeBodyOraclev9i.setDDLGenerator(this.getDDLGenerator());
                }
                this.ssbStructuredTypeOraclev9i.doAppend(oldbuffer, sourceSTProxy, prettyPrint);
                this.ssbStructuredTypeBodyOraclev9i.doAppend(oldbuffer, sourceSTProxy, prettyPrint);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof StructuredType;
    }
}

