/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public class CSSBListPartitionOracle
extends AbstractCSSBOracle {
    private StorageDesignOracle storageDesign;

    public void updateListPartitions(StringBuffer oldbuffer, CompareObjectSelection tableNode, CompareObjectSelection partitionsNode, StorageDesignOracle storageDesign, boolean prettyPrint) {
        if (partitionsNode.hasChildsWithChangeStatus()) {
            ListPartitionOracle listPartition;
            int i;
            this.storageDesign = storageDesign;
            String formattedTableName = CSSBListPartitionOracle.getFormattedTableName(tableNode, storageDesign);
            ListPartitionOracle oldDefaultPartition = null;
            ListPartitionOracle newDefaultPartition = null;
            CompareObjectSelection targetPartitionsNode = partitionsNode.getCorrespondentNode();
            int partitionCount = partitionsNode.getNumberOfChildren();
            TreeMap<String, ListPartitionOracle> valuesMap = new TreeMap<String, ListPartitionOracle>();
            for (i = 0; i < partitionCount; ++i) {
                CompareObjectSelection targetPartitionSel = (CompareObjectSelection)targetPartitionsNode.getChild(i);
                ModelIDObject obj = targetPartitionSel.getObject();
                if (!(obj instanceof ListPartitionOracle)) continue;
                listPartition = (ListPartitionOracle)obj;
                for (String value : this.getValues(listPartition.getColumns())) {
                    if (value.equalsIgnoreCase("DEFAULT")) {
                        oldDefaultPartition = listPartition;
                    }
                    valuesMap.put(value, listPartition);
                }
            }
            for (i = 0; i < partitionCount; ++i) {
                ModelIDObject targetPartition;
                CompareObjectSelection partitionSel = (CompareObjectSelection)partitionsNode.getChild(i);
                if (!partitionSel.isSelected()) continue;
                if (partitionSel.canBeCreate()) {
                    ListPartitionOracle listPartition2 = (ListPartitionOracle)partitionSel.getObject();
                    List<String> valueList = this.getValues(listPartition2.getColumns());
                    if (valueList.size() > 0 && valueList.get(0).equalsIgnoreCase("DEFAULT")) {
                        if (oldDefaultPartition != null) {
                            oldDefaultPartition = null;
                            this.renamePartition(oldbuffer, formattedTableName, oldDefaultPartition, listPartition2, prettyPrint);
                        } else {
                            this.addPartition(oldbuffer, formattedTableName, listPartition2, prettyPrint);
                        }
                        newDefaultPartition = listPartition2;
                        continue;
                    }
                    ArrayList<ListPartitionOracle> previousPartitions = null;
                    for (String value : valueList) {
                        ListPartitionOracle partitionWithValue = (ListPartitionOracle)valuesMap.get(value);
                        if (partitionWithValue == null) continue;
                        if (previousPartitions == null) {
                            previousPartitions = new ArrayList<ListPartitionOracle>();
                        }
                        if (previousPartitions.contains(partitionWithValue)) continue;
                        previousPartitions.add(partitionWithValue);
                    }
                    if (previousPartitions != null) continue;
                    if (oldDefaultPartition != null) {
                        this.splitPartition(oldbuffer, formattedTableName, oldDefaultPartition, listPartition2, listPartition2.getColumns(), prettyPrint);
                        continue;
                    }
                    this.addPartition(oldbuffer, formattedTableName, listPartition2, prettyPrint);
                    continue;
                }
                if (!partitionSel.canBeDrop() || !((targetPartition = partitionSel.getCorrespondentNode().getObject()) instanceof ListPartitionOracle)) continue;
                listPartition = (ListPartitionOracle)targetPartition;
                List<String> valueList = this.getValues(listPartition.getColumns());
                if (valueList.size() > 0 && valueList.get(0).equalsIgnoreCase("DEFAULT")) {
                    if (newDefaultPartition != null) continue;
                    this.dropPartition(oldbuffer, formattedTableName, listPartition, prettyPrint);
                    continue;
                }
                ListPartitionOracle defaultPartition = newDefaultPartition;
                if (defaultPartition == null) {
                    defaultPartition = oldDefaultPartition;
                }
                if (defaultPartition != null) {
                    this.mergePartitions(oldbuffer, formattedTableName, listPartition, defaultPartition, prettyPrint);
                    continue;
                }
                this.dropPartition(oldbuffer, formattedTableName, listPartition, prettyPrint);
            }
        }
    }

    private void addPartition(StringBuffer oldbuffer, String formattedTableName, ListPartitionOracle partition, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "ALTER");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "TABLE");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, formattedTableName);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "ADD");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITION");
        if (!partition.getName().toUpperCase().startsWith("SYS_")) {
            CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
        }
        String advancedComment = buffer.toString();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "VALUES");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, '(');
        String values = partition.getColumns();
        if (values.length() > 0) {
            CSSBListPartitionOracle.appendStringWithSpace(buffer, values);
        } else {
            CSSBListPartitionOracle.appendStringWithSpace(buffer, "DEFAULT");
        }
        CSSBListPartitionOracle.appendStringWithSpace(buffer, ')');
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBListPartitionOracle.appendNewLine(buffer, prettyPrint, 0);
        CSSBListPartitionOracle.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
    }

    private void dropPartition(StringBuffer oldbuffer, String formattedTableName, ListPartitionOracle partition, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "ALTER");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "TABLE");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, formattedTableName);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "DROP");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITION");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBListPartitionOracle.appendNewLine(buffer, prettyPrint, 0);
        CSSBListPartitionOracle.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
    }

    private void renamePartition(StringBuffer oldbuffer, String formattedTableName, ListPartitionOracle oldPartition, ListPartitionOracle newPartition, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "ALTER");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "TABLE");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, formattedTableName);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "RENAME");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITION");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(oldPartition));
        String advancedComment = buffer.toString();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "TO");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(newPartition));
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBListPartitionOracle.appendNewLine(buffer, prettyPrint, 0);
        CSSBListPartitionOracle.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
    }

    private void splitPartition(StringBuffer oldbuffer, String formattedTableName, ListPartitionOracle oldPartition, ListPartitionOracle newPartition, String values, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "ALTER");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "TABLE");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, formattedTableName);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "SPLIT");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITION");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(oldPartition));
        String advancedComment = buffer.toString();
        CSSBListPartitionOracle.appendNewLine(buffer, prettyPrint, 1);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "VALUES");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, '(');
        CSSBListPartitionOracle.appendStringWithSpace(buffer, values);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, ')');
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "INTO");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, '(');
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITION");
        if (!newPartition.getName().toUpperCase().startsWith("SYS_")) {
            CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(newPartition));
        }
        CSSBListPartitionOracle.appendStringWithSpace(buffer, ',');
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITION");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(oldPartition));
        CSSBListPartitionOracle.appendStringWithSpace(buffer, ')');
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBListPartitionOracle.appendNewLine(buffer, prettyPrint, 0);
        CSSBListPartitionOracle.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
    }

    private void mergePartitions(StringBuffer oldbuffer, String formattedTableName, ListPartitionOracle deletedPartition, ListPartitionOracle mergedPartition, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "ALTER");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "TABLE");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, formattedTableName);
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "MERGE");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "PARTITIONS");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(deletedPartition));
        CSSBListPartitionOracle.appendStringWithSpace(buffer, ',');
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(mergedPartition));
        String advancedComment = buffer.toString();
        CSSBListPartitionOracle.appendStringWithSpace(buffer, "INTO");
        CSSBListPartitionOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(mergedPartition));
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBListPartitionOracle.appendNewLine(buffer, prettyPrint, 0);
        CSSBListPartitionOracle.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
    }

    private List<String> getValues(String values) {
        ArrayList<String> valueList = new ArrayList<String>();
        values = values.trim();
        int commaIndex = values.indexOf(44);
        while (commaIndex > -1) {
            String firstLiteral = Token.getFirstTextLiteral(values);
            if (firstLiteral.length() > 0) {
                values = values.substring(firstLiteral.length());
                commaIndex = values.indexOf(44);
            } else {
                firstLiteral = values.substring(0, commaIndex).trim();
                if (firstLiteral.equalsIgnoreCase("DEFAULT")) {
                    valueList.clear();
                    valueList.add(firstLiteral);
                    return valueList;
                }
            }
            if (firstLiteral.length() > 0) {
                valueList.add(firstLiteral);
            }
            if (commaIndex > -1) {
                values = values.substring(commaIndex + 1);
            }
            values = values.trim();
            commaIndex = values.indexOf(44);
        }
        if (values.length() > 0) {
            if (values.equalsIgnoreCase("DEFAULT")) {
                valueList.clear();
            }
            valueList.add(values);
        }
        return valueList;
    }

    @Override
    public boolean canHandle(Object object) {
        return false;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
    }
}

