/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.storage.oracle.CollectionTypeComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public class CollectionTypeComparator
extends PropertiesComparator {
    public static final String COLLECTION_TYPE = "Collection Type";
    public static final String MAX_ELEMENT = "Max Element";
    public static final String DATATYPE = "Data Type";
    public static final String MAX_SIZE_AS_STRING = "Max Size as String";
    private CollectionType sourceType;
    private CollectionType targetType;
    private CollectionTypeProxy sourceTypeProxy;
    private CollectionTypeProxy targetTypeProxy;
    private CompareCWDDesigns selectionObject;
    private StorageDesign storageDesign;

    public CollectionTypeComparator(CollectionType source, CollectionType target) {
        this(source, target, null, null);
    }

    public CollectionTypeComparator(CollectionType source, CollectionType target, CollectionTypeProxy sourceTypeProxy, CollectionTypeProxy targetTypeProxy) {
        super(source, target);
        CollectionTypeProxy typeProxy;
        this.sourceType = source;
        this.targetType = target;
        this.sourceTypeProxy = sourceTypeProxy;
        this.targetTypeProxy = targetTypeProxy;
        CollectionTypeProxy collectionTypeProxy = typeProxy = sourceTypeProxy != null ? sourceTypeProxy : targetTypeProxy;
        if (typeProxy instanceof CollectionTypeProxyOracle) {
            this.storageDesign = typeProxy.getStorageDesign();
        } else {
            CollectionType type;
            CollectionType collectionType = type = source != null ? source : target;
            if (type != null) {
                this.storageDesign = type.getDesign().getRelationalDesign().getStorageDesign();
            }
        }
        this.initPropertiesList();
        this.initPropertiesFilterList();
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        CollectionTypeProxy typeProxy;
        CollectionTypeComparatorOracle physicalComparator = null;
        CollectionTypeProxy collectionTypeProxy = typeProxy = this.sourceTypeProxy != null ? this.sourceTypeProxy : this.targetTypeProxy;
        if (typeProxy instanceof CollectionTypeProxyOracle) {
            physicalComparator = new CollectionTypeComparatorOracle(this.sourceTypeProxy, this.targetTypeProxy);
        }
        this.setPhysicalPropertiesComparator(physicalComparator);
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(COLLECTION_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? this.sourceType.getType() : "");
        ph.setRightValue(this.targetType != null ? this.targetType.getType() : "");
        if (this.isExcludedFromComparison(COLLECTION_TYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MAX_ELEMENT);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.getMaxElement()) : "");
        ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.getMaxElement()) : "");
        if (this.isExcludedFromComparison(MAX_ELEMENT)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(DATATYPE);
        ph.setDDLHolder(true);
        String rdbmsType = StorageDesignOraclev12c.RDBMS_TYPE.getName();
        if (this.storageDesign != null) {
            rdbmsType = this.storageDesign.getRDBMSType().getName();
        }
        ph.setLeftValue(this.sourceType != null ? this.sourceType.getElementType().getDataType(rdbmsType) : "");
        ph.setRightValue(this.targetType != null ? this.targetType.getElementType().getDataType(rdbmsType) : "");
        if (this.isExcludedFromComparison(DATATYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(MAX_SIZE_AS_STRING);
            ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.getMaxLengthAsString()) : "");
            ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.getMaxLengthAsString()) : "");
            if (this.isExcludedFromComparison(MAX_SIZE_AS_STRING)) {
                ph.setExcluded(true);
            } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        this.initCommentsAndNotes(false);
        this.initDynamicProperties();
    }

    @Override
    public void copySelectedProperties() {
        if (this.sourceType != null && this.targetType != null) {
            this.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(COLLECTION_TYPE)) {
                    this.targetType.setType(this.sourceType.getType());
                    continue;
                }
                if (ph.getName().equals(MAX_ELEMENT)) {
                    this.targetType.setMaxElement(this.sourceType.getMaxElement());
                    continue;
                }
                if (ph.getName().equals(DATATYPE)) {
                    MergingModels.copyDataTypeFromDTO_To_DTO(this.sourceType.getElementType(), this.targetType.getElementType());
                    continue;
                }
                if (!ph.getName().equals(MAX_SIZE_AS_STRING)) continue;
                this.targetType.setMaxLengthAsString(this.sourceType.getMaxLengthAsString());
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceType == null && this.targetType != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        return this.sourceType != null ? MessageFormat.format(Messages.getString("CollectionTypeComparator.SourceCollectionType"), this.sourceType.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("CollectionTypeComparator.TargetCollectionType"), this.targetType.getName()) : "";
    }
}

