/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.ViewIndex;

public class CWDViewIndexComparator
extends PropertiesComparator {
    private ViewIndex sourceIndex;
    private ViewIndex targetIndex;
    private Map objectsMap;
    private CompareCWDDesigns selectionObject;

    public CWDViewIndexComparator(ViewIndex index, ViewIndex key, Map objectsMap) {
        super(index, key);
        this.sourceIndex = index;
        this.targetIndex = key;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(INDEX_STATUS);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.isExcludedFromComparison(INDEX_STATUS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMNS);
        ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.isExcludedFromComparison(COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, true)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
    }

    private String getElementsToString(ViewIndex keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            FKElement co = (FKElement)it.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!ph.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }
}

