/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerWindow;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerWindow
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_WINDOW";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_WINDOWS";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_WINDOWS";

    public MOHSchedulerWindow(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            for (DBObject dbo : selectedObjects) {
                String schema;
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                if ((schema = dbo.getSchema()) == null) {
                    schema = "SYS";
                }
                statement.setString(1, schema);
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) continue;
                SchedulerWindow sched = new SchedulerWindow();
                for (String prop : sched.getPropsList()) {
                    String value = null;
                    try {
                        value = rs.getString(prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("propname - " + prop);
                    }
                    sched.setProperty(prop, value);
                }
                rs.close();
                sched.validate();
                res.add(sched);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select \r\nOWNER,\r\nWINDOW_NAME,\r\nRESOURCE_PLAN,\r\nSCHEDULE_OWNER,\r\nSCHEDULE_NAME,\r\nSCHEDULE_TYPE,\r\nto_char( START_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as START_DATE,\nREPEAT_INTERVAL,\r\nto_char(END_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as END_DATE,\nDURATION,\r\nWINDOW_PRIORITY,\r\nENABLED,\r\nCOMMENTS from " + (dba ? DBA_TABLE : ALL_TABLE) + " \nwhere owner = ? and WINDOW_NAME = ?";
        return sql;
    }
}

