/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TypeElementProxyOraclev9i;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBStructuredTypeOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof StructuredType) {
            StructuredType type = (StructuredType)object;
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, type);
        } else if (object instanceof StructuredTypeProxyOraclev9i) {
            StructuredTypeProxyOraclev9i typeProxy = (StructuredTypeProxyOraclev9i)object;
            this.storageDesign = typeProxy.getStorageDesign();
            if (!typeProxy.getStructuredType().isPredefined()) {
                SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, typeProxy);
                this.appendFullDefinition(buffer, typeProxy, prettyPrint);
                this.appendPermissions(buffer, typeProxy);
                this.incrementCreateStructuredType();
            }
        }
    }

    private void appendFullDefinition(StringBuffer oldbuffer, StructuredTypeProxyOraclev9i typeProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SSBStructuredTypeOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "OR");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "REPLACE");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getOwner() != null && this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
            SSBStructuredTypeOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
            SSBStructuredTypeOraclev9i.appendString(buffer, '.');
        }
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
        advancedComment = buffer.toString();
        if (!"".equalsIgnoreCase(typeProxy.getInvokerRights())) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "AUTHID");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, typeProxy.getInvokerRights());
        }
        StructuredTypeProxyOracle parentProxy = null;
        StructuredType parentType = ((StructuredType)typeProxy.getObject()).getParentType();
        if (parentType != null) {
            parentProxy = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getProxy(parentType.getObjectID());
        }
        if (parentProxy == null) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "OBJECT");
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        } else {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "UNDER");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(parentProxy));
        }
        this.appendSqljObjectType(buffer, typeProxy, prettyPrint);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, '(');
        this.appendElements(buffer, typeProxy, prettyPrint);
        this.appendMethods(buffer, typeProxy, prettyPrint);
        SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, ')');
        if ("NO".equalsIgnoreCase(typeProxy.getFinal())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NOT");
        }
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "FINAL");
        if ("NO".equalsIgnoreCase(typeProxy.getInstantiable())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NOT");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "INSTANTIABLE");
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisherWithSlash(buffer, prettyPrint);
        SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendSqljObjectType(StringBuffer buffer, StructuredTypeProxyOraclev9i typeProxy, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(typeProxy.getMapToJavaClass())) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "EXTERNAL");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NAME");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, typeProxy.getJavaClass());
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "LANGUAGE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "JAVA");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "USING");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, typeProxy.getJavaInstanceUsing());
        }
    }

    private void appendElements(StringBuffer buffer, StructuredTypeProxyOraclev9i typeProxy, boolean prettyPrint) {
        boolean first = true;
        StructuredType st = typeProxy.getStructuredType();
        TypeElement[] elems = st.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElementProxyOraclev9i typeElement = (TypeElementProxyOraclev9i)typeProxy.getElementByDesignObject(elems[i]);
            if (!first) {
                this.appendComma(buffer);
            } else {
                first = false;
            }
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeElement));
            Object datatype = null;
            TypeElement attribute = (TypeElement)typeElement.getObject();
            DesignObject attDataType = attribute.getType();
            if (attDataType instanceof StructuredType || attDataType instanceof CollectionType) {
                RelationalObjectProxy proxy = this.storageDesign.getProxy(attDataType);
                datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(attDataType);
                if (attribute.isReference() && attDataType instanceof StructuredType) {
                    datatype = "REF " + (String)datatype;
                }
            } else {
                datatype = attribute.getDataType(this.storageDesign.getRDBMSType().getName());
            }
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, (String)datatype);
            if ("".equalsIgnoreCase(typeElement.getSqlJAttr())) continue;
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "EXTERNAL");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NAME");
            SSBStructuredTypeOraclev9i.appendString(buffer, '\'');
            SSBStructuredTypeOraclev9i.appendString(buffer, typeElement.getSqlJAttr());
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, '\'');
        }
    }

    private void appendMethods(StringBuffer buffer, StructuredTypeProxyOracle typeProxy, boolean prettyPrint) {
        boolean first;
        Iterator it = typeProxy.getMethods().iterator();
        boolean bl = first = typeProxy.getElements().size() == 0;
        while (it.hasNext()) {
            MethodProxyOraclev9i method = (MethodProxyOraclev9i)it.next();
            if (!first) {
                this.appendComma(buffer);
            } else {
                first = false;
            }
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            this.appendInheritanceClauses(buffer, method, prettyPrint);
            boolean isConstructor = "YES".equalsIgnoreCase(method.getConstructor());
            if (!isConstructor) {
                if (typeProxy.getMapOrderFunction() == method) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, typeProxy.getMapOrderType());
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "MEMBER");
                } else if ("YES".equalsIgnoreCase(method.getIsStatic())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "STATIC");
                } else {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "MEMBER");
                }
            }
            this.appendProcSpec(buffer, typeProxy, method, isConstructor, prettyPrint);
            this.appendPragmaClause(buffer, method, prettyPrint);
        }
    }

    private void appendInheritanceClauses(StringBuffer buffer, MethodProxyOraclev9i method, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(method.getOverriding())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "OVERRIDING");
        }
        if ("NO".equalsIgnoreCase(method.getInstantiable())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NOT");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "INSTANTIABLE");
        } else if ("YES".equalsIgnoreCase(method.getIsFinal())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "FINAL");
        }
    }

    private void appendProcSpec(StringBuffer buffer, StructuredTypeProxyOracle typeProxy, MethodProxyOraclev9i method, boolean isConstructor, boolean prettyPrint) {
        if (isConstructor) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "CONSTRUCTOR");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "FUNCTION");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
        } else {
            if ("PROCEDURE".equalsIgnoreCase(method.getMethodType())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "PROCEDURE");
            } else {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "FUNCTION");
            }
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(method));
        }
        if (method.getParams().size() > 0 || "NO".equalsIgnoreCase(method.getCopySelf())) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, '(');
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            boolean first = true;
            if ("NO".equalsIgnoreCase(method.getCopySelf()) && "NO".equalsIgnoreCase(method.getIsStatic())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "SELF");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "IN");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "OUT");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NOCOPY");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
                first = false;
            }
            for (MethodParamProxyOracle param : method.getParams()) {
                if (first) {
                    first = false;
                } else {
                    this.appendComma(buffer);
                    SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                }
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(param));
                if (!"".equalsIgnoreCase(param.getDirectionType())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, param.getDirectionType());
                }
                if ("NO".equalsIgnoreCase(param.getCopyArgument())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NOCOPY");
                }
                String datatype = this.getMethodParamDatatype((MethodParam)param.getObject());
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, datatype);
                String defaultValue = param.getDefaultValue().trim();
                if (defaultValue.length() <= 0) continue;
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
                String df = this.addQuotesToDefault(datatype, defaultValue);
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, df);
            }
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, ')');
        }
        if (isConstructor) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "RETURN");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "SELF");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "RESULT");
        } else {
            MethodParam returnValue = ((Method)method.getObject()).getReturnValue();
            if (returnValue != null) {
                SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "RETURN");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, this.getMethodParamDatatype(returnValue));
            }
        }
        if (method.getDeterministic().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "DETERMINISTIC");
        }
        if (method.getParallel().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "PARALLEL_ENABLE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, method.getPartitioningAndStreaming());
        }
        if (method.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined")) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "PIPELINED");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, method.getPipeliningAndAggregationImpl());
        } else if (method.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined Using")) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "PIPELINED USING");
        } else if (method.getPipeliningAndAggregation().equalsIgnoreCase("Aggregate Using")) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "AGGREGATE USING");
        }
        if (!"PL/SQL".equalsIgnoreCase(method.getImplLanguage())) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "LANGUAGE");
            if ("Java".equalsIgnoreCase(method.getImplLanguage())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "JAVA");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NAME");
                SSBStructuredTypeOraclev9i.appendString(buffer, '\'');
                SSBStructuredTypeOraclev9i.appendString(buffer, method.getJavaName());
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, '\'');
            } else if ("C".equalsIgnoreCase(method.getImplLanguage())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "C");
                if (!"".equalsIgnoreCase(method.getCName())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "NAME");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, method.getCName());
                }
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "LIBRARY");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, method.getCLibrary());
                if ("YES".equalsIgnoreCase(method.getWithContext())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "WITH");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "CONTEXT");
                }
                if (!"".equalsIgnoreCase(method.getCPartemeters())) {
                    SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, method.getCPartemeters());
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private String getMethodParamDatatype(MethodParam methodParam) {
        Object datatype = null;
        DesignObject paramDataType = methodParam.getType();
        if (paramDataType instanceof StructuredType || paramDataType instanceof CollectionType) {
            RelationalObjectProxy proxy = this.storageDesign.getProxy(paramDataType);
            datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(paramDataType);
            if (methodParam.isReference() && paramDataType instanceof StructuredType) {
                datatype = "REF " + (String)datatype;
            }
        } else {
            datatype = methodParam.getDataType(this.storageDesign.getRDBMSType().getName());
        }
        return datatype;
    }

    private void appendPragmaClause(StringBuffer buffer, MethodProxyOracle method, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(method.getPragmaClause())) {
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "PRAGMA");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "RESTRICT_REFERENCES");
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, '(');
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, method.getPragmaClause());
            SSBStructuredTypeOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyOraclev9i && ((StructuredTypeProxyOraclev9i)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)structuredTypeProxyOracle.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!structuredTypeProxyOracle.equals(permissions.getStructuredTypeOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, structuredTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, structuredTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, structuredTypeProxyOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(structuredTypeProxyOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

