/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;

public class SSBClusterOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ClusterOraclev9i cluster = (ClusterOraclev9i)object;
        this.storageDesign = cluster.getStorageDesign();
        this.appendComment(oldbuffer, cluster);
        SSBClusterOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBClusterOraclev9i.appendStringWithSpace(buffer, "CLUSTER");
        SSBClusterOraclev9i.appendStringWithSpace(buffer, cluster.getStorageDesign().getFormatedLongNameDDL(cluster));
        advancedComment = buffer.toString();
        if (this.hasNoColumns(cluster)) {
            SSBClusterOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid Cluster " + cluster.getName() + " with no columns");
            SSBClusterOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            this.incrementErrors();
        } else {
            this.appendColumns(buffer, cluster, prettyPrint);
            this.appendAttributes(buffer, cluster.getSegment(), prettyPrint);
            this.appendSize(buffer, cluster, prettyPrint);
            this.appendTableSpace(buffer, cluster, prettyPrint);
            this.appendIndex(buffer, cluster, prettyPrint);
            this.appendParallel(buffer, cluster, prettyPrint);
            this.appendRowDependencies(buffer, cluster, prettyPrint);
            this.appendCache(buffer, cluster, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBClusterOraclev9i.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.incrementCreateCluster();
        }
    }

    private void appendRowDependencies(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(cluster.getRowDependency())) {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "ROWDEPENDENCIES");
        } else {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "NOROWDEPENDENCIES");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ClusterOraclev9i && ((ClusterOraclev9i)object).isMarkedGenerate();
    }

    private boolean hasNoColumns(ClusterOraclev9i cluster) {
        ClusterColumnSetOracle columnSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterColumnSet();
        return columnSet.isEmpty();
    }

    private void appendColumns(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        ClusterColumnSetOracle columnSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterColumnSet();
        Object[] columnList = columnSet.toArray();
        Arrays.sort(columnList, new ColumnComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < columnList.length; ++i) {
            sortedList.add(columnList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            ClusterColumnOracle column = (ClusterColumnOracle)setIt.next();
            if (column.getCluster() == null || !column.getCluster().equals(cluster)) continue;
            if (first) {
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBClusterOraclev9i.appendString(buffer, ',');
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterOraclev9i.appendStringWithSpace(buffer, ' ');
            }
            SSBClusterOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            String dataType = column.getDataType();
            if (dataType.startsWith("TIMESTAMP")) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "TIMESTAMP");
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("6");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                }
                if (dataType.indexOf("WITH") <= -1) continue;
                SSBClusterOraclev9i.appendStringWithSpace(buffer, dataType.substring(10));
                continue;
            }
            if (dataType.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "INTERVAL YEAR");
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                }
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "TO MONTH");
                continue;
            }
            if (dataType.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "INTERVAL DAY");
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                }
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "TO SECOND");
                if (column.getScale() > 0) {
                    buffer.append('(').append(column.getScale());
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("6");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                continue;
            }
            SSBClusterOraclev9i.appendStringWithSpace(buffer, dataType);
            if (dataType.indexOf("CHAR") > -1) {
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!dataType.equals("CHAR") && !dataType.equals("NCHAR") || !this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("1");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
                continue;
            }
            if (column.getLengthPrecision().trim().equalsIgnoreCase("")) continue;
            buffer.append('(').append(column.getLengthPrecision());
            if (column.getScale() != 0) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, ',');
                buffer.append(column.getScale());
            }
            SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
        }
        if (!first) {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendAttributes(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getDesign().getSettings().isIncludePctFreeInDDL()) {
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "PCTFREE");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctUsedInDDL()) {
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "PCTUSED");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getPCTUsed());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 1) {
                    SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, "2");
                }
                if (segment.getMaxTrans() > 1) {
                    SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getMaxTrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    SSBClusterOraclev9i.appendStringWithSpace(buffer, "255");
                }
            }
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "STORAGE");
            SSBClusterOraclev9i.appendStringWithSpace(buffer, '(');
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "NEXT");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, segment.getSCBufferPool());
                SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                props = true;
            }
            if (props) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendSize(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        int size = cluster.getSize();
        if (size > 0) {
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "SIZE");
            SSBClusterOraclev9i.appendStringWithSpace(buffer, size);
            SSBClusterOraclev9i.appendStringWithSpace(buffer, cluster.getMeasureUnit());
        }
    }

    private void appendTableSpace(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        SegmentOracle segment;
        TableSpaceOracle tableSpace = cluster.getTableSpace();
        if (tableSpace == null && (segment = cluster.getSegment()) != null) {
            tableSpace = segment.getTableSpace();
        }
        if (tableSpace != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBClusterOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendIndex(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(cluster.getIndexed())) {
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "INDEX");
        } else if (cluster.getHashKeys() >= 2) {
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if ("YES".equalsIgnoreCase(cluster.getSingleTable())) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "SINGLE");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "TABLE");
            }
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "HASHKEYS");
            SSBClusterOraclev9i.appendStringWithSpace(buffer, cluster.getHashKeys());
            if (!"".equalsIgnoreCase(cluster.getHashExpression())) {
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, "IS");
                SSBClusterOraclev9i.appendStringWithSpace(buffer, cluster.getHashExpression());
            }
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "INDEX");
        }
    }

    private void appendParallel(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(cluster.getParallel())) {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
        } else {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendCache(StringBuffer buffer, ClusterOraclev9i cluster, boolean prettyPrint) {
        SSBClusterOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(cluster.getCache())) {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "CACHE");
        } else {
            SSBClusterOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
        }
    }

    static class ColumnComparator
    implements Comparator {
        ColumnComparator() {
        }

        public int compare(Object one, Object two) {
            if (((ClusterColumnOracle)one).getPosition() > ((ClusterColumnOracle)two).getPosition()) {
                return 1;
            }
            if (((ClusterColumnOracle)one).getPosition() < ((ClusterColumnOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

