/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;

public class SSBSynonymOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SynonymOracle synonym = (SynonymOracle)object;
        if (!synonym.getObject().trim().isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            this.storageDesign = synonym.getStorageDesign();
            this.appendPrompt(buffer, synonym, "SYNONYM");
            this.appendComment(oldbuffer, synonym);
            SSBSynonymOraclev10g.appendStringWithSpace(buffer, "CREATE");
            if ("YES".equalsIgnoreCase(synonym.getPublic())) {
                SSBSynonymOraclev10g.appendStringWithSpace(buffer, "PUBLIC");
                SSBSynonymOraclev10g.appendStringWithSpace(buffer, "SYNONYM");
                SSBSynonymOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(synonym));
            } else {
                SSBSynonymOraclev10g.appendStringWithSpace(buffer, "SYNONYM");
                SSBSynonymOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(synonym));
            }
            String advancedComment = buffer.toString();
            this.appendObject(buffer, synonym);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBSynonymOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBSynonymOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.incrementCreateSynomym();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SynonymOracle && ((SynonymOracle)object).isMarkedGenerate();
    }

    private void appendObject(StringBuffer buffer, SynonymOracle synonym) {
        Object objectName;
        buffer.append(NEWLINE);
        SSBSynonymOraclev10g.appendStringWithSpace(buffer, "FOR");
        StorageObject forObject = null;
        String forObjectID = synonym.getReferredObjectID();
        if (forObjectID.length() > 0) {
            forObject = this.storageDesign.getStorageObject(forObjectID);
        }
        if (forObject != null) {
            objectName = this.storageDesign.getFormatedLongNameDDL(forObject);
        } else {
            if (this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
                if (synonym.getObjectUser() != null) {
                    buffer.append(this.storageDesign.getFormatedName(synonym.getObjectUser())).append('.');
                } else {
                    String uname = synonym.getObjectUserName();
                    if (uname != null && !uname.isEmpty()) {
                        buffer.append(this.storageDesign.getFormatedName(uname)).append('.');
                    }
                }
            }
            objectName = synonym.getObject();
            objectName = synonym.getObjNameHasQuotes() ? "\"" + (String)objectName + "\"" : this.storageDesign.getFormatedName((String)objectName);
        }
        buffer.append((String)objectName);
        String dbLink = synonym.getDBLink();
        if (dbLink != null && dbLink.length() > 0) {
            buffer.append("@").append(dbLink);
        }
    }
}

