/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;

public class SSBIncompleteStructuredTypeOracle
extends AbstractSSBOracle {
    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StructuredTypeProxyOracle typeProxy;
        StructuredType type = null;
        if (object instanceof StructuredType) {
            type = (StructuredType)object;
            if (!type.isPredefined()) {
                SSBIncompleteStructuredTypeOracle.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, type);
                this.appendIncompleteDefinition(buffer, type, prettyPrint);
            }
        } else if (object instanceof StructuredTypeProxyOracle && !(typeProxy = (StructuredTypeProxyOracle)object).getStructuredType().isPredefined()) {
            SSBIncompleteStructuredTypeOracle.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, typeProxy);
            this.appendIncompleteDefinition(buffer, typeProxy, prettyPrint);
        }
    }

    private void appendIncompleteDefinition(StringBuffer oldbuffer, StructuredType type, boolean prettyPrint) {
        SSBIncompleteStructuredTypeOracle.appendNewLine(oldbuffer, prettyPrint, 0);
        StringBuffer buffer = new StringBuffer();
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "CREATE");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "OR");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "REPLACE");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "TYPE");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, type.getName());
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBIncompleteStructuredTypeOracle.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisherWithSlash(buffer, prettyPrint);
        SSBIncompleteStructuredTypeOracle.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendIncompleteDefinition(StringBuffer oldbuffer, StructuredTypeProxyOracle typeProxy, boolean prettyPrint) {
        String ownerName;
        StorageDesign storageDesign = typeProxy.getStorageDesign();
        SSBIncompleteStructuredTypeOracle.appendNewLine(oldbuffer, prettyPrint, 0);
        StringBuffer buffer = new StringBuffer();
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "CREATE");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "OR");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "REPLACE");
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getOwner() != null && !"".equals(ownerName = typeProxy.getOwner().getName()) && storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
            SSBIncompleteStructuredTypeOracle.appendString(buffer, storageDesign.getFormatedName(typeProxy.getOwner()));
            SSBIncompleteStructuredTypeOracle.appendString(buffer, '.');
        }
        SSBIncompleteStructuredTypeOracle.appendStringWithSpace(buffer, storageDesign.getFormatedName(typeProxy));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBIncompleteStructuredTypeOracle.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisherWithSlash(buffer, prettyPrint);
        SSBIncompleteStructuredTypeOracle.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyOracle && ((StructuredTypeProxyOracle)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }
}

