/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.sql.Connection;
import oracle.dbtools.crest.exports.ddl.DDLGenerationStatus;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.util.logging.Logger;

public class DDLGenerator {
    public static final String TYPE_DROP_GEN = "DropGen";
    private static final Logger LOGGER = new Logger(DDLGenerator.class);
    private String label = "Default";
    private SQLStatementBuilder first;
    private Connection databaseConnection = null;
    private boolean dbaUser = false;
    private DDLGenerationStatus status = null;

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected void initChainOfResponsibility() {
    }

    public SQLStatementBuilder getFirst() {
        if (this.first == null) {
            this.initChainOfResponsibility();
        }
        return this.first;
    }

    public String getDDLFor(Object object) {
        StringBuffer buffer = new StringBuffer();
        this.appendDDLFor(buffer, object);
        return buffer.toString();
    }

    public StringBuffer appendDDLFor(StringBuffer buffer, Object object) {
        SQLStatementBuilder ssb = this.getFirst();
        if (ssb == null) {
            buffer.append("DDL Generator not initialized");
        } else {
            try {
                ssb.appendTo(buffer, object, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object errorMessage = "Error while generating DDL for ";
                if (object instanceof ModelObject) {
                    errorMessage = (String)errorMessage + ((ModelObject)object).getName();
                }
                buffer.append(SQLStatementBuilder.NEWLINE);
                buffer.append("-- ").append((String)errorMessage).append(". See log file for details.");
                buffer.append(SQLStatementBuilder.NEWLINE);
                if (this.status != null) {
                    this.status.incrementErrors();
                }
                LOGGER.error(errorMessage, e);
            }
        }
        return buffer;
    }

    public void append(SQLStatementBuilder ssb) {
        if (this.first == null) {
            this.first = ssb;
        } else {
            this.first.append(ssb);
        }
        ssb.setDDLGenerator(this);
    }

    public void clearTemporaryObjects() {
        for (SQLStatementBuilder sb = this.getFirst(); sb != null; sb = sb.getSuccessor()) {
            sb.clearTemporaryObjects();
        }
    }

    public void doOnFinish(StringBuffer buffer) {
        for (SQLStatementBuilder sb = this.getFirst(); sb != null; sb = sb.getSuccessor()) {
            sb.doOnFinish(buffer);
        }
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setDatabaseConnection(Connection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public boolean isDbaUser() {
        return this.dbaUser;
    }

    public void setDbaUser(boolean dbaUser) {
        this.dbaUser = dbaUser;
    }

    public DDLGenerationStatus getStatus() {
        return this.status;
    }

    public void setStatus(DDLGenerationStatus status) {
        this.status = status;
    }
}

