/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.exports.ddl.DDLGenerationStatus;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.SSBConstraints;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.string.StringUtilities;

public class DDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private String content;
    private String ddlFilesFolder = null;
    public boolean normalIncrement = true;
    private static final char INTERVAL = ' ';
    private List sorted = new ArrayList();
    private Map sortedMap = new HashMap();
    private Map tracedMap = new HashMap();
    private SSBConstraints ssbConstraints = null;
    private DDLGenerationStatus status = null;

    public DDLFileMaker(Design design) {
        this.setDesign(design);
        this.status = new DDLGenerationStatus();
        this.status.resetCounters();
    }

    public void setStorageDesign(Object storageDesignOrSite) {
        if (storageDesignOrSite instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)storageDesignOrSite);
        } else if (storageDesignOrSite instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getDesign().getStorageDesign((RDBMSSite)storageDesignOrSite);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private void saveDDLToFile(String content, String folderName, String fileName, boolean isDataObject) {
        this.saveDDLToFile(content, folderName, fileName, isDataObject, true);
    }

    private void saveDDLToFile(String content, String folderName, String fileName, boolean isDataObject, boolean deleteExistingFile) {
    }

    private String getConstraintsDefinitionFor(TableProxy tableProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getConstraintsDefinitionFor(tableProxy);
    }

    private String getConstraintsDefinitionFor(TableViewProxy viewProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getConstraintsDefinitionFor(viewProxy);
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    private String appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            result = StringUtilities.rtrim(StringUtilities.ltrim(result));
            this.buffer().append(result);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
        }
        return result;
    }

    public void generateDDLContent() {
        this.generateDDLContent(false, false, false);
    }

    public void generateDDLContent(boolean includeTitle, boolean includeSummary, boolean includeTime) {
        List listOfDDLObjects = this.getStorageDesign().getListOfDDLObjects();
        TimeLog.log("DDL generation start");
        RDBMSSite defaultSite = this.getDesign().getSelectedRDBMSSite();
        this.getDesign().setSelectedRDBMSSite(this.getStorageDesign().getRDBMSSite());
        this.clearContent();
        if (includeTitle) {
            this.buffer().append(Messages.getString("DDLFileMaker.GeneratedBy")).append("DM Web 0.001").append(this.newline());
        }
        if (includeTitle || includeTime) {
            this.buffer().append(Messages.getString("DDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        }
        if (this.getStorageDesign() != null) {
            ModelObject object;
            ModelObject object2;
            String result;
            if (includeTitle) {
                this.buffer().append(Messages.getString("DDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
                this.buffer().append(Messages.getString("DDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
                this.buffer().append(this.newline());
                this.buffer().append(this.newline());
                this.buffer().append(this.newline());
            }
            int p = 0;
            this.resetCounters();
            this.setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator ddlAdvancedGenerator = null;
            if (DDLGenerationOptions.getDDLType() > 0 && (ddlAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator()) != null) {
                this.setddlAdvancedGenenerator(ddlAdvancedGenerator);
                ddlAdvancedGenerator.addAdvanceHeader(this.buffer());
            }
            DDLGenerator dropGenerator = this.getStorageDesign().getDDLDropGenerator();
            dropGenerator.setStatus(this.status);
            dropGenerator.clearTemporaryObjects();
            Iterator it = this.getStorageDesign().ddlDropObjects();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                TimeLog.log("DDL save to file start");
                StringBuffer content = new StringBuffer();
                while (it.hasNext()) {
                    ModelObject object4 = (ModelObject)it.next();
                    result = this.appendStatementFor(object4, dropGenerator);
                    if (result == null || result.isEmpty()) continue;
                    content.append(result);
                    content.append(this.newline());
                }
                this.saveDDLToFile(content.toString(), null, "DropStatements", true);
            } else {
                while (it.hasNext()) {
                    ModelObject object5 = (ModelObject)it.next();
                    this.appendStatementFor(object5, dropGenerator);
                }
            }
            DDLGenerator userGenerator = this.getStorageDesign().getDDLUserGenerator();
            userGenerator.setStatus(this.status);
            it = this.getStorageDesign().ddlUserObjects();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    object2 = (ModelObject)it.next();
                    result = this.appendStatementFor(object2, userGenerator);
                    if (result == null || result.isEmpty()) continue;
                    this.saveDDLToFile(result, ((ModelIDObject)object2).getOldObjectTypeName(), object2.getName(), true);
                }
            } else {
                while (it.hasNext()) {
                    object2 = (ModelObject)it.next();
                    this.appendStatementFor(object2, userGenerator);
                }
            }
            ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
            ArrayList<StructuredTypeProxy> refList = new ArrayList<StructuredTypeProxy>();
            TimeLog.log("DDL process dependencies start");
            it = this.getStorageDesign().ddlTypeObjects();
            while (it.hasNext()) {
                ModelIDObject obj = (ModelIDObject)it.next();
                if (!obj.isMarkedGenerate()) continue;
                list.add(obj);
                this.getStorageDesign().processDependencies(obj, Collections.EMPTY_LIST, refList);
            }
            TimeLog.log("DDL process dependencies end");
            DDLGenerator incompleteTypesGenerator = this.getStorageDesign().getDDLIncompleteTypeGenerator();
            incompleteTypesGenerator.setStatus(this.status);
            it = this.getStorageDesign() instanceof StorageDesignOracle ? refList.iterator() : this.getStorageDesign().ddlIncompleteTypeObjects();
            while (it.hasNext()) {
                ModelObject object6 = (ModelObject)it.next();
                this.appendStatementFor(object6, incompleteTypesGenerator);
            }
            DDLGenerator typesGenerator = this.getStorageDesign().getDDLTypeGenerator();
            typesGenerator.setStatus(this.status);
            this.sortObjects(list);
            it = this.sorted.iterator();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    ModelObject object3 = (ModelObject)it.next();
                    String result2 = this.appendStatementFor(object3, typesGenerator);
                    if (result2 == null || result2.isEmpty()) continue;
                    this.saveDDLToFile(result2, ((ModelIDObject)object3).getOldObjectTypeName(), object3.getLongName(), true);
                }
            } else {
                while (it.hasNext()) {
                    ModelObject object3 = (ModelObject)it.next();
                    this.appendStatementFor(object3, typesGenerator);
                }
            }
            DDLGenerator ddlGenerator = this.getStorageDesign().getDDLGenerator();
            ddlGenerator.setStatus(this.status);
            list.clear();
            ArrayList<ModelIDObject> tableProxies = new ArrayList<ModelIDObject>();
            for (ModelIDObject obj : listOfDDLObjects) {
                if (obj.isMarkedGenerate()) {
                    list.add(obj);
                    if (!(obj instanceof TableProxy)) continue;
                    tableProxies.add(obj);
                    continue;
                }
                if (!(obj instanceof TableProxy) && !(obj instanceof TableViewProxy)) continue;
                list.add(obj);
            }
            TimeLog.log("DDL parse objects start");
            ((StorageDesignOracle)this.getStorageDesign()).setDDLFileMaker(this);
            this.getStorageDesign().parse(list);
            TimeLog.log("DDL sort objects start");
            this.sortObjects(list);
            TimeLog.log("DDL sort objects end");
            TimeLog.log("DDL tables start");
            ArrayList processedTables = new ArrayList();
            it = this.sorted.iterator();
            while (it.hasNext()) {
                ++p;
                ModelObject object7 = (ModelObject)it.next();
                String result3 = "";
                String constraints = null;
                if (object7 instanceof TableProxy) {
                    String sl;
                    TableProxy tableProxy = (TableProxy)object7;
                    result3 = this.appendStatementFor(object7, ddlGenerator);
                    constraints = this.getConstraintsDefinitionFor(tableProxy);
                    if (constraints != null && !constraints.isEmpty()) {
                        constraints = this.formatSQL(constraints, this.getStorageDesign());
                        constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                        this.buffer().append(constraints);
                        this.buffer().append(this.newline());
                        this.buffer().append(this.newline());
                    }
                    if ((sl = this.getSupplementalLogIDSAlterFor(tableProxy)) != null && !sl.isEmpty()) {
                        sl = this.formatSQL(sl, this.getStorageDesign());
                        sl = StringUtilities.rtrim(StringUtilities.ltrim(sl));
                        this.buffer().append(sl);
                        this.buffer().append(this.newline());
                        this.buffer().append(this.newline());
                    }
                } else {
                    TableViewProxy viewProxy;
                    result3 = this.appendStatementFor(object7, ddlGenerator);
                    if (object7 instanceof TableViewProxy && (constraints = this.getConstraintsDefinitionFor(viewProxy = (TableViewProxy)object7)) != null && !constraints.isEmpty()) {
                        constraints = this.formatSQL(constraints, this.getStorageDesign());
                        constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                        this.buffer().append(constraints);
                        this.buffer().append(this.newline());
                        this.buffer().append(this.newline());
                    }
                }
                if (result3 == null || result3.isEmpty() || !DDLGenerationOptions.generateDDLInFiles()) continue;
                this.saveDDLToFile(result3, ((ModelIDObject)object7).getOldObjectTypeName(), object7.getLongName(), ((ModelIDObject)object7).isDataObject());
                if (constraints == null || constraints.isEmpty()) continue;
                this.saveDDLToFile(constraints, ((ModelIDObject)object7).getOldObjectTypeName(), object7.getLongName() + "_Constraints", ((ModelIDObject)object7).isDataObject());
            }
            this.sorted.clear();
            TimeLog.log("DDL tables end");
            DDLGenerator scopeGenerator = this.getStorageDesign().getDDLScopeGenerator();
            scopeGenerator.setStatus(this.status);
            it = this.getStorageDesign().ddlScopeObjects();
            while (it.hasNext()) {
                ++p;
                ModelObject object8 = (ModelObject)it.next();
                this.appendStatementFor(object8, scopeGenerator);
            }
            DDLGenerator redactionPolicyGenerator = this.getStorageDesign().getRedactionPolicyGenerator();
            redactionPolicyGenerator.setStatus(this.status);
            it = this.getStorageDesign().ddlRedactionPolicyObjects();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                while (it.hasNext()) {
                    ModelObject object22 = (ModelObject)it.next();
                    String result4 = this.appendStatementFor(object22, redactionPolicyGenerator);
                    if (result4 == null || result4.isEmpty()) continue;
                    content.append(result4);
                    content.append(this.newline());
                }
                this.saveDDLToFile(content.toString(), null, "RedactionPolicies", true);
            } else {
                while (it.hasNext()) {
                    Object object9 = it.next();
                    this.appendStatementFor(object9, redactionPolicyGenerator);
                }
            }
            DDLGenerator tsdpGenerator = this.getStorageDesign().getTSDPGenerator();
            tsdpGenerator.setStatus(this.status);
            tsdpGenerator.clearTemporaryObjects();
            it = this.getStorageDesign().ddlTSDPPolicyObjects();
            while (it.hasNext()) {
                Object object4 = it.next();
                this.appendStatementFor(object4, tsdpGenerator);
            }
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                tsdpGenerator.doOnFinish(content);
                this.saveDDLToFile(content.toString(), null, "TSDPPolicies", true);
                this.buffer().append(content.toString());
            } else {
                tsdpGenerator.doOnFinish(this.buffer());
            }
            TimeLog.log("DDL triggers start");
            DDLGenerator triggerGenerator = this.getStorageDesign().getDDLTriggerGenerator();
            triggerGenerator.setStatus(this.status);
            it = this.getStorageDesign().ddlTriggersCausingObjects();
            while (it.hasNext()) {
                Object object10 = it.next();
                this.appendStatementFor(object10, triggerGenerator);
            }
            if (!tableProxies.isEmpty()) {
                DDLGenerator autoIncrementColumnGenerator = this.getStorageDesign().getDDLAutoIncrementColumnGenerator();
                autoIncrementColumnGenerator.setStatus(this.status);
                for (Object e : tableProxies) {
                    this.appendStatementFor(e, autoIncrementColumnGenerator);
                }
                if (this.storageDesign instanceof StorageDesignOracle) {
                    SSBAutoIncrementColumnOracle.clearGenSequenceSet();
                }
            }
            for (DDLGenerator dDLGenerator : this.getStorageDesign().getDDLEndScriptGenerators()) {
                dDLGenerator.setStatus(this.status);
                it = this.getStorageDesign().ddlEndScriptObjects();
                if (DDLGenerationOptions.generateDDLInFiles()) {
                    while (it.hasNext()) {
                        object = (ModelObject)it.next();
                        String result5 = this.appendStatementFor(object, dDLGenerator);
                        if (result5 == null || result5.isEmpty()) continue;
                        this.saveDDLToFile(result5, ((ModelIDObject)object).getOldObjectTypeName(), object.getLongName(), true, false);
                    }
                    continue;
                }
                while (it.hasNext()) {
                    ++p;
                    object = (ModelObject)it.next();
                    this.appendStatementFor(object, dDLGenerator);
                }
            }
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                ddlAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            if (DDLGenerationOptions.generateRESTServices() && this.getStorageDesign() instanceof StorageDesignOraclev10g) {
                DDLGenerator dDLGenerator = this.getStorageDesign().getORDSGenerator();
                dDLGenerator.setStatus(this.status);
                it = this.getStorageDesign().ddlORDSObjects();
                while (it.hasNext()) {
                    object = (ModelObject)it.next();
                    dDLGenerator.appendDDLFor(this.buffer(), object);
                }
            }
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            processedTables.clear();
            if (includeSummary) {
                this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
            }
        } else {
            this.buffer().append(Messages.getString("DDLFileMaker.NoStorageDesignAvailable"));
        }
        this.getDesign().setSelectedRDBMSSite(defaultSite);
        this.ddlFilesFolder = null;
    }

    private void appendCounters(StringBuffer buffer, RDBMSType type) {
        buffer.append(Messages.getString("DDLFileMaker.SummaryReport"));
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TABLE", this.status.createTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE INDEX", this.status.createIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TABLE", this.status.alterTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE VIEW", this.status.createView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER VIEW", this.status.alterView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE", this.status.createPackage);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE BODY", this.status.createPackageBody);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PROCEDURE", this.status.createProc);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE FUNCTION", this.status.createFunction);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TRIGGER", this.status.createTrigger);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TRIGGER", this.status.alterTrigger);
        if (type == StorageDesignOraclev9i.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", this.status.createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", this.status.createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", this.status.createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", this.status.createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", this.status.createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", this.status.createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", this.status.createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", this.status.createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", this.status.createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", this.status.createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", this.status.createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", this.status.createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", this.status.createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", this.status.createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", this.status.createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", this.status.dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", this.status.dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev10g.RDBMS_TYPE || type == StorageDesignOraclev11g.RDBMS_TYPE || type == StorageDesignOraclev12cR2.RDBMS_TYPE || type == StorageDesignOraclev12c.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", this.status.createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", this.status.createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", this.status.createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", this.status.createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", this.status.createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", this.status.createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", this.status.createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", this.status.createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISK GROUP", this.status.createDiskgroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", this.status.createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", this.status.createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", this.status.createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", this.status.createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", this.status.createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", this.status.createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", this.status.createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", this.status.dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", this.status.dropDatabase);
            buffer.append(this.newline());
            if (type != StorageDesignOraclev10g.RDBMS_TYPE) {
                buffer.append("-- ");
                buffer.append(this.newline());
                this.appendFormattedString(buffer, "-- REDACTION POLICY", this.status.redactionPolicies);
                buffer.append(this.newline());
                if (type == StorageDesignOraclev12c.RDBMS_TYPE || type == StorageDesignOraclev12cR2.RDBMS_TYPE) {
                    this.appendFormattedString(buffer, "-- TSDP POLICY", this.status.tsdpPolicies);
                    buffer.append(this.newline());
                }
            }
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS DROP SCHEMA", this.status.ordsDropSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS ENABLE SCHEMA", this.status.ordsEnableSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS ENABLE OBJECT", this.status.ordsEnableObject);
            buffer.append(this.newline());
        }
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ERRORS", this.status.errors);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- WARNINGS", this.status.warnings);
        buffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer buffer, String string, int number) {
        int n = Integer.valueOf(number).toString().length();
        buffer.append(string);
        for (int i = 0; i < 45 - string.length() - n; ++i) {
            buffer.append(' ');
        }
        buffer.append(number);
    }

    public void incrementCreateDatabase() {
        if (this.normalIncrement) {
            ++this.status.createDatabase;
        }
    }

    public void incrementCreateTable() {
        if (this.normalIncrement) {
            ++this.status.createTable;
        }
    }

    public int getCreateTable() {
        return this.status.createTable;
    }

    public void incrementCreateIndex() {
        if (this.normalIncrement) {
            ++this.status.createIndex;
        }
    }

    public int getCreateIndex() {
        return this.status.createIndex;
    }

    public void incrementCreateTablespace() {
        if (this.normalIncrement) {
            ++this.status.createTablespace;
        }
    }

    public void incrementCreateView() {
        if (this.normalIncrement) {
            ++this.status.createView;
        }
    }

    public int getCreateView() {
        return this.status.createView;
    }

    public void incrementAlterTable() {
        if (this.normalIncrement) {
            ++this.status.alterTable;
        }
    }

    public void incrementAlterView() {
        if (this.normalIncrement) {
            ++this.status.alterView;
        }
    }

    public int getAlterTable() {
        return this.status.alterTable;
    }

    public int getAlterView() {
        return this.status.alterView;
    }

    public void incrementCreateTrigger() {
        if (this.normalIncrement) {
            ++this.status.createTrigger;
        }
    }

    public int getCreateTrigger() {
        return this.status.createTrigger;
    }

    public int getRedactionPolicies() {
        return this.status.redactionPolicies;
    }

    public int getTSDPPolicies() {
        return this.status.tsdpPolicies;
    }

    public int getORDSDropSchema() {
        return this.status.ordsDropSchema;
    }

    public int getORDSEnableSchema() {
        return this.status.ordsEnableSchema;
    }

    public void incrementORDSDropSchema() {
        if (this.normalIncrement) {
            ++this.status.ordsDropSchema;
        }
    }

    public void incrementORDSEnableSchema() {
        if (this.normalIncrement) {
            ++this.status.ordsEnableSchema;
        }
    }

    public int getORDSEnableObject() {
        return this.status.ordsEnableObject;
    }

    public void incrementORDSEnableObject() {
        if (this.normalIncrement) {
            ++this.status.ordsEnableObject;
        }
    }

    public void incrementAlterTrigger() {
        if (this.normalIncrement) {
            ++this.status.alterTrigger;
        }
    }

    public int getAlterTrigger() {
        return this.status.alterTrigger;
    }

    public void incrementCreatePackage() {
        if (this.normalIncrement) {
            ++this.status.createPackage;
        }
    }

    public void incrementCreateProc() {
        if (this.normalIncrement) {
            ++this.status.createProc;
        }
    }

    public void incrementCreateFunction() {
        if (this.normalIncrement) {
            ++this.status.createFunction;
        }
    }

    public void incrementCreatePackageBody() {
        if (this.normalIncrement) {
            ++this.status.createPackageBody;
        }
    }

    public void incrementCreateAlias() {
        if (this.normalIncrement) {
            ++this.status.createAlias;
        }
    }

    public void incrementCreateAuxTable() {
        if (this.normalIncrement) {
            ++this.status.createAuxTable;
        }
    }

    public void incrementCreateDistinctType() {
        if (this.normalIncrement) {
            ++this.status.createDistinctType;
        }
    }

    public void incrementCreateStructuredType() {
        if (this.normalIncrement) {
            ++this.status.createStructuredType;
        }
    }

    public int getCreateStructuredType() {
        return this.status.createStructuredType;
    }

    public void incrementCreateStructuredTypeBody() {
        if (this.normalIncrement) {
            ++this.status.createStructuredTypeBody;
        }
    }

    public int getCreateStructuredTypeBody() {
        return this.status.createStructuredTypeBody;
    }

    public void incrementCreateCollectionType() {
        if (this.normalIncrement) {
            ++this.status.createCollectionType;
        }
    }

    public int getCreateCollectionType() {
        return this.status.createCollectionType;
    }

    public void incrementCreateStoGroup() {
        if (this.normalIncrement) {
            ++this.status.createStoGroup;
        }
    }

    public void incrementCreateSynomym() {
        if (this.normalIncrement) {
            ++this.status.createSynomym;
        }
    }

    public int getCreateSynonym() {
        return this.status.createSynomym;
    }

    public void incrementCreateCluster() {
        if (this.normalIncrement) {
            ++this.status.createCluster;
        }
    }

    public void incrementCreateContext() {
        if (this.normalIncrement) {
            ++this.status.createContext;
        }
    }

    public int getCreateContext() {
        return this.status.createContext;
    }

    public void incrementCreateDimension() {
        if (this.normalIncrement) {
            ++this.status.createDimension;
        }
    }

    public int getCreateDimension() {
        return this.status.createDimension;
    }

    public void incrementCreateDirectory() {
        if (this.normalIncrement) {
            ++this.status.createDirectory;
        }
    }

    public int getCreateDirectory() {
        return this.status.createDirectory;
    }

    public void incrementCreateRole() {
        if (this.normalIncrement) {
            ++this.status.createRole;
        }
    }

    public void incrementCreateRollbackSegment() {
        if (this.normalIncrement) {
            ++this.status.createRollbackSegment;
        }
    }

    public void incrementCreateSequence() {
        if (this.normalIncrement) {
            ++this.status.createSequence;
        }
    }

    public int getCreateSequence() {
        return this.status.createSequence;
    }

    public void incrementCreateSnapshot() {
        if (this.normalIncrement) {
            ++this.status.createSnapshot;
        }
    }

    public int getCreateSnapshot() {
        return this.status.createSnapshot;
    }

    public int getCreateMaterializedViewLog() {
        return this.status.createMaterializedViewLog;
    }

    public void incrementCreateDiskgroup() {
        if (this.normalIncrement) {
            ++this.status.createDiskgroup;
        }
    }

    public void incrementCreateUser() {
        if (this.normalIncrement) {
            ++this.status.createUser;
        }
    }

    public void incrementCreateDefault() {
        if (this.normalIncrement) {
            ++this.status.createDefault;
        }
    }

    public void incrementCreateRule() {
        if (this.normalIncrement) {
            ++this.status.createRule;
        }
    }

    public void incrementCreateIndexOnView() {
        if (this.normalIncrement) {
            ++this.status.createIndexOnView;
        }
    }

    public void incrementCreateInstance() {
        if (this.normalIncrement) {
            ++this.status.createInstance;
        }
    }

    public void incrementCreateNodeGroup() {
        if (this.normalIncrement) {
            ++this.status.createNodeGroup;
        }
    }

    public void incrementCreateDbPartitionGroup() {
        if (this.normalIncrement) {
            ++this.status.createDbPartitionGroup;
        }
    }

    public void incrementCreateBufferPool() {
        if (this.normalIncrement) {
            ++this.status.createBufferPool;
        }
    }

    public void incrementCreateSchema() {
        if (this.normalIncrement) {
            ++this.status.createSchema;
        }
    }

    public void incrementRedactionPolicies() {
        if (this.normalIncrement) {
            ++this.status.redactionPolicies;
        }
    }

    public void incrementTSDPPolicies() {
        if (this.normalIncrement) {
            ++this.status.tsdpPolicies;
        }
    }

    public void incrementDropAlias() {
        if (this.normalIncrement) {
            ++this.status.dropAlias;
        }
    }

    public void incrementDropTriggers() {
        if (this.normalIncrement) {
            ++this.status.dropTrigger;
        }
    }

    public void incrementDropProcedures() {
        if (this.normalIncrement) {
            ++this.status.dropProcedures;
        }
    }

    public void incrementDropSynonym() {
        if (this.normalIncrement) {
            ++this.status.dropSynonym;
        }
    }

    public void incrementDropStogroup() {
        if (this.normalIncrement) {
            ++this.status.dropStogroup;
        }
    }

    public void incrementDropDistinctType() {
        if (this.normalIncrement) {
            ++this.status.dropDistinctType;
        }
    }

    public void incrementDropSequence() {
        if (this.normalIncrement) {
            ++this.status.dropSequence;
        }
    }

    public void incrementDropDatabase() {
        if (this.normalIncrement) {
            ++this.status.dropDatabase;
        }
    }

    public void incrementDropTablespace() {
        if (this.normalIncrement) {
            ++this.status.dropTablespace;
        }
    }

    public void incrementErrors() {
        if (this.normalIncrement) {
            ++this.status.errors;
        }
    }

    public int getErrors() {
        return this.status.errors;
    }

    public void incrementWarnings() {
        if (this.normalIncrement) {
            ++this.status.warnings;
        }
    }

    public int getWarnings() {
        return this.status.warnings;
    }

    public void incrementPartitionFunction() {
        if (this.normalIncrement) {
            ++this.status.createPartitionFunction;
        }
    }

    public void incrementPartitionSheme() {
        if (this.normalIncrement) {
            ++this.status.createPartitionScheme;
        }
    }

    public void incrementAdvancedStep() {
        if (this.normalIncrement) {
            this.status.advancedStep += 10;
        }
    }

    public void resetCounters() {
        this.status.resetCounters();
        this.status.advancedStep = 10;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        return sql;
    }

    public int getAdvancedStep() {
        return this.status.advancedStep;
    }

    public DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return this.status.getddlAdvancedGenenerator();
    }

    public void setddlAdvancedGenenerator(DDLAdvancedGenerator ddladvgen) {
        this.status.setddlAdvancedGenenerator(ddladvgen);
    }

    private void sortObjects(List objects) {
        this.sorted.clear();
        this.sortedMap.clear();
        this.tracedMap.clear();
        for (ModelIDObject obj : objects) {
            this.addToSorted(obj, obj, objects);
            this.tracedMap.clear();
        }
        this.sortedMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSorted(ModelIDObject obj, ModelIDObject topLevelObj, List initialList) {
        if (this.sortedMap.containsKey(obj)) {
            return;
        }
        this.tracedMap.put(obj, obj);
        List<ModelIDObject> list = obj.getParsedDependOnList();
        if (list != null) {
            for (ModelIDObject dep : list) {
                if (this.sortedMap.containsKey(dep) || !initialList.contains(dep) || this.tracedMap.containsKey(dep)) continue;
                if ((topLevelObj instanceof FunctionOracle || topLevelObj instanceof StoredProcedureOracle) && dep instanceof TableProxyOracle) {
                    DDLAdvancedGenerator savedGenerator = this.getddlAdvancedGenenerator();
                    this.setddlAdvancedGenenerator(null);
                    this.normalIncrement = false;
                    try {
                        StringBuffer ddlStringBuffer = new StringBuffer();
                        this.storageDesign.getDDLGenerator().appendDDLFor(ddlStringBuffer, dep);
                        String sql = ddlStringBuffer.toString();
                        this.storageDesign.processDependencies(dep, SQLAnalyzer.getTablesAndFunctions(sql), null);
                    }
                    finally {
                        this.setddlAdvancedGenenerator(savedGenerator);
                        this.normalIncrement = true;
                    }
                }
                this.addToSorted(dep, topLevelObj, initialList);
            }
        }
        this.sorted.add(obj);
        this.sortedMap.put(obj, obj);
    }

    private String getSupplementalLogIDSAlterFor(TableProxy tableProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getSupplementalLogIDSAlterFor(tableProxy);
    }

    public DDLGenerationStatus getStatus() {
        return this.status;
    }
}

