/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.internal.AbstractTemplateRptPathProvider;
import com.oracle.bmc.auth.internal.EnvironmentRptPathProvider;
import com.oracle.bmc.auth.internal.ImdsRptPathProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLeafRptPathProvider
extends AbstractTemplateRptPathProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLeafRptPathProvider.class);
    private final Map<String, String> replacements;

    public DefaultLeafRptPathProvider() {
        super(DefaultLeafRptPathProvider.getPathTemplate());
        LOG.debug("A path provider was not specified, using DefaultLeafRptPathProvider");
        this.replacements = this.buildReplacements();
    }

    @Override
    protected Map<String, String> getReplacements() {
        return this.replacements;
    }

    private static String getPathTemplate() {
        String pathTemplate = EnvironmentRptPathProvider.LeafResourceRptPathProvider.getPathTemplate();
        if (pathTemplate == null) {
            LOG.debug("Unable to get path template from {} env variable, using IMDS template", (Object)"OCI_RESOURCE_PRINCIPAL_RPT_PATH_FOR_LEAF_RESOURCE");
            pathTemplate = ImdsRptPathProvider.getPathTemplate();
        }
        LOG.debug("The path template is {}", (Object)pathTemplate);
        return pathTemplate;
    }

    private Map<String, String> buildReplacements() {
        Map<String, String> replacementMap = EnvironmentRptPathProvider.LeafResourceRptPathProvider.buildReplacements();
        if (replacementMap == null) {
            LOG.debug("Unable to get replacements from {} env variable, getting replacements from IMDS", (Object)"OCI_RESOURCE_PRINCIPAL_RPT_ID_FOR_LEAF_RESOURCE");
            replacementMap = ImdsRptPathProvider.buildReplacements();
        }
        LOG.debug("The replacement map is {}", replacementMap);
        return replacementMap;
    }
}

