/* iod-telemetry SqlPerf.sql version 2022.02.18 csierra */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        SELECT
            -- soft PK
            con_id,
            sql_id,
            -- columns
            severity, -- severity goes from 1 to 6, where 1 is urgent and 6 is informative
            alert_level, -- alert_level goes from 1 to 6, where 6 is the highest alert
            alert_type, -- LONGEXECS, HIGHAAS, REGRESS, NONSCALE, DEMOTED, KILLED
            signature,
            snap_id,
            TO_CHAR(snap_time, 'YYYY-MM-DD"T"HH24:MI:SS') AS snap_time,
            threshold_violation_factor AS factor,
            value, -- elapsed_seconds (LONGEXECS), db_secs_per_exec_delta (REGRESS), aas_tot (HIGHAAS), ms_per_execution (NONSCALE), threshold_violation_factor (KILLED and DEMOTED)
            value_uom,
            key_value,
            violation_count AS alarm_cnt,
            TO_CHAR(last_violation_time, 'YYYY-MM-DD"T"HH24:MI:SS') AS last_alarm,
            -- extension
            username,
            regexp_replace(replace(replace(replace(substr(sql_text,1,500),chr(39),'\'||chr(39)),'\','\\'),'"','\"'),'[^[:print:]]','') AS sql_text,
            application_category AS sql_type,
            pdb_name AS con_name,
            CASE WHEN severity = 1 AND rn_sev <= 10 THEN 1 ELSE 0 END AS notification, -- replace this expression with column "notification" once new version of alerts_hist_v is propagated with oratk
            rn_sev
          FROM C##IOD.alerts_hist_v
         WHERE rn_sev <= 1000 -- on every metrics snapshot, report up to 1000 alerts
    ),
    v$metric as (
        -- for alarm firing use notification = 1
        -- for alarm dedupliction use: db_domain, db_name, con_name and sql_id
        SELECT
            'SqlPerf.SqlId.Alerts' AS metric_name,
             ',"con_name":"'     || nvl(to_char(con_name     ),'null') || '"' ||
             ',"con_id":"'       || nvl(to_char(con_id       ),'null') || '"' ||
             ',"sql_id":"'       || nvl(to_char(sql_id       ),'null') || '"' ||
             ',"signature":"'    || nvl(to_char(signature    ),'null') || '"' ||
             ',"severity":"'     || nvl(to_char(severity     ),'null') || '"' ||
             ',"alert_type":"'   || nvl(to_char(alert_type   ),'null') || '"' ||
             ',"alert_level":"'  || nvl(to_char(alert_level  ),'null') || '"' ||
             ',"snap_id":"'      || nvl(to_char(snap_id      ),'null') || '"' ||
             ',"snap_time":"'    || nvl(to_char(snap_time    ),'null') || '"' ||
             ',"value":"'        || nvl(to_char(value        ),'null') || '"' ||
             ',"value_uom":"'    || nvl(to_char(value_uom    ),'null') || '"' ||
             ',"factor":"'       || nvl(to_char(factor       ),'null') || '"' ||
             ',"notification":"' || nvl(to_char(notification ),'null') || '"' ||
             ',"alarm_cnt":"'    || nvl(to_char(alarm_cnt    ),'null') || '"' ||
             ',"last_alarm":"'   || nvl(to_char(last_alarm   ),'null') || '"' ||
             ',"username":"'     || nvl(to_char(username     ),'null') || '"' ||
             ',"sql_type":"'     || nvl(to_char(sql_type     ),'null') || '"' ||
             ',"sql_text":"'     || nvl(to_char(sql_text     ),'null') || '"' ||
             ',"key_value":"'    || nvl(to_char(key_value    ),'null') || '"' as metric_dimensions
            ,alert_level as metric_value
          FROM v$metric_history
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
