with
    function to_metric_value (v varchar2) return number
    is begin
        return to_number(nvl(v,1));
    exception when others then
        return 1;
    end to_metric_value;
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select /*+ INLINE OPT_PARAM('_px_cdb_view_enabled' 'FALSE') */
               name,
               substrb(replace(value,'"',''''),1,256) value
        from v$parameter
    ),
    v$metric as (
        select
            'Parameter' as metric_name
            ,',"parameter_name":"'            || nvl(to_char(name           ),'null')  || '"' ||
             ',"parameter_value":"'      || nvl(to_char(value     ),'null')  || '"' as metric_dimensions
            ,to_metric_value(value) as metric_value
            ,lengthb(value) value_length
        from
            v$metric_history
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
