/* iod-telemetry EventMetric.sql version 2019.05.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
    select
        n.name metric_name,
        --m.wait_count  cnt,
        --10*m.time_waited ms,
        nvl(round(10*m.time_waited/nullif(m.wait_count,0),3) ,0) value
     from v$eventmetric m,
           v$event_name n
     where m.event_id=n.event_id
       and wait_count>0
    ),
    v$metric as (
        select
            'EventMetric.' || regexp_replace(initcap(replace(metric_name,'%','Percent')),
                -- https://confluence.aka.lgl.grungy.us/display/Telemetry/Metrics+and+Tags
                '[' ||                                          -- T2 supports alphanumeric characters, periods, underscores, hyphens
                '\[\\\^\$\|\?\*\+\(\)' ||                       -- special characters not supported by T2 that need to be escaped within REGEXP_REPLACE
                '!#&,/:;<=>{}~' ||                              -- special characters not supported by T2
                CHR(9) ||CHR(10)||CHR(12)||CHR(13)||CHR(32)||   -- tabs, spaces, newlines
                CHR(34)||CHR(39)||CHR(96)||                     -- quotes, backticks
            ']','') as metric_name
            ,'' as metric_dimensions
            ,round(value,2) as metric_value
        from v$metric_history
    )
select
    v$metricname.project        as project
    ,v$metricname.fleet         as fleet
    ,v$metricname.host          as host
    ,v$metric.metric_name       as metric_name
    ,v$metric.metric_value      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
