Rem
Rem $Header: dbgendev/src/langdata/plsql/sql/create_types.sql /main/1 2025/08/05 18:39:33 deveverm Exp $
Rem
Rem create_types.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      create_types.sql - Creates types defined as part of langdata
Rem
Rem    DESCRIPTION
Rem      LangData requires custom types, these are created as part of this sql 
Rem      script
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/sql/create_types.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    07/15/25 - Created
Rem

SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE TYPE ranked_report_obj IS OBJECT (
    report_id              VARCHAR2(36),
    description_id         VARCHAR2(36),
    vector_distance        NUMBER,
    source                 VARCHAR2(100),
    similarity_search_rank NUMBER,
    cross_encoder_rank     NUMBER,
    overall_rank           NUMBER,
    match_type             VARCHAR2(100)
);
/

CREATE OR REPLACE TYPE ranked_report_table IS TABLE OF ranked_report_obj;
/

CREATE OR REPLACE TYPE ranked_drilldown_obj AS OBJECT (
    drilldown_id       VARCHAR2(50),
    description_id     VARCHAR2(50),
    match_type         VARCHAR2(100)
);
/

CREATE OR REPLACE TYPE ranked_drilldown_table AS TABLE OF ranked_drilldown_obj;
/

CREATE OR REPLACE TYPE ranked_doc_obj IS OBJECT (
    doc_id                  VARCHAR2(36),
    description_id          VARCHAR2(36),
    enhanced_text           VARCHAR2(4000),
    is_report               BOOLEAN,
    vector_distance         NUMBER,
    source                  VARCHAR2(100),
    similarity_search_rank  NUMBER,
    cross_encoder_rank      NUMBER,
    overall_rank            NUMBER,
    match_type              VARCHAR2(100)
);
/

CREATE OR REPLACE TYPE ranked_doc_table IS TABLE OF ranked_doc_obj;
/

CREATE OR REPLACE TYPE report_row_obj IS OBJECT (
    id                 VARCHAR2(36),
    title              VARCHAR2(255),
    match_document     CLOB,
    status             VARCHAR2(20),
    report_description VARCHAR2(2000)
);
/

CREATE OR REPLACE TYPE report_row_table AS TABLE OF report_row_obj;
/

CREATE OR REPLACE TYPE data_row_obj AS OBJECT (
    id              VARCHAR2(36),
    text            VARCHAR2(2000),
    version         NUMBER,
    status          VARCHAR2(20),
    enhanced_text   VARCHAR2(4000)
);
/

CREATE OR REPLACE TYPE data_table AS TABLE OF data_row_obj;
/

CREATE OR REPLACE TYPE drilldown_row_obj IS OBJECT (
    id                 VARCHAR2(36),
    title              VARCHAR2(255),
    match_document     CLOB,
    status             VARCHAR2(20),
    report_id          VARCHAR2(36),
    domain_id          VARCHAR2(36),
    drilldown_description VARCHAR2(2000)
);
/

CREATE OR REPLACE TYPE drilldown_row_table AS TABLE OF drilldown_row_obj;
/

CREATE OR REPLACE TYPE drilldown_description_row_obj AS OBJECT (
    id              VARCHAR2(36),
    text            VARCHAR2(2000),
    version         NUMBER,
    status          VARCHAR2(20),
    enhanced_text   VARCHAR2(4000)
);
/

CREATE OR REPLACE TYPE drilldown_description_table 
    AS TABLE OF drilldown_description_row_obj;
/

CREATE OR REPLACE TYPE filter_rec_type AS OBJECT (
    name  VARCHAR2(200),
    count INTEGER
);
/

CREATE OR REPLACE TYPE filter_tab_type AS TABLE OF filter_rec_type;
/

create or replace TYPE user_search_row_obj AS OBJECT (
    id                          VARCHAR2(36),
    query_text                  VARCHAR2(2000),
    report_matches              CLOB,  
    feedback_rating             VARCHAR2(20),
    feedback_comments           VARCHAR2(2000),
    required_feedback_action    VARCHAR2(200),
    feedback_action_priority    VARCHAR2(200),
    expected_report_id          VARCHAR2(36),
    expected_drilldown_id       VARCHAR2(36),
    search_type                 VARCHAR2(50),
    username                 VARCHAR2(200),
    augmented_query_text        VARCHAR2(2000),
    created_at                  TIMESTAMP
);
/

CREATE OR REPLACE TYPE user_search_row_table AS TABLE OF user_search_row_obj;
/

CREATE OR REPLACE TYPE rerank_obj IS OBJECT (
    doc_id      VARCHAR2(36),
    doc_text    VARCHAR2(4000),
    query_text  VARCHAR2(4000),
    doc_rank    NUMBER,
    score       NUMBER
);
/

CREATE OR REPLACE TYPE rerank_table IS TABLE OF rerank_obj; 
/