Rem
Rem $Header: dbgendev/src/langdata/plsql/named-entities/named_entities_pkg.pks /main/9 2025/07/07 21:00:20 dadoshi Exp $
Rem
Rem named_entities_pkg.pks
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      named_entities_pkg.pks - Named Entities Package
Rem
Rem    DESCRIPTION
Rem      Package structure for named entities package Contains procedures, 
Rem      get_all_named_entities and add_named_entity in the Named Entities 
Rem      package
Rem
Rem    NOTES
Rem      None
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/named-entities/named_entities_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dadoshi     07/07/25 - JIRA_DBAI1022: Remove
Rem                           c_unique_constraint_violated exception usage
Rem    fgurrola    06/27/25 - Declare initialization procedure.
Rem    dadoshi     05/15/25 - Remove get_entity_using_ner() procedure
Rem    dadoshi     05/15/25 - JIRA_DBAI804: Add support for identifying
Rem                           multiple entities of the same type
Rem    deveverm    04/10/25 - DBAI-723: Refactored all functions calling NER to
Rem                           named_entities_pkg
Rem    jiangnhu    04/04/25 - Move get_entities_from_text from utils pkg to 
Rem                           named entities pkg to avoid mutual dependency
Rem    dadoshi     03/11/25 - JIRA_DBAI574: Add add_named_entities_to_document
Rem                           API usage
Rem    dadoshi     03/11/25 - Update add_named_entity to take id as an optional
Rem                           argument.
Rem    arevathi    10/21/24 - Modified Headers
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_named_entities_pkg IS
    /*
    ----------------------------------------------------------------------------
    Package Name: lang_data_named_entities_pkg 
    Description: This package contains procedures related to adding and
                 retrieving named entities from langdata$named_entities table.
    ----------------------------------------------------------------------------
    Author: Revathi Ari
    Created: 30/09/2024
    ----------------------------------------------------------------------------
    Public Procedures:
    ----------------------------------------------------------------------------
    PROCEDURE get_all_named_entities
    ----------------------------------------------------------------------------
    Description:
        This procedure retrieves all the named entities created 
        
    Parameters:
        - p_named_entities (OUT SYS_REFCURSOR)
            A reference cursor used to output the result set containing the 
            named entities (id and name) from the database.
    Exceptions:
    - c_unknown_expection_code (-20001):
        A catch-all exception handler that raises a custom error with code 
        -20001 for any unknown issues, using the `lang_data_errors_pkg` package
        with the message "Unknown Exception".
    ----------------------------------------------------------------------------
    PROCEDURE add_named_entities_to_document
    ----------------------------------------------------------------------------
    Description:
        This procedure adds the entity types to the langdata$named_entities 
        table, if not already present, for all the filters with use_ner set to
        true of the given match document.

    Parameters:
        - p_match_document (IN JSON):
            Match Document of a report/drilldown.
    
    Exceptions:
        - c_unknown_expection_code (-20001):
            A catch-all exception handler that raises a custom error with code 
            -20001 for any unknown issues, using the `lang_data_errors_pkg` 
            package with the message "Unknown Exception".
    ----------------------------------------------------------------------------
    PROCEDURE add_named_entity
    ----------------------------------------------------------------------------
    Description:
        This procedure add an entry to the langdata$named_entities table, based 
        on the name of the entity provided. ID of the named entity is an 
        optional argument.
        
    Parameters:
        - p_id (IN VARCHAR2)
            ID of the entity
        - p_name (IN VARCHAR2 DEFAULT NULL)
            Name of the entity.
    
    Exceptions:
        - c_resource_already_exists (-20005):
            Raised if a named entity with the given name is already present in
            the langdata$named_entities table.
        - c_unknown_expection_code (-20001):
            A catch-all exception handler that raises a custom error with code 
            -20001 for any unknown issues, using the `lang_data_errors_pkg` 
            package with the message "Unknown Exception".
    ----------------------------------------------------------------------------
    FUNCTION get_entities_from_text
    ----------------------------------------------------------------------------
    Description:
        Extracts named entities from a given input text using a Python-based 
        entity recognition model. It first retrieves all registered entity 
        labels from the metadata table, constructs a JSON request, and invokes 
        the `process_entities` Python function via `pyqEval`.

        The result is a JSON array of identified entities including their start 
        and end positions, text content, and labels.

    Parameters:
        - p_text (IN VARCHAR2): The input text from which to extract entities.

    Returns:
        - JSON: A JSON array containing the recognized entities in the format:
            - start (NUMBER): Start index of the entity.
            - end (NUMBER): End index of the entity.
            - text (VARCHAR2): The matched entity text.
            - label (VARCHAR2): The label assigned to the entity.

    Exceptions:
        - None.
    ----------------------------------------------------------------------------
    PROCEDURE get_entities_using_ner
    ----------------------------------------------------------------------------
    Description:
        Computes the entities in the provided query text based on the
        list of entity types provided, using the process_entities python
        function. This procedure calls the process_entities just once
        providing the list of entity types as string once instead of 
        multiple calls for every single entity type separately.
    
    Parameters:
        - p_query (IN VARCHAR2): The user query text.
        - p_filter_descriptions (IN SYS.ODCIVARCHAR2LIST): List of the filter
                                                           descriptions for 
                                                           each entity type
                                                           provided here.
        - p_entity_types (IN SYS.ODCIVARCHAR2LIST): List of entity types/labels
                                                    of which the values are to
                                                    computed using NER.
        - p_results (OUT SYS.ODCIVARCHAR2LIST): List of the entities found in 
                                                query text for each entity type.
                                    
    Exceptions:
        - None.
    ----------------------------------------------------------------------
    PROCEDURE get_all_entities_using_ner
    ----------------------------------------------------------------------
    Description:
        Extracts all entities of specified labels from a query using NER, 
        generates context for each entity, and computes embeddings.

    Parameters:
        - p_query (IN VARCHAR2): The query text to analyze.
        - p_labels (IN VARCHAR2): A comma-separated list of entity labels.
        - p_num_words_before (IN NUMBER): Number of words before the entity for
                                          context.
        - p_num_words_after (IN NUMBER): Number of words after the entity for
                                          context.
        - p_result (OUT JSON): A JSON array containing entities with context and
                               embeddings.

    Exceptions:
        - None.

    ----------------------------------------------------------------------------
    PROCEDURE ner_call
    ----------------------------------------------------------------------------
    Description:
        Makes call to Named_entity_recognition function. On on-prem systems 
        this calls process_entities via oml4py. On ADB systems it calls OCI AI 
        language endpoint to call NER

    Parameters:
        - p_query (IN VARCHAR2): The query text to analyze.
        - p_labels (IN VARCHAR2): A string of labels to search in p_query. It 
        should be lowercase and labels should be seperated with a comma (,)/

    Exceptions:
        - None.
    ----------------------------------------------------------------------------
    PROCEDURE initialize_named_entities
    ----------------------------------------------------------------------------
    Description:
        Initializes langdata$named_entities table by inserting predefined
        named entities.

    Parameters:
        - None

    Exceptions:
        - None.
    */
    
    -- Public procedure declaration for getting all named entities
    PROCEDURE get_all_named_entities (
        p_named_entities OUT SYS_REFCURSOR
    );

    PROCEDURE add_named_entities_to_document (
        p_match_document IN JSON
    );

     -- Public procedure declaration for adding a new named entity
    PROCEDURE add_named_entity (
        p_name  IN VARCHAR2,
        p_id    IN VARCHAR2 DEFAULT NULL
    );

    FUNCTION ner_call(
        p_query VARCHAR2,
        p_labels VARCHAR2
    ) RETURN JSON;

    FUNCTION get_entities_from_text (
        p_text IN VARCHAR2
    ) RETURN JSON;

    PROCEDURE get_entities_using_ner(
        p_query IN VARCHAR2,
        p_filter_descriptions IN SYS.ODCIVARCHAR2LIST,
        p_entity_types IN SYS.ODCIVARCHAR2LIST,
        p_ids IN SYS.ODCIVARCHAR2LIST,
        p_results OUT SYS.ODCIVARCHAR2LIST
    );
    
    PROCEDURE get_all_entities_using_ner (
        p_query              IN VARCHAR2,
        p_labels             IN VARCHAR2,
        p_num_words_before   IN NUMBER DEFAULT 5,
        p_num_words_after    IN NUMBER DEFAULT 2,
        p_result             OUT JSON
    );

    PROCEDURE initialize_named_entities;

END lang_data_named_entities_pkg;
/


