Rem
Rem $Header: dbgendev/src/langdata/plsql/dbassist/dbassist_reports.sql /main/3 2025/07/10 10:55:30 nmmathe Exp $
Rem
Rem dbassist_reports.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      dbassist_reports.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/dbassist/dbassist_reports.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nmmathe     07/07/25 - Add report to return number of rows on a given
Rem                           table.
Rem    pryarla     06/23/25 - Add domain to the reports
Rem    gadiga      05/20/25 - Langdata reports for dbassist
Rem    gadiga      05/20/25 - Created
Rem

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'How many rows are currently in the transactions table?',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'This report captures SQL statements to find the number of rows in a table.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many records are in the transactions table?',
        'What is the total number of rows in transactions?',
        'Can you tell me how many entries exist in users table?',
        'How many data rows are currently present in sessions?',
        'What’s the row count for the transactions table right now?',
        'How many items does the sessions table have?',
        'Could you provide the number of rows in transactions?',
        'What’s the current size (row count) of sessions',
        'How many tuples are stored in the users table?',
        'Please tell me how many rows are there in users.'
        ),
        p_match_document       => JSON('{"sql": "SELECT COUNT(*) AS total_rows FROM :table_name_filter", "filters" : [{
                "use_ner": True,
                "entity_type": "table_name",
                "filter_name": "table_name_filter",
                "default_value": "",
            }]}'),
        p_description_id       => v_description_id
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Database Status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Determine the current status of the database instance.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is the database instance in a read-only mode?'
        ,'Are there any database instance best practice deviations?'
        ,'Are there any locks in the database instance?'
        ,'Are there any performance issues with the database instance?'
        ,'Has the database instance been shut down?'
        ,'Is the database instance in restricted mode?'
        ,'Are there any alerts for the database instance?'
        ,'Is the database instance experiencing high disk usage?'
        ,'Are there any database instance data inconsistencies?'
        ,'Is the database instance in a stable state?'
        ,'What is the database instance''s current auditing status?'
        ,'Are all datafiles of the database instance online?'
        ,'Is the database instance in recovery mode?'
        ,'Is the database instance in mount mode?'
        ,'Is the database instance in open mode?'
        ,'Is the database instance in nomount mode?'
        ,'Is the database instance part of a RAC environment?'
        ,'Is the database instance experiencing any issues?'
        ,'Are there any pending transactions in the database instance?'
        ,'Are all database instance services running?'
        ,'Is the database instance experiencing any network issues?'
        ,'Are there any database instance connectivity issues?'
        ,'Is the database instance optimized for performance?'
        ,'What is the database instance''s current backup status?'
        ,'Is the database instance in a healthy state?'
        ,'Are all database services operational?'
        ,'What is the current uptime of the database instance?'
        ,'Are there any database instance storage issues?'
        ,'Is the database instance compliant with regulatory requirements?'
        ),
        p_match_document       => JSON('{"sql": "SELECT status FROM v$instance", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Database Open Mode',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the current open mode of the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is the database open for application use?'
        ,'Can I grant privileges in the current database mode?'
        ,'Can the database accept new connections?'
        ,'Is the database open to all users?'
        ,'What mode is the database operating in?'
        ,'Is the database in a mode that allows indexing?'
        ,'Is the database in restricted mode?'
        ,'Is the database restricted to specific IP addresses?'
        ,'Can the database handle concurrent connections?'
        ,'Is the current database mode allowing transactions?'
        ,'Is the database available for user connections?'
        ,'What is the open status of the database?'
        ,'Is the current open mode allowing data modifications?'
        ,'What open mode is the database set to right now?'
        ,'Can I confirm the database is not in mount mode?'
        ,'Is the database restricted to admin users only?'
        ,'Is the database currently in a usable state?'
        ,'Is the database available for data warehousing operations?'
        ,'Is the database open for database tuning?'
        ,'Is the database open for normal operations?'
        ,'Is the database currently open for read/write operations?'
        ,'What is the current database mode for recovery?'
        ,'What is the current open mode of the database?'
        ,'What mode is required for database backups?'
        ,'Is the database open for data exports?'
        ,'Can I update database statistics in the current mode?'
        ,'Is the database in a mode that allows data purging?'
        ,'Is the database available for PL/SQL execution?'
        ,'Is the database open for maintenance?'
        ),
        p_match_document       => JSON('{"sql": "SELECT open_mode FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking User Sessions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve information on active user sessions and their programs.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you show session IDs for all active sessions?'
        ,'Which programs are causing the most load?'
        ,'What is the peak session count for each program today?'
        ,'Do any programs have unusually high session counts?'
        ,'Can you show the session IDs for all active sessions on a specific node?'
        ,'Can you list all active sessions with their corresponding session status?'
        ,'How many active sessions are there per user?'
        ,'What is the breakdown of active sessions by program vendor?'
        ,'Average duration of active sessions?'
        ,'How many active sessions are there per hour of the day?'
        ,'Are there any long-running active sessions?'
        ,'Are there any active sessions with high CPU usage?'
        ,'What is the average session duration for each program?'
        ,'How do session counts vary during peak hours?'
        ,'Are there any active sessions with high memory usage?'
        ,'What is the session status for each active session?'
        ,'Can you show the distribution of active sessions by program category?'
        ,'Which programs are associated with active user sessions?'
        ,'How many active sessions are running on each server?'
        ,'What is the breakdown of active sessions by program category and vendor?'
        ,'What is the total count of active sessions per program?'
        ,'Can you list all active sessions with their corresponding program versions?'
        ,'How many sessions are active per database instance?'
        ,'Are there any anomalies in session activity?'
        ,'What programs have the highest number of active sessions?'
        ,'Can you list active sessions by program type?'
        ,'Which users have the most active sessions?'
        ,'Can I get a list of sessions by program version?'
        ,'Can you show the session counts for each program over time?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, sid, serial#, status FROM v$session WHERE username IS NOT NULL SELECT machine, program, COUNT(*) FROM v$session GROUP BY machine, program;", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Tablespace Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the size and details of tablespaces.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any tablespaces with space thresholds set?'
        ,'How much free space is available in each tablespace?'
        ,'What is the total number of tablespaces in the database?'
        ,'How many data files are associated with each tablespace?'
        ,'Can you provide details on tablespace usage history?'
        ,'What are the names of all tablespaces in the database?'
        ,'Which tablespaces have the highest fragmentation?'
        ,'Are there any tablespaces in read-only mode?'
        ,'Can you provide a summary of tablespace storage parameters?'
        ,'What is the average size of all tablespaces?'
        ,'What is the average block size across all tablespaces?'
        ,'Can you list tablespaces with their associated schemas?'
        ,'Are there any tablespaces with no free space?'
        ,'What is the maximum size limit for each tablespace?'
        ,'Which tablespace has the most data files?'
        ,'Can you show the growth trend of tablespaces over time?'
        ,'Are there any tablespaces with flashback logging enabled?'
        ,'How many tablespaces are using automatic segment space management?'
        ,'How do tablespaces differ in terms of extent management?'
        ,'Which tablespaces have the most indexes stored?'
        ,'Are there any tablespaces with invalid or corrupted data files?'
        ,'What is the default tablespace for the database?'
        ,'What is the allocation type for each tablespace?'
        ,'Can you show the tablespace size history for the last month?'
        ,'Are there any tablespaces with insufficient free space?'
        ,'Are there any tablespaces with logging disabled?'
        ,'What is the status of each tablespace (online/offline)?'
        ,'Which tablespace has the most used space?'
        ,'Which tablespaces are set to autoextend?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, file_name, bytes/1024/1024 AS size_mb FROM dba_data_files ORDER BY tablespace_name", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Redo Log Status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Review the status and details of redo log files.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are redo log files being archived to multiple destinations?'
        ,'Are there any redo log files in need of recovery?'
        ,'Are all redo log files multiplexed?'
        ,'How do I validate redo log file integrity?'
        ,'Are there any redo log files marked as stale?'
        ,'What is the current status of redo log files?'
        ,'How many redo logs are in the current cycle?'
        ,'What is the total size of all redo log files?'
        ,'What is the redo log file''s compatibility version?'
        ,'How are redo logs configured for RAC environments?'
        ,'Which redo log files are inactive?'
        ,'How many redo log files are required for my database?'
        ,'How frequently are redo logs switched?'
        ,'How many redo log switches occurred today?'
        ,'How do I identify long-running redo log switches?'
        ,'What is the redo log file format?'
        ,'What is the current redo log buffer size?'
        ,'What is the status of the oldest redo log?'
        ,'Can I drop a redo log group?'
        ,'Are there any redo log files with missing members?'
        ,'How many redo log files are active?'
        ,'Can I rename a redo log file?'
        ,'Are there any redo log files with errors?'
        ,'What is the current redo log file''s creation time?'
        ,'How do I determine the optimal redo log size?'
        ,'Are there any redo log files with bad headers?'
        ,'Are there any redo log files with incomplete recovery?'
        ,'What is the redo log file retention policy?'
        ,'Are there any redo logs with high I/O wait times?'
        ),
        p_match_document       => JSON('{"sql": "SELECT group#, status, member FROM v$logfile SELECT group#, sequence#, bytes/1024/1024 AS size_mb, status FROM v$log;", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Blocked Sessions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify sessions currently blocked by others.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is there a pattern to blocked sessions?'
        ,'Are specific tables causing session blocks?'
        ,'What is the current block rate?'
        ,'Are there multiple blockers for a session?'
        ,'What are the session IDs of blocked sessions?'
        ,'Are there any blocked sessions with a high priority?'
        ,'Are there any critical sessions being blocked?'
        ,'Are there any blocked sessions with a high number of waits?'
        ,'How often do blocks occur?'
        ,'Which sessions are blocked due to row-level locks?'
        ,'Can you identify blocking user names?'
        ,'Which tables are most frequently causing blocks?'
        ,'Are there any sessions blocked by a specific application?'
        ,'Can you list blocked sessions by user?'
        ,'Which sessions have been blocked the longest?'
        ,'Can you show me the top blocking sessions?'
        ,'Are there any blocked sessions with high CPU usage?'
        ,'Can you identify the resource causing the most blocks?'
        ,'How many sessions are blocked currently?'
        ,'Which sessions are being blocked by multiple sessions?'
        ,'How many sessions are waiting for a resource?'
        ,'Who is blocking the current sessions?'
        ,'Are there any sessions blocked by a specific user?'
        ,'What is the average wait time for blocked sessions?'
        ,'Is blocking affecting system performance?'
        ,'What resources are causing session blocks?'
        ,'Are there any blocked sessions with a high number of block switches?'
        ,'How many users are affected by blocking?'
        ,'How long have the current blocked sessions been waiting?'
        ),
        p_match_document       => JSON('{"sql": "SELECT blocking_session, sid, serial#, wait_class, seconds_in_wait FROM v$session WHERE blocking_session IS NOT NULL", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Long-Running Queries',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Discover active queries running for extended periods.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you list queries active for more than 15 minutes?'
        ,'How many queries are active for over 5 hours?'
        ,'Which active queries are using excessive network resources?'
        ,'Can you list queries running for over 45 minutes?'
        ,'What is the longest-running query by user?'
        ,'Which SQL IDs have the longest-running active queries?'
        ,'Can you list queries running for over 10 hours?'
        ,'How can I track queries that exceed a certain execution time?'
        ,'Are there any queries running for more than 4 days?'
        ,'Are there any queries stuck in execution?'
        ,'What queries are consuming the most time?'
        ,'Which queries have been executing for over an hour?'
        ,'Can you list queries active for more than 30 minutes?'
        ,'How can I monitor queries running for an extended period?'
        ,'Are there any queries running for an unusually long time?'
        ,'What are the longest-running queries currently active?'
        ,'Which sessions have queries running for over an hour?'
        ,'Can you show queries that have been active since yesterday morning?'
        ,'Which queries have the highest CPU usage?'
        ,'Which active queries are causing performance issues?'
        ,'Are there any queries running for more than 3 days?'
        ,'Which database users have the most long-running active queries?'
        ,'How can I identify queries running for extended periods?'
        ,'Are there active queries that have exceeded a set threshold?'
        ,'What are the top 5 longest-running active queries?'
        ,'How do I find queries running unusually long?'
        ,'How can I track long-running active queries?'
        ,'What criteria define a long-running active query?'
        ,'How can I see active queries exceeding expected run time?'
        ),
        p_match_document       => JSON('{"sql": "SELECT a.sid, a.serial#, a.username, a.status, b.sql_text FROM v$session a, v$sqlarea b WHERE a.sql_address = b.address AND a.status = ''ACTIVE'' ORDER BY a.last_call_et DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Index Fragmentation',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Evaluate fragmentation levels of database indexes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which indexes require immediate attention due to fragmentation?'
        ,'Can index fragmentation affect database backups?'
        ,'Can index fragmentation cause data retrieval issues?'
        ,'What resources are needed to address index fragmentation?'
        ,'What tools help measure index fragmentation?'
        ,'Are there any indexes that are immune to fragmentation?'
        ,'How do I identify fragmented indexes in my database?'
        ,'Can you provide a script to rebuild all fragmented indexes?'
        ,'Are there any automated tools for rebuilding fragmented indexes?'
        ,'Are there different types of index fragmentation?'
        ,'Can you provide a histogram of index fragmentation levels?'
        ,'How can I assess the fragmentation of my database indexes?'
        ,'How does index fragmentation vary over time?'
        ,'How does fragmentation occur in database indexes?'
        ,'How do I prioritize index rebuilding based on fragmentation levels?'
        ,'How does index fragmentation impact data integrity?'
        ,'What are the signs of severe index fragmentation?'
        ,'How do I compare fragmentation across databases?'
        ,'How does index fragmentation affect storage usage?'
        ,'How do I know if an index needs rebuilding?'
        ,'Are there any indexes with zero fragmentation?'
        ,'What is the relationship between index fragmentation and disk space?'
        ,'What is the fragmentation threshold for my indexes?'
        ,'Is there a way to prevent index fragmentation?'
        ,'How do I interpret fragmentation statistics?'
        ,'What is the current fragmentation level of my indexes?'
        ,'Can I use SQL queries to identify indexes with high fragmentation levels?'
        ,'Can fragmentation levels predict future performance issues?'
        ,'Can you rank indexes by fragmentation percentage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT index_name, table_name, blevel, leaf_blocks, distinct_keys FROM dba_indexes WHERE table_name = ''TABLE_NAME''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Database Parameters',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List memory-related parameters and block size.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you detail memory allocation parameters?'
        ,'How is memory tuned for OLTP workloads?'
        ,'How is memory allocated for parallel operations?'
        ,'What is the database block size?'
        ,'What is the current block size setting?'
        ,'Can you list all memory-related warnings?'
        ,'How are memory parameters affecting performance?'
        ,'What is the current setting for db_cache_size?'
        ,'How does block size affect I/O?'
        ,'What are the memory-related initialization parameters?'
        ,'How is block size determined?'
        ,'Can you compare block size between databases?'
        ,'How is memory allocation affected by database version?'
        ,'How does block size impact query performance?'
        ,'Are there any custom memory parameters?'
        ,'What are the shared pool settings?'
        ,'What is the PGA memory size?'
        ,'What is the maximum memory limit?'
        ,'Can you detail memory usage by session?'
        ,'What is the current setting for streams_pool_size?'
        ,'Can you list all memory-related errors?'
        ,'Can you list all memory settings?'
        ,'How is block size configured?'
        ,'What is the default block size?'
        ,'Are there any memory parameters set to zero?'
        ,'How does block size affect database performance?'
        ,'How much memory is allocated to the shared pool?'
        ,'How is memory allocated for sorting operations?'
        ,'What is the total memory used by the database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$parameter WHERE name LIKE ''%memory%'' SHOW PARAMETER db_block_size;", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Invalid Objects',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify objects with invalid status in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many invalid objects exist in the database?'
        ,'How to troubleshoot invalid object errors?'
        ,'Can invalid objects affect database backups?'
        ,'Which invalid objects were recently modified?'
        ,'Are there invalid materialized views?'
        ,'How can I find invalid procedures?'
        ,'What is the trend of invalid objects over time?'
        ,'Can you show invalid functions?'
        ,'Which database objects are currently invalid?'
        ,'Are there any invalid operators in the database?'
        ,'Are invalid synonyms present?'
        ,'Can invalid objects be ignored?'
        ,'Any invalid types in the database?'
        ,'Are there any invalid text indexes in the database?'
        ,'How to prevent invalid objects from affecting database performance?'
        ,'Which invalid objects have dependencies?'
        ,'Can you list the invalid objects that are owned by a specific role?'
        ,'What is the total count of invalid objects in the database?'
        ,'Are there invalid mining models?'
        ,'How to recompile all invalid objects at once?'
        ,'How to identify the root cause of invalid objects?'
        ,'How to fix invalid objects in Oracle?'
        ,'Do we have invalid triggers?'
        ,'Causes of objects becoming invalid?'
        ,'Can you show me the invalid objects that are related to a specific table?'
        ,'Can you list the invalid objects that are dependent on a specific object?'
        ,'How to prevent objects from becoming invalid?'
        ,'How to recompile invalid objects in a specific schema?'
        ,'Are there invalid cubes in the database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT owner, object_name, object_type, status FROM dba_objects WHERE status = ''INVALID''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Background Process Status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the status of background processes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is the CKPT process currently active?'
        ,'What is the status of the MMAN process?'
        ,'How do I restart a failed background process?'
        ,'Can I get a list of all background processes with errors?'
        ,'Active background processes count?'
        ,'Is the MMNL process functioning properly?'
        ,'How do I troubleshoot failed background processes?'
        ,'What is the status of the ARCn processes?'
        ,'How can I identify idle background processes?'
        ,'Are there any background processes with warnings?'
        ,'What is the current state of the DBWR process?'
        ,'Can I get a report of all active background processes?'
        ,'What is the status of the PMON process?'
        ,'Is the DBWn process operational?'
        ,'What is the status of the CKPT process during database startup?'
        ,'Which background processes are idle?'
        ,'How many background processes are suspended?'
        ,'What background processes are essential for database startup?'
        ,'What background processes are involved in database backup?'
        ,'Is the RECO process running as expected?'
        ,'Which background processes are running?'
        ,'Is the SMON process running?'
        ,'Are there any alerts for background processes?'
        ,'What is the health status of background processes?'
        ,'Are there any background processes that are not responding?'
        ,'Is the LREG process active?'
        ,'Are any background processes causing performance issues?'
        ,'Is the LGWR process writing redo logs correctly?'
        ,'What is the current status of all background processes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT program, status FROM v$process", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Archive Log Mode',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Verify if the database is in archive log mode.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to confirm database is in archive log mode?'
        ,'Is archive log mode turned on?'
        ,'How do I check archive log mode from the command line?'
        ,'Are archive logs being generated?'
        ,'Is archive logging enabled on this database?'
        ,'Is there a way to check archive log mode?'
        ,'Has the database been set to archive log mode?'
        ,'What is the relationship between archive log mode and database recovery?'
        ,'What is the current archive log mode setting?'
        ,'Best practices for managing archive logs?'
        ,'Can I use archive log mode with Oracle RMAN?'
        ,'How can I check the archive log mode status?'
        ,'How do I troubleshoot archive log mode issues?'
        ,'Is the database operating in archive log mode?'
        ,'Is there a report for archive log mode status?'
        ,'What is the archive log mode status now?'
        ,'How do I verify archive log mode?'
        ,'Is archive log mode required for Oracle database upgrades?'
        ,'What happens if archive log mode is disabled?'
        ,'How to determine if archive log mode is on?'
        ,'Can I monitor archive log mode using Oracle Enterprise Manager?'
        ,'How to verify archive log mode from system tables?'
        ,'What command shows archive log mode status?'
        ,'How to verify if archive log mode is configured?'
        ,'How do I ensure archive log mode is on?'
        ,'How do I check the archive log mode history?'
        ,'What query checks archive log mode status?'
        ,'How do I verify archive log mode after a database restart?'
        ,'Can I get the current archive log setting?'
        ),
        p_match_document       => JSON('{"sql": "SELECT log_mode FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Datafiles for Corruption',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify any corruptions in database datafiles.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How does datafile corruption impact performance?'
        ,'How can I check for datafile corruption?'
        ,'How long does it take to repair a corrupted datafile?'
        ,'Is there a pattern to datafile corruption?'
        ,'What are the consequences of ignoring datafile corruption?'
        ,'How frequent is datafile corruption detected?'
        ,'What tools detect datafile corruption?'
        ,'Are there specific datafiles at higher risk?'
        ,'Can datafile corruption affect database performance metrics?'
        ,'Are there any corrupted datafiles in the archive log?'
        ,'Can datafile corruption be caused by software bugs?'
        ,'How do I identify corrupt blocks in datafiles?'
        ,'How do I detect datafile corruption during backup?'
        ,'Can you automate datafile corruption checks?'
        ,'Can I get a report on datafile corruption by tablespace?'
        ,'What datafiles are currently corrupted?'
        ,'What are the common causes of datafile corruption?'
        ,'Can you explain the process of datafile corruption detection?'
        ,'Are there any corrupted datafiles in the undo tablespace?'
        ,'What is the most common type of datafile corruption?'
        ,'How reliable are datafile corruption reports?'
        ,'How do I prevent future datafile corruption?'
        ,'Can corrupted datafiles be recovered?'
        ,'How often should I check for datafile corruption?'
        ,'Can you recommend a schedule for datafile corruption checks?'
        ,'Can datafile corruption affect database security?'
        ,'How do I verify datafile corruption repair?'
        ,'How do I ensure datafile integrity after a repair?'
        ,'Are specific tablespaces affected by corruption?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$database_block_corruption", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Gathering Statistics (Optimizing Performance)',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Optimize performance by gathering schema statistics.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the best time to collect schema statistics?'
        ,'Can schema statistics gathering be parallelized?'
        ,'Can schema statistics be gathered for partitions?'
        ,'What is the recommended frequency for gathering schema statistics in a production environment?'
        ,'Can schema statistics gathering be automated using Oracle Enterprise Manager?'
        ,'How frequently should I update schema statistics?'
        ,'How do I analyze the output of schema statistics gathering?'
        ,'Can I gather schema statistics using a specific Oracle utility?'
        ,'How do I interpret schema statistics reports?'
        ,'What are the system requirements for gathering schema statistics?'
        ,'How do I exclude certain tables from statistics gathering?'
        ,'How do I monitor the progress of schema statistics gathering?'
        ,'How long does it take to gather schema statistics?'
        ,'Can schema statistics be gathered for temporary tables?'
        ,'What are the best practices for gathering schema statistics in a data warehouse environment?'
        ,'How do I rollback schema statistics changes?'
        ,'What are common issues when gathering schema statistics?'
        ,'How do I determine the optimal sample size for gathering schema statistics?'
        ,'Which tables need updated schema statistics?'
        ,'How do I identify which schemas need updated statistics?'
        ,'Can I gather schema statistics for a specific database object?'
        ,'Can I gather schema statistics using a scheduled job?'
        ,'Can I gather statistics without affecting performance?'
        ,'What are the differences between gathering schema statistics for OLTP and OLAP systems?'
        ,'What is the impact of stale schema statistics?'
        ,'How do I optimize schema statistics gathering for large databases?'
        ,'What is the relationship between schema statistics and database indexing?'
        ,'How do I gather schema statistics for large schemas?'
        ,'What are the benefits of gathering schema statistics regularly?'
        ),
        p_match_document       => JSON('{"sql": "EXEC DBMS_STATS.GATHER_SCHEMA_STATS(''SCHEMA_NAME'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Query Execution Plans',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Analyze execution plans for SQL queries.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How can I find the execution plan for a stored procedure?'
        ,'What is the impact of parallelization on the execution plan?'
        ,'What are the differences between the execution plans of two different queries?'
        ,'How to detect bottlenecks in the execution plan?'
        ,'How can I identify index scans in the execution plan?'
        ,'What is the execution plan for a query that uses regular expressions?'
        ,'What is the impact of data skew on the execution plan?'
        ,'Can I see the execution plan for a past query?'
        ,'How do I identify merge joins in the execution plan?'
        ,'How do I identify correlated subqueries in the execution plan?'
        ,'How can I view the execution plan for a specific SQL query?'
        ,'How can I export an execution plan for analysis?'
        ,'What are the memory requirements for this execution plan?'
        ,'What is the estimated execution time for this query?'
        ,'What are the most expensive operations in the execution plan?'
        ,'What is the execution plan for a query with multiple joins?'
        ,'Can I view the execution plan for a query that uses materialized views?'
        ,'What are the indexing recommendations based on the execution plan?'
        ,'How can I detect plan changes over time?'
        ,'What are the statistics used to generate the execution plan?'
        ,'Which steps in the execution plan are parallelized?'
        ,'Can I see the execution plan for a specific user session?'
        ,'What are the I/O costs in the execution plan?'
        ,'How do I identify table scans in the execution plan?'
        ,'How do I compare the execution plans of two different query optimization methods?'
        ,'What are the query optimization techniques used in the execution plan?'
        ,'Which indexes are missing in the execution plan?'
        ,'How can I visualize the execution plan?'
        ,'How to analyze execution plan with sorting?'
        ),
        p_match_document       => JSON('{"sql": "EXPLAIN PLAN FOR SELECT * FROM table_name SELECT * FROM TABLE(DBMS_XPLAN.DISPLAY);", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Database Locks',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Investigate locks held on database objects.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How can I detect lock contention issues?'
        ,'How do I identify locks on partitioned tables?'
        ,'What objects are locked by a specific user?'
        ,'Are there any deadlocks present in the database?'
        ,'What are the lock statistics for today?'
        ,'Can I view lock history for a particular table?'
        ,'What is the lock strategy for a specific schema?'
        ,'What locks are currently active on the database?'
        ,'How can I automate lock detection?'
        ,'How do I resolve locks on a specific object?'
        ,'Can I get a report of locks by object type?'
        ,'Can I get a report of all lock types?'
        ,'How can I prevent deadlocks?'
        ,'Which SQLs are causing the most locks?'
        ,'Can I see a list of all sessions holding locks?'
        ,'Can I see historical lock data?'
        ,'Which tables are frequently locked?'
        ,'How do I identify lock owners?'
        ,'Can I get a report of locks by schema?'
        ,'What is the impact of locks on performance?'
        ,'Can I get a report of locks by SQL statement?'
        ,'Which sessions are waiting for locks to be released?'
        ,'How many locks are currently held by each session?'
        ,'Which user is holding the most locks?'
        ,'How do I determine the lock mode used?'
        ,'What is the lock strategy for this database?'
        ,'Are there any lock waits occurring now?'
        ,'What session is blocking others?'
        ,'Are there any exclusive locks currently?'
        ),
        p_match_document       => JSON('{"sql": "SELECT l.session_id, l.locked_mode, o.object_name, o.object_type FROM v$locked_object l, dba_objects o WHERE l.object_id = o.object_id", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Running Jobs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor currently executing database jobs.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you list executing jobs with their corresponding SQL IDs?'
        ,'What are the execution details for job ID 123?'
        ,'What is the total memory usage of all executing jobs?'
        ,'What is the total I/O usage of all executing jobs?'
        ,'How many jobs are executing by priority level?'
        ,'What is the maximum execution time for any job?'
        ,'Can you list the executing jobs by priority?'
        ,'Can you list executing jobs by their start date?'
        ,'What is the total number of executing jobs per instance?'
        ,'Can you provide the job names currently executing?'
        ,'What are the executing jobs with multiple retries?'
        ,'What are the start times of the executing jobs?'
        ,'What is the average execution time for current jobs?'
        ,'How many executing jobs are in the ''RUNNING'' state?'
        ,'Can you provide the execution history for job ID 1011?'
        ,'Are there any executing jobs that are using excessive resources?'
        ,'Can you list executing jobs by database instance?'
        ,'Are there any jobs executing with warnings?'
        ,'How many jobs are executing in each schema?'
        ,'How many jobs are executing in parallel?'
        ,'Which user has the most executing jobs?'
        ,'How many database jobs are running right now?'
        ,'Are there any jobs executing longer than 1 hour?'
        ,'What is the minimum execution time for any job?'
        ,'How many jobs are executing per user?'
        ,'Are there any jobs executing during peak hours?'
        ,'Are there any jobs stuck in execution?'
        ,'What is the total number of executing jobs?'
        ,'What are the executing jobs with high memory usage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT job_name, session_id, running_instance, elapsed_time FROM dba_scheduler_running_jobs", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Database Status and Open Mode',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve both status and open mode of the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you confirm the database is in read-only mode?'
        ,'What is the database''s current connection status?'
        ,'What is the database''s current operational mode?'
        ,'Is the database in exclusive mode?'
        ,'What is the current state of database performance?'
        ,'Is the database in the nomount state?'
        ,'Is the database open for system operations?'
        ,'What is the current status of the database?'
        ,'Is the database in a mounted but not open state?'
        ,'What is the database''s open status?'
        ,'What is the current status of database transactions?'
        ,'Is the database open for internal operations?'
        ,'What is the current state of database accessibility?'
        ,'Is the database in a consistent state?'
        ,'Can users access the database currently?'
        ,'What is the current availability of the database?'
        ,'Is the database currently in active mode?'
        ,'Can the database be accessed for low-priority operations?'
        ,'Can the database be accessed for queries?'
        ,'Is the database available for normal operations?'
        ,'Can the database be used for data exports?'
        ,'Can the database be accessed for maintenance?'
        ,'Is the database open for external connections?'
        ,'Can users access the database for updates?'
        ,'Has the database been opened successfully?'
        ,'What open mode is the database configured for?'
        ,'What is the current accessibility level of the database?'
        ,'What is the status of the database''s open mode?'
        ,'Is the database open for all users?'
        ),
        p_match_document       => JSON('{"sql": "SELECT ''STATUS = '' || status FROM v$instance union SELECT ''MODE = '' || open_mode FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Startup Time',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find the time when the database was last started.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the last startup time of the database?'
        ,'What is the last database launch timestamp?'
        ,'What date and time was the database last initiated?'
        ,'Can you provide the last database activation date?'
        ,'What date and time did the database last start?'
        ,'What is the database''s last startup timestamp?'
        ,'When was the database last powered on?'
        ,'What is the last time the database was started?'
        ,'What is the database''s last boot timestamp?'
        ,'What is the timestamp of the last database start?'
        ,'When did the database last start running?'
        ,'When was the database last started?'
        ,'What is the last startup time for the database?'
        ,'When did the database last come online?'
        ,'What is the last recorded database startup time?'
        ,'Can you tell me the last database start time?'
        ,'What is the last database startup time and date?'
        ,'Show the last time the database was started.'
        ,'Provide the last database startup time.'
        ,'What is the last database start date and time?'
        ,'Show me the last database startup date.'
        ,'What is the last time the database was booted?'
        ,'When did the database come online last?'
        ,'Provide the last database initiation time.'
        ,'When did the most recent database startup occur?'
        ,'When was the database last turned on?'
        ,'What time did the database last start?'
        ,'What was the last database boot time?'
        ,'Provide the last database initialization time.'
        ),
        p_match_document       => JSON('{"sql": "SELECT TO_CHAR(startup_time, ''DD-MON-YYYY HH24:MI:SS'') AS startup_time FROM v$instance", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Database Role (Primary/Standby)',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Determine if the database is in primary or standby role.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you confirm if the database is primary?'
        ,'Can you tell if the database is primary?'
        ,'What role is the database currently in?'
        ,'Is the database operating in a standby role?'
        ,'How do I verify the database''s current role?'
        ,'Is the database''s role primary or standby?'
        ,'What is the role of the database server?'
        ,'What is the database''s role configuration?'
        ,'Can you identify the database''s role?'
        ,'Can you confirm the database''s current status?'
        ,'What is the current database role setting?'
        ,'What is the current role of the database?'
        ,'Is the database operating as primary or standby?'
        ,'How do I check the database role status?'
        ,'Can you verify the database''s role type?'
        ,'Is the database currently in standby status?'
        ,'Is the database configured as a standby?'
        ,'What role is my Oracle database currently in?'
        ,'Can you confirm if the database is in standby mode?'
        ,'Am I running a primary database?'
        ,'Is the database acting as a standby database?'
        ,'Is the database primary or standby right now?'
        ,'Is the database a primary database right now?'
        ,'Is the current database role primary?'
        ,'What is the database role type?'
        ,'Is the database set as a primary database?'
        ,'Can you identify if the database is primary?'
        ,'What is the role of the current database instance?'
        ,'Can you determine the database''s role status?'
        ),
        p_match_document       => JSON('{"sql": "SELECT database_role FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Uptime',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Calculate the total uptime of the database instance.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you display the instance''s uptime history?'
        ,'How many seconds has the database instance been running today?'
        ,'Report the instance''s uptime in hours.'
        ,'What''s the accumulated uptime for the database instance this year?'
        ,'Can you provide the database''s total operational time?'
        ,'How long has the database instance been live?'
        ,'What is the total uptime for the database instance?'
        ,'How many hours has the database been running?'
        ,'What''s the total uptime for the database instance in quarters?'
        ,'How many weeks has the database been up?'
        ,'Can you provide the instance''s uptime details for the last 30 days?'
        ,'How many months has the database been operational?'
        ,'How many minutes has the database been running continuously?'
        ,'How long has the database been continuously running?'
        ,'Can you calculate the total uptime for me?'
        ,'What''s the total uptime for the database instance in months?'
        ,'What''s the database''s uptime in hours?'
        ,'Can you calculate the average uptime per day?'
        ,'Provide the instance''s total uptime in days.'
        ,'How many days has the database instance been continuously operational?'
        ,'What''s the accumulated downtime for the database instance?'
        ,'Can you calculate the database instance''s uptime ratio?'
        ,'How long has the database instance been up since the last update?'
        ,'Can you give a breakdown of the instance''s uptime?'
        ,'How long has the database instance been active?'
        ,'Can you show me the database instance''s uptime forecast?'
        ,'Provide the total uptime in seconds.'
        ,'Can you summarize the database''s uptime?'
        ,'How many hours has the database instance been online today?'
        ),
        p_match_document       => JSON('{"sql": "SELECT (SYSDATE - startup_time) * 24 UPTIME_HOURS FROM v$instance", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Finding Current SCN (System Change Number)',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve the current SCN of the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is the SCN affected by database restarts?'
        ,'How does the current SCN affect replication?'
        ,'Is the SCN included in database exports?'
        ,'Can I manually change the current SCN?'
        ,'What is the current SCN of the database?'
        ,'How to troubleshoot SCN issues?'
        ,'Can I use the SCN for auditing purposes?'
        ,'How is the current SCN used in backups?'
        ,'How is the current SCN calculated?'
        ,'Can I compare SCNs between databases?'
        ,'Show me the database''s current SCN.'
        ,'Can I use the SCN to recover a database?'
        ,'Where is the SCN stored in the database?'
        ,'Does the current SCN correlate with transactions?'
        ,'How does the SCN impact database performance?'
        ,'How can I find the current SCN?'
        ,'Is there a way to check the current SCN?'
        ,'Is the SCN updated during database migrations?'
        ,'What factors influence the current SCN?'
        ,'What table holds the current SCN?'
        ,'How does the current SCN relate to checkpoints?'
        ,'Retrieve the latest SCN value.'
        ,'How do I access the current SCN?'
        ,'What does the current SCN indicate?'
        ,'What processes update the current SCN?'
        ,'How do I retrieve the SCN value?'
        ,'What query shows the current SCN?'
        ,'Can the current SCN be corrupted?'
        ,'How does the SCN relate to Oracle RMAN?'
        ),
        p_match_document       => JSON('{"sql": "SELECT current_scn FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Finding Active Sessions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Count the number of active sessions in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What''s the active session summary?'
        ,'How many active database sessions exist?'
        ,'Display the number of active sessions.'
        ,'How many sessions are currently running?'
        ,'How many active sessions exist at present?'
        ,'Provide the active session total count.'
        ,'How many active sessions does the database have?'
        ,'What is the total number of active sessions?'
        ,'Current count of active sessions?'
        ,'What''s the active database session count?'
        ,'How many active sessions are running?'
        ,'What is the active session count?'
        ,'How many active sessions are there now?'
        ,'Can you provide the active session count?'
        ,'How many sessions are active now?'
        ,'Can you show the number of active sessions?'
        ,'What\u2019s the count of active sessions now?'
        ,'How many active sessions exist?'
        ,'Can you count the active sessions for me?'
        ,'How many active sessions are there in total?'
        ,'How many sessions are currently active?'
        ,'Provide the current number of active sessions.'
        ,'What is the current active session count?'
        ,'What''s the current active session number?'
        ,'Count of active sessions in the database?'
        ,'Display the active session list.'
        ,'What''s the active session status?'
        ,'Can you report active sessions?'
        ,'What is the active session count now?'
        ),
        p_match_document       => JSON('{"sql": "SELECT COUNT(*) FROM v$session WHERE status = ''ACTIVE''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All User Sessions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display all user sessions with their details.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the IP addresses of active sessions?'
        ,'List all sessions with their associated processes.'
        ,'Display details of sessions with high memory usage.'
        ,'How many sessions are using high CPU?'
        ,'Which sessions are running on server ''Server1''?'
        ,'What are the details of sessions with open transactions?'
        ,'Which users have sessions with high CPU usage by module?'
        ,'Show sessions sorted by session ID.'
        ,'Are there any sessions with invalid usernames?'
        ,'List user sessions with their session IDs.'
        ,'Display sessions with their associated client versions.'
        ,'Which sessions are connected to a specific server process?'
        ,'List sessions with their corresponding terminal IDs.'
        ,'How many sessions are using more than 1GB RAM?'
        ,'Show sessions sorted by process ID.'
        ,'List sessions with their last activity time.'
        ,'List sessions with their current session states.'
        ,'Show sessions grouped by user privilege levels.'
        ,'How many sessions are using data encryption?'
        ,'Show locked sessions and their details.'
        ,'What are the details of sessions with high undo space usage?'
        ,'Display sessions with their associated module names.'
        ,'List sessions with their associated authentication methods.'
        ,'Which users have the longest-running sessions?'
        ,'Display session details by application name.'
        ,'Are there any sessions with expired passwords?'
        ,'What are the details of all user sessions?'
        ,'Show sessions by user and machine name.'
        ,'What are the details of sessions with high network usage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, username, machine, status FROM v$session", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Checking Sessions by Program',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Count sessions grouped by the program in use.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the top programs by session count?'
        ,'What programs are currently running sessions?'
        ,'Are there programs with zero sessions?'
        ,'Which programs have the most active sessions?'
        ,'Show the session distribution across programs.'
        ,'Are there any programs without sessions?'
        ,'Which programs have the most sessions with errors?'
        ,'Which programs are currently underutilized in sessions?'
        ,'Can you show the average session count per program category?'
        ,'Programs with no active sessions?'
        ,'Which program has the most sessions per user?'
        ,'Provide session counts for all running programs.'
        ,'How many programs have sessions that are currently in a waiting state?'
        ,'What is the session count per program?'
        ,'Which programs have the highest average session count?'
        ,'What programs have exceeded session limits?'
        ,'What is the session load per program?'
        ,'Which program is hosting the maximum sessions?'
        ,'How are sessions divided among programs?'
        ,'How many programs have active sessions now?'
        ,'Which programs have sessions that are currently blocked?'
        ,'What is the maximum session count for any program?'
        ,'Can you provide session counts for each program module?'
        ,'Can you provide session counts for each program category?'
        ,'Can you show session counts for each application?'
        ,'What is the total session count across all programs?'
        ,'How many sessions are allocated to each tool?'
        ,'Can you list sessions by program usage?'
        ,'How many sessions are currently idle per program?'
        ),
        p_match_document       => JSON('{"sql": "SELECT program, COUNT(*) FROM v$session GROUP BY program", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Finding Sessions by User',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List sessions associated with the user SCOTT.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can I see the sessions for SCOTT by memory usage?'
        ,'What is the maximum session limit for SCOTT?'
        ,'What is the average session memory usage for SCOTT?'
        ,'List the IP addresses for SCOTT''s sessions.'
        ,'Which SCOTT session has the highest CPU usage?'
        ,'What are the wait events for SCOTT''s sessions?'
        ,'How many sessions does SCOTT have on each instance?'
        ,'Are SCOTT''s sessions using any Oracle features like partitioning?'
        ,'Are SCOTT''s sessions connected via a specific protocol?'
        ,'Are SCOTT''s sessions using parallel processing?'
        ,'What sessions are active for user SCOTT?'
        ,'Is SCOTT connected to multiple sessions?'
        ,'Are there any errors in SCOTT''s sessions?'
        ,'Are there any terminated sessions for SCOTT?'
        ,'What is the session duration for user SCOTT?'
        ,'What is the session priority for user SCOTT?'
        ,'What is the average CPU usage for SCOTT''s sessions?'
        ,'What is the session type for user SCOTT?'
        ,'How long has SCOTT''s session been active?'
        ,'Are SCOTT''s sessions using any diagnostic tools?'
        ,'What is the average session duration for SCOTT?'
        ,'Can I see the SQL statements executed by SCOTT''s sessions?'
        ,'Are there any sessions for SCOTT with high disk I/O?'
        ,'How many sessions belong to SCOTT?'
        ,'What is the status of SCOTT''s sessions?'
        ,'Can I see the sessions for SCOTT by action name?'
        ,'Are SCOTT''s sessions using any temporary tablespace?'
        ,'Are SCOTT''s sessions using any advanced security features?'
        ,'Can I see the sessions for SCOTT by client information?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, username, osuser FROM v$session WHERE username = ''SCOTT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Finding Longest Running Queries',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify the queries running for the longest duration.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the longest-running queries by operating system?'
        ,'How can I detect queries with excessive execution time?'
        ,'How can I track the longest-running queries by day of the week?'
        ,'How can I find queries with execution times over 1 hour?'
        ,'What query has been running the longest this week?'
        ,'What are the top 5 longest-running queries?'
        ,'Which SQL statements are causing the longest delays?'
        ,'What are the longest-running queries by schema?'
        ,'Which queries have the longest average row processing time?'
        ,'How can I track the longest-running queries by hour of the day?'
        ,'Which queries have the highest total CPU time?'
        ,'How to find queries with the most prolonged duration today?'
        ,'How can I list queries with the longest wait times?'
        ,'Which SQL statements have the longest parse time?'
        ,'How do I find queries with the highest number of executions?'
        ,'What are the longest-running queries by module?'
        ,'Which SQL statements have the longest duration?'
        ,'Which queries are currently consuming the most time?'
        ,'How can I track the longest-running queries daily?'
        ,'What queries are causing performance bottlenecks?'
        ,'How do I identify queries with high CPU usage and long duration?'
        ,'How to identify queries with the longest elapsed time?'
        ,'Which SQL statements have the longest PL/SQL execution time?'
        ,'What are the longest-running queries in the last 30 minutes?'
        ,'What are the top 10 longest-running queries by elapsed time?'
        ,'What are the longest-running queries by session?'
        ,'How do I identify long-running queries in the database?'
        ,'How can I find queries with the highest execution time?'
        ,'What are the longest-running queries in the past 24 hours?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, sql_id, status, last_call_et FROM v$session WHERE status=''ACTIVE'' ORDER BY last_call_et DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check All Tablespaces',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Provide a summary of all tablespaces in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which tablespaces have the highest I/O activity?'
        ,'Which tablespaces have the most partitions?'
        ,'Are there any tablespaces with a default tablespace quota?'
        ,'Are there any tablespaces with auto-extend enabled?'
        ,'Are there any tablespaces with invalid objects?'
        ,'Which tablespace has the least amount of free space?'
        ,'Which tablespaces have the most triggers?'
        ,'Which tablespaces are using automatic segment space management?'
        ,'How often are tablespaces backed up?'
        ,'What is the total size of all temporary tablespaces?'
        ,'What is the total number of rows in each tablespace?'
        ,'Are there any tablespaces with a flashback archive?'
        ,'What is the average used percentage of all tablespaces?'
        ,'Calculate the average size of tablespaces.'
        ,'What is the current usage percentage of each tablespace?'
        ,'How much free space does each tablespace have?'
        ,'Which tablespaces are used by the most users?'
        ,'What is the default block size for each tablespace?'
        ,'How many datafiles does each tablespace have?'
        ,'Which tablespaces are locally managed?'
        ,'What is the total number of SQL plans in each tablespace?'
        ,'What are the names of all tablespaces?'
        ,'Which tablespaces have the most materialized views?'
        ,'What is each tablespace''s maximum size limit?'
        ,'Are there any tablespaces with a high water mark greater than 90%?'
        ,'Are there any tablespaces with a block size greater than 8KB?'
        ,'Are there any tablespaces shared across multiple databases?'
        ,'Are there any tablespaces using bigfile architecture?'
        ,'Which tablespaces have the highest number of objects?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, status, contents FROM dba_tablespaces", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Tablespace Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Summarize used space in each tablespace.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you alert me when a tablespace reaches 95% used space?'
        ,'Which tablespaces have used space above 90%?'
        ,'How does used space in a tablespace impact database scalability?'
        ,'What is the historical space usage for tablespaces?'
        ,'How much space is used by the largest tablespace?'
        ,'Can you compare used space between two specific tablespaces?'
        ,'Which tablespace has the highest used space?'
        ,'Can you provide a detailed space usage report?'
        ,'What is the average used space percentage across all tablespaces?'
        ,'Are there any tablespaces with used space below 10%?'
        ,'How often should I monitor tablespace used space?'
        ,'How does used space in one tablespace affect others?'
        ,'How is space usage distributed across tablespaces?'
        ,'How does used space compare across tablespaces?'
        ,'What is the used space percentage for each tablespace?'
        ,'How much space is used by the temporary tablespace?'
        ,'Which tablespace has the least used space?'
        ,'Can you rank tablespaces by used space?'
        ,'How does used space affect database performance?'
        ,'Show the used space for all tablespaces.'
        ,'How do I reclaim space in overused tablespaces?'
        ,'Which tablespaces are nearing full capacity?'
        ,'Are there any tablespaces with zero used space?'
        ,'What tablespaces require space optimization?'
        ,'What is the total used space in the database?'
        ,'What tablespaces have unused allocated space?'
        ,'What is the used space for the system tablespace?'
        ,'Identify tablespaces with critical space usage.'
        ,'Can you alert me when space usage is high?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, SUM(bytes)/1024/1024 AS used_mb FROM dba_segments GROUP BY tablespace_name", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Free Space in Tablespaces',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Calculate free space available in each tablespace.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which tablespaces need immediate attention?'
        ,'Can I get a list of tablespaces with the most free space allocated?'
        ,'How does free space affect the performance of SQL queries?'
        ,'What is the average free space percentage across all tablespaces?'
        ,'How does free space in the system tablespace impact performance?'
        ,'How much free space is in each tablespace?'
        ,'Can I get a report of tablespaces with free space above a certain percentage?'
        ,'Can you compare free space usage between different databases?'
        ,'Which tablespaces are low on free space?'
        ,'What are the consequences of low free space?'
        ,'What is the total free space in the database currently?'
        ,'How to increase free space in tablespaces?'
        ,'How to set alerts for low free space?'
        ,'What are the consequences of running out of free space in a tablespace?'
        ,'How does free space impact database backup and recovery processes?'
        ,'How do I troubleshoot free space issues in my Oracle database?'
        ,'What are the recommended free space thresholds for each tablespace type?'
        ,'Compare free space between tablespaces.'
        ,'Can you show me the free space history for a specific tablespace?'
        ,'What are the critical free space thresholds?'
        ,'Show free space percentage per tablespace.'
        ,'What''s the average free space across tablespaces?'
        ,'What is the largest free space block in each tablespace?'
        ,'Can I get a report of tablespaces with free space below a certain threshold?'
        ,'How often is free space checked?'
        ,'Can free space be predicted for future needs?'
        ,'What is the impact of free space on database scalability?'
        ,'How do I identify tablespaces with inadequate free space?'
        ,'Can you show me the free space distribution across different database objects?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, SUM(bytes)/1024/1024 AS free_mb FROM dba_free_space GROUP BY tablespace_name", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Datafiles',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List details of all datafiles in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the block size of the largest datafile?'
        ,'What is the status of each datafile?'
        ,'What is the checkpoint count for each datafile?'
        ,'What is the redundancy level of datafiles?'
        ,'Which datafiles have the lowest usage?'
        ,'What tablespaces do the datafiles belong to?'
        ,'What are the file IDs of all datafiles?'
        ,'Are there any datafiles with errors?'
        ,'Are there any temporary datafiles?'
        ,'Are there any datafiles with non-standard block sizes?'
        ,'What is the average size of datafiles?'
        ,'Are there any corrupted datafiles?'
        ,'What is the average growth rate of datafiles?'
        ,'What is the block size of each datafile?'
        ,'What is the redundancy level of each datafile?'
        ,'What are the names of all datafiles?'
        ,'What is the creation date of each datafile?'
        ,'What is the maximum size of datafiles?'
        ,'Which datafile has the largest size?'
        ,'Which datafiles have the most errors?'
        ,'How many datafiles are in read-write mode?'
        ,'What is the total I/O activity for all datafiles?'
        ,'When were the datafiles last accessed?'
        ,'What is the total free space in all datafiles?'
        ,'Which datafile has the most free space?'
        ,'Which tablespaces have numerous datafiles?'
        ,'Which datafiles have the most corrupted blocks?'
        ,'What is the total size of temporary datafiles?'
        ,'How much free space is in each datafile?'
        ),
        p_match_document       => JSON('{"sql": "SELECT file_name, tablespace_name, bytes/1024/1024 AS size_mb FROM dba_data_files", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check All Indexes',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all indexes owned by the user SCOTT.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show indexes under SCOTT.'
        ,'What are the indexing best practices for SCOTT''s tables?'
        ,'What is the total size of SCOTT''s indexes?'
        ,'Can you list SCOTT''s indexes?'
        ,'What indexes does SCOTT own?'
        ,'Can you provide SCOTT''s index fragmentation details?'
        ,'SCOTT''s index column details?'
        ,'What is the average size of SCOTT''s indexes?'
        ,'SCOTT''s index status summary?'
        ,'Index count for SCOTT?'
        ,'Can you provide SCOTT''s index storage usage trends?'
        ,'What are SCOTT''s index types?'
        ,'How many bitmap indexes does SCOTT have?'
        ,'What are the top 5 most used indexes by SCOTT?'
        ,'Can you show SCOTT''s index validation history?'
        ,'How many indexes does SCOTT have?'
        ,'List the tables with indexes owned by SCOTT.'
        ,'What are SCOTT''s primary indexes?'
        ,'Can you list SCOTT''s indexes that need rebuilding?'
        ,'Indexes SCOTT has created?'
        ,'Which indexes are SCOTT''s?'
        ,'What are the recommendations for improving SCOTT''s index performance?'
        ,'Can you show SCOTT''s index rebuild history?'
        ,'Can you list SCOTT''s indexes that are not being used?'
        ,'List SCOTT''s non-unique indexes.'
        ,'SCOTT''s bitmap indexes?'
        ,'Can you show SCOTT''s index storage details?'
        ,'How many indexes does SCOTT have on partitioned tables?'
        ,'Can you provide SCOTT''s index maintenance schedule?'
        ),
        p_match_document       => JSON('{"sql": "SELECT index_name, table_name, uniqueness FROM dba_indexes WHERE owner = ''SCOTT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Index Fragmentation',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check fragmentation of indexes on the EMP table.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which index on EMP has the highest fragmentation?'
        ,'Is fragmentation consistent across all EMP indexes?'
        ,'What are the best practices for maintaining optimal index fragmentation on the EMP table?'
        ,'How to monitor EMP index fragmentation regularly?'
        ,'Are EMP indexes optimized for performance?'
        ,'Are there any specific system events that can cause EMP index fragmentation?'
        ,'Which EMP index has the lowest fragmentation?'
        ,'How often should EMP indexes be defragmented?'
        ,'Are there any unused indexes on the EMP table?'
        ,'How does EMP index fragmentation impact storage?'
        ,'What database statistics show EMP index fragmentation?'
        ,'Which EMP index requires immediate attention?'
        ,'How do I identify the root cause of EMP index fragmentation?'
        ,'Can I use the DBCC CHECKDB command to identify EMP index fragmentation issues?'
        ,'What tools identify EMP index fragmentation?'
        ,'How does fragmentation affect EMP index performance?'
        ,'Can I use DBMS_REDEFINITION to reduce EMP index fragmentation?'
        ,'What is the relationship between index fragmentation and EMP table storage?'
        ,'Are there any third-party tools that can help with EMP index fragmentation?'
        ,'Can I use the Oracle Enterprise Manager to monitor EMP index fragmentation?'
        ,'How does the size of the EMP table affect index fragmentation?'
        ,'How does the frequency of DML operations affect EMP index fragmentation?'
        ,'List all fragmented indexes on the EMP table.'
        ,'Are there any database configuration options that can help reduce EMP index fragmentation?'
        ,'How does data volume affect index fragmentation on the EMP table?'
        ,'What is the average fragmentation level of indexes on the EMP table?'
        ,'Can I rebuild indexes on the EMP table during peak hours?'
        ,'What metrics indicate EMP index fragmentation?'
        ,'What is the fragmentation percentage of EMP indexes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT index_name, table_name, leaf_blocks, distinct_keys FROM dba_indexes WHERE table_name = ''EMP''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Top SQL Queries by CPU Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify SQL queries consuming the most CPU.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the most resource-intensive SQL queries in terms of CPU?'
        ,'What SQL statements are using the most CPU cycles?'
        ,'Can you provide a list of SQL queries with high CPU usage and long execution time?'
        ,'What SQL queries have the highest average CPU usage over time?'
        ,'Which SQL queries are causing CPU spikes?'
        ,'Which queries are causing the most CPU contention?'
        ,'Which queries are responsible for high CPU usage?'
        ,'Which SQL queries are the most CPU-hungry?'
        ,'Which queries have the highest average CPU usage?'
        ,'How to locate SQL queries with top CPU usage?'
        ,'What SQL queries are most CPU-intensive?'
        ,'How to find SQL queries causing CPU overload?'
        ,'Which SQL operations are causing CPU bottlenecks?'
        ,'Can you list SQL queries with high CPU usage and high disk I/O?'
        ,'How do I find SQL queries with peak CPU utilization?'
        ,'Which SQL queries are contributing to CPU bottlenecks?'
        ,'What are the most CPU-intensive SQL queries for a specific table?'
        ,'How to detect SQL queries with high CPU utilization patterns?'
        ,'How to identify SQL queries with excessive CPU demand?'
        ,'What SQL queries are straining CPU resources the most?'
        ,'How to pinpoint SQL queries with high CPU overhead?'
        ,'How to track SQL queries that consume the most CPU?'
        ,'Which queries are leading to high CPU consumption?'
        ,'What are the top CPU-consuming SQL queries by session?'
        ,'How to find SQL queries that frequently max CPU usage?'
        ,'What SQL queries have the highest CPU-to-execution-time ratio?'
        ,'How to detect SQL queries with high CPU usage and high memory usage?'
        ,'What are the most CPU-demanding queries currently running?'
        ,'How to identify CPU-heavy SQL queries in my database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_text, cpu_time FROM v$sql ORDER BY cpu_time DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Top SQL Queries by Disk Reads',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Determine SQL queries with the most disk reads.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the SQL queries with critical disk read levels?'
        ,'Can you visualize SQL queries with high disk read trends?'
        ,'Which SQL statements are causing disk read spikes?'
        ,'Can you simulate the disk read behavior of SQL queries?'
        ,'How to find SQL queries that are disk read heavy?'
        ,'Can you identify SQL queries with high disk read latency?'
        ,'Which SQL queries have the highest disk reads?'
        ,'Can you provide a list of SQL queries with high disk read ratios?'
        ,'What SQL queries are leading to disk read saturation?'
        ,'Which SQL queries are optimized for minimal disk reads?'
        ,'Which queries contribute most to disk read operations?'
        ,'How do I prioritize SQL queries for disk read optimization?'
        ,'Can you rank SQL queries by disk read frequency?'
        ,'How can I check SQL queries with maximum disk reads?'
        ,'What are the top 5 SQL queries with the most disk reads?'
        ,'What SQL queries are contributing to high disk utilization?'
        ,'Which SQL queries are impacting disk performance?'
        ,'What SQL queries are impacted by disk read caching?'
        ,'Which SQL queries are responsible for high disk usage?'
        ,'Which SQL queries are experiencing disk read contention?'
        ,'What SQL queries are most demanding on disk resources?'
        ,'Which SQL operations are resulting in high disk read volumes?'
        ,'What SQL queries are subject to disk read throttling?'
        ,'Can you recommend SQL queries to optimize for disk reads?'
        ,'Which SQL queries are leading to high disk access?'
        ,'How do I find SQL queries with the most I/O activity?'
        ,'How to detect SQL queries with excessive disk I/O?'
        ,'What are the disk read counts for top SQL queries?'
        ,'What SQL queries have the highest disk read counts?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_text, disk_reads FROM v$sql ORDER BY disk_reads DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Wait Events',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Analyze wait events that impact performance.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you show wait events by database feature?'
        ,'How often does the ''db file sequential read'' occur?'
        ,'What wait events are common after recent updates?'
        ,'Are there specific wait events linked to CPU usage?'
        ,'What wait events are specific to data migration?'
        ,'Are there wait events related to database configuration?'
        ,'How can I reduce wait event impact?'
        ,'Are there wait events specific to storage problems?'
        ,'Which wait events are linked to locking mechanisms?'
        ,'Can you list wait events by priority level?'
        ,'How do I resolve ''latch free'' waits issues?'
        ,'What is the total wait time for all events?'
        ,'What is the impact of wait events on database throughput?'
        ,'What are the top wait events affecting performance?'
        ,'Which wait events are linked to network latency?'
        ,'What strategies exist for mitigating wait events?'
        ,'How do I analyze wait events for a specific SQL statement?'
        ,'Can you provide recommendations for reducing wait event impact?'
        ,'How do I troubleshoot ''enqueue'' waits?'
        ,'Can you identify wait events during peak loads?'
        ,'Can you list the wait events by impact severity?'
        ,'How do wait events vary by time of day?'
        ,'What wait events should I prioritize for tuning?'
        ,'How do I compare wait events across instances?'
        ,'What is the average wait time for each event?'
        ,'What is causing high ''log file sync'' waits?'
        ,'Which wait events are causing the most delays?'
        ,'How do I identify wait events causing timeouts?'
        ,'Which wait events are related to disk I/O?'
        ),
        p_match_document       => JSON('{"sql": "SELECT event, total_waits, time_waited FROM v$system_event ORDER BY time_waited DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Undo Tablespace Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Review usage statistics of undo tablespaces.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How is undo data being backed up?'
        ,'What is the growth rate of undo tablespaces?'
        ,'What are the system requirements for undo tablespaces?'
        ,'What is the total size of all undo tablespaces?'
        ,'Can undo tablespaces be resized online?'
        ,'Which sessions are using the most undo space?'
        ,'Are there any locked objects in undo tablespaces?'
        ,'What are the considerations for sizing undo tablespaces in a RAC environment?'
        ,'How often are undo tablespaces extended?'
        ,'How much space is left in the undo tablespaces?'
        ,'Which database objects are using the most undo space?'
        ,'How many undo tablespaces are currently active?'
        ,'How many datafiles are in each undo tablespace?'
        ,'Can I drop an undo tablespace while the database is running?'
        ,'How does undo tablespace usage affect disk space?'
        ,'What is the current utilization of undo tablespaces?'
        ,'How do I troubleshoot undo tablespace errors?'
        ,'How do I migrate undo tablespaces to a new storage system?'
        ,'How do undo tablespaces impact system resources?'
        ,'How often are undo tablespaces backed up?'
        ,'What is the relationship between undo tablespaces and temporary tablespaces?'
        ,'Are there any unused undo tablespaces?'
        ,'How do I optimize undo tablespace performance?'
        ,'What is the average size of undo tablespaces?'
        ,'How do I monitor undo tablespace usage in real-time?'
        ,'How many transactions are using undo tablespaces?'
        ,'Are there any performance issues related to undo tablespaces?'
        ,'Which undo tablespace is closest to full capacity?'
        ,'What is the difference between undo tablespaces and redo log files?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, status, SUM(bytes)/1024/1024 AS size_mb FROM dba_undo_extents GROUP BY tablespace_name, status", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Redo Logs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display information about redo logs in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How are redo logs protected against data loss?'
        ,'What is the total number of redo log files?'
        ,'How do I recover from a redo log file corruption?'
        ,'How many redo log groups are active?'
        ,'How frequently are redo logs backed up?'
        ,'Are redo logs affected by database upgrades?'
        ,'Are redo logs compressed by default?'
        ,'How do I migrate redo logs to a new storage device?'
        ,'How do I configure redo log archiving?'
        ,'Are redo logs required for database recovery?'
        ,'Are redo logs archived automatically?'
        ,'Any redo log files with errors?'
        ,'Can I add redo log members to an existing group?'
        ,'How many redo logs are in the current log group?'
        ,'How do I check redo log file integrity?'
        ,'Can I delete inactive redo log files?'
        ,'How do I monitor redo log space usage in real-time?'
        ,'What is the redo log buffer size?'
        ,'Are there any redo logs in an inactive state?'
        ,'What is the redo log retention policy?'
        ,'Total redo log groups configured?'
        ,'What is the relationship between redo logs and database checkpoints?'
        ,'What is the last archived redo log?'
        ,'How often are redo logs switched?'
        ,'Are redo logs multiplexed for redundancy?'
        ,'What is the sequence number of the current log?'
        ,'What is the minimum size of redo log files?'
        ,'What is the difference between redo log groups and members?'
        ,'Can I use redo logs for auditing purposes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT group#, thread#, status, bytes FROM v$log", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Last RMAN Backup',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the completion time and status of the last RMAN backup.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Did any warnings occur during the last RMAN backup?'
        ,'What is the name of the last RMAN backup file?'
        ,'What time did the last RMAN backup conclude?'
        ,'What is the expiration date for the last RMAN backup?'
        ,'Duration of the lastest RMAN backup?'
        ,'Can I use the last RMAN backup for cloning?'
        ,'What errors, if any, occurred in the last RMAN backup?'
        ,'Can I restore from the last RMAN backup?'
        ,'Were there any skipped files during the last RMAN backup?'
        ,'What was the completion time of the last RMAN backup?'
        ,'Can you provide a summary of the last RMAN backup''s performance?'
        ,'What was the duration of the last RMAN backup?'
        ,'Was the last RMAN backup interrupted?'
        ,'Was the last RMAN backup successful?'
        ,'When did the last RMAN backup finish?'
        ,'Did the last RMAN backup use compression?'
        ,'How can I access the last RMAN backup completion report?'
        ,'Did the last RMAN backup complete successfully?'
        ,'Completion time of the last RMAN backup?'
        ,'Did the last RMAN backup finish as expected?'
        ,'Were any errors encountered during the last RMAN backup''s verification?'
        ,'What encryption method was used for the last RMAN backup?'
        ,'What is the size of the lastest RMAN backup?'
        ,'How can I validate the integrity of the last RMAN backup?'
        ,'Did the last RMAN backup include all databases?'
        ,'Can you show me the last RMAN backup''s configuration?'
        ,'What is the end time of the last RMAN backup?'
        ,'How can I check for corruption in the last RMAN backup?'
        ,'Was there a failure in the last RMAN backup?'
        ),
        p_match_document       => JSON('{"sql": "SELECT completion_time, status FROM v$backup WHERE status=''COMPLETED'' ORDER BY completion_time DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Validate Backup',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Validate the integrity of the database backup.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is my latest database backup corrupted?'
        ,'How to verify backup logs for errors?'
        ,'Can I use a third-party tool for Oracle backup validation?'
        ,'How do I validate backups after a database upgrade?'
        ,'How do I test a backup for data integrity?'
        ,'How long does a typical backup validation take?'
        ,'How do I confirm backup consistency?'
        ,'What is the status of my last backup validation?'
        ,'Are there discrepancies in my backup data?'
        ,'Can I ensure my backup is restorable?'
        ,'How do I check if a backup is complete?'
        ,'What are signs of a successful backup validation?'
        ,'How do I validate backups for a specific schema?'
        ,'How to ensure backup files are not corrupted?'
        ,'Can I use a script to validate database backups?'
        ,'What Oracle features validate backups?'
        ,'How do I validate backups for a database with a large amount of data?'
        ,'What are the limitations of backup validation in Oracle?'
        ,'How can I verify the integrity of my database backup?'
        ,'What are the common causes of backup validation failures?'
        ,'How often should I validate backups?'
        ,'What is the best practice for backup validation?'
        ,'How to validate backup after a database change?'
        ,'How to automate backup integrity checks?'
        ,'What steps are involved in validating a backup?'
        ,'Are there any backup validation tools for Oracle Cloud?'
        ,'How do I troubleshoot backup validation failures?'
        ,'How do I validate backups for a database with a high volume of transactions?'
        ,'How to validate a backup without restoring?'
        ),
        p_match_document       => JSON('{"sql": "RMAN> VALIDATE DATABASE", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Get Execution Plan',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Generate and display the execution plan for a SQL query.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the key steps in my SQL execution plan?'
        ,'How can I display the query execution plan?'
        ,'How do I identify the slowest operation in my execution plan?'
        ,'How is my query being executed by Oracle?'
        ,'What is the role of statistics in generating an execution plan?'
        ,'How do I optimize the execution plan for a query with a large result set?'
        ,'Can you show me the execution plan for a query with a recursive subquery?'
        ,'Can you provide the execution plan for a query with a UNION operator?'
        ,'How do I use the execution plan to identify performance bottlenecks?'
        ,'How do I use the execution plan to identify opportunities for parallelization?'
        ,'What is the impact of indexing on the execution plan?'
        ,'Can you list the execution plan operations?'
        ,'Can you provide the execution plan for a query with a Common Table Expression (CTE)?'
        ,'What is the execution plan for a complex query?'
        ,'What is the order of operations in this execution plan?'
        ,'What is the relationship between the execution plan and the query optimizer?'
        ,'How do I analyze the execution plan for a query with multiple sorting operations?'
        ,'How does Oracle choose the execution plan?'
        ,'What join methods are used in my execution plan?'
        ,'How can I optimize my SQL execution plan?'
        ,'What are the different types of execution plans in Oracle?'
        ,'What operations are in my SQL''s execution plan?'
        ,'How do I compare execution plans for different queries?'
        ,'Can you generate an execution plan for a query with aggregate functions?'
        ,'How to generate an execution plan in Oracle?'
        ,'What is the difference between an execution plan and a query plan?'
        ,'What steps does Oracle take to execute my query?'
        ,'How do I analyze the execution plan output?'
        ,'Can you break down the execution plan stages?'
        ),
        p_match_document       => JSON('{"sql": "EXPLAIN PLAN FOR SELECT * FROM employees SELECT * FROM TABLE(DBMS_XPLAN.DISPLAY);", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Current Running SQL Queries',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve currently active SQL queries ordered by last activity.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the active SQL queries today?'
        ,'List currently active SQL queries by last activity timestamp.'
        ,'List active queries by execution time.'
        ,'Which active SQL queries were executed last?'
        ,'What active SQL queries have the most recent activity?'
        ,'What are the SQL queries currently active, ordered by last activity?'
        ,'Can I retrieve active SQL queries?'
        ,'Can you provide active SQL query list?'
        ,'Can I see active SQL queries sorted by recent activity?'
        ,'List active SQL queries.'
        ,'What SQL queries are currently active?'
        ,'Show active SQL queries in order.'
        ,'Which active queries have the latest timestamp?'
        ,'Provide a list of active SQL queries sorted by last activity.'
        ,'What active SQL queries are running?'
        ,'What are the active SQL queries, sorted by last activity timestamp?'
        ,'Provide a list of active queries.'
        ,'Provide active SQL queries, ordered by most recent activity.'
        ,'Show me active SQL queries listed by last activity.'
        ,'Display active SQL queries.'
        ,'Provide active SQL queries.'
        ,'Show active SQL queries sorted by last execution time.'
        ,'Retrieve active SQL statements sorted by last activity.'
        ,'Can I see active SQL queries?'
        ,'What SQL queries are active at the moment?'
        ,'List active SQL queries by recent execution.'
        ,'List active SQL queries by their most recent execution.'
        ,'Which SQL queries are active now?'
        ,'Retrieve the active SQL queries ordered by their last activity time.'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, sql_text FROM v$sql WHERE sql_text IS NOT NULL ORDER BY last_active_time DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Locked Objects',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify database objects that are currently locked by sessions.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Identify locked objects with high contention.'
        ,'Are there any locked Flashback archives?'
        ,'Which schemas have the most locked objects?'
        ,'Identify sessions with table-level locks.'
        ,'Can you list locked PL/SQL packages?'
        ,'Which database objects are locked by the SYS user?'
        ,'Are any materialized views locked?'
        ,'Identify locked synonyms currently.'
        ,'Are there any locked objects in the SYS schema?'
        ,'Which schemas have locked objects?'
        ,'Identify locked indexes in the database.'
        ,'Are there any locked Oracle Text indexes?'
        ,'Which locked objects are most critical?'
        ,'What roles have locked objects?'
        ,'Are any Java classes currently locked?'
        ,'Which users have the most locked objects?'
        ,'Are any global temporary tables locked?'
        ,'What is the longest-running lock?'
        ,'Identify locked objects with the highest wait time.'
        ,'Are there any locked triggers now?'
        ,'Identify locked objects in the SYSTEM tablespace.'
        ,'Which locked objects are causing waits?'
        ,'What sessions are causing object locks?'
        ,'Identify sessions with multiple locks.'
        ,'Are any database objects locked by system sessions?'
        ,'Which sessions hold exclusive locks?'
        ,'Are there any locked tables currently?'
        ,'Which sessions are holding shared locks?'
        ,'What is the total number of sessions holding locks?'
        ),
        p_match_document       => JSON('{"sql": "SELECT session_id, oracle_username, os_user_name, object_id FROM v$locked_object", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find the SQL Causing the Lock',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find the SQL statement responsible for a specific session lock.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What query is causing session lock?'
        ,'Find SQL responsible for session lock.'
        ,'What SQL statement is causing the session to be locked?'
        ,'Which SQL statement is blocking my session?'
        ,'What SQL is holding the session lock?'
        ,'Which SQL is causing the session to lock?'
        ,'Identify the SQL query that is blocking the session.'
        ,'Find the SQL behind the current lock.'
        ,'Which SQL statement is causing the session to be blocked?'
        ,'Which SQL statement is responsible for lock?'
        ,'What SQL is the cause of the session lock?'
        ,'Locate the SQL causing session lock.'
        ,'Which SQL statement is causing the session lock?'
        ,'What query is holding the current session lock?'
        ,'Identify the SQL causing session lock.'
        ,'Determine the SQL statement that is causing the lock.'
        ,'Identify the SQL query for session lock.'
        ,'Identify the SQL causing session blockage.'
        ,'Which SQL query is locking the current session?'
        ,'Locate the SQL query that is holding the session lock.'
        ,'Identify the SQL query responsible for the lock.'
        ,'What SQL statement is causing a lock?'
        ,'What query is responsible for locking this session?'
        ,'What SQL is responsible for this lock?'
        ,'Locate the SQL statement causing the lock.'
        ,'Find the SQL statement that is causing the session lock.'
        ,'Which SQL query is locking the session?'
        ,'Find the SQL query that is locking the session now.'
        ,'What SQL statement is blocking the current session?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_text FROM v$sql WHERE sql_id = (SELECT sql_id FROM v$session WHERE sid = 1234)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Background Processes',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Show all background processes currently running in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which background processes are enabled?'
        ,'Are there active background processes now?'
        ,'Which processes are background?'
        ,'List all running background processes.'
        ,'Are any processes running in background?'
        ,'List the operational background processes.'
        ,'Display all current background tasks.'
        ,'List all active background processes.'
        ,'List current database background processes.'
        ,'Show the list of running background processes.'
        ,'How many processes are currently running?'
        ,'What background processes are active now?'
        ,'How many processes are background?'
        ,'What is the current background process status?'
        ,'Show current background process status.'
        ,'Are there any operational background processes?'
        ,'Can I see current process activity?'
        ,'Which background processes are in progress?'
        ,'Can you display active background processes?'
        ,'Show me the active background processes.'
        ,'What are the current background processes?'
        ,'Show all operational background processes.'
        ,'What running background processes exist?'
        ,'Are any background processes executing?'
        ,'What background processes are running?'
        ,'Are background processes running currently?'
        ,'Display background process list now.'
        ,'Which processes are currently active?'
        ,'Show background process information.'
        ),
        p_match_document       => JSON('{"sql": "SELECT program, status FROM v$process WHERE program IS NOT NULL", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Process Limits',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check current and maximum utilization of database resources.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the maximum number of sessions recorded?'
        ,'What is the current PGA memory usage?'
        ,'What is the maximum undo tablespace usage?'
        ,'What is the current database parsing rate?'
        ,'What is the current redo log switch interval?'
        ,'What is the maximum CPU usage recorded?'
        ,'How much of the database is currently cached?'
        ,'What is the maximum redo log space usage?'
        ,'What is the current database throughput?'
        ,'What is the lowest buffer cache hit ratio recorded?'
        ,'What is the maximum PGA memory recorded?'
        ,'What is the current network bandwidth usage?'
        ,'What is the maximum I/O usage observed?'
        ,'What is the current database recovery time?'
        ,'How many transactions are currently waiting?'
        ,'What is the current undo retention setting?'
        ,'What is the current SQL execution rate?'
        ,'How many database buffers are currently free?'
        ,'What is the maximum number of users connected?'
        ,'How much memory is currently used?'
        ,'How many connections are active now?'
        ,'How many background processes are running now?'
        ,'How many deadlocks have occurred today?'
        ,'How much of the temp tablespace is allocated?'
        ,'How many sessions are idle now?'
        ,'How much of the CPU is being used now?'
        ,'How many rows are being processed per second?'
        ,'What is the maximum number of transactions recorded?'
        ,'What is the maximum number of concurrent connections?'
        ),
        p_match_document       => JSON('{"sql": "SELECT resource_name, current_utilization, max_utilization FROM v$resource_limit", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Users with DBA Role',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all users who have been granted the DBA role.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Who oversees database administration?'
        ,'Which accounts have DBA privileges?'
        ,'Who are the power users?'
        ,'List DBA role grantees.'
        ,'Who are the DBA role assignees?'
        ,'Who has system DBA privileges?'
        ,'Who holds the DBA role?'
        ,'Which users have DBA authority?'
        ,'Who manages the database?'
        ,'Who has been assigned the DBA role?'
        ,'List users with DBA role access.'
        ,'Who has DBA level access?'
        ,'Who are the senior DBAs?'
        ,'Who has system admin rights?'
        ,'Who has DBA role delegation?'
        ,'Users granted the DBA role?'
        ,'Identify DBA role custodians.'
        ,'Which users are granted DBA roles?'
        ,'Who are the database administrators?'
        ,'Who has the DBA role?'
        ,'List users with full DBA access.'
        ,'Who has DBA role assignments?'
        ,'Which users have comprehensive DBA access?'
        ,'Which accounts possess DBA privileges?'
        ,'Identify users granted the DBA role.'
        ,'Show users with DBA permissions.'
        ,'Who has ultimate DBA authority?'
        ,'List all DBA role holders now.'
        ,'Identify DBA role owners.'
        ),
        p_match_document       => JSON('{"sql": "SELECT grantee FROM dba_role_privs WHERE granted_role = ''DBA''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Grant DBA Role to a User',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Assign the DBA role to a specified user.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to manage DBA role across multiple databases?'
        ,'How to ensure DBA role compliance?'
        ,'Is DBA role assignment logged?'
        ,'How to notify users of DBA role changes?'
        ,'What are the DBA role assignment security considerations?'
        ,'How to check for unauthorized DBA roles?'
        ,'What is the purpose of the DBA role?'
        ,'What are the DBA role assignment troubleshooting steps?'
        ,'How to grant DBA role to a user?'
        ,'How to revoke DBA role from a user?'
        ,'How to list all roles of a user?'
        ,'How to document DBA role assignments?'
        ,'How to verify if a user has DBA role?'
        ,'Can DBA role be assigned to a user group in Active Directory?'
        ,'How to monitor DBA role usage?'
        ,'How to add DBA role to a user?'
        ,'What are the common mistakes in DBA role assignment?'
        ,'How to restrict DBA role access?'
        ,'How to assign DBA role in a script?'
        ,'What privileges does the DBA role include?'
        ,'How does DBA role affect security?'
        ,'How to analyze DBA role usage patterns?'
        ,'How to remove DBA role from all users?'
        ,'What are the implications of DBA role on auditing?'
        ,'Can DBA role be assigned using a script in SQL?'
        ,'Can multiple users have the DBA role?'
        ,'How to check users with DBA role?'
        ,'How to optimize DBA role assignments for performance?'
        ,'Can DBA role be assigned using a wizard?'
        ),
        p_match_document       => JSON('{"sql": "GRANT DBA TO username", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check User Privileges',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display system privileges granted to a specific user.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'List all system privileges for user Alice.'
        ,'Can user Kelly drop any database objects?'
        ,'Show system privileges granted to user Coordinator.'
        ,'What are the administrative privileges for user Supervisor?'
        ,'Is user Specialist granted SELECT ANY TABLE privilege?'
        ,'Is user Oscar granted SELECT ANY TABLE privilege?'
        ,'What system privileges does user Admin have?'
        ,'Can user Tester create any database procedures?'
        ,'What system privileges are assigned to user Finance?'
        ,'List all administrative privileges for user Ian.'
        ,'Does user Support have EXECUTE ANY PROCEDURE privilege?'
        ,'Can user Wendy alter any user accounts?'
        ,'Can user DBOwner create users?'
        ,'Is user Chloe granted DROP ANY TABLE privilege?'
        ,'Does user Manager have ALTER SYSTEM privilege?'
        ,'Can user Frank create tablespaces?'
        ,'Can user Amy manage any tablespaces?'
        ,'List all system privileges for user Architect.'
        ,'What system privileges are assigned to user Technician?'
        ,'Can user Marketing create any database triggers?'
        ,'What system privileges are assigned to user Director?'
        ,'What system privileges does user JohnDoe have?'
        ,'Can user Consultant drop any database objects?'
        ,'Can user Quinn create any database links?'
        ,'Is user Victor granted any system privileges?'
        ,'Does user Assistant have CREATE TABLE privilege?'
        ,'Can user Logistics manage any tablespaces?'
        ,'Show system privileges granted to user Carol.'
        ,'Does user Representative have CREATE SEQUENCE privilege?'
        ),
        p_match_document       => JSON('{"sql": "SELECT privilege FROM dba_sys_privs WHERE grantee = ''USERNAME''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check All Users',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all users and their account statuses in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Who are the inactive users?'
        ,'Who are the users with system privileges?'
        ,'Can you list users with accounts created before last year?'
        ,'Are there any expired user accounts?'
        ,'Can you list users with multiple accounts?'
        ,'Which users have never accessed the database?'
        ,'Who are the users with DBA privileges?'
        ,'How many users have accounts set to expire next month?'
        ,'Can you show all users with expired accounts?'
        ,'What are the account statuses for all users?'
        ,'Are there any users with accounts locked due to account policy violations?'
        ,'Are there any users with expired roles?'
        ,'Can you identify users with accounts set to expire on a specific date?'
        ,'Can you list users with custom roles?'
        ,'Can you find users with multiple failed logins?'
        ,'Are there any users with inactive accounts due to security breaches?'
        ,'Can you show users with accounts expiring in the current year?'
        ,'Which user accounts have been recently unlocked?'
        ,'Can you identify users with accounts having object privileges?'
        ,'What is the status of the ''admin'' user account?'
        ,'Which users have accounts with no password expiration?'
        ,'Which user accounts are set to expire today?'
        ,'What accounts have been locked due to security violations?'
        ,'Are there any users with accounts locked due to inactivity?'
        ,'Can you list users created in the last month?'
        ,'Which users have accounts set to expire soon?'
        ,'Can you list users with account status changes?'
        ,'Can you show users with accounts expiring in a week?'
        ,'How many users have accounts with system roles?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, account_status FROM dba_users", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Locked Users',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify user accounts that are currently locked.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'List of currently locked users?'
        ,'Find all locked database users.'
        ,'What is the list of locked users?'
        ,'List of locked user accounts.'
        ,'Identify locked database accounts.'
        ,'Are my accounts locked?'
        ,'Get a list of locked users.'
        ,'Display locked user accounts.'
        ,'Display all locked users now.'
        ,'Any accounts locked currently?'
        ,'Check if any accounts are locked.'
        ,'View locked user list.'
        ,'Locked users in the database?'
        ,'Locked accounts summary?'
        ,'Which user accounts are locked now?'
        ,'Are user accounts locked currently?'
        ,'Who are the locked users?'
        ,'What accounts are currently locked?'
        ,'Are database users locked?'
        ,'Show locked user accounts now.'
        ,'View locked database accounts.'
        ,'Find users with locked accounts.'
        ,'What are the locked user accounts?'
        ,'Verify locked user accounts.'
        ,'Which user accounts are locked?'
        ,'Are there locked users?'
        ,'Who are the users with locked accounts?'
        ,'Which users have locked accounts?'
        ,'What users are locked?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username FROM dba_users WHERE account_status = ''LOCKED''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check User Roles',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve all roles granted to a specific user.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What roles has user \"TechAdmin\" been granted?'
        ,'Can you list roles for user \"NetworkAdmin\"?'
        ,'Retrieve roles for user \"ITUser\".'
        ,'Retrieve roles for a user named \"AdminUser\".'
        ,'What roles are granted to a user named \"OracleDBA\"?'
        ,'Can you show roles for user \"TestUser\"?'
        ,'What roles are tied to user \"AuditAccount\"?'
        ,'What are the assigned roles for \"QAUser\"?'
        ,'What are the roles assigned to user \"ReadOnly\"?'
        ,'Retrieve user \"ITSupport\" roles.'
        ,'Retrieve roles for user \"DevUser.\"'
        ,'What roles does user \"ProductManager\" hold?'
        ,'Does user \"Analyst\" have any assigned roles?'
        ,'Can you list all roles for user \"NetworkUser\"?'
        ,'Retrieve all roles assigned to user \"FinanceAdmin\".'
        ,'How many roles does user \"HRUser\" have?'
        ,'List roles for a user named \"SalesAdmin\".'
        ,'List all roles for user \"BackupUser\".'
        ,'What roles is user \"DBAdmin\" assigned to?'
        ,'Show all roles granted to user \"DevOpsAdmin\".'
        ,'Show roles for user \"SupportAgent.\"'
        ,'What roles are linked to user \"SysUser\"?'
        ,'Display all roles of user \"SecurityUser.\"'
        ,'What roles does user \"ProductAdmin\" hold?'
        ,'Display roles assigned to user \"GuestUser.\"'
        ,'List roles for a specific user \"OracleUser\".'
        ,'Which roles are tied to user \"OpsUser\"?'
        ,'Show roles granted to user \"DevOpsUser.\"'
        ,'What roles belong to user \"ReadOnlyUser\"?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM dba_role_privs WHERE grantee = ''USERNAME''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Grant a Role to a User',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Assign specific roles to a user in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can a user have both admin and user roles?'
        ,'How do I check the role assignments for a specific user in a specific database?'
        ,'What roles should be assigned for database backup tasks?'
        ,'How do I assign roles with limited privileges?'
        ,'How do I remove all roles from a user?'
        ,'Can I assign a custom role to a user?'
        ,'What happens if I assign conflicting roles?'
        ,'What is the difference between a role and a privilege in Oracle Database?'
        ,'What is the command to grant a role?'
        ,'How do I assign a custom role to a user with specific privileges?'
        ,'How do I assign a role to a user in a multitenant database environment?'
        ,'What is the difference between granting a role and assigning a privilege?'
        ,'Is there a way to list all users with a specific role?'
        ,'Can I restrict a user from assigning roles to other users?'
        ,'How do I assign a role to a user using the SQL*Plus command-line tool?'
        ,'How do I assign roles using a script?'
        ,'How do I assign the RESOURCE role to a user?'
        ,'What roles should be assigned to a user for database security tasks?'
        ,'How do I assign the DBA role to a user?'
        ,'Can I automate role assignments for new users?'
        ,'Can I assign roles based on user activity?'
        ,'How do I assign a role to a user using the Oracle Enterprise Manager?'
        ,'What are the default roles for a new user?'
        ,'What roles does user John currently have?'
        ,'How do I check a user''s role assignments?'
        ,'Can I assign a role to a user with a specific authentication method?'
        ,'How do I assign a role to a new user?'
        ,'What roles are required for a user to perform database tuning tasks?'
        ,'Can I assign a role to a user based on their job function?'
        ),
        p_match_document       => JSON('{"sql": "GRANT connect, resource TO username", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Revoke a Role from a User',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Remove a specific role from a user in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to confirm a role removal?'
        ,'Can you revoke a role from a user?'
        ,'What errors occur during role removal?'
        ,'How to remove a role from a user''s default roles?'
        ,'Can a role be removed using Oracle Cloud Infrastructure?'
        ,'What are the best practices for removing roles?'
        ,'How to document role removal for auditing purposes?'
        ,'Can a role be removed using a database trigger?'
        ,'How to remove a default role?'
        ,'What command removes a role from a user?'
        ,'Can I remove multiple roles at once?'
        ,'How do I remove a role from a user?'
        ,'Can a role be removed from a user''s authentication method?'
        ,'What are the system requirements for removing a role?'
        ,'Can a role be removed during maintenance?'
        ,'How to log role removal actions?'
        ,'Can a role be removed from a schema?'
        ,'How to list roles before removal?'
        ,'What happens to user privileges after role removal?'
        ,'How to automate role removal?'
        ,'How to remove a role from a user''s profile?'
        ,'What is the syntax to remove a role?'
        ,'Steps to revoke a user''s role?'
        ,'What impact does role removal have on sessions?'
        ,'Can a role be removed from a user''s group membership?'
        ,'Can I schedule role removal?'
        ,'How to undo a role removal?'
        ,'How to remove a role from a user''s LDAP directory?'
        ,'What is the difference between revoking and dropping a role?'
        ),
        p_match_document       => JSON('{"sql": "REVOKE connect FROM username", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Audit Settings Ordered by Timestamp',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'View audit trail records ordered by the timestamp.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What query shows audit records for the last hour?'
        ,'How to access audit trails sorted by time?'
        ,'What''s the SQL for audit records by timestamp and session ID?'
        ,'How to view audit logs for a specific database user?'
        ,'Can I filter audit logs by timestamp range?'
        ,'Can I view audit trails for a specific database role?'
        ,'Which query fetches audit records by time sequence?'
        ,'How can I sort audit trail records by time?'
        ,'How to display audit trails in a specific format?'
        ,'What''s the SQL for retrieving audit records by month?'
        ,'How do I retrieve audit trails for a specific IP address?'
        ,'What''s the best way to view audit logs by time?'
        ,'How to see audit entries in chronological order?'
        ,'How to retrieve audit logs in time order?'
        ,'Can I list audit logs by time order?'
        ,'How to fetch audit records for a specific table?'
        ,'How do I sort audit logs by timestamp?'
        ,'What method retrieves audit logs by timestamp and operation?'
        ,'What query shows audit records for the last week?'
        ,'What''s the best way to view audit logs for a specific time range?'
        ,'What query displays audit records by timestamp?'
        ,'How to access audit trails for a specific database object?'
        ,'Can audit records be viewed in chronological order?'
        ,'What''s the SQL to list audit records by time?'
        ,'How do I retrieve audit records chronologically?'
        ,'How can I access audit trails ordered by timestamp?'
        ,'How can I order audit records by timestamp?'
        ,'What query shows audit records for the last month?'
        ,'How can I fetch audit logs ordered by timestamp?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM dba_audit_trail ORDER BY timestamp DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Enable Auditing',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Activate auditing for session creation in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do I integrate session creation auditing with other security tools?'
        ,'How to integrate session creation auditing with SIEM?'
        ,'How to check session creation audit settings?'
        ,'How to configure auditing for session creation?'
        ,'How to troubleshoot session creation auditing issues?'
        ,'Can I customize the format of session creation audit reports?'
        ,'Does session creation auditing require a restart?'
        ,'Can I use session creation auditing to detect security threats?'
        ,'What is the difference between auditing session creation and auditing logon attempts?'
        ,'How do I audit session creation activities for a specific IP address?'
        ,'Can I filter session creation audits by user?'
        ,'How do I configure alerts for suspicious session creation activity?'
        ,'How to roll back session creation auditing changes?'
        ,'What are the auditing options for session creation in a multitenant database?'
        ,'What are the limitations of auditing session creation?'
        ,'Is session creation auditing enabled by default?'
        ,'How often are session creation audit logs updated?'
        ,'What command activates session auditing?'
        ,'What is the syntax for enabling session auditing?'
        ,'How do I troubleshoot issues with session creation auditing on a specific database?'
        ,'How do I view session creation audit reports?'
        ,'How to audit all session creations in the database?'
        ,'What are the best practices for managing session creation audit logs?'
        ,'How to audit failed session creation attempts?'
        ,'Can session creation auditing be enabled at the user level?'
        ,'How to disable session creation auditing?'
        ,'How to audit session creation for specific users?'
        ,'What are the system requirements for auditing session creation?'
        ,'Can I use session creation auditing to monitor database administrator activity?'
        ),
        p_match_document       => JSON('{"sql": "AUDIT CREATE SESSION", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Failed Login Attempts',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify failed login attempts by users in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many failed logins were there last month?'
        ,'How many failed logins were due to account lockouts?'
        ,'Can you identify failed logins due to incorrect usernames?'
        ,'Which user had the most recent failed login?'
        ,'What is the average number of failed logins per day?'
        ,'How many failed logins were triggered by password expiration?'
        ,'How many failed logins occurred during maintenance hours?'
        ,'How many failed logins during peak hours?'
        ,'How many failed logins were due to authentication protocol errors?'
        ,'Are failed logins linked to specific network zones?'
        ,'Are failed logins associated with specific roles?'
        ,'Are there any failed logins from unknown devices?'
        ,'What is the average number of failed logins per user per day?'
        ,'How many failed logins occurred overnight?'
        ,'Are there failed logins associated with specific application access?'
        ,'What is the total count of failed logins by user X?'
        ,'Which IP address has the most repeated failed logins?'
        ,'Can you list the top 5 users with failed logins this month?'
        ,'Are there any patterns in failed logins by day of the week?'
        ,'List failed logins from unauthorized devices.'
        ,'Are failed logins concentrated at specific times?'
        ,'How many failed login attempts per user?'
        ,'Did any failed logins trigger security alerts?'
        ,'What are the common reasons for failed logins?'
        ,'How many failed logins were there this week?'
        ,'How many distinct users had failed logins?'
        ,'Which accounts had failed logins from unknown IPs?'
        ,'Which users have the most failed logins?'
        ,'Are there any patterns in failed login attempts?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, timestamp, returncode FROM dba_audit_trail WHERE returncode <> 0", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Users with SYSDBA Privileges',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List users with SYSDBA privileges from the password file.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Retrieve SYSDBA account list.'
        ,'Enumerate SYSDBA user accounts.'
        ,'Who holds SYSDBA privilege?'
        ,'List all accounts with SYSDBA privileges.'
        ,'Identify accounts having SYSDBA.'
        ,'Who possesses SYSDBA privileges?'
        ,'Who are the SYSDBA users?'
        ,'Retrieve list of SYSDBA users.'
        ,'Retrieve accounts with SYSDBA.'
        ,'Which accounts have SYSDBA?'
        ,'Retrieve list of SYSDBA account holders.'
        ,'Get list of users who are SYSDBA.'
        ,'Who is granted SYSDBA?'
        ,'Which users are SYSDBA?'
        ,'List holders of SYSDBA rights.'
        ,'Which accounts are granted SYSDBA?'
        ,'Get users with SYSDBA access.'
        ,'Who are the SYSDBA holders?'
        ,'Identify users granted SYSDBA.'
        ,'What accounts are SYSDBA enabled?'
        ,'Show SYSDBA users list.'
        ,'List users who have SYSDBA access.'
        ,'Identify SYSDBA users.'
        ,'Who has been granted SYSDBA?'
        ,'Who holds SYSDBA rights?'
        ,'Show me SYSDBA privileged users.'
        ,'Find all SYSDBA account holders.'
        ,'What users have SYSDBA access?'
        ,'List SYSDBA privileged users.'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$pwfile_users", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Who Is Using SYSDBA',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify sessions currently using SYSDBA privileges.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which sessions currently hold SYSDBA?'
        ,'Display the list of active SYSDBA connections.'
        ,'Show the sessions that are currently using SYSDBA.'
        ,'Identify the session IDs of users with SYSDBA access.'
        ,'Are there any users with SYSDBA privileges currently logged in?'
        ,'List the users who are logged in as SYSDBA.'
        ,'Find all sessions with SYSDBA privileges currently in use.'
        ,'How many SYSDBA sessions are active?'
        ,'Are there any active SYSDBA sessions currently running?'
        ,'Display users logged in with SYSDBA.'
        ,'Who is logged in with SYSDBA privileges?'
        ,'List current SYSDBA sessions.'
        ,'Which sessions are currently holding SYSDBA privileges?'
        ,'Who are the users connected with SYSDBA privileges?'
        ,'Are there any SYSDBA users connected to the database?'
        ,'How many sessions have SYSDBA access?'
        ,'Display the users who are logged in with SYSDBA rights.'
        ,'Who are the users with SYSDBA privileges at this time?'
        ,'Display a list of users connected with SYSDBA rights.'
        ,'Are any sessions currently utilizing SYSDBA privileges?'
        ,'Show session IDs with SYSDBA access.'
        ,'Identify users with SYSDBA sessions.'
        ,'Identify current users with SYSDBA.'
        ,'Find sessions with SYSDBA privileges.'
        ,'How many sessions are currently using SYSDBA privileges?'
        ,'Can you list the users with SYSDBA roles active?'
        ,'List the session IDs with active SYSDBA access.'
        ,'Show all current SYSDBA sessions.'
        ,'How many users are logged in as SYSDBA?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, osuser, program FROM v$session WHERE sysdba = ''YES''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List Tablespaces with Autoextend Enabled',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List tablespaces with autoextend enabled data files.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you list autoextend tablespaces?'
        ,'Do any tablespaces have autoextend enabled for data files created before a specific date?'
        ,'How to find autoextend tablespaces?'
        ,'Show tablespaces with flexible file sizes.'
        ,'Can you list tablespaces with autoextend enabled for data files that are frequently accessed?'
        ,'List tablespaces where autoextend is enabled for specific file types.'
        ,'Show tablespaces with autoextend on.'
        ,'How many data files in each tablespace have autoextend enabled?'
        ,'Which tablespaces have autoextend enabled for data files that are part of a specific tablespace group?'
        ,'Are there any tablespaces with autoextend enabled for data files that are rarely used?'
        ,'Are there tablespaces configured for autoextend?'
        ,'List tablespaces where all data files can autoextend.'
        ,'Which tablespaces have unrestricted growth?'
        ,'Can you show me tablespaces with autoextend enabled for data files with specific attributes?'
        ,'Can I get a list of non-autoextend tablespaces?'
        ,'Are there tablespaces with fixed-size data files?'
        ,'Are there any tablespaces with mixed autoextend settings?'
        ,'Can you identify tablespaces with autoextend limitations due to disk space?'
        ,'Which tablespaces have autoextend enabled for data files with specific storage parameters?'
        ,'List tablespaces with autoextend data files.'
        ,'Which tablespaces have autoextend enabled for data files that are subject to specific security policies?'
        ,'Which tablespaces have autoextend enabled for temporary data files?'
        ,'Which tablespaces have autoextend by default?'
        ,'List all tablespaces with expandable data files.'
        ,'Which tablespaces have dynamic growth?'
        ,'Are there any tablespaces that cannot autoextend due to space constraints?'
        ,'Can I get a list of tablespaces with autoextend enabled for data files in specific directories?'
        ,'Can you detail tablespaces with autoextend enabled?'
        ,'Identify tablespaces with autoextend enabled.'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, file_name, autoextensible FROM dba_data_files WHERE autoextensible = ''YES''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check High Water Mark of a Table',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the high water mark for a specified table.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to check high water mark for USER_LOGS?'
        ,'Provide the high water mark for the PROJECTS table.'
        ,'What is the current high water mark on CUSTOMER_DATA?'
        ,'How to check the high water mark for the AUDIT_TRAIL table?'
        ,'Retrieve the high water mark for INVENTORY table.'
        ,'What is the high water mark for table SHIPPING_DETAILS?'
        ,'Display the high water mark for the CUSTOMER_ORDERS table.'
        ,'How do I get the high water mark for the SUPPORT_TICKETS table?'
        ,'What is the high water mark in the CONTRACTS table?'
        ,'Show the high water mark for the ANALYTICS_DATA table.'
        ,'What is EMPLOYEE_BENEFITS'' high water mark?'
        ,'What is the high water mark for the PAYROLL table?'
        ,'How do I access the high water mark in PURCHASES table?'
        ,'Show me the high water mark of the USER_LOGS table.'
        ,'What is the high water mark for table EMPLOYEES?'
        ,'What is the high water mark for the SHIPPING_DETAILS table?'
        ,'Can I check the LEADS table''s high water mark?'
        ,'What is the high water mark on the EMPLOYEE_BENEFITS table?'
        ,'Display the high water mark for TRANSACTIONS table.'
        ,'How do I retrieve the high water mark for the SALES table?'
        ,'What is the INVOICES table''s high water mark?'
        ,'How do I find the high water mark of SALES table?'
        ,'Can I view the high water mark for the LEADS table?'
        ,'Where is the high water mark for PRODUCT_CATALOG?'
        ,'What is the high water mark for RETURNS table?'
        ,'Provide the high water mark for PROJECTS table.'
        ,'How to find SUPPORT_TICKETS'' high water mark?'
        ,'What is the high water mark of the INVOICES table?'
        ,'Can you find the high water mark for the FEEDBACK table?'
        ),
        p_match_document       => JSON('{"sql": "SELECT blocks, empty_blocks FROM dba_tables WHERE table_name = ''EMP''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Tables Without Primary Keys',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify tables lacking a primary key constraint.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show tables without a primary key.'
        ,'List all tables lacking primary key constraints.'
        ,'Are primary keys mandatory for tables with indexes?'
        ,'Do any schemas have tables without primary keys?'
        ,'Show tables that need primary key constraints.'
        ,'Which tables don''t have a primary key?'
        ,'Are there any tables with missing primary keys?'
        ,'Which tables are without primary key constraints?'
        ,'Are there tables missing primary key constraints?'
        ,'Are primary key constraints required for tables with foreign keys?'
        ,'What tables are missing primary key constraints?'
        ,'Are there any security risks associated with tables without primary keys?'
        ,'Identify tables without primary keys.'
        ,'Are there any tables without primary keys?'
        ,'Find schemas with tables missing primary keys.'
        ,'How do I enforce primary key constraints on existing tables?'
        ,'Are there tables without a primary key constraint?'
        ,'Are there any consequences of not having primary keys?'
        ,'List all tables with missing primary key constraints.'
        ,'Do any tables lack primary key constraints?'
        ,'Are there any performance benefits to having primary keys on all tables?'
        ,'Which schemas have tables without primary keys?'
        ,'List schemas with tables lacking primary keys.'
        ,'Can you list tables without primary keys and their storage sizes?'
        ,'Are primary key constraints missing in any tables?'
        ,'Are primary keys required for all tables?'
        ,'Do all tables in my schema have primary keys?'
        ,'Can you show me a list of tables without primary keys and their creation dates?'
        ,'Do tables without primary keys affect performance?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name FROM dba_tables WHERE table_name NOT IN (SELECT table_name FROM dba_constraints WHERE constraint_type = ''P'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Unused Indexes',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Detect indexes that have not been analyzed recently.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What indexes need reanalysis?'
        ,'Which indexes haven''t been updated recently?'
        ,'Are there indexes with stale stats?'
        ,'How can I find stale indexes?'
        ,'Find indexes with expired statistics.'
        ,'List indexes needing a statistical update.'
        ,'Are there indexes with incomplete analysis?'
        ,'Which indexes have incomplete stats?'
        ,'What indexes haven''t been analyzed recently?'
        ,'Detect indexes with inconsistent stats.'
        ,'Detect indexes with missing analysis.'
        ,'Show me indexes with stale data.'
        ,'What indexes have outdated stats?'
        ,'Show indexes lacking recent analysis.'
        ,'Which indexes require fresh analysis?'
        ,'Which indexes are missing recent analysis?'
        ,'How to detect neglected indexes?'
        ,'List indexes with stale statistical info.'
        ,'List indexes with no recent stats.'
        ,'Detect indexes with stale analysis.'
        ,'Identify indexes with outdated data.'
        ,'Find indexes overdue for analysis.'
        ,'Which indexes have old data?'
        ,'Find indexes that require re-validation.'
        ,'Are there any indexes with expired stats?'
        ,'Which indexes have outdated statistical information?'
        ,'Which indexes require a stats update?'
        ,'Find indexes that need a refresh.'
        ,'List indexes with expired analysis.'
        ),
        p_match_document       => JSON('{"sql": "SELECT index_name, table_name FROM dba_indexes WHERE last_analyzed IS NULL", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List Partitions of a Table',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all partitions of a specified table.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Display partition details for the ''collections'' table.'
        ,'What are the partitioning details for the ''jobs'' table?'
        ,'List the partitions of the ''metrics'' table.'
        ,'List all partitions for the ''views'' table.'
        ,'Show partitions of the ''inventory'' table.'
        ,'List the partitions of the ''objects'' table.'
        ,'What partitions are in the ''privileges'' table?'
        ,'What are the partition details for the ''relationships'' table?'
        ,'List all partitions of the ''cache'' table.'
        ,'What are the partition names for the ''orders'' table?'
        ,'What partitions exist in the ''audit'' table?'
        ,'How many partitions does the ''sales'' table have?'
        ,'What partitions exist in the ''indexes'' table?'
        ,'Which partitions exist for the ''customers'' table?'
        ,'Enumerate the partitions of the ''alerts'' table.'
        ,'What tables have the most partitions?'
        ,'What partitions exist in the ''security'' table?'
        ,'What are the partitioning details for the ''files'' table?'
        ,'What is the partitioning scheme for the ''schema'' table?'
        ,'What partitions are defined for the ''performance'' table?'
        ,'How is the ''temp_data'' table partitioned?'
        ,'List all partitions for the ''configuration'' table.'
        ,'Show all partitions for the ''archive_data'' table.'
        ,'Provide partition names for the ''logins'' table.'
        ,'What partitions are in the ''programs'' table?'
        ,'Enumerate partitions for the ''finance'' table.'
        ,'Display all partitions for the ''user_data'' table.'
        ,'What partitions does the ''functions'' table have?'
        ,'What are the partition names for the ''services'' table?'
        ),
        p_match_document       => JSON('{"sql": "SELECT partition_name, high_value FROM dba_tab_partitions WHERE table_name = ''SALES''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check RMAN Backup History',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Review recent RMAN backup jobs and their statuses.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the statuses of recent RMAN backup jobs?'
        ,'What is the average size of RMAN backups?'
        ,'When is the next full RMAN backup scheduled?'
        ,'What errors occurred in recent RMAN backups?'
        ,'What is the success rate of RMAN backups for the last month?'
        ,'What is the next scheduled RMAN backup?'
        ,'When was the lastest RMAN backup completed?'
        ,'List all databases with no recent RMAN backups.'
        ,'When is the next RMAN backup due?'
        ,'Did any RMAN backup jobs encounter warnings?'
        ,'What is the total duration of all RMAN backups today?'
        ,'How many RMAN backups are running now?'
        ,'List all RMAN backup jobs with errors.'
        ,'How many RMAN backups are overdue for more than a week?'
        ,'List recent successful RMAN backup jobs.'
        ,'Are there any RMAN backup jobs in progress?'
        ,'What is the frequency of RMAN backup failures?'
        ,'When was the last full RMAN backup performed?'
        ,'How many RMAN backups failed recently?'
        ,'Are there any RMAN backup jobs that are still running from yesterday?'
        ,'How many RMAN backups are scheduled this week?'
        ,'Which RMAN job had the shortest runtime recently?'
        ,'Are there any RMAN backups overdue?'
        ,'What is the frequency of successful RMAN backups?'
        ,'How many RMAN backups were completed last week?'
        ,'What is the status of the most recent RMAN backup?'
        ,'Are there any failed RMAN backups today?'
        ,'List all recent RMAN backup jobs.'
        ,'List RMAN backup jobs by database name.'
        ),
        p_match_document       => JSON('{"sql": "SELECT start_time, status, input_type FROM v$rman_backup_job_details ORDER BY start_time DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Datafiles in Backup Mode',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify datafiles currently in backup mode.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you identify datafiles in backup mode by their storage location?'
        ,'Can you show me the backup mode status of datafiles for a specific database instance?'
        ,'List all datafiles in backup mode.'
        ,'Identify backup mode datafiles by creation date.'
        ,'What datafiles are currently locked in backup mode?'
        ,'How long have datafiles been in backup mode?'
        ,'What is the status of datafiles in backup mode?'
        ,'Can you list datafiles in backup mode, along with their corresponding tablespaces?'
        ,'Are datafiles in backup mode during maintenance?'
        ,'Are all datafiles in backup mode?'
        ,'How can I receive alerts when a datafile enters backup mode?'
        ,'Are there any datafiles that are always in backup mode?'
        ,'Is backup mode active for any datafiles?'
        ,'Retrieve datafiles currently in backup mode.'
        ,'How do I check if all datafiles are in backup mode during a specific time?'
        ,'Are there datafiles stuck in backup mode?'
        ,'Can I get a list of datafiles that entered backup mode today?'
        ,'Datafiles in backup mode: names and paths?'
        ,'How can I check if a specific datafile is in backup mode?'
        ,'Confirm if datafile X is in backup mode.'
        ,'Can you list datafiles in backup mode, sorted by size?'
        ,'What is the average time datafiles spend in backup mode?'
        ,'Which datafiles have been in backup mode the longest?'
        ,'Are specific datafiles in backup mode?'
        ,'Which datafiles exited backup mode recently?'
        ,'How many datafiles are currently in backup mode?'
        ,'List datafiles in backup mode by tablespace.'
        ,'What is the total size of all datafiles in backup mode?'
        ,'Are there any datafiles in backup mode that are not being backed up?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$backup WHERE status = ''ACTIVE''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Tables With High Row Migration',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List tables experiencing high row migration counts.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you show tables with abnormal row migration patterns?'
        ,'Identify tables with row migration problems now.'
        ,'Which tables are most affected by row migration?'
        ,'What tables are prone to row migration?'
        ,'Which tables have row migration problems that need attention?'
        ,'Can you show me tables with row migration warnings?'
        ,'What tables are affected by high row migration counts?'
        ,'Are there tables with unusually high row migration?'
        ,'How can I identify tables with excessive row migration?'
        ,'What tables have row migration issues that need fixing?'
        ,'List tables experiencing row migration difficulties.'
        ,'What tables have the highest row migration rates?'
        ,'Which tables have the highest row migration?'
        ,'What tables are experiencing excessive row migration?'
        ,'List tables with significant row migration counts.'
        ,'Which tables suffer most from row migration?'
        ,'How to find tables with row migration bottlenecks?'
        ,'Identify any tables with row migration alerts.'
        ,'Which tables need checking for row migration?'
        ,'Which tables need optimization due to row migration?'
        ,'Can you list tables with row migration concerns?'
        ,'Identify tables with high row migration statistics.'
        ,'How to detect tables with row migration?'
        ,'Can you list tables with row migration alerts now?'
        ,'Which tables show high row migration activity?'
        ,'Are there tables with row migration anomalies?'
        ,'Which tables are prone to row migration errors?'
        ,'What tables are impacted by row migration?'
        ,'What tables have high row migration statistics today?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, chain_cnt FROM dba_tables WHERE chain_cnt > 0", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check CPU Usage by SQL Statements',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify SQL statements consuming the most CPU time.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'List SQL statements with top CPU demand.'
        ,'Find SQL statements with high CPU consumption.'
        ,'What are the SQLs with peak CPU time?'
        ,'Which queries have high CPU utilization?'
        ,'Which SQL statements cause high CPU usage?'
        ,'List SQLs with significant CPU usage.'
        ,'Which SQL statements have high CPU costs?'
        ,'How can I find SQLs with the most CPU load?'
        ,'List top CPU-using SQL statements.'
        ,'Which SQL statements have peak CPU time?'
        ,'What SQL queries are CPU resource-intensive?'
        ,'Identify SQL with excessive CPU load.'
        ,'Which queries are using the most CPU resources?'
        ,'Which SQL queries are CPU bottlenecks?'
        ,'Show SQL queries with high CPU consumption.'
        ,'What SQL consumes the most CPU time?'
        ,'How do I identify CPU-heavy SQL workloads?'
        ,'List SQL statements with significant CPU demands.'
        ,'Show SQL statements with high CPU demand.'
        ,'Find the SQLs with the highest CPU load.'
        ,'What are the top 5 SQLs by CPU usage?'
        ,'What SQL queries have excessive CPU usage?'
        ,'How to find SQLs that max out CPU?'
        ,'Find SQLs with maximum CPU utilization.'
        ,'What SQL queries are CPU performance issues?'
        ,'How to detect CPU-heavy SQL statements?'
        ,'Find SQLs with the highest CPU usage.'
        ,'Which SQL queries strain CPU resources?'
        ,'Which SQL statements are CPU bottlenecks?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, sql_text, cpu_time FROM v$sql ORDER BY cpu_time DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Buffer Cache Hit Ratio',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Calculate the buffer cache hit ratio for performance.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Does buffer cache size affect hit ratio?'
        ,'Can buffer cache hit ratio be improved by adjusting database parameters?'
        ,'What are the signs of buffer cache hit ratio problems?'
        ,'How often does buffer cache hit ratio change?'
        ,'How does the buffer cache hit ratio affect Oracle database licensing costs?'
        ,'Why is my buffer cache hit ratio low?'
        ,'How do I interpret buffer cache hit ratio results?'
        ,'How does buffer cache hit ratio affect query speed?'
        ,'Can buffer cache hit ratio be used to predict database growth?'
        ,'How does the buffer cache hit ratio impact database security?'
        ,'What is the impact of buffer cache hit ratio on database health?'
        ,'Can I set a target buffer cache hit ratio for my database?'
        ,'What tools can help me analyze buffer cache hit ratio trends?'
        ,'Can buffer cache hit ratio be used to evaluate database administrator performance?'
        ,'How does the buffer cache hit ratio impact database recovery time?'
        ,'Can a high buffer cache hit ratio reduce the need for indexing?'
        ,'What is the formula for buffer cache hit ratio?'
        ,'What tools monitor buffer cache hit ratio?'
        ,'How does disk I/O affect buffer cache hit ratio?'
        ,'How do I calculate the buffer cache hit ratio?'
        ,'How does the buffer cache hit ratio impact Oracle database support costs?'
        ,'How can I improve the buffer cache hit ratio?'
        ,'How does buffer cache hit ratio influence memory allocation?'
        ,'What are the best practices for documenting buffer cache hit ratio results?'
        ,'How does the buffer cache hit ratio affect database backup time?'
        ,'How often should I check the buffer cache hit ratio?'
        ,'What SQL query retrieves the buffer cache hit ratio?'
        ,'How does buffer cache hit ratio correlate with CPU usage?'
        ,'Can buffer cache hit ratio be used to predict database performance?'
        ),
        p_match_document       => JSON('{"sql": "SELECT (1 - (physical_reads / consistent_gets)) * 100 AS hit_ratio FROM v$buffer_pool_statistics", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Library Cache Hit Ratio',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Determine the hit ratio of the library cache.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the significance of the library cache hit ratio in Oracle?'
        ,'What are the best practices for monitoring library cache hit ratio in a cloud environment?'
        ,'What is the role of bind variables in library cache hit ratio?'
        ,'How does the library cache hit ratio relate to latch contention?'
        ,'How can I improve the library cache hit ratio?'
        ,'Can a high library cache hit ratio lead to performance issues?'
        ,'What is the role of the shared pool in determining library cache hit ratio?'
        ,'How can I automate monitoring of the library cache hit ratio?'
        ,'How can I use Oracle Enterprise Manager to monitor library cache hit ratio?'
        ,'How do I calculate the library cache hit ratio?'
        ,'How does the library cache hit ratio affect Oracle''s multitenant architecture?'
        ,'How to monitor library cache hit ratio trends?'
        ,'How do shared pool settings impact the library cache hit ratio?'
        ,'How does the library cache hit ratio impact database upgrade performance?'
        ,'What is the impact of a poor library cache hit ratio?'
        ,'How does the library cache hit ratio change over time?'
        ,'How does the library cache hit ratio impact database scalability?'
        ,'What is the relationship between library cache hit ratio and disk I/O?'
        ,'How can I use Oracle''s SQL Tuning Advisor to improve library cache hit ratio?'
        ,'What are the symptoms of a low library cache hit ratio?'
        ,'What is the historical trend of my library cache hit ratio?'
        ,'How often should I check the library cache hit ratio?'
        ,'What is the formula for library cache hit ratio?'
        ,'How does the library cache hit ratio affect database throughput?'
        ,'How does the library cache hit ratio affect Exadata performance?'
        ,'What is the difference between library cache hit ratio and result cache hit ratio?'
        ,'What is the minimum library cache hit ratio for optimal performance?'
        ,'Can I use Oracle''s Automatic Workload Repository (AWR) to analyze library cache hit ratio?'
        ,'Can I use SQL tracing to analyze library cache hit ratio issues?'
        ),
        p_match_document       => JSON('{"sql": "SELECT (sum(pinhits) / sum(pins)) * 100 AS lib_cache_hit_ratio FROM v$librarycache", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check SQL Using Full Table Scans',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find SQL statements performing full table scans.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the impact of full table scans on database throughput?'
        ,'Which SQL statements need indexing to prevent full scans?'
        ,'Can I get a list of SQL statements with full table scans by user?'
        ,'What is the correlation between full table scans and database errors?'
        ,'How do I monitor full table scans in real-time?'
        ,'What are the most common causes of full table scans?'
        ,'What SQL statements are performing full table scans most frequently?'
        ,'Are full table scans causing contention on database resources?'
        ,'Can you show me the SQL statements with the highest full scan costs?'
        ,'Is there a pattern in SQL performing full table scans?'
        ,'Which indexes can help reduce full table scans?'
        ,'Are there any full table scans in the last 24 hours?'
        ,'Which user queries are causing full table scans?'
        ,'What indexes could prevent current full table scans?'
        ,'Are full table scans affecting query speed?'
        ,'What are the best practices to avoid full table scans?'
        ,'What SQL statements are causing full table scans?'
        ,'What is the average duration of full table scans?'
        ,'What is the impact of full table scans on performance?'
        ,'How do I reduce full table scans in my database?'
        ,'What queries should I optimize to avoid full table scans?'
        ,'Which queries are performing full table scans?'
        ,'Can you recommend indexes to prevent full table scans?'
        ,'How do I identify SQL statements with unnecessary full table scans?'
        ,'How do I analyze the performance impact of full table scans?'
        ,'How frequently do full table scans occur?'
        ,'Can I see a report of recent full table scans?'
        ,'Are full table scans impacting database availability?'
        ,'What are the trends in full table scans over time?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, sql_text FROM v$sql WHERE executions > 50 AND sql_text LIKE ''%FULL%SCAN%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Queries Without Index Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify queries that do not utilize indexes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which SQL operations are not using indexes effectively?'
        ,'Queries executing without indexes?'
        ,'What are the top resource-intensive queries without indexes?'
        ,'What queries are executing without index assistance?'
        ,'Which queries are devoid of index use?'
        ,'Which queries are not using indexes for data retrieval?'
        ,'Are there SQLs not leveraging indexes?'
        ,'How to find queries with index underutilization?'
        ,'Identify non-indexed queries.'
        ,'What are the top queries without index support?'
        ,'Can you identify queries that need index optimization?'
        ,'Are there any index-less queries?'
        ,'Identify queries with low index usage percentage.'
        ,'How to detect queries with index misuse?'
        ,'What queries are not optimized with indexes?'
        ,'Show me SQL statements with minimal index involvement.'
        ,'How to find queries with index-related performance issues?'
        ,'How to find index-neglecting queries?'
        ,'How to detect queries with index-related errors?'
        ,'Are there queries bypassing indexes?'
        ,'Are there any queries that are not using indexes for aggregate functions?'
        ,'What are the queries that ignore index recommendations?'
        ,'Queries executing without index help?'
        ,'What queries are not leveraging indexes for joining?'
        ,'Which operations do not use indexes?'
        ,'How to spot queries not using indexes?'
        ,'Are there queries not using indexes?'
        ,'Which queries are not using indexes?'
        ,'Which SQL statements lack index usage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, sql_text FROM v$sql WHERE executions > 10 AND sql_text NOT LIKE ''%INDEX%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Constraints in a Schema',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all constraints within a specified schema.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the primary key constraints in a schema?'
        ,'List constraints that are system-generated.'
        ,'What constraints exist in the PROJECT_MANAGEMENT schema?'
        ,'What are the constraints in the ACCOUNTING_AUDIT schema?'
        ,'What constraints are defined in the EMPLOYEE schema?'
        ,'What are the constraints in the ACCOUNTING schema?'
        ,'What constraints are present in the SUPPLY_CHAIN schema?'
        ,'Can you display constraints for system tables?'
        ,'List constraints for a specific table.'
        ,'Show all constraints for the INVENTORY schema.'
        ,'Retrieve unique constraints for a table.'
        ,'Which constraints are in the PRODUCT_CATALOG schema?'
        ,'Show constraints in the SHIPPING schema.'
        ,'Which schema has the most constraints?'
        ,'List all constraints in the FINANCE schema.'
        ,'Can you display foreign key constraints?'
        ,'Retrieve constraints that are relevant to performance.'
        ,'What constraints exist in the PAYROLL schema?'
        ,'List constraints with a specific name.'
        ,'Provide constraints in the PAYROLL_PROCESSING schema.'
        ,'Provide constraints for the SALES_REPORTS schema.'
        ,'Retrieve constraints for a materialized view.'
        ,'Retrieve constraints in the INVENTORY_MGMT schema.'
        ,'Display constraints in the MARKETING_ANALYTICS schema.'
        ,'Show all constraints for the ORDER_PROCESSING schema.'
        ,'List constraints within the PROCUREMENT schema.'
        ,'Which constraints are enabled in the schema?'
        ,'List constraints for the ORDERS schema.'
        ,'Can you provide user-defined constraints?'
        ),
        p_match_document       => JSON('{"sql": "SELECT constraint_name, table_name, constraint_type FROM dba_constraints WHERE owner = ''SCOTT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Triggers in a Schema',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve all triggers defined within a specified schema.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which triggers are enabled in a schema?'
        ,'Are there any triggers on temporary tables?'
        ,'List all triggers in the LEGAL schema.'
        ,'How to find triggers in a newly created schema?'
        ,'Provide details of triggers on a specific table.'
        ,'How many triggers are in the FINANCE schema?'
        ,'Which triggers are active in the CRM schema?'
        ,'What triggers are in the IT schema?'
        ,'Retrieve triggers from all schemas.'
        ,'Retrieve the trigger list from the SECURITY schema.'
        ,'Any disabled triggers in the SALES schema?'
        ,'How to list triggers in the OPERATIONS schema?'
        ,'Are there any triggers on a particular table?'
        ,'Do triggers exist on system tables?'
        ,'How many triggers are defined on a specific table?'
        ,'Do triggers exist on materialized views?'
        ,'What triggers are used for auditing?'
        ,'List triggers that are defined on synonyms.'
        ,'Retrieve active triggers in the TRAINING schema.'
        ,'How many triggers are active?'
        ,'How to retrieve triggers that are used for performance monitoring?'
        ,'Retrieve triggers that are used for security.'
        ,'What triggers exist in the PUBLIC_RELATIONS schema?'
        ,'What are the trigger names in the MARKETING schema?'
        ,'What are the names of disabled triggers?'
        ,'What are the names of triggers that start with a specific letter?'
        ,'List all triggers in the SALES schema.'
        ,'Retrieve triggers from the ACCOUNTING schema.'
        ,'Show triggers that are owned by a specific user.'
        ),
        p_match_document       => JSON('{"sql": "SELECT trigger_name, table_name, status FROM dba_triggers WHERE owner = ''SCOTT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Views in a Schema',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all views within a specified schema.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which views are listed in the STRATEGY schema?'
        ,'List all views that are related to a certain business area.'
        ,'Which views are present in the INVENTORY schema?'
        ,'Display all views in the DATA_WAREHOUSE schema.'
        ,'What views are dependent on a specific package?'
        ,'List all views in a specific directory.'
        ,'Are there views in the default schema?'
        ,'Give me a list of views in a certain tablespace.'
        ,'How many views are in the system schema?'
        ,'What are the views under the TRAINING schema?'
        ,'Display views from the LOGISTICS schema.'
        ,'Are there any views in the RESEARCH schema?'
        ,'List views for a specific user.'
        ,'How many views exist in the SECURITY schema?'
        ,'How many views are in a certain schema category?'
        ,'What views exist in the HR schema?'
        ,'Enumerate views in the PROCUREMENT schema.'
        ,'Display views that start with a specific letter.'
        ,'What views are available for a certain application?'
        ,'Identify views in the PROJECT_MANAGEMENT schema.'
        ,'What views are available to a certain user?'
        ,'Tell me the views in the PLANNING schema.'
        ,'What views are defined in the public schema?'
        ,'Identify views within the MARKETING schema.'
        ,'List views from the HUMAN_RESOURCES schema.'
        ,'Show all views under the SALES schema.'
        ,'Show me views that are related to a specific table.'
        ,'What views can be accessed by a certain role?'
        ,'Give me views from the DEVELOPMENT schema.'
        ),
        p_match_document       => JSON('{"sql": "SELECT view_name FROM dba_views WHERE owner = ''SCOTT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find the Size of a Table',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Determine the size of a specific table in megabytes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Check \"products\" table size in megabytes.'
        ,'How large is the \"marketing\" table?'
        ,'Report the size of \"hr_records\" in MB.'
        ,'Determine the size of \"sessions\" in MB.'
        ,'What is the megabyte size of \"security_logs\"?'
        ,'What is the megabyte size of \"products\" table?'
        ,'What is the size of \"employees_backup\" table in megabytes?'
        ,'Determine the size of \"backup_files\" table in MB.'
        ,'What is the size of \"orders\" table in megabytes?'
        ,'How big is the \"transactions\" table in megabytes?'
        ,'Report the size of \"returns\" in MB.'
        ,'How many megabytes is the \"orders\" table?'
        ,'How many megabytes does \"temp_storage\" use?'
        ,'Can you find the MB size of \"receipts\" table?'
        ,'How many MB does \"receipts\" table use?'
        ,'What is the size of \"audit\" table in MB?'
        ,'What is the size of \"logs\" table in MB?'
        ,'What is the size of \"departments\" in MB?'
        ,'How big is the \"accounts\" table in MB?'
        ,'How big is the \"archive_data\" table?'
        ,'What is the size of \"project_data\" in MB?'
        ,'How many MB does the \"temp_storage\" table occupy?'
        ,'Determine the megabyte size of \"suppliers\".'
        ,'How large is the \"employees\" table in MB?'
        ,'Determine the size of \"accounts\" table in MB.'
        ,'Report the MB size of \"transactions\" table.'
        ,'Check the megabyte size of \"shippings\" table.'
        ,'Check the size of \"financials\" table in MB.'
        ,'How big is the \"marketing\" table in megabytes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT segment_name, bytes/1024/1024 AS size_mb FROM dba_segments WHERE segment_type = ''TABLE'' AND segment_name = ''EMPLOYEES''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Database Growth Over Time',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Analyze database growth by tracking file size changes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How much has the database grown since its inception?'
        ,'Is there a particular tablespace growing unexpectedly fast?'
        ,'Which data files have increased in size recently?'
        ,'How does current database growth compare to budget projections?'
        ,'How frequently are data files being resized?'
        ,'What is the historical growth pattern of each tablespace?'
        ,'What is the average daily growth of the database?'
        ,'Are there any anomalies in file size changes?'
        ,'What is the minimum size reached by any file?'
        ,'How much has each tablespace grown since last year?'
        ,'How has the database size changed over the last month?'
        ,'What was the growth rate of the database last year?'
        ,'Which file has shown the least growth recently?'
        ,'What is the trend in database size growth over the last five years?'
        ,'Are there any files that have not changed in size recently?'
        ,'What is the projected growth for the next year?'
        ,'Has any data file been removed or deleted recently?'
        ,'What was the size of the database last week?'
        ,'How much space is left before reaching capacity?'
        ,'What is the projected growth for the next quarter?'
        ,'Has any file exceeded its maximum allocated size?'
        ,'Can you list the top three largest files in the database?'
        ,'Which tablespace is currently using the most space?'
        ,'What is the maximum size reached by any file?'
        ,'Can you summarize the quarterly growth statistics?'
        ,'What is the total size of all tablespaces combined?'
        ,'Can you summarize the monthly growth statistics?'
        ,'What is the total growth in size over the last year?'
        ,'Can you list the top five rapidly growing files?'
        ),
        p_match_document       => JSON('{"sql": "SELECT TO_CHAR(creation_time, ''YYYY-MM-DD'') AS date, SUM(bytes)/1024/1024 AS size_mb FROM dba_data_files GROUP BY TO_CHAR(creation_time, ''YYYY-MM-DD'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Temporary Tablespace Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the usage of temporary tablespaces in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many temporary tablespaces are configured for auto-extend?'
        ,'How often are temporary tablespaces resized?'
        ,'How many temporary tablespaces are configured?'
        ,'How does temporary tablespace usage impact database performance metrics?'
        ,'Are there any alerts for temporary tablespace usage?'
        ,'Can you provide a historical usage report for temporary tablespaces?'
        ,'How does temporary tablespace usage compare to last month?'
        ,'What is the growth rate of temporary tablespace usage?'
        ,'Which temporary tablespace has the highest usage?'
        ,'How often do temporary tablespaces exceed 80% usage?'
        ,'What is the temporary tablespace usage trend for the last quarter?'
        ,'Are there any temporary tablespaces with a high number of extents?'
        ,'How does temporary tablespace usage affect database backup time?'
        ,'What is the average daily usage of temporary tablespaces?'
        ,'Are any temporary tablespaces nearing full capacity?'
        ,'Which temporary tablespace is used most frequently?'
        ,'Do any temporary tablespaces have auto-extend enabled?'
        ,'What is the average temporary tablespace usage per session?'
        ,'What is the largest temporary tablespace by size?'
        ,'How does temporary tablespace usage affect database startup time?'
        ,'Can you show the temporary tablespace usage for a specific SQL query?'
        ,'Can you list the temporary tablespaces that are not being used?'
        ,'What is the current usage percentage of temporary tablespaces?'
        ,'Is there a temporary tablespace with zero usage?'
        ,'How much free space is available in temporary tablespaces?'
        ,'How often are temporary tablespace usage reports generated?'
        ,'What is the smallest temporary tablespace by usage?'
        ,'Can you list all temporary tablespaces by usage?'
        ,'Which temporary tablespace has the highest average usage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, SUM(bytes)/1024/1024 AS used_mb FROM dba_temp_files GROUP BY tablespace_name", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Export Jobs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all export jobs executed in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you list export jobs executed by department?'
        ,'How often are export jobs executed?'
        ,'Are there any failed export jobs?'
        ,'What export jobs were executed in the last 24 hours?'
        ,'List export jobs executed on weekends.'
        ,'Which export jobs are currently running?'
        ,'Can you list export jobs by job name?'
        ,'Which export jobs have completed successfully?'
        ,'What export jobs were executed by a specific user role?'
        ,'List export jobs with their start time.'
        ,'Can you list export jobs executed in a specific time range?'
        ,'What are the names of the executed export jobs?'
        ,'Show export jobs executed by user.'
        ,'List export jobs executed with a specific level of logging.'
        ,'What export jobs were executed overnight?'
        ,'What is the total number of export jobs executed?'
        ,'Which export jobs were executed during maintenance hours?'
        ,'List export jobs by execution date.'
        ,'List export jobs by priority.'
        ,'List export jobs executed on a specific day of the week.'
        ,'List export jobs executed with a specific degree of parallelism.'
        ,'Are there any export jobs executing now?'
        ,'List export jobs by export type.'
        ,'List export jobs executed by database instance.'
        ,'Can you list export jobs executed by a specific team?'
        ,'Show export jobs executed in the last quarter.'
        ,'Which export jobs were executed in October?'
        ,'What export jobs were executed using a specific export method?'
        ,'Which export jobs were executed with a specific option?'
        ),
        p_match_document       => JSON('{"sql": "SELECT job_name, state, operation, job_mode FROM dba_datapump_jobs WHERE operation = ''EXPORT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Import Jobs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all import jobs executed in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you list import jobs by job ID?'
        ,'How many import jobs succeeded today?'
        ,'Can you list import jobs that were executed concurrently?'
        ,'Are there any import jobs with errors today?'
        ,'Which import job had the most warnings?'
        ,'How many import jobs were executed this year?'
        ,'Can you list import jobs by execution date?'
        ,'What were the parameters of the last import job?'
        ,'What is the status of import jobs executed yesterday?'
        ,'What import jobs were executed by schema X?'
        ,'Are there any import jobs scheduled for tomorrow?'
        ,'What import jobs were executed using a specific parameter?'
        ,'Which import job had the most errors?'
        ,'What import jobs were executed by user X?'
        ,'Can you show the top 5 longest import jobs?'
        ,'What is the total number of import jobs executed?'
        ,'What import jobs were executed yesterday?'
        ,'How many import jobs were executed per day last week?'
        ,'What was the size of the last import job?'
        ,'What import jobs were executed last quarter?'
        ,'Can you show import jobs with no errors?'
        ,'When was the last import job executed?'
        ,'What import jobs were executed during peak hours?'
        ,'What are the details of today''s import jobs?'
        ,'Which user executed the last import job?'
        ,'Can you list import jobs by schema and user?'
        ,'What is the status of the latest import job?'
        ,'What is the earliest recorded import job?'
        ,'Can you show the import job with the smallest size?'
        ),
        p_match_document       => JSON('{"sql": "SELECT job_name, state, operation, job_mode FROM dba_datapump_jobs WHERE operation = ''IMPORT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Flashback Logs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'View flashback logs for database recovery purposes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the benefits of using flashback logs?'
        ,'Can I configure flashback log retention for a specific tablespace?'
        ,'How often are flashback logs generated?'
        ,'How do I know if flashback logging is enabled?'
        ,'How to set flashback log retention policy?'
        ,'How do flashback logs assist in recovery?'
        ,'Can I use flashback logs to recover a database to a previous version?'
        ,'Can I delete old flashback logs?'
        ,'What is the minimum retention period for flashback logs?'
        ,'How to check flashback log space allocation?'
        ,'Can flashback logs be archived?'
        ,'What is the recommended retention period for flashback logs?'
        ,'What is the relationship between flashback logs and database backups?'
        ,'How to check flashback log configuration settings?'
        ,'How do I monitor flashback log growth?'
        ,'What is the impact of disabling flashback logging?'
        ,'Can I use flashback logs to recover a deleted user?'
        ,'What command lists all flashback logs?'
        ,'What is the difference between flashback log retention and purge?'
        ,'Can I use flashback logs to recover a database after a hardware failure?'
        ,'How to check flashback log performance impact?'
        ,'How to verify flashback log integrity?'
        ,'How to restore using flashback logs?'
        ,'How to find flashback log file location?'
        ,'How to view flashback log history?'
        ,'Can I use flashback logs to recover a corrupted database?'
        ,'How to verify flashback log availability?'
        ,'Can I automate flashback log monitoring?'
        ,'How to configure flashback log retention?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$flashback_database_log", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Flashback a Table',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Revert a table to a previous state using flashback technology.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to verify a table''s state after a flashback?'
        ,'How to ensure data integrity after a flashback?'
        ,'How do I enable flashback on a specific table?'
        ,'What happens to indexes during a table flashback?'
        ,'Can I flashback a table that has been modified by a SQL script?'
        ,'Can I flashback a table to a specific point in time?'
        ,'How to check flashback logs for a specific table?'
        ,'Can flashback be used in a multi-tenant database?'
        ,'How do I verify the integrity of a table after a flashback?'
        ,'What are the security implications of using table flashback?'
        ,'Can flashback be performed on a read-only table?'
        ,'What permissions are required for table flashback?'
        ,'Can flashback be used to recover from a table corruption?'
        ,'Can I use flashback to revert a table to a previous backup?'
        ,'How does flashback impact table performance?'
        ,'How does flashback affect table dependencies?'
        ,'What are the risks of using table flashback?'
        ,'How do I monitor flashback operations in real-time?'
        ,'What are the limitations of flashing back a table with LOB columns?'
        ,'Can I use flashback to revert a table to a previous incarnation?'
        ,'Can I revert a table without losing current data?'
        ,'Can I use flashback to recover from a failed DML operation?'
        ,'How do I revert a table to a previous version?'
        ,'Can I flashback a table that has been modified by a materialized view?'
        ,'What are the considerations for flashback in a database with Oracle Label Security enabled?'
        ,'What are the best practices for testing flashback operations?'
        ,'How do I check if flashback is enabled for a table?'
        ,'What limitations exist for using table flashback?'
        ,'How to find the timestamp for table flashback?'
        ),
        p_match_document       => JSON('{"sql": "FLASHBACK TABLE employees TO TIMESTAMP (SYSTIMESTAMP - INTERVAL ''5'' MINUTE)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Orphaned Rows',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify rows in a child table without corresponding parent entries.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show child rows with parent IDs that are null.'
        ,'Are there any child tables with all rows orphaned?'
        ,'How to list child records missing parents?'
        ,'Identify child rows with invalid parent references.'
        ,'Show all child tables with no parent links.'
        ,'Which child entries are parentless?'
        ,'Are there any child entries missing parents?'
        ,'List child table entries lacking parents.'
        ,'Find child rows with no matching parent records.'
        ,'Identify orphaned rows in the child table.'
        ,'Identify child table entries missing parents.'
        ,'Which child tables have orphaned rows that are causing issues?'
        ,'List child rows with missing parent IDs in a specific table.'
        ,'List orphaned records in the child table.'
        ,'Are there any child tables with orphaned rows that need attention?'
        ,'List child rows with no parent connections in a specific schema.'
        ,'How many orphaned child records exist?'
        ,'Are there child rows unlinked to parents?'
        ,'Locate orphaned child entries.'
        ,'Which tables have orphaned child rows?'
        ,'Show all child rows with orphaned status.'
        ,'What child rows have missing parent entries?'
        ,'Find child rows with no parent link.'
        ,'Which child rows lack parent entries?'
        ,'Which child records are missing parent links?'
        ,'Are there any child rows with duplicate parent IDs?'
        ,'Are there any orphaned records in the database?'
        ,'What is the percentage of orphaned child rows in a table?'
        ,'What child table rows lack parent records?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM child_table WHERE foreign_key_column NOT IN (SELECT primary_key_column FROM parent_table)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Tables Without Data',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find tables in the database that contain no data.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any tables with no data or records?'
        ,'What tables have zero data rows?'
        ,'Which tables have no data and no records?'
        ,'How to detect tables with no data?'
        ,'How to check for empty tables in the database?'
        ,'Show me tables with no data in the schema.'
        ,'Identify tables with no existing data.'
        ,'What tables have zero data and are empty?'
        ,'Find tables that have no data and are empty.'
        ,'Can you show me tables with zero data and no entries?'
        ,'Locate tables with no data.'
        ,'Which tables have no data entries?'
        ,'Are there any empty tables in the database?'
        ,'List all empty tables in the database.'
        ,'What tables have no records in the database?'
        ,'How to find empty tables in the current database?'
        ,'List all tables without data.'
        ,'How to list tables with no data?'
        ,'Are there tables with no data entries in the database?'
        ,'How to identify tables with no data rows?'
        ,'Which tables in the database are empty?'
        ,'Find tables with no existing records.'
        ,'Show tables that have no data and no entries.'
        ,'Are there any tables without data?'
        ,'How to check for tables with no rows?'
        ,'Can you identify tables with zero data?'
        ,'Identify tables with no data in the current schema.'
        ,'Which tables in the schema are empty?'
        ,'Which tables in the database have no content?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name FROM dba_tables WHERE num_rows = 0", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Tables with High Delete Counts',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify tables with a high number of delete operations.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What tables have delete operations that are impacting data consistency?'
        ,'How can I find tables with frequent deletes?'
        ,'Which tables have delete operations that are causing deadlocks?'
        ,'What tables have delete operations that are impacting data compression?'
        ,'Which tables have delete operations that are causing data inconsistencies across replicas?'
        ,'How can I identify tables with delete activity during peak hours?'
        ,'What tables are most impacted by delete operations?'
        ,'Which tables have delete operations that are executed by specific database roles?'
        ,'Which tables have the most delete operations?'
        ,'What tables have delete operations that are impacting data warehousing operations?'
        ,'How do I detect tables with abnormal delete patterns?'
        ,'Which tables have an unusual delete rate?'
        ,'Which tables have delete operations exceeding thresholds?'
        ,'What are the top tables for delete transactions?'
        ,'How do I detect tables with delete operations that are violating data retention policies?'
        ,'List tables with delete operation surges.'
        ,'List tables with the highest delete operations.'
        ,'How to identify tables with delete spikes?'
        ,'How can I track tables with delete operations that are related to data migration?'
        ,'How do I identify tables with delete operations that are not being logged?'
        ,'Which tables have a delete operation anomaly?'
        ,'What tables are experiencing high delete activity?'
        ,'What tables show a high delete frequency?'
        ,'How do I spot tables with heavy delete usage?'
        ,'How can I find tables with unexpected delete operations?'
        ,'How can I track tables with delete trends?'
        ,'List tables with delete operations that exceed 50% of total DML operations.'
        ,'How can I find tables with delete operations that are related to specific applications?'
        ,'What tables have delete operations that are impacting data encryption?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, deletes FROM v$segment_statistics WHERE statistic_name = ''table scans (short tables)''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Tables with High Insert Counts',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify tables with high insert operations.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What tables have the longest insert transaction times?'
        ,'Identify tables with inserts that are causing the most contention.'
        ,'What are the top tables by insert count?'
        ,'Which tables have the most insertions?'
        ,'Which tables have inserts that are causing deadlocks?'
        ,'Which tables have inserts that are not compliant with regulatory requirements?'
        ,'Which tables have the highest average insert size?'
        ,'Identify tables with unusual insert patterns.'
        ,'Which tables have the most insert errors?'
        ,'Which tables are insert-heavy?'
        ,'Which tables have inserts that are using the most CPU?'
        ,'Which tables have inserts that are using the most parallel processing?'
        ,'Identify the tables with high insert activity.'
        ,'What are the most insert-affected tables?'
        ,'What tables have the most insert-related errors?'
        ,'Which tables are most affected by insert operations?'
        ,'Identify tables with inserts that are impacting system performance.'
        ,'Are there tables with a surge in insertions?'
        ,'What tables have the most insert rollbacks?'
        ,'Which tables have increased insert operations recently?'
        ,'What tables are primarily used for inserts?'
        ,'Which tables have the highest insert rates?'
        ,'What tables have the highest insert operations?'
        ,'How to detect tables with inserts that are not following best practices?'
        ,'Which tables have inserts that are causing the most undo activity?'
        ,'How can I find tables with frequent inserts?'
        ,'Identify tables with inserts that are blocking other operations.'
        ,'Can you list tables with high insert volumes?'
        ,'Which tables show high insert frequency?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, inserts FROM v$segment_statistics WHERE statistic_name = ''table fetch continued row''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Database Parameters',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display all database parameters in alphabetical order.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are parameter values included in the alphabetical list?'
        ,'Are parameters sorted alphabetically by default?'
        ,'How many parameters are listed alphabetically?'
        ,'Show database parameters in A-Z order.'
        ,'Display all parameters in alphabetical order.'
        ,'What is the purpose of sorting parameters alphabetically?'
        ,'Display parameters sorted from A to Z.'
        ,'Display database parameters in reverse alphabetical order.'
        ,'How do I use the alphabetical parameter list for troubleshooting?'
        ,'Are there any limitations to the alphabetical parameter list?'
        ,'List parameters with their descriptions in alphabetical order.'
        ,'How are parameters ordered alphabetically?'
        ,'Can I export the alphabetical parameter list to a file?'
        ,'Can you provide an example of an alphabetical parameter list?'
        ,'Is the alphabetical parameter list available in multiple languages?'
        ,'Show me the top 10 parameters in alphabetical order.'
        ,'What are the parameters sorted by name?'
        ,'How do I customize the alphabetical parameter list?'
        ,'Display an alphabetical list of parameters.'
        ,'What parameters are listed alphabetically?'
        ,'Are all database parameters included in the alphabetical list?'
        ,'How are the parameters sorted alphabetically?'
        ,'Can I access the alphabetical parameter list remotely?'
        ,'Can you provide documentation for the alphabetical parameter list?'
        ,'Display parameters from A to Z.'
        ,'How do I search for a specific parameter in the alphabetical list?'
        ,'How do I integrate the alphabetical parameter list with other tools?'
        ,'Are parameter names case-sensitive in the alphabetical list?'
        ,'Is the alphabetical parameter list available for all databases?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$parameter ORDER BY name", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Show All Hidden Parameters',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Show all hidden database parameters.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to display hidden parameters in Oracle?'
        ,'Identify all hidden database parameters.'
        ,'List hidden parameters and their values.'
        ,'List all hidden database parameters.'
        ,'What are the default hidden parameters in Oracle?'
        ,'Can I create custom hidden parameters?'
        ,'List Oracle database''s hidden parameters.'
        ,'Are hidden parameters configurable?'
        ,'How to uncover hidden database parameters?'
        ,'List all hidden parameters with their descriptions.'
        ,'How to validate the effectiveness of hidden parameter changes?'
        ,'How to compare hidden parameters between instances?'
        ,'Extract all hidden parameters in Oracle.'
        ,'How to list hidden parameters in Oracle DB?'
        ,'What hidden parameters are set in my database?'
        ,'How can I see hidden database parameters?'
        ,'What is the purpose of hidden parameters?'
        ,'Provide a list of hidden database settings.'
        ,'What are the risks of modifying hidden parameters?'
        ,'How do I access hidden Oracle parameters?'
        ,'What hidden parameters are currently set?'
        ,'List hidden parameters related to performance.'
        ,'What are the secret parameters in Oracle DB?'
        ,'What are the concealed parameters in Oracle?'
        ,'Find all hidden parameters in Oracle DB.'
        ,'What are the undocumented database parameters?'
        ,'Can you recommend optimal hidden parameter settings?'
        ,'How can I view hidden Oracle database parameters?'
        ,'Display all hidden parameters in the database.'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$parameter WHERE name LIKE ''_%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check SGA (System Global Area) Size',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the size of each SGA component.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the size of the Flashback Buffer?'
        ,'What is the size of the SGA Target?'
        ,'How much memory does the Data Dictionary Cache use?'
        ,'What is the size of the PGA?'
        ,'What is the size of the Row Cache?'
        ,'What is the size of the SGA block?'
        ,'What is the size of the Messaging Buffer?'
        ,'What is the size of the Result Cache?'
        ,'How much memory does the SGA use in total?'
        ,'How large is the Buffer Cache?'
        ,'What is the total SGA size?'
        ,'How large is the Reserved Pool?'
        ,'How big is the SQL Area?'
        ,'How much memory is allocated to the SGA components?'
        ,'How much memory does the SGA consume?'
        ,'What is the size of the System Global Area?'
        ,'What is the size of the SGA footprint?'
        ,'Size of the Streams Pool?'
        ,'How big is the User Global Area?'
        ,'How large is the Java Pool?'
        ,'What is the size of the SGA region?'
        ,'How large is the SQL Area?'
        ,'How large is the Session Memory?'
        ,'What is the size of the Library Cache?'
        ,'How large is the Cache Area?'
        ,'How much memory does the Buffer Cache use?'
        ,'How large is the SGA chunk?'
        ,'How big is the Undo Buffer?'
        ,'How large is the UGA?'
        ),
        p_match_document       => JSON('{"sql": "SELECT component, current_size/1024/1024 AS size_mb FROM v$sga_dynamic_components", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check PGA (Program Global Area) Size',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Show total allocated PGA size in MB.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many megabytes is the PGA using?'
        ,'How much PGA memory is used?'
        ,'How much PGA is allocated in megabytes?'
        ,'How much memory is the PGA consuming?'
        ,'How many megabytes are used by the PGA?'
        ,'Show total PGA allocation.'
        ,'What is the PGA allocation amount in MB?'
        ,'Show the total PGA allocation size.'
        ,'Display PGA allocation size.'
        ,'How many MB does the PGA allocate?'
        ,'Show the allocated size of PGA in MB.'
        ,'Can you show the PGA size?'
        ,'Can you report the PGA size in megabytes?'
        ,'What is the total allocated PGA?'
        ,'How much PGA is used in megabytes?'
        ,'What is the PGA allocation in MB?'
        ,'How much memory does the PGA use in MB?'
        ,'What is the current PGA allocation in MB?'
        ,'How large is the PGA allocation?'
        ,'What is the PGA allocation size in MB?'
        ,'Show the PGA memory allocation.'
        ,'What is the PGA memory allocation amount?'
        ,'What is the total allocated PGA size in MB?'
        ,'What is the PGA size allocation?'
        ,'What is the total PGA memory usage?'
        ,'How much PGA is allocated?'
        ,'Provide the total allocated PGA size.'
        ,'Report the PGA allocation.'
        ,'Report the allocated PGA memory size.'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value/1024/1024 AS size_mb FROM v$pgastat WHERE name = ''total PGA allocated''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Database Block Size',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve the database block size setting.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to verify the block size of the database?'
        ,'Is block size a dynamic or static parameter?'
        ,'How to query the block size of the database?'
        ,'What command shows the current block size?'
        ,'What is the smallest block size for this DB?'
        ,'How can I find the block size of my database?'
        ,'Where can I check the database block size setting?'
        ,'What are the compliance requirements for block size settings?'
        ,'How does block size influence performance?'
        ,'What is the recommended block size for my database?'
        ,'What tools can I use to analyze block size usage?'
        ,'What is the block size setting for this instance?'
        ,'What is the database block size in bytes?'
        ,'How to check the block size setting for Oracle DB?'
        ,'What happens if I set an invalid block size?'
        ,'What are the limitations of changing block size?'
        ,'Is there a way to retrieve the database block size?'
        ,'How do I look up the block size configuration?'
        ,'How to identify the optimal block size for my workload?'
        ,'How does block size affect backup and recovery times?'
        ,'What is the relationship between block size and disk space?'
        ,'What is the impact of block size on database cloning?'
        ,'What is the default block size for this Oracle instance?'
        ,'How to measure the effectiveness of block size settings?'
        ,'Can I use system tables to update the block size?'
        ,'How to check if block size is consistent across databases?'
        ,'What are the security implications of block size settings?'
        ,'How to find the block size parameter in Oracle?'
        ,'How to troubleshoot block size-related issues?'
        ),
        p_match_document       => JSON('{"sql": "SHOW PARAMETER db_block_size", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Object Privileges of a User',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List object privileges granted to a specific user.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'List user Brian''s privileges on procedures.'
        ,'What object privileges are assigned to user Frank?'
        ,'What object privileges does user Indie have?'
        ,'What privileges does user Gary have on indexes?'
        ,'List user Bryce''s privileges on sequences.'
        ,'Can user Remi execute any packages?'
        ,'Can user Helen create any objects?'
        ,'What object privileges are granted to user David?'
        ,'List object privileges for user Jackson.'
        ,'What object privileges are assigned to user Sadie?'
        ,'Does user Amy have any privileges on synonyms?'
        ,'What privileges does user Michael have on packages?'
        ,'Does user Avery have any privileges on synonyms?'
        ,'Show object privileges for user Emma.'
        ,'List user Mark''s privileges on tables.'
        ,'Does user Isabella have INSERT privileges on tables?'
        ,'Can user Steve update any tables?'
        ,'What privileges does user Landon have on procedures?'
        ,'Does user Maya have UPDATE privileges?'
        ,'Can user Scarlett modify any tables?'
        ,'What are user Harper''s privileges on materialized views?'
        ,'Can user Caleb create any objects in a specific schema?'
        ,'What tables can user Alex access?'
        ,'Does user Paul have DELETE privileges?'
        ,'List object privileges for user Gabriel.'
        ,'List user Ruby''s privileges on functions.'
        ,'What object privileges does user Mason have?'
        ,'Can user Zoe modify any views?'
        ,'Can user Aiden update any sequences?'
        ),
        p_match_document       => JSON('{"sql": "SELECT privilege, table_name FROM dba_tab_privs WHERE grantee = ''SCOTT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Queries with High Execution Counts',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify queries with high execution counts.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there queries executed more than 200 times in the last 10 minutes?'
        ,'Which queries have execution counts that decreased by 25% since last quarter?'
        ,'Identify queries with execution counts greater than 2,000 in the last day.'
        ,'List queries executed more than 4,000 times in the last 24 hours.'
        ,'Which queries have execution counts that tripled since last quarter?'
        ,'Which queries have the highest execution counts today?'
        ,'What is the execution count for query ID 1234?'
        ,'Which queries have the highest execution counts on weekends?'
        ,'Which query has the highest execution count this month?'
        ,'Which queries have execution counts exceeding last month''s average?'
        ,'How many queries have execution counts over 3,000 this month?'
        ,'Identify queries with execution counts greater than 1,200 in the last 2 days.'
        ,'How many queries have execution counts over 4,000 this year?'
        ,'Which queries have the highest execution counts in the last 24 hours?'
        ,'Which queries have execution counts that halved since last month?'
        ,'What is the execution count for the query with ID 9012?'
        ,'What is the execution count trend for the top 5 queries?'
        ,'What is the execution count trend for the most executed query?'
        ,'What are the execution counts for the top 2 most executed queries?'
        ,'Are there queries executed more than 1,500 times weekly?'
        ,'List queries with execution counts above the 90th percentile.'
        ,'How many queries have execution counts over 2,500?'
        ,'Are there queries with execution counts above 10,000 this year?'
        ,'Which queries have the highest execution counts during peak hours?'
        ,'Are there queries executed more than 500 times daily?'
        ,'Identify queries with execution counts greater than 6,000 annually.'
        ,'What is the average execution count for all queries this week?'
        ,'Which queries have execution counts that decreased since last week?'
        ,'Identify queries with execution counts above the 95th percentile.'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, executions, sql_text FROM v$sql WHERE executions > 100 ORDER BY executions DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Redo Log Switches',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Track redo log switch activities.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do redo log switches affect Oracle RAC performance?'
        ,'How many redo log switches are triggered by checkpoints?'
        ,'Can I simulate the effect of increasing redo log file size?'
        ,'How many redo log switches occurred in the last 24 hours?'
        ,'What is the size of the redo log file?'
        ,'What is the redo log switch trend over the last year?'
        ,'Can I predict redo log switch volume based on historical data?'
        ,'Can I automate redo log switch monitoring?'
        ,'How many redo log switches occurred during a specific time range?'
        ,'When was the last redo log switch?'
        ,'What is the impact of redo log switches on disk space usage?'
        ,'How do redo log switches affect query performance?'
        ,'What is the relationship between redo log switches and CPU usage?'
        ,'Redo log switches count for today?'
        ,'Can I predict when the next redo log switch will occur?'
        ,'How does redo log switch frequency compare to last month?'
        ,'What is the effect of redo log switches on flashback database operations?'
        ,'What is the shortest interval between log switches?'
        ,'How many redo log switches occurred during maintenance?'
        ,'What is the difference in redo log switch behavior between test and prod environments?'
        ,'What is the correlation between redo log switches and transaction volume?'
        ,'How many redo log switches happened in the last hour?'
        ,'How often do redo log switches occur on weekends?'
        ,'Can I optimize redo log switch performance for a specific workload?'
        ,'How many redo log switches occur during database upgrades?'
        ,'How do redo log switches impact database throughput?'
        ,'What is the frequency of redo log switches this week?'
        ,'What is the redo log switch pattern for a particular database user?'
        ,'How does redo log switch frequency vary by day of the week?'
        ),
        p_match_document       => JSON('{"sql": "SELECT thread#, sequence#, first_change#, first_time FROM v$log_history ORDER BY first_time DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find SQL Causing a Lock',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify SQL statements causing locks by session ID.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Identify sessions with locking SQL statements.'
        ,'Retrieve SQL statements causing locks per session.'
        ,'Can I list sessions with SQL locks on a specific index?'
        ,'Which sessions have the most SQL locks on a specific table?'
        ,'Identify SQL causing locks across session IDs.'
        ,'How to monitor SQL lock activity by session in real-time?'
        ,'List SQL causing locks grouped by session IDs.'
        ,'Which SQL statements are causing locks on a specific partition?'
        ,'What is the average lock time for SQL statements by session?'
        ,'What SQL queries are causing locks per session?'
        ,'What is the longest-running SQL lock by session?'
        ,'Identify locked SQL statements for a specific session.'
        ,'How to resolve SQL locks by session ID?'
        ,'Can I view SQL locks by session ID and SQL statement?'
        ,'What are the SQL statements responsible for locks?'
        ,'Find SQL causing locks for specific session IDs.'
        ,'What is the most frequently locked SQL statement by session?'
        ,'How to find session-specific SQL locks?'
        ,'Can I see the session ID of the SQL statement causing a lock?'
        ,'Which SQL statements are locking by session?'
        ,'Can I identify sessions with SQL locks on a specific package?'
        ,'Which session IDs have SQL causing locks?'
        ,'Which SQL statements are causing locks by session ID?'
        ,'List sessions with SQL causing locking issues.'
        ,'Can I see the SQL lock history for a specific session?'
        ,'Determine SQL causing locks by session identifier.'
        ,'How many sessions are waiting for a locked SQL resource?'
        ,'How to detect SQL deadlocks by session ID?'
        ,'How many SQL locks are active per session?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_text FROM v$sql WHERE sql_id IN (SELECT sql_id FROM v$session WHERE sid = 1234)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find All Foreign Key Constraints',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all foreign key constraints in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which foreign key constraints are system-generated?'
        ,'List foreign key constraints created in the last 30 days.'
        ,'What are the foreign key constraints in the database?'
        ,'Are there self-referencing foreign key constraints?'
        ,'Are there any foreign key constraints with no delete rules?'
        ,'Show foreign key constraints for a specific table.'
        ,'Which tables have foreign key constraints?'
        ,'List foreign key constraints by table name.'
        ,'What tables have the most foreign key constraints?'
        ,'Which foreign key constraints are enforced?'
        ,'Are there any disabled foreign key constraints?'
        ,'List foreign key constraints with on update actions.'
        ,'Which tables have foreign key constraints with cascade update?'
        ,'List foreign key constraints that reference a specific table.'
        ,'Which foreign key constraints are validated by the database?'
        ,'How to find foreign key constraint violations?'
        ,'List foreign key constraints with unique column names.'
        ,'Find foreign key constraints that reference system tables.'
        ,'Which foreign key constraints are used by database triggers?'
        ,'What are the parent tables for foreign keys?'
        ,'Are there any foreign key constraints with no referenced tables?'
        ,'List foreign key constraints with specific column names.'
        ,'Show foreign key constraints with restrict delete.'
        ,'How to check the creation date of foreign key constraints?'
        ,'Find foreign key constraints that reference tables in other schemas.'
        ,'Are there any foreign key constraints with self-referential delete rules?'
        ,'List foreign key constraints with no action on delete.'
        ,'What is the status of foreign key constraints?'
        ,'How to check the last modified date of foreign key constraints?'
        ),
        p_match_document       => JSON('{"sql": "SELECT constraint_name, table_name FROM dba_constraints WHERE constraint_type = ''R''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Indexes in a Schema',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display all indexes within a specified schema.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show indexes for the SALES schema.'
        ,'Show me indexes for a particular database.'
        ,'How many indexes are in a given schema?'
        ,'Can you list indexes in the MANAGEMENT schema?'
        ,'Which indexes belong to the COMPLIANCE schema?'
        ,'Which indexes belong to the SUPPLY_CHAIN schema?'
        ,'Provide a list of indexes on a certain table.'
        ,'Which indexes are in the MARKETING schema?'
        ,'Display all indexes in a certain directory.'
        ,'Provide a list of indexes in the INVENTORY schema.'
        ,'List indexes in the default schema.'
        ,'How many indexes exist in the DEVELOPMENT schema?'
        ,'Are there any indexes on a specific field?'
        ,'Can you list indexes for a given database object?'
        ,'What are the indexes in the CUSTOMER schema?'
        ,'Show me indexes for the PRODUCT schema.'
        ,'Which indexes are used by a certain query?'
        ,'Display all indexes in the EMPLOYEE schema.'
        ,'Provide a report of indexes in the RESEARCH schema.'
        ,'Show indexes for a specific data type.'
        ,'Are there any indexes in the RISK schema?'
        ,'What indexes are in my schema?'
        ,'Can you display indexes for all tables?'
        ,'Provide indexes for the LOGISTICS schema.'
        ,'How many indexes are in the ACCOUNTING schema?'
        ,'Are there any indexes on a specific partition?'
        ,'Show indexes in the current schema.'
        ,'List all indexes in the FINANCE schema.'
        ,'List indexes for a specific table.'
        ),
        p_match_document       => JSON('{"sql": "SELECT index_name, table_name FROM dba_indexes WHERE owner = ''HR''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Audit Trail',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Review audit trail entries sorted by timestamp.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What IP addresses appear in the audit trail?'
        ,'How many audit entries were recorded yesterday?'
        ,'Show audit trail entries for user ''admin.'''
        ,'How many audit entries are there per day?'
        ,'Are there any audit entries for unauthorized grants?'
        ,'Show audit entries for schema modifications.'
        ,'Show audit entries for user ''sys''.'
        ,'What time did the first audit entry occur today?'
        ,'Show audit entries related to data exports.'
        ,'Show audit trail entries for ''SELECT'' statements.'
        ,'Are there any unauthorized access attempts?'
        ,'What actions are most common in the audit trail?'
        ,'What actions did user ''john_doe'' perform?'
        ,'Are there audit entries outside business hours?'
        ,'What are the latest audit trail entries?'
        ,'List audit entries for database changes.'
        ,'What is the total number of audit entries this month?'
        ,'List audit entries with errors.'
        ,'Are there any audit entries for invalid login attempts?'
        ,'List audit entries for database space management.'
        ,'Show audit entries for table ''employees.'''
        ,'Show audit entries for index creations.'
        ,'List audit entries for database startup events.'
        ,'List audit entries for database shutdown events.'
        ,'List audit entries for successful backups.'
        ,'Show audit entries for role changes.'
        ,'Show audit entries for all database objects.'
        ,'What is the oldest audit trail entry?'
        ,'What actions are least common in the audit trail?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, action_name, timestamp FROM dba_audit_trail ORDER BY timestamp DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Data Pump Jobs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all data pump jobs with their current status.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many data pump jobs are currently running in parallel?'
        ,'How many data pump jobs have completed successfully?'
        ,'What is the total number of data pump jobs that have been retried more than once?'
        ,'Are there any data pump jobs that are currently being debugged?'
        ,'Can I see data pump jobs that started yesterday?'
        ,'How many data pump jobs are in \"Not Started\" status?'
        ,'Can I see data pump jobs that have a specific dependency or prerequisite?'
        ,'Are there any data pump jobs with a status of \"Detached\"?'
        ,'Are there any suspended data pump jobs?'
        ,'Are there any data pump jobs with \"Paused\" status?'
        ,'List all data pump jobs with their end times.'
        ,'What is the average duration of completed data pump jobs?'
        ,'What is the status of the most recently created data pump job?'
        ,'List data pump jobs with a status change in the last hour.'
        ,'Are there any data pump jobs with warnings?'
        ,'Are there any failed data pump jobs?'
        ,'How many data pump jobs are currently waiting for resources?'
        ,'What is the status of data pump job ID 102?'
        ,'Can I see data pump jobs that were created by a specific user?'
        ,'What are the statuses of data pump jobs created last week?'
        ,'Are there any data pump jobs with unknown status?'
        ,'List all completed data pump jobs.'
        ,'List data pump jobs that were completed within the last 30 minutes.'
        ,'List data pump jobs with \"Error\" status.'
        ,'List all data pump jobs with their start times.'
        ,'Are there any data pump jobs with a status of \"Terminated\"?'
        ,'Are there any data pump jobs that were manually stopped?'
        ,'Can I see data pump jobs that have a specific parameter or option set?'
        ,'List data pump jobs that have been modified or updated within the last day.'
        ),
        p_match_document       => JSON('{"sql": "SELECT job_name, state, operation, job_mode FROM dba_datapump_jobs", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List Users with Expired Passwords',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify users with expired passwords.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can password expiration be disabled?'
        ,'How to notify users of expired passwords?'
        ,'How do I identify critical users with expired passwords?'
        ,'How to check for expired passwords programmatically?'
        ,'Are any admin accounts expired?'
        ,'What is the impact of expired passwords?'
        ,'Can I extend password expiration for specific users?'
        ,'Do expired passwords affect user access?'
        ,'Can I extend password expiration for users with expired passwords?'
        ,'Are there any users with expired passwords in the HR schema?'
        ,'Which users have passwords expiring soon?'
        ,'Are there audit logs for expired passwords?'
        ,'Can users with expired passwords log in?'
        ,'List usernames with expired passwords.'
        ,'Are there any security implications of expired passwords?'
        ,'Do expired passwords affect database performance?'
        ,'Which users have expired passwords?'
        ,'Are there any password expiration policies for guest accounts?'
        ,'How to extend password expiration date?'
        ,'Can I reset expired passwords using SQL?'
        ,'Are there critical users with expired passwords?'
        ,'How do I identify users with expired passwords programmatically?'
        ,'Are there any default password expiration settings?'
        ,'How do I handle expired passwords for external users?'
        ,'Is password expiration policy enforced?'
        ,'Are there default users with expired passwords?'
        ,'Are there system accounts with expired passwords?'
        ,'What roles have expired passwords?'
        ,'Can I generate a report of users with expired passwords using SQL?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, account_status FROM dba_users WHERE account_status LIKE ''%EXPIRED%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find All Users with Default Passwords',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find users with default or null passwords.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which user accounts are insecure?'
        ,'Which user accounts are vulnerable due to default passwords?'
        ,'Are there any Oracle users with default passwords?'
        ,'Which users have not changed their default database password?'
        ,'How many users have default passwords?'
        ,'How to find accounts with default passwords?'
        ,'Do any accounts have default passwords?'
        ,'Who has not changed their default password?'
        ,'How to identify users with weak passwords?'
        ,'Can I see a report of users with null passwords?'
        ,'Who are the users with default passwords?'
        ,'Can you identify null password users?'
        ,'What is the best way to find users with default passwords?'
        ,'Can you help me find accounts with no password set?'
        ,'How to detect and fix default password issues?'
        ,'Are there users with empty passwords?'
        ,'Are there any users with default credentials in our database?'
        ,'How many user accounts have default passwords set?'
        ,'Can I list users with default credentials?'
        ,'Which users currently have null passwords?'
        ,'Are there any security risks with default passwords?'
        ,'Is there a way to check for default passwords?'
        ,'What users have default passwords set?'
        ,'Can you identify users with weak password settings?'
        ,'Which accounts need password updates?'
        ,'Are there any users with blank passwords?'
        ,'How to identify users with default password settings?'
        ,'Can you list all users with default or null passwords?'
        ,'Which users need to update their passwords?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username FROM dba_users WHERE password IS NULL", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Which Users Have Proxy Access',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check which users have proxy access.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to identify users having proxy access?'
        ,'How to enable proxy access for a user?'
        ,'How can I list users with proxy access?'
        ,'Which accounts have proxy access enabled?'
        ,'Which users have proxy access to other databases?'
        ,'Who has proxy access to other accounts?'
        ,'Who has been denied proxy access?'
        ,'Which users currently have proxy access?'
        ,'How to revoke proxy access from a user?'
        ,'How to restrict proxy access to certain hours?'
        ,'Are there any proxy access quotas?'
        ,'Are any accounts granted proxy access?'
        ,'Which database users have proxy access?'
        ,'Can I list users with proxy access by role?'
        ,'Can I generate a report on proxy access usage?'
        ,'Who has proxy access to the current database?'
        ,'Are any users configured with proxy access?'
        ,'Who is authorized for proxy access?'
        ,'Who can proxy for multiple users?'
        ,'How to transfer proxy access to another user?'
        ,'How to check for users with proxy rights?'
        ,'Are proxy accesses limited to specific schemas?'
        ,'List users with active proxy access.'
        ,'Are proxy accesses assigned to any users?'
        ,'Who can act as a proxy for other users?'
        ,'How to check proxy access for a specific user?'
        ,'Are there users with delegated proxy access?'
        ,'Can I set up proxy access for a group?'
        ,'Can I view users with proxy access history?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM dba_proxies", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check ASM Disk Groups',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display details of all ASM disk groups.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many ASM disk groups are in normal mode?'
        ,'What is the total capacity of all high redundancy ASM disk groups?'
        ,'List the status of all ASM disk groups.'
        ,'Which ASM disk group has the most failgroups?'
        ,'What is the average usable file size limit of all ASM disk groups?'
        ,'Can I get a list of ASM disk groups sorted by capacity?'
        ,'What is the allocation unit size of the ASM disk group with the least free space?'
        ,'What is the average capacity of all ASM disk groups?'
        ,'What are the names of all ASM disk groups?'
        ,'How many databases are using each ASM disk group?'
        ,'What is the disk group compatibility for ASM features?'
        ,'What is the name of the ASM disk group with the lowest redundancy level?'
        ,'Are there any high redundancy ASM disk groups?'
        ,'What is the total number of databases using all ASM disk groups?'
        ,'Are there any offline disks in the ASM disk groups?'
        ,'Count the total disks in ASM disk groups.'
        ,'Can I get a list of ASM disk groups with restricted access sorted by name?'
        ,'Are there any ASM disk groups with a block size other than 8192?'
        ,'What is the disk group type of the ASM disk group with the most databases?'
        ,'How many disks are part of each ASM disk group?'
        ,'Are there any ASM disk groups with no free space?'
        ,'How many ASM disk groups are currently configured?'
        ,'Which ASM disk group offers the most free space?'
        ,'Which ASM disk groups have warning alerts?'
        ,'Are there any ASM disk groups with a sector size other than 512?'
        ,'What is the compatibility attribute of the ASM disk group with the most disks?'
        ,'What are the disk names in each ASM disk group?'
        ,'What is the redundancy level of each ASM disk group?'
        ,'How many ASM disk groups have a stripe column size of 8?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, state, type, total_mb, free_mb FROM v$asm_diskgroup", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check ASM Disks',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all ASM disks with their properties.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any ASM disks with warnings?'
        ,'Show the ASM disk group descriptions.'
        ,'Which ASM disks are currently active?'
        ,'What are the ASM disk group names?'
        ,'List ASM disks with their sector sizes.'
        ,'What is the total capacity of all ASM disks?'
        ,'List ASM disks with their disk group names and IDs.'
        ,'What are the ASM disk device paths?'
        ,'What are the usage percentages of ASM disks?'
        ,'List ASM disks with their read and write statistics.'
        ,'What are the ASM disk names and paths?'
        ,'List ASM disks with their failgroups.'
        ,'What is the free space on each ASM disk?'
        ,'Can you list ASM disks by their redundancy level?'
        ,'Are there unformatted ASM disks?'
        ,'Show details of each ASM disk.'
        ,'List ASM disks with their mount points.'
        ,'Provide the failure groups for all ASM disks.'
        ,'What is the size of each ASM disk in GB?'
        ,'What are the names of all ASM disks?'
        ,'What is the status of each ASM disk?'
        ,'Can you list all ASM disks?'
        ,'Show the mount status of each ASM disk.'
        ,'Show the ASM disk group compatibility.'
        ,'Are there any ASM disks with invalid statuses?'
        ,'Are there any ASM disks with errors?'
        ,'What is the ASM disk group state?'
        ,'Show the creation date of each ASM disk.'
        ,'Show the ASM disk group incarnation numbers.'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, path, state, total_mb, free_mb FROM v$asm_disk", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Largest Segments in Tablespaces',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify the largest segments by size.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many segments are larger than 50GB and partitioned?'
        ,'Can you list segments larger than 5GB by owner?'
        ,'What is the size of the largest segment that is not partitioned?'
        ,'Which segment is currently the largest in the database?'
        ,'Which tablespace has the largest total segment size?'
        ,'What is the total size of all segments larger than 500MB?'
        ,'What is the average size of the top 20 largest segments?'
        ,'How many segments are larger than 10GB and not indexed?'
        ,'What is the largest segment''s impact on performance?'
        ,'Can you list the largest segments in each tablespace by size?'
        ,'What are the top 5 largest segments by size?'
        ,'Which segment has shown the most growth recently?'
        ,'How many segments are larger than 100MB in the system tablespace?'
        ,'Which segment has the highest number of extents?'
        ,'Are there any partitioned segments among the largest?'
        ,'What is the growth rate of the largest segment?'
        ,'What is the growth trend of the largest segment over the past month?'
        ,'What is the average size of the largest segments?'
        ,'How many segments are larger than the median segment size?'
        ,'How many segments are larger than 1GB in the current database?'
        ,'Are there any segments larger than 1GB that are not regularly accessed?'
        ,'How many segments exceed 50GB in size?'
        ,'What is the size of the second largest segment?'
        ,'How often are the top 10 largest segments backed up?'
        ,'Which tablespace contains the largest segment?'
        ,'How does the size of the largest segment compare to others?'
        ,'How frequently are the largest segments accessed?'
        ,'What is the total size of the top 10 largest segments?'
        ,'Which schema has the most segments larger than 5GB?'
        ),
        p_match_document       => JSON('{"sql": "SELECT segment_name, segment_type, tablespace_name, bytes/1024/1024 AS size_mb FROM dba_segments ORDER BY bytes DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Identify Tables with High Chained Rows',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find tables with a high count of chained rows.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the correlation between table size and chained row count?'
        ,'Can you identify tables with both high chained row counts and large size?'
        ,'Which tables have the most significant increase in chained rows?'
        ,'How do chained row counts affect backup and recovery times?'
        ,'Can you list tables with chained row counts that exceed a certain percentage?'
        ,'How many tables have no chained rows?'
        ,'How do chained row counts affect table performance?'
        ,'How frequently do chained rows occur in large tables?'
        ,'Are there tables with chained row counts increasing over time?'
        ,'Which table has the maximum chained rows?'
        ,'Can you provide a histogram of chained row counts by table?'
        ,'What percentage of rows are chained in each table?'
        ,'Are there any tables with chained rows that are not regularly maintained?'
        ,'Can you provide a ranking of tables by chained row count and size?'
        ,'Can you list tables with chained row counts above average?'
        ,'Which tables have recently increased in chained rows?'
        ,'Can you provide a summary of chained rows by schema?'
        ,'Are there specific schemas with high chained row tables?'
        ,'Are there historical trends in chained row counts?'
        ,'How do chained row counts impact database scalability?'
        ,'Are there any tables with high chained row counts and high data growth rates?'
        ,'What are the best practices for reducing chained row counts in large tables?'
        ,'Identify tables with significant chained row counts.'
        ,'Which tables should be prioritized for chained row optimization?'
        ,'How can I identify tables with potential chaining issues?'
        ,'Are there any tables with unexpected chained row counts?'
        ,'Can chained rows be reduced with table reorganization?'
        ,'Are there any patterns in tables with high chained rows?'
        ,'How do chained rows impact data retrieval efficiency?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, chain_cnt FROM dba_tables WHERE chain_cnt > 1000", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Data Guard Configuration',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the configuration of Data Guard roles.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can I use Data Guard with other Oracle tools?'
        ,'How do I backup a Data Guard configuration?'
        ,'What is the transport mode for redo logs?'
        ,'Is there a delay in redo apply?'
        ,'What is the difference between switchover and failover?'
        ,'Are all standby databases in sync?'
        ,'What is the status of the Data Guard configuration?'
        ,'Can I have multiple primary databases?'
        ,'How is the failover configured for Data Guard?'
        ,'Can a logical standby database be used for reporting?'
        ,'How do I configure redo log transport?'
        ,'What is the current synchronization status?'
        ,'What Data Guard roles are supported?'
        ,'How do I enable Data Guard broker?'
        ,'How do I check the status of Data Guard roles?'
        ,'What role does the database currently have?'
        ,'Are all roles functioning correctly?'
        ,'Are there any configuration warnings or errors?'
        ,'What are the limitations of using Data Guard?'
        ,'How is data applied to standby databases?'
        ,'What happens during a role transition?'
        ,'How do I monitor Data Guard performance?'
        ,'Can I configure Data Guard for a single database?'
        ,'Can I have a mix of physical and logical standby databases?'
        ,'Can I use Data Guard with Oracle RAC?'
        ,'How many standby databases are configured?'
        ,'What is the redo apply status?'
        ,'Are there any logical standby databases?'
        ,'What are the security considerations for Data Guard?'
        ),
        p_match_document       => JSON('{"sql": "SELECT database_role, protection_mode FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Data Guard Transport Lag',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display transport lag in Data Guard setup.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the current transport lag in Data Guard?'
        ,'How does transport lag affect Data Guard performance?'
        ,'Does transport lag affect failover times?'
        ,'What are the consequences of prolonged transport lag?'
        ,'What is the threshold for acceptable transport lag?'
        ,'Can I set up notifications for transport lag exceeding 5 minutes?'
        ,'Is there a trend in increasing transport lag?'
        ,'How often is transport lag occurring in our setup?'
        ,'Are there alerts set for high transport lag?'
        ,'What is the peak transport lag during high load?'
        ,'How do I reduce transport lag in Data Guard?'
        ,'How do I troubleshoot transport lag issues in a RAC environment?'
        ,'How does transport lag impact disaster recovery plans?'
        ,'Can transport lag be affected by disk I/O performance?'
        ,'How does transport lag impact database performance metrics?'
        ,'How do I calculate the transport lag threshold for our setup?'
        ,'Is there any transport lag exceeding 10 minutes?'
        ,'How can I visualize transport lag data?'
        ,'What is the current transport lag in minutes?'
        ,'What is the average transport lag over the last week?'
        ,'What are the consequences of ignoring transport lag issues?'
        ,'How do I identify transport lag trends and patterns?'
        ,'Can I use Oracle Cloud Control to monitor transport lag?'
        ,'How can I check the transport lag in my Data Guard setup?'
        ,'What is the historical trend of transport lag?'
        ,'Can I get a list of instances with high transport lag?'
        ,'What causes transport lag in a Data Guard environment?'
        ,'What is the relationship between transport lag and redo log size?'
        ,'How does transport lag affect database backup and recovery processes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$dataguard_stats WHERE name = ''transport lag''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Standby Database Recovery Progress',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor recovery progress of standby databases.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the recovery status of all standby databases in my environment?'
        ,'Can I get a list of applied redo logs on the standby database?'
        ,'What is the current redo apply mode on standby?'
        ,'How frequently are logs being applied to the standby?'
        ,'How often is the standby database updated from primary?'
        ,'What is the current log sequence gap between primary and standby?'
        ,'What is the average recovery time for my standby database?'
        ,'How much time is left for standby recovery completion?'
        ,'Are there any errors in the standby recovery process?'
        ,'Can I view the recovery history of my standby database?'
        ,'What is the current recovery throughput of my standby database?'
        ,'What''s the recovery progress percentage of my standby?'
        ,'Is the standby database synchronized with the primary?'
        ,'How can I monitor the standby database''s log switch frequency?'
        ,'How can I detect recovery lag in standby databases?'
        ,'How do I know if my standby database is in real-time recovery mode?'
        ,'How do I check the standby database''s redo apply latency?'
        ,'What is the current data guard status of standby databases?'
        ,'How do I know if my standby database is in a consistent state?'
        ,'How can I monitor the standby database''s synchronization status?'
        ,'How do I check if the standby database is configured for real-time recovery?'
        ,'Are there any standby databases with recovery issues?'
        ,'Can I view the standby database''s recovery metrics, such as apply rate and latency?'
        ,'What is the last received log sequence on standby?'
        ,'What is the time it took for the standby database to catch up after a failover?'
        ,'What is the current SCN gap between primary and standby databases?'
        ,'What is the time lag between primary and standby databases?'
        ,'What is the gap between primary and standby databases?'
        ,'How can I ensure my standby database is catching up?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sequence#, applied FROM v$archived_log ORDER BY sequence# DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Streams Capture Process',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the status of Streams capture processes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any Streams capture processes with missing dependencies?'
        ,'Are there any Streams capture processes with pending tasks?'
        ,'Can any Streams capture processes be optimized for better performance?'
        ,'Are there any Streams capture processes that are not properly monitored?'
        ,'How many Streams capture processes are currently in a warning state?'
        ,'What is the status history of the Streams capture processes?'
        ,'Have any Streams capture processes been terminated unexpectedly?'
        ,'What percentage of Streams capture processes are active?'
        ,'What is the oldest Streams capture process?'
        ,'Are there any Streams capture processes that are redundant?'
        ,'Have any Streams capture processes been updated recently?'
        ,'What is the average runtime of Streams capture processes?'
        ,'Are there any Streams capture processes that are not properly secured?'
        ,'Have any Streams capture processes been manually stopped recently?'
        ,'What is the uptime of the longest running Streams capture process?'
        ,'Are all Streams capture processes synchronized correctly?'
        ,'Are there any Streams capture processes with invalid configurations?'
        ,'What is the status of Streams capture processes during peak hours?'
        ,'Are there any Streams capture processes with warnings?'
        ,'Have any Streams capture processes been restarted today?'
        ,'Are all Streams capture processes properly configured for alerts?'
        ,'Are all Streams capture processes operating normally?'
        ,'What is the status of Streams capture processes on a specific server?'
        ,'Are there any Streams capture processes in an aborted state?'
        ,'How many Streams capture processes are idle?'
        ,'How long have the Streams capture processes been running?'
        ,'Are there any Streams capture processes that are not properly audited?'
        ,'When was the last Streams capture process started?'
        ,'What is the status of newly created Streams capture processes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT capture_name, status FROM dba_capture", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check GoldenGate Extract Status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the status of GoldenGate extract processes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the status of the GoldenGate extract process named \"EXT1\"?'
        ,'What is the status of the extract process \"EXT2\"?'
        ,'Which GoldenGate extract processes have the lowest CPU usage?'
        ,'How many GoldenGate extract processes have been restarted in the last 24 hours?'
        ,'How many GoldenGate extract processes are running in parallel?'
        ,'Are there any duplicate extract processes running?'
        ,'Are any GoldenGate extract processes stopped?'
        ,'Are there any GoldenGate extract processes that are not configured for any table?'
        ,'Are there any GoldenGate extract processes that are running with a different user ID?'
        ,'What is the total extraction rate of all GoldenGate extract processes?'
        ,'Are there any GoldenGate extract processes that need attention?'
        ,'What is the current status of all GoldenGate extract processes?'
        ,'Which GoldenGate extract processes are currently paused?'
        ,'Which GoldenGate extract processes are configured to run on a specific schedule?'
        ,'What is the memory usage of each extract process?'
        ,'Can you provide the configuration details of each GoldenGate extract process?'
        ,'Which GoldenGate extract processes are in an error state?'
        ,'Are there any GoldenGate extract processes with warnings?'
        ,'Can you show the history of all GoldenGate extract processes for the last month?'
        ,'Are there any GoldenGate extract processes that have been modified in the last week?'
        ,'What is the average CPU usage across all extract processes?'
        ,'Which GoldenGate extract processes have the highest memory usage?'
        ,'Are there any GoldenGate extract processes with a high error rate?'
        ,'What is the status of the GoldenGate extract process group \"GROUP1\"?'
        ,'How many extract processes are configured in the system?'
        ,'Can you list all active GoldenGate extract processes?'
        ,'Which extract processes are configured for database \"DB1\"?'
        ,'What is the extraction rate of each GoldenGate process?'
        ,'What is the status of all GoldenGate extract processes for database \"DB3\"?'
        ),
        p_match_document       => JSON('{"sql": "SELECT extract_name, status FROM dba_goldengate_processes WHERE process_type = ''EXTRACT''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Buffer Pool Advisory',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Examine buffer pool advisory statistics.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How can I automate buffer pool advisory reviews?'
        ,'How is buffer pool efficiency measured?'
        ,'What changes are suggested by buffer pool advisory?'
        ,'How does buffer pool size relate to memory usage?'
        ,'What are the signs of buffer pool inefficiency?'
        ,'What historical trends are visible in buffer pool stats?'
        ,'How can I visualize buffer pool statistics for trend analysis?'
        ,'How can I monitor buffer pool usage in real-time?'
        ,'How do I interpret buffer pool advisory data?'
        ,'What are the best practices for configuring buffer pool parameters?'
        ,'How does buffer pool size impact system throughput?'
        ,'How can I reduce buffer pool contention?'
        ,'What is the relationship between buffer pool and I/O?'
        ,'How does buffer pool size impact memory usage?'
        ,'What are the signs of optimal buffer pool performance?'
        ,'How can I use buffer pool advisory to optimize caching?'
        ,'What is the optimal buffer pool configuration?'
        ,'How does buffer pool size affect query execution time?'
        ,'What metrics are used to measure buffer pool efficiency?'
        ,'What is the relationship between buffer pool and disk I/O?'
        ,'How do buffer pool advisory statistics affect caching?'
        ,'How does buffer pool advisory affect query performance?'
        ,'How does buffer pool advisory improve performance?'
        ,'How does buffer pool size affect performance?'
        ,'What are the benefits of a larger buffer pool?'
        ,'How can buffer pool advisory aid in capacity planning?'
        ,'How does buffer pool size relate to database size?'
        ,'What are the key differences between buffer pool advisory and other Oracle advisors?'
        ,'How can I validate buffer pool advisory recommendations?'
        ),
        p_match_document       => JSON('{"sql": "SELECT size_for_estimate, buffers_for_estimate, estd_physical_reads FROM v$db_cache_advice", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Latch Contention',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify latches with high contention.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you identify latches with high contention during peak hours?'
        ,'Which latches have the highest contention currently?'
        ,'How can I visualize latch contention data?'
        ,'How do I set up alerts for high latch contention?'
        ,'Can latch contention affect transaction throughput?'
        ,'How does latch contention differ from other types of database contention?'
        ,'Is there a way to monitor latch contention in real-time?'
        ,'What Oracle features help manage latch contention?'
        ,'Are there any Oracle parameters that can help reduce latch contention?'
        ,'How can I automate monitoring of latch contention?'
        ,'What are the most common latch contention errors?'
        ,'How does latch contention affect database throughput?'
        ,'Which database features can help reduce latch contention?'
        ,'Which latch contention should I prioritize for resolution?'
        ,'How does latch contention impact database availability?'
        ,'What are the common causes of high latch contention?'
        ,'Is there a correlation between latch contention and I/O performance?'
        ,'What are the symptoms of high latch contention?'
        ,'Does hardware impact latch contention levels?'
        ,'How can I identify latches with high contention?'
        ,'How does latch contention affect CPU utilization?'
        ,'What are the top 5 latches with the most contention?'
        ,'Are there any specific latches frequently experiencing contention?'
        ,'Can latch contention lead to database downtime?'
        ,'What tools are available to analyze latch contention?'
        ,'Which latch is causing the most performance issues?'
        ,'Can you provide a summary of latch contention statistics for my database?'
        ,'How often should I check for latch contention?'
        ,'Is there a threshold for acceptable latch contention?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, gets, misses, immediate_gets, immediate_misses FROM v$latch ORDER BY misses DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Current Undo Retention',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Retrieve current undo retention settings.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the relationship between undo retention and flashback?'
        ,'Is undo retention set at the database level?'
        ,'How does undo retention affect database recovery?'
        ,'How do I monitor undo retention usage?'
        ,'What is the difference between undo retention and undo size?'
        ,'How long is the undo retention set for?'
        ,'How much time is undo data kept?'
        ,'Can I set a warning threshold for undo retention?'
        ,'How long does the system retain undo data?'
        ,'What is the duration of undo retention?'
        ,'What is the undo retention time?'
        ,'Is there a maximum undo retention period?'
        ,'What is the established undo retention period?'
        ,'What is the recommended undo retention value?'
        ,'What happens when undo retention is exceeded?'
        ,'What is the current setting for undo retention?'
        ,'What is the parameter value for undo retention?'
        ,'How do I troubleshoot undo retention issues?'
        ,'What is the configured undo retention period?'
        ,'How long is undo data configured to last?'
        ,'What is the undo retention configuration?'
        ,'How long is undo data preserved?'
        ,'What are the implications of low undo retention?'
        ,'What is the current undo retention period?'
        ,'How long is undo data retained?'
        ,'Can I change the undo retention setting?'
        ,'How does undo retention affect performance?'
        ,'How is undo retention configured?'
        ,'How do I calculate the optimal undo retention period?'
        ),
        p_match_document       => JSON('{"sql": "SHOW PARAMETER UNDO_RETENTION", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Redo Log Size',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the size of redo log groups.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the current configuration of redo logs?'
        ,'Are there any best practices for managing redo log group sizes?'
        ,'Can I use Oracle''s built-in advisors to recommend optimal redo log group sizes?'
        ,'Can I get a history of redo log group size changes?'
        ,'What tools help analyze redo log sizes?'
        ,'How do I know if my redo log groups are properly configured?'
        ,'How do I ensure that my redo log groups are properly aligned?'
        ,'Are there any redo log groups larger than 1GB?'
        ,'Can I configure redo log groups to automatically resize?'
        ,'What is the impact of small redo log sizes?'
        ,'Are there any oversized redo log groups?'
        ,'How large are the redo log groups?'
        ,'Do redo log groups differ in size?'
        ,'Does redo log size affect recovery time?'
        ,'What are the default redo log sizes?'
        ,'Are there any Oracle features that can help optimize redo log group sizes?'
        ,'What is the size of redo log group 3?'
        ,'Can I use redo log group sizes to predict database growth?'
        ,'What is the size of redo log group 2?'
        ,'How do I troubleshoot issues related to redo log group sizes?'
        ,'What is the size of each redo log group?'
        ,'What is the size of the first redo log group?'
        ,'Which redo log group is the smallest?'
        ,'How does redo log size impact performance?'
        ,'How many redo log groups exist?'
        ,'How do I identify which redo log group is causing performance issues?'
        ,'List the sizes of all redo log groups.'
        ,'Can I use SQL to query redo log group sizes?'
        ,'How to monitor redo log group sizes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT group#, status, bytes/1024/1024 AS size_mb FROM v$log", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Who Dropped a Table',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify who dropped a specific table.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Who removed the ''listeners'' table?'
        ,'Which user removed ''shippings''?'
        ,'Who deleted ''functions'' from the database?'
        ,'Who was responsible for dropping ''triggers''?'
        ,'Who dropped ''programs'' last month?'
        ,'Can you identify who dropped ''measure folders''?'
        ,'Who removed the ''schedules'' table?'
        ,'Identify who deleted ''feedback''.'
        ,'Identify the user who deleted ''reports''.'
        ,'Find who removed the ''budget'' table.'
        ,'Who dropped the ''projects'' table last week?'
        ,'Who was responsible for dropping ''user groups''?'
        ,'Who removed ''catalog'' from the database?'
        ,'Who dropped the ''invoices'' table yesterday?'
        ,'Which account dropped ''transactions''?'
        ,'Which user dropped the ''sales'' table?'
        ,'Who dropped ''purchases'' last month?'
        ,'Who executed the drop on ''procedures''?'
        ,'Which user dropped ''packages''?'
        ,'Who executed drop on ''employees''?'
        ,'Can you find who removed the ''indexes'' table?'
        ,'Who executed the drop on ''logs''?'
        ,'Identify who removed ''payments''.'
        ,'Who executed the drop on ''file watchers''?'
        ,'Who was responsible for ''vendors'' drop?'
        ,'Who removed the ''sequences'' table?'
        ,'Who deleted the ''consumer groups'' table last year?'
        ,'Who dropped the ''synonyms'' table last week?'
        ,'Find who executed the drop on ''events''.'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, obj_name, action_name, timestamp FROM dba_audit_trail WHERE action_name = ''DROP'' AND obj_name = ''EMPLOYEES''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Users Who Changed Passwords',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find users who have changed their passwords.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any password changes that were made by a user who is no longer active?'
        ,'Which user has the longest time between password changes?'
        ,'Are there any anomalies in password changes?'
        ,'How do password changes impact system security?'
        ,'Are there users with a history of password changes?'
        ,'Are there any users who changed their passwords multiple times in a short period?'
        ,'Are there users with unchanged passwords for a year?'
        ,'Which user changed their password the most times in a single day?'
        ,'How many password changes occurred during peak system usage hours?'
        ,'What are the security implications of password changes?'
        ,'Which user changed their password first this year?'
        ,'How does password change frequency vary by role?'
        ,'What is the total number of password changes this quarter?'
        ,'What is the timestamp of the last password change?'
        ,'Which users changed passwords multiple times recently?'
        ,'Can I see a report of password changes?'
        ,'Which users recently changed their passwords?'
        ,'Can I get a report of password changes for a specific time range?'
        ,'Which user changed their password on a specific date?'
        ,'How do password changes correlate with user activity?'
        ,'Are there any correlations between password changes and system login activity?'
        ,'Who changed their password in the last week?'
        ,'What is the average number of password changes per user?'
        ,'How many password changes occurred in the last 30 days?'
        ,'Can you show me the password change history for a specific user?'
        ,'Are there any users who changed their passwords more than 5 times?'
        ,'Which user changed their password most recently?'
        ,'Which users haven''t changed passwords recently?'
        ,'Can you list the top 5 users with the most password changes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, action_name, timestamp FROM dba_audit_trail WHERE action_name = ''ALTER USER''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Audit Settings',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the current audit settings.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can audit settings be customized for specific applications?'
        ,'Are there any audit setting best practices?'
        ,'Are audit logs integrated with SIEM?'
        ,'Is there a report on audit setting changes?'
        ,'Is there a policy for audit log archiving?'
        ,'Can audit settings be modified by users?'
        ,'Can audit logs be accessed by non-DBAs?'
        ,'Are audit settings documented?'
        ,'Are unsuccessful login attempts audited?'
        ,'What are the current audit settings?'
        ,'Are audit logs encrypted?'
        ,'Which actions are being audited?'
        ,'Are DDL operations audited?'
        ,'Can audit logs be used to investigate security incidents?'
        ,'Are audit logs subject to data retention policies?'
        ,'Are there any exceptions to audit logging?'
        ,'Is auditing enabled for specific schemas?'
        ,'How is auditing configured in the database?'
        ,'Is auditing enabled for all users?'
        ,'What is the audit trail location?'
        ,'Are there any automated audit setting checks?'
        ,'Is auditing of database links enabled?'
        ,'Can audit logs be used to track database performance?'
        ,'Are audit settings synchronized with security policies?'
        ,'Is there a standard for audit log formatting?'
        ,'Are audit settings aligned with industry standards?'
        ,'Are there any audit setting recommendations?'
        ,'Is there a limit to the size of audit logs?'
        ,'How are audit settings documented for auditing purposes?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM dba_stmt_audit_opts", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List Partitioned Tables',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all partitioned tables in the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Display all partitioned tables in a specific schema.'
        ,'Are partitioned tables present?'
        ,'Are there any partitioned tables with invalid objects?'
        ,'List partitioned tables by table name.'
        ,'Are there any partitioned tables in the current schema?'
        ,'What is the count of partitioned tables per schema?'
        ,'How many partitioned tables are in each schema?'
        ,'Can you identify partitioned system tables?'
        ,'Display all partitioned tables.'
        ,'What schemas have the most partitioned tables?'
        ,'List partitioned tables by schema.'
        ,'Can you list all partitioned tables?'
        ,'Are there any partitioned tables?'
        ,'What partitioned tables does the database have?'
        ,'What schemas contain partitioned tables?'
        ,'What tables have partitioning enabled?'
        ,'Can you retrieve a list of partitioned tables with their owners?'
        ,'Can you show partitioned tables?'
        ,'Can you identify partitioned tables that need maintenance?'
        ,'What are the names of partitioned tables?'
        ,'How many partitioned tables are in the SYSTEM schema?'
        ,'Identify partitioned tables by schema.'
        ,'Which tables have partitions?'
        ,'Identify partitioned tables that are not indexed.'
        ,'What tables are partitioned?'
        ,'Can you retrieve a list of partitioned tables with their last modification dates?'
        ,'What are the partitioned tables per schema?'
        ,'List partitioned tables that are not optimized.'
        ,'Which tables are partitioned?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, partitioning_type FROM dba_part_tables", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Tables with Most Partitions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify tables with the highest number of partitions.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which tables have the most partitions in a single schema?'
        ,'Which tables have the least partitions?'
        ,'What is the average partition count per schema?'
        ,'Identify tables with partition counts above the 75th percentile.'
        ,'List tables with the highest partition count.'
        ,'What is the total number of partitions across all tables?'
        ,'What is the median partition count for tables?'
        ,'How many tables have partition counts under 5?'
        ,'What tables have the highest partition counts?'
        ,'What is the partition count for the smallest table?'
        ,'Are there tables with partition counts greater than 1000?'
        ,'What is the lowest partition count recorded?'
        ,'List the top 10 tables by partition number.'
        ,'List tables with partition counts divisible by 5.'
        ,'How many tables have partitions over 200?'
        ,'What is the highest partition count recorded in a single schema?'
        ,'List tables with partition counts between 20 and 50.'
        ,'Are there tables with identical partition counts in different schemas?'
        ,'What is the partition count for each table?'
        ,'What is the average partition count per table?'
        ,'What is the highest partition count recorded?'
        ,'Identify tables with partition count above average.'
        ,'Are there tables with identical partition counts?'
        ,'Which table has the third-highest partition count?'
        ,'Find tables exceeding 100 partitions.'
        ,'Which tables exceed 500 partitions?'
        ,'Identify tables with partition counts below 5.'
        ,'What is the median partition count for tables in a single schema?'
        ,'Which tables have the highest partition counts in a specific schema?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, COUNT(*) FROM dba_tab_partitions GROUP BY table_name ORDER BY COUNT(*) DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Last RMAN Backup',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find the most recent completed RMAN backup.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the last successful RMAN backup date?'
        ,'Can you optimize RMAN backup performance?'
        ,'What is the frequency of RMAN backups?'
        ,'What are the best practices for RMAN backups?'
        ,'What is the oldest RMAN backup available?'
        ,'What is the total size of all RMAN backups?'
        ,'Who executed the last RMAN backup?'
        ,'When did the latest RMAN backup complete?'
        ,'What date marks the last RMAN backup completion?'
        ,'What is the size of the last RMAN backup?'
        ,'What is the warning message for the last RMAN backup?'
        ,'What is the date of the latest RMAN backup?'
        ,'Can you show the last RMAN backup details?'
        ,'Is the last RMAN backup recoverable?'
        ,'How many RMAN backups are available?'
        ,'Where is the last RMAN backup stored?'
        ,'How recent is the last successful RMAN backup?'
        ,'When did the last RMAN backup occur?'
        ,'When was the last successful RMAN backup?'
        ,'What is the average duration of RMAN backups?'
        ,'When was the last RMAN backup completed?'
        ,'What is the most recent RMAN backup date?'
        ,'What is the latest RMAN backup status?'
        ,'How fresh is the most recent RMAN backup?'
        ,'What are the parameters used for the last RMAN backup?'
        ,'What is the latest RMAN backup timestamp?'
        ,'When did the latest RMAN backup finish?'
        ,'What is the checksum of the last RMAN backup?'
        ,'What is the completion time of the last RMAN backup?'
        ),
        p_match_document       => JSON('{"sql": "SELECT start_time, status FROM v$rman_backup_job_details WHERE status=''COMPLETED'' ORDER BY start_time DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check RMAN Backup Pieces',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check details of RMAN backup pieces.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the creation time of the earliest RMAN backup piece?'
        ,'What is the retention policy for RMAN backup pieces?'
        ,'How often are full RMAN backups created?'
        ,'What is the backup mode of the latest RMAN backup piece?'
        ,'Are there any RMAN backup pieces in a ''pending'' status?'
        ,'Are there any RMAN backup pieces missing?'
        ,'What is the location of the latest RMAN backup piece?'
        ,'What is the compression ratio of recent RMAN backups?'
        ,'What is the backup type of the earliest RMAN backup piece?'
        ,'How many RMAN backup pieces are differential backups?'
        ,'What is the storage device for RMAN backup pieces?'
        ,'How many RMAN backup pieces are full backups?'
        ,'What is the checksum value for the earliest RMAN backup piece?'
        ,'Average RMAN backup duration?'
        ,'What is the status of the oldest RMAN backup piece?'
        ,'What is the expiration date of the latest RMAN backup piece?'
        ,'How many RMAN backup pieces are older than 30 days?'
        ,'What is the average compression ratio of RMAN backups?'
        ,'How often are RMAN backup pieces created?'
        ,'What is the completion time of the earliest RMAN backup piece?'
        ,'Are there any RMAN backup pieces that are not compressed?'
        ,'What is the backup type of the latest RMAN backup piece?'
        ,'Are there any RMAN backup pieces with errors?'
        ,'How many RMAN backup pieces failed last month?'
        ,'How long did the last RMAN backup take?'
        ,'What is the encryption status of RMAN backup pieces?'
        ,'Which RMAN backup piece has the largest size?'
        ,'Are there any incomplete RMAN backup pieces?'
        ,'What is the average size of incremental RMAN backup pieces?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$backup_piece ORDER BY completion_time DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Datafile Backup Status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Review the backup status of datafiles.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you identify datafiles with backup errors?'
        ,'Which datafiles require immediate backup attention?'
        ,'Can you identify datafiles with skipped backups?'
        ,'What is the total number of backup attempts for all datafiles?'
        ,'Can you identify datafiles with backup configuration errors?'
        ,'Can you show datafiles with backups in progress?'
        ,'Which datafiles are scheduled for backup next?'
        ,'Are there any datafiles with multiple backup attempts?'
        ,'Which datafiles have the most recent backup?'
        ,'Are there any datafiles with backup status warnings?'
        ,'Can you provide a list of datafiles with backup warnings?'
        ,'Are there any corrupted datafiles during backup?'
        ,'Which datafiles have the longest backup intervals?'
        ,'Are there any unusual patterns in datafile backups?'
        ,'Which datafiles have the shortest backup intervals?'
        ,'How frequently are datafiles backed up?'
        ,'What is the average backup size of datafiles?'
        ,'Are there any datafiles with backup anomalies?'
        ,'Are there any datafiles with backup overrides?'
        ,'How many datafiles have backups completed today?'
        ,'Are there any datafiles not backed up recently?'
        ,'Can you list datafiles with backup dependencies?'
        ,'What is the backup status of system datafiles?'
        ,'Are there any datafiles with backups paused?'
        ,'How many datafiles have failed backup attempts?'
        ,'Which datafiles have the most recent backup failures?'
        ,'How does the backup status compare to last week?'
        ,'Which datafiles have missing backup records?'
        ,'Are there any datafiles with backup timeouts?'
        ),
        p_match_document       => JSON('{"sql": "SELECT file#, status, checkpoint_time FROM v$datafile_backup", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Data Pump Export Progress',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor the progress of data pump export jobs.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How much data remains to be exported in active jobs?'
        ,'How do I export only specific schemas with data pump?'
        ,'What is the average size of exported data per job?'
        ,'Are there any data pump export jobs with warnings?'
        ,'What is the average duration of completed export jobs?'
        ,'How many data pump export jobs are running right now?'
        ,'How can I pause a data pump export job?'
        ,'What tables are being exported in current jobs?'
        ,'How do I check if a data pump export job is stuck?'
        ,'What is the total number of data pump export jobs completed this week?'
        ,'How many data pump export jobs completed today?'
        ,'How do I list all completed data pump export jobs?'
        ,'How do I cancel a data pump export job in progress?'
        ,'What is the progress percentage of active data pump exports?'
        ,'How do I optimize data pump export job performance for large datasets?'
        ,'How do I configure email notifications for data pump export job completion?'
        ,'How do I find the owner of a specific data pump export job?'
        ,'How do I troubleshoot a slow data pump export job?'
        ,'Can I see the start time of ongoing data pump exports?'
        ,'What are the error messages for failed export jobs?'
        ,'How do I handle data pump export job errors due to disk space issues?'
        ,'How do I prioritize a specific data pump export job?'
        ,'Are there any long-running data pump export jobs?'
        ,'What is the estimated completion time for export jobs?'
        ,'What is the network bandwidth used by export jobs?'
        ,'Which data pump export job has the highest priority?'
        ,'How do I view the data pump export job history for a specific table?'
        ,'What is the compression ratio of current export jobs?'
        ,'What is the total number of data pump export jobs?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM dba_datapump_sessions", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Sessions with High CPU Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify sessions consuming the most CPU.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show me sessions with the highest CPU rates.'
        ,'Show me sessions with unusually high CPU.'
        ,'How to pinpoint sessions with high CPU demand?'
        ,'How to track sessions with high CPU demand?'
        ,'How to find sessions with unusual CPU usage?'
        ,'What sessions are causing CPU performance issues?'
        ,'What sessions are leading in CPU consumption?'
        ,'Which sessions are the biggest CPU hogs?'
        ,'Which users have sessions with high CPU usage?'
        ,'What are the top 3 CPU-consuming sessions currently?'
        ,'Which sessions have the largest CPU usage variance?'
        ,'Identify sessions with CPU usage over 80%.'
        ,'How to identify sessions with peak CPU utilization?'
        ,'How do I find sessions with the most CPU strain?'
        ,'Find sessions with critical CPU consumption.'
        ,'Which sessions are using the most CPU right now?'
        ,'What are the CPU-intensive sessions currently?'
        ,'List top CPU-consuming sessions by user.'
        ,'What sessions are consuming the most CPU in the last 24 hours?'
        ,'What sessions are consuming excessive CPU?'
        ,'What are the CPU usage stats for idle sessions?'
        ,'List sessions with significant CPU usage increases.'
        ,'Which sessions are dominating CPU resources?'
        ,'What are the top CPU-consuming sessions by module?'
        ,'What session has the peak CPU usage currently?'
        ,'How do I find sessions with high CPU usage?'
        ,'What are the CPU usage stats for active sessions?'
        ,'Identify sessions with the largest CPU footprint.'
        ,'What are the top 5 CPU-consuming sessions?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, username, program, sql_id, cpu_time FROM v$session JOIN v$sql USING (sql_id) ORDER BY cpu_time DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Top 10 Active Users',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find the most active database users by session count.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there users with identical session counts?'
        ,'Who are the least active users by session?'
        ,'List users with session counts above 500.'
        ,'List users with more than 100 sessions.'
        ,'Are there users with no active sessions?'
        ,'Who are the users with the most sessions per minute?'
        ,'List users with session counts below 10.'
        ,'Identify users with stable session counts.'
        ,'How many users have over 50 sessions?'
        ,'What is the average session count per user?'
        ,'Identify users with decreasing session counts.'
        ,'Which users have increased session activity?'
        ,'Who are the top 3 users in session growth?'
        ,'Who are the top users by session count in the last day?'
        ,'Which users have the highest session growth rate?'
        ,'Which user has the second most sessions?'
        ,'Who are the top 5 active database users?'
        ,'Who are the inactive users by session count?'
        ,'List users with session count below average.'
        ,'Who are the users with the most concurrent sessions?'
        ,'Which user has the most sessions in the current month?'
        ,'Rank users by average session duration.'
        ,'What is the maximum session count for a user?'
        ,'Are there users with zero sessions?'
        ,'Rank users by session count.'
        ,'Who are the new active database users?'
        ,'How many sessions do the top 3 users have?'
        ,'How many users have session counts above 1000?'
        ,'How many users have a session count above 200?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, COUNT(*) as session_count FROM v$session WHERE username IS NOT NULL GROUP BY username ORDER BY session_count DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Sessions Generating Most Redo Logs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify sessions generating the most redo logs.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the peak redo log generating sessions?'
        ,'What sessions have the largest redo log footprint?'
        ,'What sessions are generating the most redo log traffic?'
        ,'List top redo log generating sessions by client program.'
        ,'What are the peak hours for redo log generation by session?'
        ,'Identify sessions with high redo log generation by SQL operation.'
        ,'Which processes create the most redo logs?'
        ,'Who are the leading redo log generators?'
        ,'List sessions with the highest redo log activity.'
        ,'Which session is creating the most redo logs?'
        ,'Which sessions are causing redo log contention?'
        ,'What sessions are producing excessive redo logs?'
        ,'Which users have the highest redo log usage by database object?'
        ,'What session has the maximum redo log generation?'
        ,'What sessions have the highest redo log throughput?'
        ,'Which sessions are causing redo log bottlenecks?'
        ,'Which sessions are causing high redo log activity?'
        ,'What are the top redo log generating sessions by index name?'
        ,'What sessions are responsible for the most redo log growth?'
        ,'Find sessions with the highest redo log generation by database feature.'
        ,'What sessions contribute the most to redo logs?'
        ,'Which sessions are consuming the most redo logs?'
        ,'Who are the top redo log generators?'
        ,'Identify sessions with high redo log production.'
        ,'What are the top redo log generating sessions?'
        ,'Identify top redo log generators by session ID.'
        ,'List sessions with high redo log output by username.'
        ,'Which user sessions produce the most redo logs?'
        ,'Who is responsible for the most redo log generation?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, username, redo_blocks FROM v$session ORDER BY redo_blocks DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Top Sessions Waiting on Events',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List sessions currently waiting on events.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which events have the longest average wait times?'
        ,'Are any sessions waiting on Java events?'
        ,'What wait events are most common right now?'
        ,'How many sessions are waiting on events now?'
        ,'Which events have the most sessions waiting?'
        ,'List sessions waiting on concurrency events.'
        ,'How many sessions are waiting on events related to database file operations?'
        ,'Which sessions have the lowest wait counts?'
        ,'What events are sessions currently waiting for?'
        ,'Which sessions have the highest average wait time?'
        ,'List sessions waiting on cursor pin events.'
        ,'What is the total wait time for sessions waiting on I/O events?'
        ,'Are any sessions waiting on CPU events?'
        ,'Are there any sessions waiting on latch events?'
        ,'Which sessions are currently waiting on events?'
        ,'Identify sessions with the longest wait times.'
        ,'What are the top 3 events causing the most waits?'
        ,'Are any sessions waiting on XML events?'
        ,'Are there sessions waiting on events related to Oracle RAC operations?'
        ,'What is the average wait count for all sessions?'
        ,'Are there sessions waiting on enqueue events?'
        ,'List the session IDs currently waiting on events.'
        ,'List sessions waiting on lock events.'
        ,'How many sessions are waiting for resources?'
        ,'Are any sessions waiting on undo events?'
        ,'What is the average wait time for sessions?'
        ,'List sessions waiting on events related to parallel query execution.'
        ,'How many active sessions are waiting on events?'
        ,'What is the current wait event for session 123?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, event, wait_class, state FROM v$session_wait ORDER BY sid", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Identify High Buffer Gets',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify SQL queries with the highest buffer gets.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which queries have the most consistent buffer gets?'
        ,'What is the difference in buffer gets between similar queries?'
        ,'Are there queries with buffer gets anomalies?'
        ,'Can you show SQLs sorted by buffer gets?'
        ,'What is the threshold for high buffer gets in SQL queries?'
        ,'Which queries should be optimized for buffer gets?'
        ,'Can you list the top 10 SQLs by buffer gets?'
        ,'What is the impact of indexing on buffer gets?'
        ,'How frequently do top SQLs hit buffer limits?'
        ,'Can you compare buffer gets across different databases?'
        ,'What is the correlation between buffer gets and CPU usage?'
        ,'How can I monitor buffer gets for critical queries?'
        ,'How can I automate the identification of queries with high buffer gets?'
        ,'Are there any queries with buffer gets below a certain threshold?'
        ,'What is the average buffer gets per query?'
        ,'Identify SQLs with buffer gets above a threshold.'
        ,'What causes high buffer gets in queries?'
        ,'How do buffer gets relate to query execution plans?'
        ,'How to reduce buffer gets in top SQLs?'
        ,'Are buffer gets concentrated in specific queries?'
        ,'Are there queries with unusually high buffer gets?'
        ,'What are the SQLs with buffer gets over 1,000?'
        ,'What is the relationship between buffer gets and disk I/O?'
        ,'Can you identify queries with buffer gets spikes?'
        ,'How many buffer gets does the busiest query have?'
        ,'Which SQLs are flagged for high buffer gets?'
        ,'How do I identify queries with increasing buffer gets?'
        ,'Do any queries have buffer gets over 10,000?'
        ,'Is there a pattern in queries with high buffer gets?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, sql_text, buffer_gets FROM v$sql ORDER BY buffer_gets DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check System-Level Wait Statistics',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display system-level wait statistics.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do wait times compare between daytime and nighttime?'
        ,'Are there any wait events that occur only during peak hours?'
        ,'What is the longest wait event recorded today?'
        ,'What is the shortest average wait time for any event?'
        ,'How do wait times compare between different database instances?'
        ,'Are there any wait events that occur only during weekends?'
        ,'What are the top wait events by time consumed?'
        ,'How many wait events are related to disk I/O operations?'
        ,'What percentage of waits are due to CPU usage?'
        ,'What is the longest average wait time for any event?'
        ,'What is the total wait time for all wait events today?'
        ,'Which wait event is most impacted by system configuration changes?'
        ,'Are there any significant changes in wait statistics?'
        ,'Are there any wait events that are specific to a particular database table?'
        ,'What are the top 10 system wait events?'
        ,'Which wait events are impacting performance?'
        ,'How many wait events are related to network activity?'
        ,'How do wait times trend over the last week?'
        ,'What is the total wait time for user sessions?'
        ,'What percentage of waits are due to concurrency issues?'
        ,'What is the average wait time for system-generated sessions?'
        ,'What is the impact of lock waits on throughput?'
        ,'How many wait events occur during database backups?'
        ,'What is the average wait time for user-initiated sessions?'
        ,'What is the impact of wait events on query execution?'
        ,'How much time is spent on I/O waits?'
        ,'Which wait event is most correlated with system load?'
        ,'How do wait events correlate with application load?'
        ,'Are there any wait events with zero occurrences?'
        ),
        p_match_document       => JSON('{"sql": "SELECT wait_class, total_waits, time_waited FROM v$system_wait_class ORDER BY time_waited DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Current System Load',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Examine current system load metrics.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any long-running queries active?'
        ,'How many sessions are waiting for CPU resources?'
        ,'Are there any invalid objects in the database?'
        ,'How much SGA memory is being utilized?'
        ,'How many log switches have occurred in the last hour?'
        ,'Are there any sessions consuming excessive CPU resources?'
        ,'What is the current system load average over 5 minutes?'
        ,'How many sessions are currently executing a query?'
        ,'What is the current load average on the server?'
        ,'What is the current PGA usage?'
        ,'How many background processes are running?'
        ,'Are there any sessions with high CPU usage due to PL/SQL execution?'
        ,'How many extents are currently allocated for the SYSTEM tablespace?'
        ,'How many database locks are currently held?'
        ,'How many user sessions are currently connected?'
        ,'Are there tablespaces close to full capacity?'
        ,'How many transactions per second are occurring?'
        ,'How many processes are currently running in the background?'
        ,'What is the current average active session count per CPU core?'
        ,'Are there any sessions with high undo segment usage?'
        ,'How many sessions are currently waiting for a resource?'
        ,'What is the current PGA usage in percentage?'
        ,'What is the average wait time for disk I/O operations?'
        ,'Are there any active sessions causing high load?'
        ,'What is the current rate of logons per second?'
        ,'Are there any deadlocks detected?'
        ,'What is the current memory usage by the Oracle instance in GB?'
        ,'What is the current rate of logical reads?'
        ,'What is the current cache hit ratio?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$sysstat WHERE name IN (''CPU used by this session'', ''physical reads'', ''physical writes'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Free System Memory',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check available free memory in the SGA.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to check SGA memory usage?'
        ,'How can I clear free memory in the SGA?'
        ,'How to optimize SGA memory configuration?'
        ,'What is the difference between SGA free memory and total memory?'
        ,'How to analyze SGA memory usage patterns?'
        ,'What is the total free space in the SGA?'
        ,'What are the best practices for managing SGA free memory?'
        ,'What are the implications of low SGA free memory?'
        ,'Can you show the free memory status in the SGA?'
        ,'What are the warning signs of low SGA free memory?'
        ,'What is the relationship between SGA free memory and performance?'
        ,'What percentage of SGA memory is free?'
        ,'How does SGA free memory affect database operations?'
        ,'What is the impact of SGA free memory on queries?'
        ,'How much free memory is available in the SGA?'
        ,'How is SGA free memory distributed across components?'
        ,'What are the consequences of zero SGA free memory?'
        ,'What is the current free memory size in the SGA?'
        ,'How to troubleshoot low SGA free memory?'
        ,'Can I get the SGA free memory details?'
        ,'What is the average SGA free memory usage?'
        ,'How to increase free memory in the SGA?'
        ,'How does SGA free memory correlate with other resources?'
        ,'How to predict SGA free memory requirements?'
        ,'How much SGA memory is allocated?'
        ,'How to set up alerts for SGA memory thresholds?'
        ,'What tools can I use to check SGA free memory?'
        ,'How frequently does SGA free memory change?'
        ,'What is the impact of increasing SGA free memory?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$sga_dynamic_free_memory", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Process and Session Limits',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display current and maximum session and process limits.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How often are session limits updated?'
        ,'Can session limits be managed through SQL?'
        ,'What is the average session count?'
        ,'Can I set session limits based on user roles?'
        ,'Are there any session limit best practices?'
        ,'Can I reserve sessions for specific users?'
        ,'How often do we hit session limits?'
        ,'How many sessions are active at present?'
        ,'Are process limits configurable per instance?'
        ,'What causes session limit breaches?'
        ,'Is there a process limit history report?'
        ,'How do session limits affect scalability?'
        ,'Are session limits affected by database version?'
        ,'How do current sessions compare to the max?'
        ,'Is there a session spike trend?'
        ,'Can I set alerts for session limit thresholds?'
        ,'What is the current session utilization?'
        ,'Can I automate session limit adjustments?'
        ,'Can session limits be dynamically adjusted?'
        ,'Are session limits user-specific?'
        ,'Are there any tools for managing session limits?'
        ,'What is the maximum session limit per user?'
        ,'Can I monitor session limits in real-time?'
        ,'Can session limits be automated?'
        ,'How to optimize session limit settings?'
        ,'What happens when process limits are exceeded?'
        ,'What is the average process count?'
        ,'What is the impact of session limits on user experience?'
        ,'Are session limits affected by database configuration?'
        ),
        p_match_document       => JSON('{"sql": "SELECT resource_name, current_utilization, max_utilization FROM v$resource_limit WHERE resource_name IN (''sessions'', ''processes'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Tablespace Read/Write Operations',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check read/write operations in tablespaces.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any tablespaces with read operations exceeding 90% of total operations?'
        ,'Are there any correlations between tablespace size and read operation count?'
        ,'How do write operations compare across tablespaces?'
        ,'Which tablespace has the highest read operations?'
        ,'Are there any correlations between tablespace fragmentation and read operation count?'
        ,'Are there any anomalies in read/write operations?'
        ,'Can you provide a trend analysis of read/write operations?'
        ,'What percentage of operations are reads in each tablespace?'
        ,'What is the total number of read operations across all tablespaces?'
        ,'How many write operations occurred in the SYSTEM tablespace?'
        ,'How have write operations changed over the last quarter?'
        ,'Which tablespace has the highest read operation count during off-peak hours?'
        ,'Which tablespace has the lowest write operations?'
        ,'Can you list tablespaces with increasing write operation latency?'
        ,'How do read/write operations correlate with tablespace size?'
        ,'Are there any tablespaces with unusual read/write patterns?'
        ,'Can you identify tablespaces with abnormal write operation patterns?'
        ,'How have write operations changed over the last month?'
        ,'Can you list tablespaces with declining read operations?'
        ,'What is the average read operation latency in each tablespace?'
        ,'Which tablespaces have the lowest write operation latency?'
        ,'What is the peak write operation time for each tablespace?'
        ,'What are the current read/write operations in each tablespace?'
        ,'Which tablespaces have the most consistent read operations?'
        ,'Are there any tablespaces with balanced read/write operations?'
        ,'Can you list tablespaces with declining write operations?'
        ,'Which tablespace has the most significant decrease in read operations?'
        ,'How do read/write operations affect overall database performance?'
        ,'What is the peak read operation time for each tablespace?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, reads, writes FROM v$filestat JOIN dba_data_files USING (file#)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Tables with Highest Disk Reads',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify tables with the highest disk read operations.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which tables frequently access disk storage?'
        ,'How do disk reads impact the performance of SQL queries?'
        ,'Can you rank tables by disk read frequency?'
        ,'What tables should I optimize for disk reads?'
        ,'Are small tables also showing high disk reads?'
        ,'How do disk reads affect the performance of data pumps?'
        ,'Which tables are causing high I/O due to reads?'
        ,'How many disk reads are performed by each table?'
        ,'How do disk reads vary between partitioned and non-partitioned tables?'
        ,'What are the top 5 tables by disk reads?'
        ,'Which tables are most affected by disk read latency?'
        ,'Can you compare disk read patterns between different schemas?'
        ,'Which tables have the highest disk read to write ratio?'
        ,'Can you identify tables with the highest read load?'
        ,'What is the correlation between disk reads and CPU usage for each table?'
        ,'What tables are top contributors to disk I/O?'
        ,'What is the distribution of disk reads across tables?'
        ,'Which tables have the highest disk reads?'
        ,'What is the disk read activity for tables with high selectivity?'
        ,'Which tables should be indexed to reduce reads?'
        ,'Can you list tables with high disk read activity and low data volume?'
        ,'Can you list tables with high disk read activity and low query activity?'
        ,'What is the average disk read latency for each table?'
        ,'Which tables have the most disk read activity during data imports?'
        ,'Which tables have surpassed disk read thresholds?'
        ,'What are the disk read stats for my tables?'
        ,'What table has the most disk read activity?'
        ,'Which tables are most I/O intensive?'
        ,'Are there any tables with zero disk read operations?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, disk_reads FROM v$sql_plan JOIN dba_objects USING (object_id) WHERE operation = ''TABLE ACCESS'' AND options = ''FULL'' ORDER BY disk_reads DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Top Objects Generating Physical I/O',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify objects causing the highest physical I/O operations.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Identify sequences with excessive physical writes.'
        ,'Which procedures are linked to high physical I/O operations?'
        ,'Identify sequences with high I/O operations.'
        ,'Which users own high I/O objects?'
        ,'Identify constraints contributing to high physical I/O.'
        ,'Which objects contribute to maximum physical writes?'
        ,'Identify tables with high physical I/O in the last hour.'
        ,'Identify tables with excessive I/O operations.'
        ,'What are the top five datafiles by physical I/O operations?'
        ,'What are the top ten I/O-intensive objects?'
        ,'What are the top three tablespaces by physical I/O operations?'
        ,'What datafiles have the most physical write activity?'
        ,'Are synonyms contributing to high I/O?'
        ,'Are there any materialized views with excessive physical reads?'
        ,'Are there any functions contributing to high physical I/O?'
        ,'Are any temporary tables causing high I/O?'
        ,'Which clusters are linked to high physical write operations?'
        ,'Identify tablespaces with high physical I/O.'
        ,'What is the highest I/O-consuming object?'
        ,'What packages are linked to significant I/O?'
        ,'Are there any IOTs with high physical I/O?'
        ,'What datafiles have the most I/O activity?'
        ,'What triggers are linked to high I/O?'
        ,'What are the top ten objects by physical read operations?'
        ,'What packages are linked to significant physical reads?'
        ,'What objects have the highest physical read operations?'
        ,'Which large objects are causing high physical reads?'
        ,'What views are linked to high physical I/O operations?'
        ,'Which object types have the highest physical read operations?'
        ),
        p_match_document       => JSON('{"sql": "SELECT owner, object_name, object_type, physical_reads, physical_writes FROM v$segment_statistics ORDER BY physical_reads DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check ASM Disk Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display current usage statistics for ASM disk groups.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the average disk size in each ASM disk group?'
        ,'How does current usage compare to last month?'
        ,'How does the current usage of each disk group compare to its average?'
        ,'Can you list the total capacity of all ASM disk groups?'
        ,'What is the current usage of the disk group with the most disks?'
        ,'What is the historical usage pattern of disk groups?'
        ,'Can you identify any disk groups with unusual usage patterns?'
        ,'What is the maximum capacity of each ASM disk group?'
        ,'Which ASM disk group has the most free space?'
        ,'What is the current usage of the disk group with the lowest utilization?'
        ,'Are there any disk groups that are not being utilized?'
        ,'What is the total used space in all ASM disk groups?'
        ,'What are the implications of current usage trends?'
        ,'Which disk group has the most consistent usage pattern?'
        ,'What are the potential risks due to current disk group usage?'
        ,'How often are disk group usage statistics updated?'
        ,'How many disks are in each ASM disk group?'
        ,'Which ASM disk group has the highest utilization?'
        ,'Can you provide a list of disk groups sorted by size?'
        ,'Can you identify any disk groups with inconsistent usage patterns?'
        ,'What is the total capacity of the disk group with the most free space?'
        ,'How often are ASM disk groups updated with new data?'
        ,'Can you forecast the usage of each disk group for the next quarter?'
        ,'Are any ASM disk groups nearing full capacity?'
        ,'Are there any disk groups that need resizing?'
        ,'Are there any ASM disk groups with less than 10% free space?'
        ,'What is the current usage trend for the smallest disk group?'
        ,'How is the load distributed across ASM disk groups?'
        ,'What is the total free space in the disk group with the highest utilization?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, total_mb, free_mb, usable_file_mb FROM v$asm_diskgroup", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor ASM Disk I/O',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Track I/O performance metrics for ASM disks.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the peak I/O throughput for each ASM disk?'
        ,'Are there any ASM disks with I/O performance issues during off-peak hours?'
        ,'What is the I/O distribution pattern across ASM disks?'
        ,'How do I/O metrics correlate with database query performance?'
        ,'What is the I/O wait time for each ASM disk?'
        ,'What is the total I/O throughput for all ASM disks?'
        ,'Are there any ASM disks with high I/O rejection rates?'
        ,'What is the I/O distribution pattern during peak database activity?'
        ,'What are the peak I/O times for ASM disks?'
        ,'Which ASM disk has the highest I/O throughput?'
        ,'What is the average I/O completion time for ASM disks?'
        ,'How does disk utilization vary among ASM disks?'
        ,'Are there any ASM disks with unusually high I/O latency?'
        ,'How do I/O performance metrics vary during peak hours?'
        ,'What is the average I/O queue length for ASM disks?'
        ,'How does I/O performance differ between read and write operations?'
        ,'What is the I/O response time distribution for ASM disks?'
        ,'How do I/O metrics vary between different ASM disk groups?'
        ,'Are there any ASM disks with low I/O utilization?'
        ,'What is the impact of I/O operations on system memory usage?'
        ,'How has ASM disk I/O performance changed over time?'
        ,'What is the I/O utilization trend for ASM disks over the past week?'
        ,'Are there any ASM disks with I/O errors or failures?'
        ,'What is the disk queue length for each ASM disk?'
        ,'Which ASM disk has the lowest I/O latency?'
        ,'What is the impact of concurrent I/O operations on ASM disks?'
        ,'What are the average I/O read times for ASM disks?'
        ,'Which ASM disk has the lowest I/O performance?'
        ,'What is the total I/O latency for all ASM disks?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, read_time, write_time, bytes_read, bytes_written FROM v$asm_disk_stat", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Last 5 RMAN Backups',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List details of the last five RMAN backup jobs.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How long did the longest of the last five RMAN backups take?'
        ,'What were the image copy backup destinations for the last five RMAN jobs?'
        ,'How many backup pieces were created in the last five RMAN jobs?'
        ,'What were the virtual full backup destinations for the last five RMAN jobs?'
        ,'How many archive logs were included in the last five RMAN backups?'
        ,'What were the sizes of the last five RMAN backups?'
        ,'Were any of the last five RMAN backups proxy backups?'
        ,'What were the names of the databases backed up in the last five RMAN jobs?'
        ,'How many blocks were changed in the last five RMAN incremental backups?'
        ,'What were the proxy backup destinations for the last five RMAN jobs?'
        ,'Were any of the last five RMAN backups incremental?'
        ,'What were the statuses of the last five RMAN backup jobs?'
        ,'Which RMAN backup job was the fastest among the last five?'
        ,'How many sections were backed up in the last five RMAN multisection backups?'
        ,'Were any of the last five RMAN backups multisection backups?'
        ,'Were any of the last five RMAN backups virtual full backups?'
        ,'Were any of the last five RMAN backups differential backups?'
        ,'What were the compression levels used in the last five RMAN backups?'
        ,'How many image copies were created in the last five RMAN backups?'
        ,'What were the durations of the last five RMAN backups?'
        ,'What were the backup destinations for the last five RMAN jobs?'
        ,'Were any of the last five RMAN backups incremental backups with a block change tracking file?'
        ,'Did any of the last five RMAN backups use encryption?'
        ,'Were any of the last five RMAN backups image copy backups?'
        ,'What were the start times of the last five RMAN backup jobs?'
        ,'What were the job names of the last five RMAN backups?'
        ,'What were the levels of the last five RMAN backups?'
        ,'Did any of the last five RMAN backups fail?'
        ,'What were the sizes of the backup pieces in the last five RMAN backups?'
        ),
        p_match_document       => JSON('{"sql": "SELECT start_time, status, input_type FROM v$rman_backup_job_details ORDER BY start_time DESC FETCH FIRST 5 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Unused Blocks in Datafiles',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify unused blocks within datafiles.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do I identify datafiles that are candidates for reclaiming unused blocks?'
        ,'What tools can help automate unused block identification and reclaiming?'
        ,'How to monitor changes in unused block count?'
        ,'What SQL query can I use to identify datafiles with unused blocks?'
        ,'How do unused blocks correlate with fragmentation?'
        ,'Can I optimize datafile storage by removing unused blocks?'
        ,'How do I prevent blocks from becoming unused?'
        ,'How do I benchmark unused block reduction?'
        ,'Which datafiles have the most unused blocks?'
        ,'What datafiles have the highest percentage of unused blocks?'
        ,'How can I optimize datafiles with unused blocks?'
        ,'Can I use Oracle''s Enterprise Manager to identify and reclaim unused blocks?'
        ,'How do I determine the number of unused blocks in a specific tablespace?'
        ,'What causes blocks to become unused?'
        ,'How do I identify unused blocks in specific tablespaces?'
        ,'Can unused blocks be repurposed automatically?'
        ,'How do I reclaim unused blocks in datafiles?'
        ,'How do I analyze the impact of unused blocks on database performance metrics?'
        ,'Can I use Oracle''s SQL Tuning Advisor to optimize queries affected by unused blocks?'
        ,'Can unused blocks lead to increased storage costs for backups?'
        ,'What are best practices for managing unused blocks?'
        ,'Are unused blocks more common in certain datafiles?'
        ,'How do I visualize unused block distribution?'
        ,'What are the potential risks of reclaiming unused blocks in production databases?'
        ,'How do I configure alerts for unused blocks?'
        ,'What percentage of a datafile is unused?'
        ,'How do I track changes in unused block count over time?'
        ,'Can unused blocks lead to data corruption?'
        ,'What are the benefits of reclaiming unused blocks in datafiles?'
        ),
        p_match_document       => JSON('{"sql": "SELECT file_name, blocks, empty_blocks FROM dba_data_files JOIN dba_free_space USING (file_id)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Last Applied Archive Log in Standby',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the most recent archive log applied on standby.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you show the archive log applied on standby yesterday?'
        ,'Which archive log was successfully applied on standby after a failure?'
        ,'Display the last applied archive log''s details on standby.'
        ,'What is the sequence number of the first archive log applied on standby?'
        ,'What is the retry count for the last failed archive log on standby?'
        ,'Provide the path of the last applied archive log on standby.'
        ,'How can I check the archive log history on standby?'
        ,'What is the SCN of the last archive log on standby?'
        ,'Which archive log was applied on standby during the last backup?'
        ,'When was the most recent archive log applied to the standby?'
        ,'Provide details of the last applied archive log on standby.'
        ,'What is the archive log application rate on standby per hour?'
        ,'Can you show the archive log applied on standby with a specific sequence number?'
        ,'Show the name of the latest archive log on standby.'
        ,'Identify the latest archive log applied on standby.'
        ,'How to check the latest applied archive log on standby?'
        ,'What is the status of the most recent archive log on standby?'
        ,'What is the timestamp of the last applied archive log on standby?'
        ,'When was the last archive log synchronized to standby?'
        ,'What is the status of the archive log application on standby?'
        ,'Can you provide the details of the archive log applied on standby last month?'
        ,'Which archive log was recently applied to the standby database?'
        ,'Can you provide the error message for the last failed archive log on standby?'
        ,'How many archive logs are applied on standby daily?'
        ,'How can I find the latest archive log applied on standby?'
        ,'What is the log number of the last applied archive on standby?'
        ,'When was the last archive log applied on the standby database?'
        ,'What is the completion time of the last archive log on standby?'
        ,'What is the timestamp of the last archive log applied on standby database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sequence#, applied FROM v$archived_log ORDER BY sequence# DESC FETCH FIRST 1 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Scheduled Jobs',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'View the status and next run date of scheduled jobs.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What was the last run date for \"IndexRebuild\"?'
        ,'What is the status of the \"DatabaseStats\" job?'
        ,'Are there any jobs with no next run date?'
        ,'How many jobs are scheduled hourly?'
        ,'Are there any jobs that are overdue?'
        ,'When is the next execution of the \"Cleanup\" job?'
        ,'What is the status of jobs scheduled for the next quarter?'
        ,'What is the status of jobs scheduled at night?'
        ,'Which jobs are scheduled to run on weekends?'
        ,'Are any jobs scheduled to run during peak hours?'
        ,'Are there any jobs that have been cancelled?'
        ,'How often does \"SystemCheck\" run?'
        ,'What is the next run date for all critical jobs?'
        ,'How many jobs are currently running?'
        ,'Are there any jobs with an unknown status?'
        ,'Are there any failed scheduled jobs?'
        ,'What is the next run date for job ID 101?'
        ,'Are any jobs scheduled to run during maintenance?'
        ,'When will the \"QuarterlyReport\" job execute?'
        ,'How many jobs are scheduled for next week?'
        ,'What is the status of jobs scheduled for the current week?'
        ,'How many jobs are scheduled for today?'
        ,'What is the status of the \"LogRotation\" job?'
        ,'Are there any jobs with a skipped status?'
        ,'When will the \"ReportGenerator\" job run next?'
        ,'What is the status of my scheduled jobs?'
        ,'What jobs are running now?'
        ,'When will the \"MonthlyReport\" job execute?'
        ,'Are there any jobs with errors?'
        ),
        p_match_document       => JSON('{"sql": "SELECT job_name, state, next_run_date FROM dba_scheduler_jobs", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Identify Sessions Using Most Memory',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify sessions consuming the most memory.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What sessions are consuming the most memory right now?'
        ,'Which sessions are prone to memory spikes?'
        ,'How do I detect sessions with excessive memory consumption?'
        ,'What are the sessions with the most memory demand?'
        ,'What sessions are consuming memory excessively?'
        ,'What are the top memory-consuming sessions?'
        ,'List sessions with the highest memory utilization.'
        ,'How to find sessions with the largest memory usage?'
        ,'What sessions are leading in memory consumption?'
        ,'What are the memory usage metrics for the top 5 sessions?'
        ,'Show me the sessions with the highest memory demand currently.'
        ,'Which sessions are causing memory spikes in the database?'
        ,'Which sessions are memory resource-intensive?'
        ,'Identify sessions with abnormal memory consumption.'
        ,'Which sessions are using the most memory currently?'
        ,'Which sessions have the highest memory allocation today?'
        ,'Which sessions are consuming the most memory in the last hour?'
        ,'List the top 10 sessions by memory consumption.'
        ,'What are the memory usage patterns of current sessions?'
        ,'Which sessions are leading in memory usage metrics?'
        ,'Show me the top 10 sessions by memory consumption in the last week.'
        ,'Show the sessions with the highest memory demand.'
        ,'Which sessions have the highest memory allocation?'
        ,'Show sessions with significant memory usage.'
        ,'What sessions are dominating memory resources?'
        ,'Identify sessions with excessive memory usage.'
        ,'Which user sessions consume maximum memory?'
        ,'Are there sessions using more memory than expected?'
        ,'Which users have sessions with high memory usage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, username, program, pga_memory FROM v$session ORDER BY pga_memory DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Real-Time Top SQL Execution Times',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor SQL statements with the longest execution times.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can you show the SQL statement with the longest execution time this week?'
        ,'What SQL statements have the longest execution times during peak hours?'
        ,'How many SQL statements have execution times exceeding 30 minutes?'
        ,'How often do SQL statements with long execution times occur?'
        ,'Which SQL statements have the longest cumulative execution times by schema?'
        ,'What is the average execution time of slow SQL statements?'
        ,'How can I prioritize SQL queries for optimization based on execution time?'
        ,'What SQL queries are causing performance bottlenecks?'
        ,'Can you rank SQL statements by execution time?'
        ,'What are the execution times for SQL statements that are using the most resources?'
        ,'What SQL statements have the longest execution times due to inadequate indexing?'
        ,'Can you provide a list of SQL statements with execution times that are not meeting the SLA?'
        ,'How do I find SQL statements with execution times that vary greatly?'
        ,'What SQL statements have the longest cumulative execution times?'
        ,'Which SQL statements have the highest execution time variance?'
        ,'How can I alert on SQL statements with excessive execution times?'
        ,'What SQL queries have execution times that exceed the SLA?'
        ,'Can you provide a list of SQL queries with execution times above 2 standard deviations?'
        ,'What SQL queries have execution times that are exceeding the baseline?'
        ,'Which SQL statement took the longest to execute today?'
        ,'What are the average execution times for SQL statements by day of the week?'
        ,'Which SQL queries should I optimize based on execution time?'
        ,'Can you identify SQL statements with execution times that are outliers?'
        ,'Which SQL statements are impacting database performance due to long execution?'
        ,'Which SQL queries are causing the most performance issues?'
        ,'Can you show me the SQL statements with execution times that are impacting system performance?'
        ,'What SQL statements have execution times over 1 hour?'
        ,'Which SQL queries have the longest execution times during maintenance windows?'
        ,'Can you provide a list of SQL statements with execution times above the average?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, sql_text, elapsed_time/1000000 AS elapsed_seconds FROM v$sql ORDER BY elapsed_seconds DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Parallel Execution Progress',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check the progress of SQL statements executed in parallel.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which parallel SQL queries are consuming the most CPU?'
        ,'How to reduce the wait time in parallel SQL execution?'
        ,'How do I find the longest running parallel SQL?'
        ,'How to identify bottlenecks in parallel SQL execution?'
        ,'Which SQL statements have completed parallel execution?'
        ,'Which parallel SQL statements are using the most resources?'
        ,'What parallel SQL statements are nearing completion?'
        ,'Are there any resource conflicts in parallel SQL?'
        ,'How many parallel SQL executions have completed successfully?'
        ,'What resources are consumed by parallel SQL queries?'
        ,'How do I identify parallel SQL execution performance issues?'
        ,'Can I view the parallel SQL execution statistics for a specific table?'
        ,'How can I track real-time progress of parallel SQL?'
        ,'How can I improve parallel SQL execution speed?'
        ,'How can I optimize parallel SQL execution for a specific query?'
        ,'Can I view the parallel SQL execution plan for a specific SQL statement?'
        ,'What parallel SQL executions are currently active?'
        ,'Which SQL statements have parallel execution enabled?'
        ,'How many SQL statements are running in parallel now?'
        ,'Are there any parallel SQL executions stuck?'
        ,'What are the recent parallel SQL execution errors?'
        ,'What are the recent parallel SQL execution stats?'
        ,'Are there any failed parallel SQL statements?'
        ,'Are there any parallel SQL executions currently blocked?'
        ,'What is the execution order of parallel SQL statements?'
        ,'What is the progress of my parallel SQL batch job?'
        ,'How do I check the parallel execution efficiency for a specific query?'
        ,'What is the average wait time for parallel SQL executions?'
        ,'How many parallel SQL statements are running now?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, sql_id, degree FROM v$px_session", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find All Active User Sessions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all currently active user sessions.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How many active user sessions are there?'
        ,'Are there any blocked active sessions?'
        ,'How many active sessions are using the most resources?'
        ,'What is the session language of active users?'
        ,'How many sessions are active during peak hours?'
        ,'How many active sessions are from remote users?'
        ,'Are there any active sessions from unknown users?'
        ,'Are there any active sessions with high temporary space usage?'
        ,'What is the process ID of active sessions?'
        ,'What time did the active sessions start?'
        ,'Are there any active sessions with no current activity?'
        ,'What is the client information of active sessions?'
        ,'What is the session state of active users?'
        ,'What is the last activity time of active sessions?'
        ,'Which users have the longest active sessions?'
        ,'What privileges do users of active sessions have?'
        ,'What is the session ID for each active user?'
        ,'What applications are linked to active sessions?'
        ,'What is the authentication method of active sessions?'
        ,'Can you list the SQL statements executed by active sessions?'
        ,'What is the wait event for active sessions?'
        ,'What is the IP address of active sessions?'
        ,'Are there any inactive sessions currently?'
        ,'Can you list the program names of active sessions?'
        ,'Are there any sessions with locked resources?'
        ,'Can you identify sessions with high disk I/O usage?'
        ,'What is the duration of each active session?'
        ,'Are there any active sessions with failed login attempts?'
        ,'What is the login time of active sessions?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, osuser, machine, status FROM v$session WHERE username IS NOT NULL", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Identify Unauthorized System Access',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify failed login attempts and unauthorized actions.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the top unauthorized actions attempted this week?'
        ,'Are failed login attempts associated with system errors?'
        ,'What is the trend of failed logins over the past month?'
        ,'Which user accounts have been locked out due to excessive failed logins?'
        ,'Which database services are most vulnerable to unauthorized actions?'
        ,'How many failed login attempts occurred during peak hours?'
        ,'Are certain applications causing failed login attempts?'
        ,'Are there any failed login attempts from unknown IP addresses?'
        ,'How many unauthorized actions were recorded this month?'
        ,'Can you provide details of the last unauthorized action?'
        ,'Are there any failed login attempts from mobile devices?'
        ,'What is the average number of failed login attempts per day?'
        ,'Who attempted unauthorized access to sensitive tables?'
        ,'What is the trend of failed logins by hour of the day?'
        ,'Can you identify the top 5 IP addresses with failed login attempts?'
        ,'What is the average response time for failed login alerts?'
        ,'Can you list failed login attempts by IP address?'
        ,'Are there specific users with repeated unauthorized actions?'
        ,'What are the most common reasons for failed logins?'
        ,'Can you provide a list of users with no failed login attempts?'
        ,'Can you identify the source of failed login attempts?'
        ,'Which user roles are most involved in unauthorized actions?'
        ,'What measures are in place for failed login alerts?'
        ,'How are failed logins distributed across database nodes?'
        ,'Are there any specific times with spikes in failed logins?'
        ,'What actions were attempted by unauthorized users?'
        ,'Can you provide a list of IP addresses with failed login attempts from multiple users?'
        ,'What are the most common times of day for unauthorized actions?'
        ,'Are failed logins linked to specific database services?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, terminal, action_name, returncode FROM dba_audit_trail WHERE returncode <> 0 ORDER BY timestamp DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Detect Privilege Escalations',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List users who have been granted high-level roles.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Who has the ALTER TABLE privilege?'
        ,'Who holds the CREATE RULE SET privilege?'
        ,'Identify users with the GRANT ANY PRIVILEGE.'
        ,'Who holds the EXP_FULL_DATABASE role?'
        ,'Who holds the SELECT ANY TABLE privilege?'
        ,'Which users have the AUDIT_SYSTEM privilege?'
        ,'Which users have the CREATE INDEXTYPE privilege?'
        ,'Who has the CREATE MATERIALIZED VIEW privilege?'
        ,'List users with the EXECUTE ANY TYPE privilege.'
        ,'Identify users with the ALTER USER privilege.'
        ,'Which users have been granted DBA roles?'
        ,'List users with the EXECUTE ANY PROCEDURE privilege.'
        ,'List users with the CREATE SESSION privilege.'
        ,'List users with the CREATE RULE privilege.'
        ,'List users with the EXECUTE ANY INDEXTYPE privilege.'
        ,'Which users are assigned the IMP_FULL_DATABASE role?'
        ,'Identify users with the EXECUTE ANY OPERATOR privilege.'
        ,'List users with the COMMENT ANY TABLE privilege.'
        ,'Identify users with the CONNECT role.'
        ,'Identify users granted the EXECUTE ANY RULE privilege.'
        ,'Identify users with the CREATE TABLESPACE privilege.'
        ,'Who holds the CREATE USER privilege?'
        ,'List users with the DROP TABLESPACE privilege.'
        ,'Which users have the GRANT ANY ROLE privilege?'
        ,'List users with the ALTER PROFILE privilege.'
        ,'List users with the ADMINISTER DATABASE TRIGGER privilege.'
        ,'Identify users with the EXECUTE ANY SCHEDULE privilege.'
        ,'List users with the CREATE JOB privilege.'
        ,'Who holds the CREATE DIMENSION privilege?'
        ),
        p_match_document       => JSON('{"sql": "SELECT grantee, granted_role FROM dba_role_privs WHERE granted_role IN (''DBA'', ''SYSDBA'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List Users with SYSOPER Privileges',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify users with SYSOPER privileges.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are SYSOPER privileges assigned to any users?'
        ,'Identify users with SYSOPER privileges and their roles.'
        ,'Are there any SYSOPER-privileged accounts?'
        ,'How to verify users with SYSOPER privileges?'
        ,'Who possesses SYSOPER access in this database?'
        ,'Can you identify users with SYSOPER rights?'
        ,'Which users have SYSOPER privileges and are locked out currently?'
        ,'Who has SYSOPER permissions in the database?'
        ,'Who is authorized with SYSOPER privileges?'
        ,'How to find users with SYSOPER privileges?'
        ,'Which accounts are granted SYSOPER rights?'
        ,'Who are the SYSOPER role holders?'
        ,'Can you identify users with SYSOPER privileges and their corresponding roles?'
        ,'How many users have SYSOPER privileges in total now?'
        ,'Are SYSOPER privileges assigned to users?'
        ,'How to check for users with SYSOPER privileges and expired passwords?'
        ,'Are there any users with SYSOPER privileges who are inactive?'
        ,'List users with SYSOPER privileges in this database.'
        ,'Can you display a list of SYSOPER users now?'
        ,'Are there any users with SYSOPER capabilities?'
        ,'How to list users with SYSOPER access rights and permissions?'
        ,'Are there accounts with SYSOPER authorization?'
        ,'How can I list users with SYSOPER access?'
        ,'How do I check for SYSOPER users?'
        ,'Who currently holds SYSOPER privileges?'
        ,'List all SYSOPER role-assigned users.'
        ,'Which users have SYSOPER privileges?'
        ,'List all accounts with SYSOPER privileges.'
        ,'How many users have SYSOPER privileges?'
        ),
        p_match_document       => JSON('{"sql": "SELECT * FROM v$pwfile_users WHERE sysoper = ''TRUE''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Users Who Modified System Objects',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Track users who modified system objects.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can I see a list of system objects modified by a user with a specific role?'
        ,'Who has permission to modify system objects?'
        ,'How many system objects were changed this month?'
        ,'How can I audit changes to system objects?'
        ,'Who changed the system objects yesterday?'
        ,'Which users have altered system objects?'
        ,'Can I see a list of users who changed system objects?'
        ,'Can I track changes to system objects by date and time?'
        ,'Can I see a report of system object modifications by user role?'
        ,'How can I prevent unauthorized modifications to system objects?'
        ,'What system objects were modified recently?'
        ,'What system objects were modified during peak hours?'
        ,'Can I see a history of system object modifications by user ID?'
        ,'Can I see a list of system objects modified by a specific user?'
        ,'Which users have modified system objects in the last quarter?'
        ,'Can I see a history of system object modifications?'
        ,'How many system objects were modified during a specific time range?'
        ,'Who last modified system objects?'
        ,'Are there any anomalies in system object modifications?'
        ,'Who modified the system objects over the weekend?'
        ,'How do I detect and prevent malicious modifications to system objects?'
        ,'What system objects were altered by multiple users?'
        ,'How often are system objects updated during maintenance windows?'
        ,'Which system objects are modified most frequently?'
        ,'How do I identify users who modified system objects without proper training?'
        ,'Can I track changes to system objects as part of a change management process?'
        ,'What is the average frequency of system object modifications?'
        ,'Can I identify users who modified system objects without approval?'
        ,'Who has modified system objects without proper authorization?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, action_name, obj_name, timestamp FROM dba_audit_trail WHERE action_name IN (''CREATE'', ''DROP'', ''ALTER'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check RAC Node Status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the status of all RAC nodes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any RAC nodes with disk space issues?'
        ,'Are there any RAC nodes with high error rates?'
        ,'Are any RAC nodes in a warning state?'
        ,'Which RAC nodes are experiencing issues?'
        ,'Are any RAC nodes in maintenance mode?'
        ,'Are there any RAC nodes with pending alerts?'
        ,'Is there a node that is not participating in the cluster?'
        ,'Are any RAC nodes in restricted mode?'
        ,'How many RAC nodes are active?'
        ,'Are there any RAC nodes with configuration drift?'
        ,'Is there a communication issue between RAC nodes?'
        ,'Is there a node that is not properly synchronized with the cluster?'
        ,'Are all RAC nodes running the same database version?'
        ,'Are there any RAC nodes with warnings?'
        ,'Are any RAC nodes running outdated software?'
        ,'What is the current load on each RAC node?'
        ,'Is there a network issue affecting RAC nodes?'
        ,'Which RAC node has the most connections?'
        ,'What is the current patch level of each RAC node?'
        ,'Are there any RAC nodes recently rebooted?'
        ,'Are any RAC nodes currently down?'
        ,'Are any RAC nodes experiencing issues with the interconnect?'
        ,'Which RAC node is the current master node?'
        ,'Can you list all RAC nodes in the cluster?'
        ,'What is the average uptime of all RAC nodes?'
        ,'Is there a performance issue with any RAC node?'
        ,'What is the current node count in the RAC cluster?'
        ,'What is the current status of all RAC nodes?'
        ,'Is there a node eviction in the RAC cluster?'
        ),
        p_match_document       => JSON('{"sql": "SELECT inst_id, instance_name, status FROM gv$instance", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Cluster Interconnect Latency',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor latency in the cluster interconnect.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can I use third-party tools to monitor interconnect latency?'
        ,'How do I troubleshoot intermittent interconnect latency issues?'
        ,'What are the symptoms of high interconnect latency?'
        ,'Can hardware issues cause interconnect latency?'
        ,'How do I visualize interconnect latency data?'
        ,'Can latency issues impact database performance?'
        ,'How frequently should I check interconnect latency?'
        ,'What are the best practices for optimizing interconnect latency?'
        ,'What is the role of interconnect latency in Oracle database tuning?'
        ,'What scripts help monitor interconnect latency?'
        ,'What are the consequences of high interconnect latency?'
        ,'How do I diagnose sudden increases in interconnect latency?'
        ,'How can I monitor interconnect latency trends?'
        ,'How is interconnect latency measured in Oracle?'
        ,'How do I identify bottlenecks in the interconnect latency?'
        ,'What is the current latency of the cluster interconnect?'
        ,'What are the symptoms of interconnect latency issues in RAC?'
        ,'Can I monitor interconnect latency using SQL queries?'
        ,'What is the historical interconnect latency data?'
        ,'How does interconnect latency impact backup and recovery?'
        ,'What Oracle views show interconnect latency?'
        ,'What factors affect cluster interconnect latency?'
        ,'What performance metrics indicate interconnect latency?'
        ,'How do I set up alerts for interconnect latency?'
        ,'What is the role of interconnect latency in failover scenarios?'
        ,'What is the difference between interconnect latency and network latency?'
        ,'Is the cluster interconnect latency within acceptable limits?'
        ,'How do I identify nodes with high interconnect latency?'
        ,'How do I optimize cluster interconnect latency?'
        ),
        p_match_document       => JSON('{"sql": "SELECT inst_id, wait_time_milli FROM gv$sysstat WHERE name = ''gc cr block receive time''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Most Waited Cluster Events',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify cluster events with the highest wait times.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Identify cluster events with wait times that are decreasing over time.'
        ,'How frequently do cluster events cause waits over 10 seconds?'
        ,'Which cluster events have wait times that exceed 50% of the total wait time?'
        ,'Which cluster events have the highest wait time standard deviation during month-end processing?'
        ,'What are the top 5 cluster events by wait time?'
        ,'What is the longest recorded wait time for a cluster event?'
        ,'What cluster events have the highest wait time variance?'
        ,'How often do cluster events exceed 5 seconds in wait time?'
        ,'Identify cluster events with wait times that are increasing over time.'
        ,'Are there any cluster events with zero wait time?'
        ,'Identify cluster events with wait times that exceed 1 minute.'
        ,'Which cluster event has the most significant impact on performance?'
        ,'What is the correlation between cluster event wait times and disk I/O?'
        ,'Which cluster events cause the most delays in query execution?'
        ,'Which cluster events have the highest wait time during maintenance windows?'
        ,'Which cluster event wait times are improving?'
        ,'What cluster events have the highest average wait times?'
        ,'How do cluster event wait times affect database availability?'
        ,'How do cluster event wait times vary by day of the week?'
        ,'Which cluster events have the highest wait time to response time ratio?'
        ,'Which cluster events have the highest wait time variance during weekends?'
        ,'How do cluster event wait times affect database recovery time?'
        ,'Which cluster events are delaying operations the most?'
        ,'What actions can reduce cluster event wait times?'
        ,'Which cluster events have increased wait times recently?'
        ,'How many cluster events have wait times over 1 second?'
        ,'What cluster events contribute most to system delays?'
        ,'How do wait times for cluster events affect user sessions?'
        ,'What is the wait time distribution for cluster events during backups?'
        ),
        p_match_document       => JSON('{"sql": "SELECT event, total_waits, time_waited FROM gv$system_event ORDER BY time_waited DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Load Balancing Across Nodes',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Analyze active session distribution across RAC nodes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How does session distribution impact performance?'
        ,'Which node consistently has the most active sessions?'
        ,'How do session loads differ during off-peak hours?'
        ,'What is the maximum session capacity per RAC node?'
        ,'Are there session distribution anomalies?'
        ,'Can session distribution be used to predict node failures?'
        ,'Which RAC node has the highest active sessions?'
        ,'What is the session distribution trend over time?'
        ,'What is the relationship between session distribution and SQL execution plans?'
        ,'Which RAC node has the highest average session load over the last day?'
        ,'What is the session distribution like during database upgrades?'
        ,'How do RAC node configurations affect session distribution?'
        ,'Are sessions evenly distributed across RAC nodes?'
        ,'What is the average session load per RAC node?'
        ,'Which RAC node is most prone to session bottlenecks?'
        ,'What is the session distribution like during maintenance windows?'
        ,'What is the average active session count per RAC node over the last hour?'
        ,'What are the peak session times for each node?'
        ,'What is the optimal session distribution strategy for our database?'
        ,'Are there any correlations between session distribution and node resource utilization?'
        ,'How is session distribution monitored across nodes?'
        ,'Which RAC node has the most inconsistent session load?'
        ,'How is session load balanced across nodes?'
        ,'How many sessions are active on each RAC node?'
        ,'How does session load affect RAC node storage utilization?'
        ,'Are there any correlations between session distribution and database errors?'
        ,'How does session distribution impact resource allocation?'
        ,'What is the impact of session distribution on RAC node network traffic?'
        ,'How does session load affect RAC node failover times?'
        ),
        p_match_document       => JSON('{"sql": "SELECT inst_id, COUNT(*) AS active_sessions FROM gv$session WHERE status = ''ACTIVE'' GROUP BY inst_id", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Global Cache Blocks Requested',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor requests for global cache blocks in a cluster.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any failed cache block requests?'
        ,'What percentage of cache block requests are successful?'
        ,'What is the success rate of cache block requests?'
        ,'What is the impact of cache block requests on CPU usage?'
        ,'Are there any cache block request bottlenecks during data loads?'
        ,'How does cache block request latency vary by time of day?'
        ,'What is the cache block request load on the interconnect?'
        ,'What percentage of cache block requests are served from memory?'
        ,'Which database objects are most frequently requested from cache?'
        ,'How does cache block request volume change daily?'
        ,'What is the longest cache block request delay recorded?'
        ,'What is the cache block request distribution by schema?'
        ,'What is the cache block request queue length?'
        ,'How often do cache block requests lead to deadlocks?'
        ,'How are cache block requests distributed across instances?'
        ,'What is the distribution of cache block requests by type?'
        ,'What is the average cache block request size?'
        ,'Are there any cache block request issues with database upgrades?'
        ,'Which SQL statements generate the most cache block requests?'
        ,'Are there any anomalies in cache block requests?'
        ,'Are there any cache block request bottlenecks?'
        ,'Which nodes have the highest cache block request rate?'
        ,'How many cache block requests are pending?'
        ,'Are there any specific users causing high cache block requests?'
        ,'What is the current global cache block request rate?'
        ,'What is the cache block request rate during maintenance windows?'
        ,'Are there any patterns in cache block request failures?'
        ,'How many cache block requests are generated by Oracle background processes?'
        ,'How does cache block request volume change hourly?'
        ),
        p_match_document       => JSON('{"sql": "SELECT inst_id, name, value FROM gv$sysstat WHERE name LIKE ''gc%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Smart Scan Efficiency',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Evaluate the efficiency of smart scans in Exadata.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do I compare smart scan vs. traditional I/O?'
        ,'What metrics indicate smart scan performance?'
        ,'What percentage of queries use smart scans?'
        ,'How do I identify queries that can benefit from smart scans?'
        ,'How do smart scans interact with parallel processing?'
        ,'What is the impact of smart scans on database security?'
        ,'How are smart scans logged in the system?'
        ,'How do smart scans handle large datasets?'
        ,'How do smart scans affect database resource utilization?'
        ,'How do smart scans improve data retrieval?'
        ,'What are the limitations of smart scans on Exadata?'
        ,'What are the best practices for monitoring smart scan performance?'
        ,'What is the role of indexes in smart scans?'
        ,'How do I configure smart scans for optimal performance?'
        ,'What tuning parameters affect smart scans?'
        ,'What is the role of storage indexes in smart scans?'
        ,'How do smart scans impact CPU usage?'
        ,'What tools help analyze smart scan performance?'
        ,'What is the average smart scan response time?'
        ,'What is the role of Exadata storage in smart scan performance?'
        ,'What are the system requirements for smart scans on Exadata?'
        ,'What is the impact of smart scans on database latency?'
        ,'How to determine smart scan eligibility of queries?'
        ,'What are the common issues with smart scans?'
        ,'How do smart scans affect database scalability?'
        ,'How do smart scans affect storage performance?'
        ,'Can smart scans be used with Oracle Database partitioning?'
        ,'How do smart scans impact database backup and recovery?'
        ,'What are the benefits of using smart scans with Oracle Database 12c?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$sysstat WHERE name IN (''cell smart IO'', ''cell smart scan'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Hottest Exadata Disks',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify Exadata disks with the highest I/O activity.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to find Exadata disks with high I/O contention?'
        ,'How to optimize I/O performance on Exadata disks?'
        ,'What are the busiest disks in Exadata by I/O?'
        ,'What are the top 5 Exadata disks by I/O activity?'
        ,'Which Exadata disks have the highest I/O throughput?'
        ,'How to analyze I/O patterns on Exadata disks?'
        ,'How do I find Exadata disks with excessive I/O?'
        ,'Which disks are under the most I/O stress in Exadata?'
        ,'Which disks in Exadata are experiencing I/O saturation?'
        ,'Which disks are the busiest in my Exadata system?'
        ,'Can you list the top 10 Exadata disks by I/O read activity?'
        ,'Can you highlight Exadata disks with intense I/O?'
        ,'What is the I/O activity distribution across Exadata disks?'
        ,'How to find Exadata disks with high I/O wait times?'
        ,'Which Exadata disks have the highest I/O queue length?'
        ,'What disks show the most I/O activity in Exadata?'
        ,'Which Exadata disks have the highest I/O service time?'
        ,'Can you show Exadata disks ranked by I/O usage?'
        ,'How to spot Exadata disks with peak I/O demands?'
        ,'How to determine I/O hotspots on Exadata disks?'
        ,'Which Exadata disks have the most I/O operations?'
        ,'Can you list Exadata disks with top I/O rates?'
        ,'Can you show the I/O activity history for each Exadata disk?'
        ,'What is the current I/O activity on each Exadata disk?'
        ,'Identify the top I/O performing disks in Exadata.'
        ,'How to identify Exadata disks with inconsistent I/O performance?'
        ,'Which Exadata disks are leading in I/O activity?'
        ,'What is the I/O activity level of each Exadata disk?'
        ,'Which Exadata disks have the highest I/O activity?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, read_time, write_time, bytes_read, bytes_written FROM v$cell_state", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Exadata Flash Cache Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor the usage percentage of Exadata flash cache.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What applications are using the most flash cache?'
        ,'Can you provide a forecast for flash cache usage over the next quarter?'
        ,'Are there any flash cache usage trends by day of the week?'
        ,'What is the average flash cache usage over the last quarter?'
        ,'Is there a forecast for future flash cache usage trends?'
        ,'What is the historical maximum flash cache usage?'
        ,'How often is the flash cache completely full?'
        ,'What strategies can optimize flash cache usage?'
        ,'How does flash cache usage vary by database instance?'
        ,'Are there any flash cache usage alerts for the last 24 hours?'
        ,'What is the flash cache hit ratio for read-only operations?'
        ,'How much free space is left in the Exadata flash cache?'
        ,'How frequently is the flash cache usage above 80%?'
        ,'What is the flash cache usage distribution across all storage cells?'
        ,'What is the historical minimum flash cache usage recorded?'
        ,'Are there any flash cache usage trends by month?'
        ,'Are there any recommendations to reduce flash cache usage?'
        ,'How does flash cache usage impact query optimization?'
        ,'How does flash cache usage affect query performance?'
        ,'What metrics indicate optimal flash cache performance?'
        ,'What is the current flash cache usage percentage?'
        ,'How much flash cache is used by backup operations?'
        ,'What is the correlation between flash cache usage and CPU utilization?'
        ,'How does flash cache usage vary by workload type?'
        ,'How much of the flash cache is used by read operations?'
        ,'What is the average usage percentage of the flash cache this month?'
        ,'What is the historical average flash cache usage for this time of year?'
        ,'What is the average flash cache usage during maintenance windows?'
        ,'Can you provide a comparison of flash cache usage between different databases?'
        ),
        p_match_document       => JSON('{"sql": "SELECT flashcache_hit_percent FROM v$cell_flashcache_usage", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Exadata IO Response Times',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Track response times for I/O operations on Exadata.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the minimum I/O response time recorded in the last quarter?'
        ,'What is the correlation between I/O response times and disk space usage?'
        ,'How have I/O response times changed since the last patch?'
        ,'How do response times compare across different Exadata nodes?'
        ,'How have I/O response times improved after optimization efforts?'
        ,'What are the top 10 slowest I/O operations?'
        ,'How do I/O response times vary by hour?'
        ,'How frequently do I/O response times exceed 50ms?'
        ,'How frequently do I/O response times exceed 200ms?'
        ,'How do response times differ between primary and standby databases?'
        ,'What is the maximum I/O response time recorded?'
        ,'How do response times correlate with memory usage?'
        ,'How do I/O response times vary by workload type?'
        ,'How do response times correlate with network latency?'
        ,'What is the impact of I/O response times on user experience?'
        ,'What is the current average I/O response time on Exadata?'
        ,'How do response times vary by I/O request size?'
        ,'What is the distribution of I/O response times?'
        ,'How do I/O response times vary by day of the week?'
        ,'How do response times change during backups?'
        ,'What is the distribution of I/O response times for the top 5 databases?'
        ,'How do response times compare across different I/O types?'
        ,'What is the 90th percentile of I/O response times for the last quarter?'
        ,'What is the average I/O response time for flash storage?'
        ,'Which storage cells have the highest I/O response times?'
        ,'Are there any seasonal trends in I/O response times?'
        ,'How have I/O response times changed since the last storage upgrade?'
        ,'How do response times differ across different storage tiers?'
        ,'What is the impact of I/O response times on application performance?'
        ),
        p_match_document       => JSON('{"sql": "SELECT metric_name, value, unit FROM v$cell_metrics WHERE metric_name LIKE ''%I/O Response Time%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Exadata Offload Efficiency',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Assess the effectiveness of offloading operations in Exadata.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How does offloading affect memory usage in Exadata?'
        ,'What is the relationship between offloading and database partitioning?'
        ,'How effective is offloading in our Exadata environment?'
        ,'Which SQL statements are offloaded in Exadata?'
        ,'How does offloading affect network traffic in Exadata?'
        ,'Are specific workloads more efficient with offloading?'
        ,'How is offloading performance measured in Exadata?'
        ,'How does offloading affect the performance of queries with subqueries?'
        ,'How does offloading impact overall system throughput?'
        ,'Is there a difference in offloading between peak and off-peak hours?'
        ,'What operations benefit most from Exadata offloading?'
        ,'Can offloading improve the performance of queries with window functions?'
        ,'Are certain data types more effectively offloaded?'
        ,'How does offloading affect the performance of queries with aggregations?'
        ,'Are there any bottlenecks despite offloading in Exadata?'
        ,'How does offloading affect the performance of queries with regular expressions?'
        ,'How does offloading impact the performance of queries with joins?'
        ,'How does offloading affect Exadata storage cells?'
        ,'How does offloading affect the performance of queries with JSON data types?'
        ,'Are there any differences in offloading efficiency between Exadata models?'
        ,'How frequently are operations offloaded in Exadata?'
        ,'What is the offloading efficiency for analytical queries?'
        ,'Can offloading reduce the load on Exadata''s compute nodes?'
        ,'What percentage of operations are offloaded in Exadata?'
        ,'How does offloading impact query execution times?'
        ,'Is there a notable reduction in CPU usage due to offloading?'
        ,'What improvements can be made to enhance offloading effectiveness?'
        ,'Are there any limitations to current offloading strategies?'
        ,'Can offloading reduce the load on Exadata storage cells?'
        ),
        p_match_document       => JSON('{"sql": "SELECT metric_name, value FROM v$cell_metrics WHERE metric_name LIKE ''%Offload%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Running Autonomous Database Services',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List running autonomous database services and their status.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'List running autonomous databases and their statuses.'
        ,'Can you provide an update on autonomous service status?'
        ,'What is the current state of autonomous databases?'
        ,'What autonomous databases are currently in service?'
        ,'How can I verify autonomous database status?'
        ,'What is the status of autonomous database operations?'
        ,'How do I check the status of autonomous services?'
        ,'Are there any autonomous database services that are down?'
        ,'What autonomous database services are up and running?'
        ,'Are there any autonomous databases that are not running?'
        ,'What is the current operational status of autonomous databases?'
        ,'Are autonomous database services currently operational?'
        ,'What services are running in autonomous databases?'
        ,'Which autonomous databases are not down?'
        ,'Can I get a list of active autonomous services?'
        ,'Are there any inactive autonomous database services?'
        ,'What is the current status of each autonomous database service?'
        ,'What is the operational status of autonomous databases?'
        ,'Which autonomous databases are currently active?'
        ,'How many autonomous databases are running now?'
        ,'Which autonomous databases have an up status?'
        ,'How many services are running in autonomous mode?'
        ,'How can I check running autonomous database services?'
        ,'Can you list the active autonomous database services?'
        ,'Are all autonomous services currently running smoothly?'
        ,'Can you list autonomous databases by status?'
        ,'Which autonomous databases are operational at the moment?'
        ,'What autonomous databases have a running status?'
        ,'What is the status of all running autonomous databases?'
        ),
        p_match_document       => JSON('{"sql": "SELECT db_name, status FROM dba_autonomous_databases", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Autonomous Database CPU Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor CPU usage in autonomous databases.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How does current CPU usage affect performance?'
        ,'What are the top CPU-consuming processes?'
        ,'What are the CPU usage metrics for the last 24 hours?'
        ,'What is the relationship between CPU usage and memory usage?'
        ,'What is the average CPU usage per day?'
        ,'How to correlate CPU usage with workload?'
        ,'How many CPUs are being used by the database?'
        ,'What is the CPU usage per session?'
        ,'How do I detect CPU usage spikes?'
        ,'How to analyze CPU usage by database schema?'
        ,'Can I view CPU usage by database service name?'
        ,'How to optimize database configuration for CPU usage?'
        ,'Which queries are consuming most CPU?'
        ,'Can I see CPU usage trends over time?'
        ,'What is the historical CPU usage pattern?'
        ,'What are the CPU usage statistics for the current week?'
        ,'How can I check current CPU usage?'
        ,'How to troubleshoot high CPU usage issues?'
        ,'How to reduce CPU usage caused by database indexing?'
        ,'Which database operations consume the most CPU?'
        ,'How do I find average CPU usage this month?'
        ,'Is there a CPU usage alert system?'
        ,'Are there any CPU usage anomalies?'
        ,'What is the current CPU utilization rate?'
        ,'Can I compare CPU usage across different databases?'
        ,'Can I view CPU usage by database instance?'
        ,'What is the CPU usage trend over the last quarter?'
        ,'How does CPU usage compare to last month?'
        ,'Can I set up CPU usage notifications?'
        ),
        p_match_document       => JSON('{"sql": "SELECT metric_name, value FROM v$sysmetric WHERE metric_name = ''CPU Usage Per Sec''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List All Oracle Cloud Users',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display all users in the Oracle Cloud environment.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How to fetch all users in Oracle Cloud?'
        ,'Can I get a list of all Oracle Cloud users?'
        ,'How to access Oracle Cloud user details?'
        ,'Retrieve a list of Oracle Cloud users.'
        ,'Display all user profiles in Oracle Cloud.'
        ,'What are the usernames in the Oracle Cloud?'
        ,'What are the Oracle Cloud user permissions?'
        ,'How to see all users in Oracle environment?'
        ,'What SQL query lists all Oracle Cloud users?'
        ,'Show me the Oracle Cloud user list.'
        ,'How to identify users in Oracle Cloud?'
        ,'Can I display Oracle Cloud user accounts?'
        ,'What is the Oracle Cloud user directory?'
        ,'What are the current users in Oracle Cloud?'
        ,'How to compile a list of Oracle Cloud users?'
        ,'How to find user profiles in Oracle Cloud?'
        ,'Can I identify all users in Oracle Cloud?'
        ,'How to summarize users in Oracle Cloud?'
        ,'How to get user information in Oracle Cloud?'
        ,'Which command lists Oracle Cloud users?'
        ,'Generate Oracle Cloud user report.'
        ,'What query shows all Oracle Cloud users?'
        ,'What are the active users in Oracle Cloud?'
        ,'Display Oracle Cloud user names.'
        ,'What are the user roles in Oracle Cloud?'
        ,'What are the Oracle Cloud user details?'
        ,'Can I see a list of all Oracle Cloud accounts?'
        ,'How to extract user data from Oracle Cloud?'
        ,'How to compile an Oracle Cloud user list?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username FROM dba_users WHERE common = ''YES''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Autonomous Workload Balancing',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor active session distribution across autonomous services.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the average active session per service?'
        ,'How has session distribution changed over time?'
        ,'What services have the most active sessions currently?'
        ,'Which service has the most consistent session count?'
        ,'How do active sessions affect CPU usage by service?'
        ,'How does active session distribution vary by day of the week?'
        ,'Are there any services with consistently high active session counts?'
        ,'How does session distribution impact memory usage by service?'
        ,'How do session distributions impact resource allocation?'
        ,'How are active sessions distributed across services?'
        ,'What service has the lowest session distribution variance?'
        ,'How often do active sessions peak per service?'
        ,'Can you identify session distribution bottlenecks?'
        ,'What is the average active session count per service over time?'
        ,'How does session distribution impact service availability?'
        ,'Which services have the most active sessions on weekends?'
        ,'Can you compare active session counts between different service categories?'
        ,'Can you forecast active session counts based on historical data?'
        ,'Can session distribution predict future service demands?'
        ,'Can you provide a summary of active sessions by service for the last week?'
        ,'How do session distributions vary on weekends?'
        ,'Which services have the most active sessions during off-peak hours?'
        ,'How are session distributions impacting database performance?'
        ,'Can you list active sessions per service?'
        ,'What is the peak active session count for each service?'
        ,'How does session distribution affect network usage by service?'
        ,'Which service has the highest active session count?'
        ,'What is the distribution of active sessions by service type?'
        ,'Can you provide a histogram of active sessions by service?'
        ),
        p_match_document       => JSON('{"sql": "SELECT service_name, active_sessions FROM gv$service_stats", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Oracle Cloud Storage Usage',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Show storage allocation and usage in Oracle Cloud tablespaces.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which tablespace is using the most storage?'
        ,'Which tablespaces have the fastest storage usage growth rate?'
        ,'What is the maximum storage capacity for each tablespace?'
        ,'What is the impact of storage allocation on query performance?'
        ,'Can I get a list of tablespaces with storage usage below 20%?'
        ,'Can you provide a forecast of storage usage for the next quarter?'
        ,'Can I get a report of tablespaces with storage issues?'
        ,'How often should I monitor tablespace storage allocation?'
        ,'Which tablespace has the highest storage allocation?'
        ,'What storage optimization recommendations are there for tablespaces?'
        ,'Are there any tablespaces with inconsistent storage usage patterns?'
        ,'Can I see storage trends over time for tablespaces?'
        ,'How much storage is allocated to the system tablespace?'
        ,'How does storage allocation compare between tablespaces?'
        ,'Are there any tablespaces with unused storage allocation?'
        ,'Are there any tablespaces with unused allocated storage?'
        ,'What percentage of storage is used in each tablespace?'
        ,'How often is tablespace storage usage updated?'
        ,'Which tablespaces have the lowest storage allocation?'
        ,'What is the recommended storage allocation for each tablespace?'
        ,'How is storage distributed among Oracle Cloud tablespaces?'
        ,'How much storage is allocated to each tablespace?'
        ,'Are there any tablespaces nearing full capacity?'
        ,'How does storage allocation impact database scalability?'
        ,'What is the average storage usage for each tablespace type?'
        ,'Can I see a list of tablespaces with over 90% storage usage?'
        ,'Can you show the storage allocation history for a specific tablespace?'
        ,'What tablespaces have the fastest growing storage usage?'
        ,'Can I receive notifications for tablespaces with low free space?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tablespace_name, allocated_space, used_space FROM dba_cloud_tablespaces", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Auto-Detect Unusual CPU Spikes Using AI',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify SQL statements with abnormal CPU usage patterns.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How can I find SQLs with unexpected CPU usage?'
        ,'Are there SQL statements with unpredictable CPU usage?'
        ,'Which SQL statements are experiencing CPU usage spikes?'
        ,'Identify SQL statements with CPU usage trends that are not typical.'
        ,'Which SQLs are using excessive CPU resources?'
        ,'What SQL statements are causing CPU usage to spike?'
        ,'What SQL queries have irregular CPU consumption trends?'
        ,'What queries are causing abnormal CPU load?'
        ,'Which queries are consuming excessive CPU resources?'
        ,'Are there any SQL statements with excessive CPU usage?'
        ,'Which queries are causing CPU spikes?'
        ,'List SQL statements with abnormal CPU utilization.'
        ,'Identify queries with abnormal CPU usage.'
        ,'What SQL statements have CPU usage that is higher than expected?'
        ,'Identify SQL queries with high CPU consumption.'
        ,'Are there SQL statements with irregular CPU usage?'
        ,'What SQL statements have the most abnormal CPU usage?'
        ,'What SQL queries are flagged for abnormal CPU consumption?'
        ,'What SQL statements are consuming more CPU than expected?'
        ,'Which SQL statements are showing abnormal CPU usage?'
        ,'List SQL statements with CPU utilization outliers.'
        ,'Which SQL statements exhibit abnormal CPU behavior?'
        ,'What queries have abnormal CPU usage distributions?'
        ,'Identify SQLs with high CPU usage anomalies.'
        ,'Find SQLs with CPU usage patterns that are not normal.'
        ,'How can I detect SQLs with unusual CPU patterns?'
        ,'Which SQLs are showing CPU usage outliers?'
        ,'Which SQL queries are flagged for high CPU usage?'
        ,'What SQL queries have CPU consumption patterns that are unusual?'
        ),
        p_match_document       => JSON('{"sql": "SELECT cpu_time FROM v$sql_monitor WHERE cpu_time > (SELECT AVG(cpu_time) + 2*STDDEV(cpu_time) FROM v$sql_monitor)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Predict Storage Growth Using Historical Trends',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Analyze historical data to forecast storage growth.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the key drivers of storage growth in our database?'
        ,'What is the average monthly storage growth rate?'
        ,'Has storage growth accelerated or decelerated recently?'
        ,'What is the projected storage growth for the next quarter?'
        ,'What is the expected storage usage by the end of the year?'
        ,'How reliable are our historical storage data trends?'
        ,'Can you forecast storage needs based on business growth projections?'
        ,'How accurate are previous storage growth forecasts?'
        ,'How does user activity affect storage growth?'
        ,'How do data archiving policies affect storage growth?'
        ,'Can you identify any opportunities to optimize storage usage and reduce growth?'
        ,'Can you identify any anomalies in storage growth?'
        ,'Are there any seasonal patterns in storage growth?'
        ,'How does storage growth vary across departments?'
        ,'How does database size correlate with storage growth?'
        ,'How does our storage growth compare to industry benchmarks?'
        ,'How does storage growth impact database licensing costs?'
        ,'What is the storage growth forecast for a specific schema or tablespace?'
        ,'Are there any cost implications of projected storage growth?'
        ,'How does data compression affect storage growth forecasts?'
        ,'How does storage growth affect our ability to meet regulatory compliance requirements?'
        ,'Can you identify the top storage-consuming databases?'
        ,'What factors are influencing our storage growth rate?'
        ,'What storage capacity will be needed in six months?'
        ,'What is the average storage growth rate per quarter?'
        ,'Is there a need to upgrade storage infrastructure soon?'
        ,'Are there any storage-intensive queries that impact growth?'
        ,'What is the storage growth forecast for a specific database feature (e.g., partitioning)?'
        ,'Are there any storage growth trends specific to certain tables?'
        ),
        p_match_document       => JSON('{"sql": "SELECT TO_CHAR(creation_time, ''YYYY-MM'') AS month, SUM(bytes)/1024/1024 AS size_mb FROM dba_segments GROUP BY TO_CHAR(creation_time, ''YYYY-MM'') ORDER BY month", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Query JSON Data in Oracle',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Extract specific values from JSON data stored in Oracle.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do you update a JSON field in Oracle?'
        ,'How to query JSON data in Oracle using regular expressions?'
        ,'Is there a way to extract JSON values into variables?'
        ,'How to migrate JSON data from another database to Oracle?'
        ,'How do I handle missing JSON keys in queries?'
        ,'How to handle JSON data with nested arrays in Oracle?'
        ,'How to optimize JSON queries in Oracle for performance?'
        ,'What is the maximum size of JSON data in Oracle?'
        ,'How do I extract JSON values conditionally?'
        ,'How to validate JSON data against an XSD schema in Oracle?'
        ,'How can I extract JSON values from a CLOB column?'
        ,'How can I extract JSON data using PL/SQL?'
        ,'How to extract JSON data from a VARCHAR2 column?'
        ,'Can I retrieve nested JSON values from Oracle?'
        ,'What is the syntax to query JSON data in Oracle?'
        ,'How do I extract a specific JSON key value in Oracle?'
        ,'How do I extract JSON data with error handling?'
        ,'How to extract JSON data from a BLOB column?'
        ,'How to extract JSON data from an Oracle external table?'
        ,'What are the best practices for indexing JSON data in Oracle?'
        ,'How to optimize JSON data storage in Oracle for disk space?'
        ,'Can JSON data be indexed in Oracle for faster access?'
        ,'What are best practices for storing JSON in Oracle?'
        ,'What are the limitations of JSON querying in Oracle?'
        ,'How can I filter rows based on JSON content?'
        ,'What datatype should store JSON in Oracle?'
        ,'What are the limitations of Oracle JSON functions?'
        ,'What are the error handling mechanisms for Oracle JSON functions?'
        ,'How to compare JSON data between two Oracle tables?'
        ),
        p_match_document       => JSON('{"sql": "SELECT json_value(data, ''$.name'') AS name, json_value(data, ''$.age'') AS age FROM employees_json_table", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Corrupt Blockchain Transactions',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List blockchain transactions with failed status.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the average time to resolve a failed blockchain transaction?'
        ,'How many failed transactions occurred in the last month?'
        ,'Are there any failed blockchain transactions this week?'
        ,'Can you show me the details of a specific failed blockchain transaction?'
        ,'Can you show me the top 5 failed blockchain transactions?'
        ,'Can you provide a summary of failed blockchain transactions by day?'
        ,'What are the details of the latest failed blockchain transaction?'
        ,'What is the failure rate of blockchain transactions by node?'
        ,'Which blockchain transactions ended with a failed status?'
        ,'What causes blockchain transactions to fail?'
        ,'Are there any failed blockchain transactions from a specific user?'
        ,'How long do failed blockchain transactions take to resolve?'
        ,'Which blockchain transactions failed due to timeouts?'
        ,'How are failed blockchain transactions logged?'
        ,'Can you provide a summary of failed blockchain transactions?'
        ,'What actions are taken after a blockchain transaction fails?'
        ,'Can you show me the failed blockchain transactions for a specific date range?'
        ,'Can you provide a list of failed blockchain transactions with timestamps?'
        ,'Which blockchain transactions failed due to insufficient funds?'
        ,'What is the failure rate of blockchain transactions?'
        ,'Are there specific blocks with more failed transactions?'
        ,'What percentage of blockchain transactions fail?'
        ,'What is the current status of failed blockchain transactions?'
        ,'How many blockchain transactions failed today?'
        ,'Are there patterns in failed blockchain transactions?'
        ,'Which users have the most failed blockchain transactions?'
        ,'What is the average duration of failed blockchain transactions?'
        ,'What is the total count of failed blockchain transactions?'
        ,'Do failed blockchain transactions correlate with system load?'
        ),
        p_match_document       => JSON('{"sql": "SELECT tx_id, status FROM dba_blockchain_transactions WHERE status = ''FAILED''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor JSON Table Performance',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Track performance metrics for JSON tables.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'How do I track JSON table growth over time?'
        ,'How do I troubleshoot JSON query performance issues?'
        ,'How do I analyze JSON query execution plans?'
        ,'Can I automate JSON table maintenance tasks?'
        ,'What are the JSON table locking mechanisms?'
        ,'How do I monitor JSON table disk space usage?'
        ,'How can I detect JSON table access patterns?'
        ,'What is the impact of JSON schema changes on performance?'
        ,'What is the JSON table row count over time?'
        ,'How do I identify JSON tables with high lock contention?'
        ,'What are the top JSON queries by execution time?'
        ,'What is the JSON data retention policy?'
        ,'What is the JSON query timeout setting?'
        ,'How do I monitor JSON table log activity?'
        ,'What is the JSON parsing time for queries?'
        ,'How is JSON data impacting database performance?'
        ,'How can I integrate JSON tables with other Oracle features?'
        ,'How do I measure JSON table throughput?'
        ,'How do I optimize JSON table indexing?'
        ,'How often are JSON tables updated?'
        ,'What is the JSON table read/write ratio?'
        ,'What is the average response time for JSON operations?'
        ,'What is the JSON parsing error rate?'
        ,'What are the key metrics for JSON table efficiency?'
        ,'Can I use JSON tables with Oracle RAC?'
        ,'How frequently do JSON tables experience deadlocks?'
        ,'How do I validate JSON table data integrity?'
        ,'Which JSON tables have the most indexes?'
        ,'How can I migrate JSON tables to a new database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, json_schema, storage_size FROM dba_json_tables", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Tables Without Access in Last 6 Months',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify tables not accessed in the last six months.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Find tables with zero modifications in the last six months.'
        ,'Which tables are stagnant for six months?'
        ,'Reveal tables with no activity for half a year.'
        ,'List tables idle for over six months.'
        ,'List dormant tables for the past six months.'
        ,'Identify tables with no activity in the last six months.'
        ,'Reveal tables with low usage patterns.'
        ,'Which tables haven''t been accessed in six months?'
        ,'Tables not utilized since six months ago?'
        ,'List tables with no updates in the last 180 days.'
        ,'Tables not updated in the last six months?'
        ,'Identify tables with no access in half a year.'
        ,'Which tables have not been queried in the last year?'
        ,'Identify tables with six-month access gap.'
        ,'List tables with no access in the last nine months.'
        ,'Which tables have not been queried in the last two quarters?'
        ,'Find six-month dormant database tables.'
        ,'Identify tables with zero usage in the last six months.'
        ,'List tables not accessed in the past six months.'
        ,'Are there tables with no updates in six months?'
        ,'Reveal tables unused in six months.'
        ,'What tables are inactive for six months?'
        ,'Identify tables not used for six months.'
        ,'What tables have been inactive for the longest period?'
        ,'Which tables lack activity for six months?'
        ,'Find tables with zero access in six months.'
        ,'Show me tables that are no longer active.'
        ,'Identify tables with low query volumes.'
        ,'Are any tables unqueried for six months?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name, last_accessed FROM dba_tables WHERE last_accessed < SYSDATE - 180", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check for Tables Without Indexes',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Find tables that do not have associated indexes.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can I get a report of unindexed tables in schema Z?'
        ,'Can you provide a list of unindexed tables in the test database?'
        ,'How to find tables without indexes?'
        ,'Which tables are missing indexes?'
        ,'Provide list of unindexed tables.'
        ,'Are all tables in schema X indexed?'
        ,'List tables missing indexes.'
        ,'Show me tables that need indexing in schema X.'
        ,'Identify tables with no indexes.'
        ,'What tables are not indexed in my schema?'
        ,'Tables without indexes in schema Y?'
        ,'Which schemas have unindexed tables?'
        ,'How to find tables that aren''t indexed in Oracle?'
        ,'What schemas have tables without indexes?'
        ,'Which tables are not indexed in the development database?'
        ,'Find tables without associated indexes.'
        ,'How many tables have no indexes?'
        ,'Provide a report of tables lacking indexes.'
        ,'What tables have no indexes?'
        ,'Tables needing indexes?'
        ,'What are the unindexed tables?'
        ,'Can you list unindexed tables?'
        ,'How to report tables missing indexes?'
        ,'Any tables not indexed?'
        ,'Do any tables lack indexes?'
        ,'Are there tables without any indexes?'
        ,'How many tables are unindexed in the current schema?'
        ,'Identify unindexed tables in the entire database.'
        ,'Are there any tables without indexes in the test database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT table_name FROM dba_tables WHERE table_name NOT IN (SELECT table_name FROM dba_indexes)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Identify Users Who Have Never Logged In',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify users who have never logged into the database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Find users who haven''t modified any database data.'
        ,'Which users have never executed a database query?'
        ,'Can you find users with no logins?'
        ,'Which users have never accessed the system?'
        ,'Are there users with no login data?'
        ,'Are there any users with no database login audit trails?'
        ,'Who are the inactive database user roles?'
        ,'Find accounts with no login activity.'
        ,'Are there users with no login history?'
        ,'What users have no database access history?'
        ,'Who are the inactive users in the database?'
        ,'List users who haven''t logged in this month.'
        ,'Which users have never connected to the database?'
        ,'List users who have never authenticated.'
        ,'Identify users with no recorded logins.'
        ,'Who hasn''t accessed the database?'
        ,'List users who haven''t accessed the database this year.'
        ,'Find users who haven''t performed any database operations.'
        ,'List users who haven''t logged in yet.'
        ,'Who are the dormant database user accounts?'
        ,'Who are the non-active users?'
        ,'Find users who haven''t accessed the database recently.'
        ,'Which users have no database usage history?'
        ,'Can you list dormant database users?'
        ,'Are there any users without login credentials?'
        ,'Can you show me inactive database accounts?'
        ,'Find users without any database login records.'
        ,'Which users have no login history?'
        ,'Are there any users who never logged in?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username FROM dba_users WHERE last_login IS NULL", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Objects Created Recently',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List database objects created in the past week.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which indexes are new this week?'
        ,'Are there new chains this week?'
        ,'List new users added recently.'
        ,'List object types created in the last week.'
        ,'Which programs were created recently?'
        ,'Show recent libraries created.'
        ,'Which indexes were created in the last week?'
        ,'What types of objects were created this week?'
        ,'List any new dimensions this week.'
        ,'Are there any new XML schemas from the past week?'
        ,'What objects were modified this week?'
        ,'What materialized views were added?'
        ,'Are there any new schedules from this week?'
        ,'List consumer groups added in the past 7 days.'
        ,'List database links added in the last week.'
        ,'List newly created jobs.'
        ,'What recent changes in object privileges?'
        ,'What chains were created recently?'
        ,'What materialized views were created recently?'
        ,'What database objects were created yesterday?'
        ,'List newly created packages.'
        ,'Which programs were added in the last week?'
        ,'Show new schedules added this week.'
        ,'List libraries added in the past 7 days.'
        ,'What tablespaces were created this week?'
        ,'Are there any new sequences from this week?'
        ,'Show recent database links.'
        ,'What tables were created this week?'
        ,'What roles were created in the last week?'
        ),
        p_match_document       => JSON('{"sql": "SELECT object_name, created FROM dba_objects WHERE created > SYSDATE - 7", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Active Data Guard Apply Rate',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor apply and transport lag in Active Data Guard.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the consequences of high transport lag?'
        ,'How do I verify transport lag in real-time?'
        ,'How do I set up email notifications for apply lag issues?'
        ,'Are there any Oracle tools specifically designed for transport lag monitoring?'
        ,'What are the best practices for reducing transport lag in Active Data Guard?'
        ,'How do I resolve excessive apply lag?'
        ,'Can I use SQL queries to monitor apply lag in real-time?'
        ,'Can hardware upgrades reduce apply lag?'
        ,'What is the relationship between apply lag and database replication?'
        ,'What are the recommended settings for transport lag in Oracle databases?'
        ,'What causes apply lag in Active Data Guard?'
        ,'What are the implications of ignoring apply lag alerts?'
        ,'How does apply lag impact data consistency?'
        ,'What are the consequences of not monitoring transport lag?'
        ,'How do I troubleshoot apply lag issues?'
        ,'What queries show current transport lag?'
        ,'How do I automate apply lag checks?'
        ,'How can I check the transport lag status?'
        ,'How to interpret transport lag statistics?'
        ,'How does apply lag impact database availability?'
        ,'Can I use scripts to monitor apply lag and send alerts?'
        ,'What is the difference between apply lag and redo log lag?'
        ,'How do I configure my database to alert me to transport lag issues?'
        ,'Is transport lag influenced by system load?'
        ,'How to set up alerts for transport lag?'
        ,'Is there any apply lag alert?'
        ,'How do I reduce transport lag?'
        ,'What is the current apply lag in Active Data Guard?'
        ,'How do I analyze transport lag trends over time?'
        ),
        p_match_document       => JSON('{"sql": "SELECT name, value FROM v$dataguard_stats WHERE name IN (''apply lag'', ''transport lag'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Data Guard Switchover Readiness',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Check if the database is ready for a switchover.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Is the control file synchronized for switchover?'
        ,'What is the current switchover status?'
        ,'Is flashback enabled for switchover?'
        ,'Is the Data Guard broker configured?'
        ,'Are there any blocking sessions preventing switchover?'
        ,'Is the database in a valid state for switchover?'
        ,'Is the database backup current and complete?'
        ,'Are there any unresolved archive log issues?'
        ,'Are there any pending transactions before switchover?'
        ,'Are all redo logs synchronized?'
        ,'Are there any unresolved data dictionary issues?'
        ,'Is the database in ARCHIVELOG mode?'
        ,'Is the standby database in sync with primary?'
        ,'Is the role transition feasible now?'
        ,'Is flashback logging enabled for the database?'
        ,'Is the standby database synchronized?'
        ,'Is the database backup up-to-date?'
        ,'Are there any gaps in Data Guard configuration?'
        ,'Is the database protection mode suitable?'
        ,'Are all services configured for switchover?'
        ,'Is the switchover process enabled?'
        ,'Are all network settings correct for switchover?'
        ,'Are there any errors in the database alert log?'
        ,'Is the database in FORCE LOGGING mode?'
        ,'Is the primary database in a stable state?'
        ,'Are there any active database sessions?'
        ,'Is the switchover eligibility checked and confirmed?'
        ,'Are all patches applied for switchover?'
        ,'Is the primary database in a consistent state?'
        ),
        p_match_document       => JSON('{"sql": "SELECT switchover_status FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Standby Database Protection Mode',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Display the protection mode of the standby database.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the standby database''s current protection mode?'
        ,'How is the protection mode of the standby database set?'
        ,'What is the current protection level?'
        ,'Is maximum protection enabled?'
        ,'Where can I see the protection mode of the standby database?'
        ,'What protection mode is currently active?'
        ,'What is the default protection mode for my standby database?'
        ,'How to display protection information?'
        ,'How to access protection mode info?'
        ,'How to check if the standby database is in maximum performance?'
        ,'How to find out the protection mode of the standby database?'
        ,'How do I know if the standby database is in maximum availability?'
        ,'What is the standby database''s protection level?'
        ,'What is the current protection mode of the standby database?'
        ,'How to confirm protection configuration?'
        ,'How do I determine the protection mode for the standby database?'
        ,'What is the protection mode setting?'
        ,'Can I check protection mode now?'
        ,'How do I find the standby database protection mode?'
        ,'Can I get the protection mode status of the standby database?'
        ,'Can I view protection settings?'
        ,'How can I check the protection mode for my standby database?'
        ,'Can you display protection mode details?'
        ,'What mode is the standby database in?'
        ,'How to find protection mode information?'
        ,'How to verify the protection mode of a standby database?'
        ,'How to confirm protection mode?'
        ,'What is the default protection setting?'
        ,'Is the standby database configured for maximum protection?'
        ),
        p_match_document       => JSON('{"sql": "SELECT protection_mode FROM v$database", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Users Who Accessed Critical Tables',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Track user access to sensitive tables like FINANCIALS and HR_EMPLOYEES.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which user has the most access attempts to FINANCIALS?'
        ,'How often is HR_EMPLOYEES accessed monthly?'
        ,'Are there any access anomalies for FINANCIALS?'
        ,'Are there any access restrictions on FINANCIALS?'
        ,'Which users have never accessed FINANCIALS?'
        ,'Who accessed HR_EMPLOYEES last week?'
        ,'How often is FINANCIALS accessed on weekends?'
        ,'What are peak access times for FINANCIALS?'
        ,'How many accesses to FINANCIALS were made during maintenance hours?'
        ,'When is HR_EMPLOYEES least accessed?'
        ,'How many users have accessed HR_EMPLOYEES in the last hour?'
        ,'Has user X accessed HR_EMPLOYEES?'
        ,'What is the access trend for FINANCIALS?'
        ,'How many unique users accessed HR_EMPLOYEES?'
        ,'What is the access trend for sensitive tables this quarter?'
        ,'Which user accessed HR_EMPLOYEES the most?'
        ,'How many times was FINANCIALS accessed this month?'
        ,'Which department accesses FINANCIALS most?'
        ,'What time is HR_EMPLOYEES most accessed?'
        ,'How many users accessed FINANCIALS today?'
        ,'How often is FINANCIALS accessed daily?'
        ,'Which users accessed both FINANCIALS and HR_EMPLOYEES?'
        ,'Which user accessed HR_EMPLOYEES from an unknown location?'
        ,'Which users have access to both FINANCIALS and HR_EMPLOYEES?'
        ,'Who has access to HR_EMPLOYEES today?'
        ,'Are there unauthorized accesses to FINANCIALS?'
        ,'What is the peak access hour for HR_EMPLOYEES?'
        ,'Which user accessed FINANCIALS at 10am yesterday?'
        ,'How many times was HR_EMPLOYEES accessed by a single user?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, action_name, obj_name, timestamp FROM dba_audit_trail WHERE obj_name IN (''FINANCIALS'', ''HR_EMPLOYEES'') ORDER BY timestamp DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check for Failed Logins',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify failed login attempts by users.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any failed login attempts from users who have recently changed their passwords?'
        ,'Which database has the most failed login attempts?'
        ,'Are there any failed login attempts from users with locked accounts?'
        ,'Can you list failed logins by department?'
        ,'What is the peak day for failed login attempts?'
        ,'Are there any failed login attempts from IP addresses with a history of malicious activity?'
        ,'Can you identify failed logins from unknown users?'
        ,'Are there failed logins from expired accounts?'
        ,'Can you show a list of failed login attempts this week?'
        ,'How many failed login attempts were made using Kerberos authentication?'
        ,'Are there any patterns in failed logins by location?'
        ,'What is the average number of failed login attempts per user?'
        ,'Did any admin accounts have failed login attempts?'
        ,'Are there any patterns in failed login attempts by day of the week?'
        ,'Are there any failed login attempts from users who have been inactive for a long time?'
        ,'Any failed logins from unknown IPs?'
        ,'Which IP addresses are associated with failed logins?'
        ,'How often do failed logins occur per user?'
        ,'Are failed logins increasing along the time?'
        ,'What are the peak hours for failed login attempts?'
        ,'Are there any failed login attempts from users with inactive accounts?'
        ,'Can you identify failed logins during weekends?'
        ,'Are there any unusual patterns in failed logins?'
        ,'Which users have the highest failed logins?'
        ,'Which client applications are linked to failed logins?'
        ,'How many failed login attempts were made using the Oracle console?'
        ,'Are there failed logins after password changes?'
        ,'Can you provide details of the last failed login?'
        ,'Which user has the highest failed login attempts?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, os_user, timestamp FROM dba_audit_trail WHERE returncode <> 0", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Database Links and Connections',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List all database links and their connection details.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are the connection strings for each link?'
        ,'What are the user credentials for each link?'
        ,'Are there any database links with invalid connection strings?'
        ,'List database links sorted by creation date.'
        ,'List all database links with connection details.'
        ,'How to find database link connection details?'
        ,'What are the privileges for each database link?'
        ,'List database links with their associated schemas.'
        ,'How to optimize database link performance?'
        ,'What is the purpose of each database link?'
        ,'List database links with their service names.'
        ,'Are there any broken database links?'
        ,'How to troubleshoot database link connection issues?'
        ,'Which database links use Kerberos authentication?'
        ,'Show database link connection types.'
        ,'How to check link connection protocols?'
        ,'Which database links are used for replication?'
        ,'What are the database link security best practices?'
        ,'Show database link creation scripts.'
        ,'Which links connect to external databases?'
        ,'How to view database link connection history?'
        ,'List database links with their associated Oracle versions.'
        ,'How to identify unused database links?'
        ,'List database links with their network protocol settings.'
        ,'What are the database link troubleshooting tools?'
        ,'How many database links use SSL encryption?'
        ,'Show database link names and their corresponding owners.'
        ,'List database links with their associated tablespaces.'
        ,'What are the target databases for each link?'
        ),
        p_match_document       => JSON('{"sql": "SELECT db_link, username, host FROM dba_db_links", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Failed Logins Per User',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor the number of failed login attempts for each user.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Can I filter failed logins by user location?'
        ,'Can I get a report of failed logins by application?'
        ,'How many failed login attempts occurred today?'
        ,'Which user had the last failed login attempt?'
        ,'Are there any anomalies in the failed login trends?'
        ,'Which user has the most failed logins in the last month?'
        ,'What is the trend of failed logins this week?'
        ,'How many users have failed logins due to incorrect passwords?'
        ,'Are there any failed logins from new users?'
        ,'Which IP address has the most failed logins?'
        ,'Which user has the most recent failed login?'
        ,'What percentage of logins are failed?'
        ,'What is the total number of failed login attempts?'
        ,'Are there any failed logins from users with expired accounts?'
        ,'Can I filter failed logins by user department?'
        ,'Can we alert on failed login thresholds?'
        ,'What time of day sees most failed logins?'
        ,'How many failed logins per user today?'
        ,'Which user has the longest streak of failed logins?'
        ,'What is the average time between failed login attempts?'
        ,'Are failed logins more frequent during weekends?'
        ,'How many failed logins occurred during peak hours?'
        ,'Are there any unusual spikes in failed logins?'
        ,'Are there any patterns in failed logins?'
        ,'Can I get a list of users with no failed logins?'
        ,'How do failed logins compare to last month?'
        ,'Can I see failed logins by user role?'
        ,'Can I see a list of users with failed logins due to account lockouts?'
        ,'Which user has the highest number of consecutive failed logins?'
        ),
        p_match_document       => JSON('{"sql": "SELECT username, COUNT(*) AS failed_attempts FROM dba_audit_trail WHERE returncode <> 0 GROUP BY username ORDER BY failed_attempts DESC", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Identify SQL Queries with Anomaly Behavior (AI Model)',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Identify SQL statements with unusual behavior using AI.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which SQL statements exhibit unexpected data dictionary cache usage?'
        ,'Can you identify SQL queries with unexpected bind variable behavior?'
        ,'What SQL queries have unusual PL/SQL compilation times?'
        ,'What SQL statements have unusual AQ (Advanced Queueing) usage?'
        ,'Which queries are experiencing sudden increases in CPU usage?'
        ,'How to identify SQL statements with inconsistent response times?'
        ,'How to detect SQL queries with unusual elapsed times?'
        ,'What are the SQL queries with unusual parsing activity?'
        ,'Can you identify SQL queries with unusual buffer gets?'
        ,'Which SQL statements exhibit unexpected concurrency issues?'
        ,'Which SQL statements are showing irregular snapshot usage?'
        ,'Which SQL queries are experiencing unexpected slowdowns?'
        ,'Can you identify SQL statements with erratic memory consumption?'
        ,'What are the SQL statements with high temporary tablespace usage?'
        ,'How can I identify SQL queries with unexpected Java pool usage?'
        ,'What SQL queries have unusual PGA memory allocation?'
        ,'Which SQL queries are showing unusual execution frequency?'
        ,'What are the top SQL statements with abnormal CPU usage?'
        ,'What SQL statements have unusual optimization techniques?'
        ,'Which SQL statements are showing irregular SQL compiler usage?'
        ,'What are the SQL queries with unusual file system I/O activity?'
        ,'What are the SQL queries with unusual sequence number generation?'
        ,'How can I spot SQL statements with high library cache misses?'
        ,'Can you identify SQL statements with unexpected network usage?'
        ,'How can I spot SQL statements with irregular disk reads?'
        ,'Which SQL queries are causing unexpected session waits?'
        ,'How can I find SQL statements with unusual execution patterns?'
        ,'How can I identify SQL queries with unusual index usage patterns?'
        ,'How do I find SQL queries with unusual rollback activity?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, elapsed_time, executions FROM v$sql WHERE elapsed_time > (SELECT AVG(elapsed_time) + 2*STDDEV(elapsed_time) FROM v$sql)", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Detect Blocked Sessions with Machine Learning',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Use machine learning to find sessions blocked by specific events.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are any sessions blocked by B-tree index events?'
        ,'Which sessions are blocked by GoldenGate events?'
        ,'Which sessions are blocked by SQL*Net events?'
        ,'What sessions are blocked by Oracle Streams events?'
        ,'Find sessions blocked by PL/SQL execution events.'
        ,'Identify sessions blocked by pipe waits.'
        ,'What sessions are blocked by event class waits?'
        ,'Which sessions are blocked by bitmap merge events?'
        ,'Which sessions are blocked by sequence number generation events?'
        ,'How many sessions are blocked by checkpoint events?'
        ,'Which sessions are blocked by transaction waits?'
        ,'Are any sessions blocked by SQL execution events?'
        ,'Identify sessions blocked by wait-for-data events.'
        ,'What sessions are affected by semaphore waits?'
        ,'How many sessions are blocked by sort events?'
        ,'Which sessions are blocked by library cache events?'
        ,'How many sessions are blocked by log buffer waits?'
        ,'Which sessions are blocked by control file waits?'
        ,'What sessions are blocked by Oracle Spatial events?'
        ,'What sessions are blocked by log file sync events?'
        ,'Identify sessions blocked by Data Guard events?'
        ,'What sessions are affected by enqueue waits?'
        ,'How many sessions are blocked by resource manager?'
        ,'Are there sessions blocked by inter-process communication events?'
        ,'Are there sessions blocked by Oracle Multimedia events?'
        ,'Are any sessions blocked by materialized view events?'
        ,'What sessions are blocked by redo log waits?'
        ,'Find sessions blocked by latch contention events.'
        ,'Are there sessions blocked by undo segment waits?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sid, serial#, event, blocking_session FROM v$session WHERE event IN (''enq: TX - row lock contention'', ''library cache lock'')", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Find Oracle Databases Running in Kubernetes',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'List Oracle databases running in Kubernetes environments.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which Oracle databases are in Kubernetes pods?'
        ,'Which Kubernetes namespaces contain Oracle databases?'
        ,'How many Oracle instances are in Kubernetes?'
        ,'Provide names of Oracle databases in Kubernetes.'
        ,'How are Oracle databases monitored in Kubernetes?'
        ,'Which Oracle databases in Kubernetes have automated scaling enabled?'
        ,'Are Oracle databases in Kubernetes integrated with other cloud services?'
        ,'How many Oracle databases are managed by Kubernetes in our environment?'
        ,'Are there any Oracle databases in Kubernetes with security vulnerabilities?'
        ,'How many Oracle databases run on Kubernetes?'
        ,'Can you list Oracle database instances in Kubernetes?'
        ,'Which Kubernetes environments host Oracle databases?'
        ,'Can you identify Oracle databases in Kubernetes with connection issues?'
        ,'Name Oracle databases found in Kubernetes.'
        ,'How are Oracle databases configured in Kubernetes?'
        ,'Are there any Oracle databases deployed in Kubernetes pods?'
        ,'Are there any Oracle databases in Kubernetes?'
        ,'Are there Oracle databases in Kubernetes namespaces?'
        ,'Can you show Oracle databases hosted in Kubernetes?'
        ,'Can you show the performance metrics of Oracle databases in Kubernetes?'
        ,'Which Oracle databases in Kubernetes have resource constraints?'
        ,'How many Kubernetes clusters host Oracle databases?'
        ,'What is the status of Oracle databases in Kubernetes environments?'
        ,'Are Oracle databases running on Kubernetes nodes?'
        ,'Can you identify Oracle databases with Kubernetes-based storage?'
        ,'Which Oracle databases are integrated with Kubernetes?'
        ,'Are there any Oracle databases in Kubernetes with pending updates?'
        ,'Are Oracle databases containerized in Kubernetes?'
        ,'How do Oracle databases in Kubernetes handle network partitions?'
        ),
        p_match_document       => JSON('{"sql": "SELECT db_name, open_mode FROM v$database WHERE db_name LIKE ''K8S%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Kubernetes Cluster Nodes Running Oracle',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor resource usage for Kubernetes nodes running Oracle.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What is the average resource usage for nodes in a specific availability zone?'
        ,'Are there any nodes with high CPU idle time?'
        ,'What is the current resource utilization for each node type?'
        ,'Which nodes are experiencing high resource usage due to network policies?'
        ,'What is the total resource capacity of each node?'
        ,'What are the I/O statistics for each node?'
        ,'How can I monitor node resource usage for stateful sets?'
        ,'Are there nodes with consistently high CPU spikes?'
        ,'How can I monitor node resource quotas?'
        ,'Are there nodes with high file system usage?'
        ,'How can I check node resource usage by container?'
        ,'Which nodes are experiencing resource bottlenecks?'
        ,'What is the average network bandwidth usage per node?'
        ,'How do I monitor resource usage anomalies?'
        ,'What is the current resource usage for nodes with specific labels?'
        ,'How do I monitor node resource usage for specific pods?'
        ,'Are there any nodes with high network latency?'
        ,'What is the node resource utilization by storage class?'
        ,'Which nodes have the lowest network latency?'
        ,'How do I check for node resource utilization trends?'
        ,'How can I visualize node resource usage over time?'
        ,'Which node has the lowest memory allocation?'
        ,'Is there a node with high swap usage?'
        ,'How to identify nodes with high memory pressure?'
        ,'Are there nodes experiencing high resource usage due to system processes?'
        ,'Which nodes have the highest disk usage percentage?'
        ,'What is the current disk usage for each node?'
        ,'What is the average resource usage for nodes in a specific cluster?'
        ,'Are any nodes running out of available memory?'
        ),
        p_match_document       => JSON('{"sql": "SELECT node_name, pod_name, cpu_usage, memory_usage FROM dba_k8s_nodes", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check Oracle Cloud Autonomous Scaling Events',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Review the events related to scaling in Oracle Cloud Autonomous databases.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any anomalies in scaling patterns?'
        ,'What is the history of scaling events for the past month?'
        ,'What is the average time taken for scaling operations to complete?'
        ,'Can I see a timeline of recent scaling events?'
        ,'How do I optimize database performance during scaling events?'
        ,'Are there any failed scaling attempts?'
        ,'What is the impact of scaling on database auditing and compliance settings?'
        ,'Can I compare scaling events across multiple databases?'
        ,'Can I automate the analysis of scaling event logs?'
        ,'Are there any scaling events during off-peak hours?'
        ,'Can I analyze scaling events by specific time zones?'
        ,'What is the average number of scaling events per day?'
        ,'What is the relationship between scaling and database storage usage?'
        ,'Are there any scaling events that occurred during maintenance windows?'
        ,'Can I simulate scaling events to test database performance?'
        ,'How do I determine the optimal scaling settings for my database?'
        ,'How does scaling impact database security settings?'
        ,'How frequently does scaling occur in my autonomous database?'
        ,'What are the peak times for scaling events?'
        ,'How can I optimize scaling to reduce costs?'
        ,'How do I view scaling events for a specific database?'
        ,'Are there any scaling events that were triggered by external factors?'
        ,'What resources were affected by the latest scaling?'
        ,'How are scaling events logged in the system?'
        ,'What is the average duration of scaling events?'
        ,'How do I configure custom notifications for scaling events?'
        ,'How can I identify unsuccessful scaling events?'
        ,'What are the most recent scaling events that affected CPU usage?'
        ,'What is the current scaling status of my autonomous database?'
        ),
        p_match_document       => JSON('{"sql": "SELECT event_time, event_type FROM dba_autonomous_scaling_events", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Monitor Oracle Cloud SQL Execution Time',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Monitor and rank SQL statements by execution time in Oracle Cloud environments.',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Are there any SQL statements with inconsistent execution times?'
        ,'How do SQL execution times vary by database?'
        ,'Which SQL statements are using the most temporary space?'
        ,'How do execution times compare across different SQL statements?'
        ,'How can I improve SQL execution performance?'
        ,'What factors influence SQL execution time the most?'
        ,'How do I rank SQL statements by execution time?'
        ,'What is the current execution time for all SQL statements?'
        ,'Which SQL statements are running slower than usual?'
        ,'Which SQL query is the most resource-intensive?'
        ,'How can I reduce SQL execution time in Oracle Cloud?'
        ,'Can I see the execution time history for a specific SQL statement?'
        ,'How many SQL statements exceed a 10-second execution time?'
        ,'What SQL statement has the lowest execution time?'
        ,'Which SQL statements are running during peak hours?'
        ,'Are there any SQL statements with execution time spikes?'
        ,'How can I identify long-running SQL queries?'
        ,'Can I monitor SQL execution times by user?'
        ,'What are the top 10 slowest SQL statements?'
        ,'How do I optimize slow SQL statements?'
        ,'How frequently do slow SQL statements occur?'
        ,'Are there SQL statements with execution time improvements?'
        ,'Are there any SQL statements exceeding 5 seconds?'
        ,'Can I see SQL execution times for today?'
        ,'What is the maximum execution time recorded for SQL statements?'
        ,'Can I see the top 5 SQL statements by execution time?'
        ,'How do I identify SQL statements with high recursion?'
        ,'Are there any SQL statements with high execution times due to indexing?'
        ,'How do I identify SQL statements with high CPU usage?'
        ),
        p_match_document       => JSON('{"sql": "SELECT sql_id, elapsed_time FROM v$sql_monitor ORDER BY elapsed_time DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Database status',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Shows current database status including open mode, startup time, uptime, sessions active and blocked, ORA- errors in database and space usage',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show me database status'
        ,'How is my database doing'
        ,'Whats the current status of database'
        ,'Is the database up and running right now'
        ,'What is the current operational state of the database'
        ,'What is the health and availability status of the database'
        ),
        p_match_document       => JSON('{"sql": "SELECT ''Database status            : '' || name || '' | '' || open_mode || '' | '' ||  database_role status FROM v$database Union SELECT ''Database instance status   : '' || instance_name  || '' | '' || status  || '' | '' || database_status status FROM v$instance Union SELECT ''Database startup time      : '' || TO_CHAR(startup_time, ''DD-MON-YYYY HH24:MI:SS'') status FROM v$instance Union SELECT ''Database uptime            : '' || round((SYSDATE - startup_time) * 24,2) || '' hours'' status FROM v$instance Union SELECT ''Number of ACTIVE sessions  : '' || COUNT(*) status FROM v$session WHERE status = ''ACTIVE'' Union SELECT ''Number of BLOCKED sessions : '' || count(1) status FROM v$session WHERE blocking_session IS NOT NULL Union select ''ORA- ERRORs in last 1 day  : '' ||count(1) status from V$DIAG_ALERT_EXT where ORIGINATING_TIMESTAMP > sysdate-1 and message_text like ''%ORA-%'' Union SELECT ''Space Usage                : '' ||        round(sum(used_space * block_size / 1024 / 1024/1024)) || '' GB used, '' || ROUND(sum((tablespace_size - used_space) * block_size / 1024 / 1024 / 1024)) || ''GB free'' status FROM dba_tablespace_usage_metrics", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Check top tables by size for a tablespace',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'This report shows list of top 10 tables by size for the give tablespace',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show top tables by size for tablespace abcd'
        ,'Show space usage by table in abcd tablespace'
        ,'What tables consume more space in abcd table space'
        ,'Provide list of 10 tables consuming more space'
        ),
        p_match_document       => JSON('{"sql": "SELECT segment_name AS table_name, ROUND(bytes / 1024 / 1024, 2) AS size_mb FROM dba_segments WHERE tablespace_name = :tablespace_name AND segment_type = ''TABLE'' ORDER BY bytes DESC FETCH FIRST 10 ROWS ONLY", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;

/
DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Show SQLs running for last n seconds',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'This report captures SQL statements that have been running for at least n seconds, highlighting long-running or currently executing queries. It helps DBAs identify expensive SQLs impacting system performance in real-time by filtering active sessions based on elapsed time. Useful for spotting blocking sessions, inefficient queries, or runaways consuming excessive resources',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Which SQLs have been running for more than 30 seconds right now'
        ,'Are there any queries currently executing for over a minute'
        ,'Show me all active SQLs running longer than 10 seconds'
        ,'What long-running queries are still active in the database and running for more than 30 seconds'
        ,'Show sqls running for more than 5 seconds'
        ),
        p_match_document       => JSON('{"sql": "SELECT SID, SERIAL#, USERNAME, TO_CHAR(SYSDATE-LAST_CALL_ET/24/60/60,''HH24:MI:SS'') STARTED, TRUNC(LAST_CALL_ET/60) || '' MINS, '' || MOD(LAST_CALL_ET,60) || '' SECS'' DUR, (SELECT SQL_TEXT FROM V$SQL WHERE ADDRESS = SQL_ADDRESS) SQL_TEXT FROM V$SESSION WHERE USERNAME IS NOT NULL and username not in (''SYS'') AND LAST_CALL_ET > :seconds_filter  AND STATUS = ''ACTIVE''", "filters" : [{
                "use_ner": True,
                "entity_type": "number",
                "filter_name": "seconds_filter",
                "default_value": "60",
            }]}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/


DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Show details for a given session id or sid',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'This report provides list SQL for the session id or sid',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'show details for sid 111'
        ,'show sql for session id 1234'
        ,'provide sql, event for sid 123'
        ),
        p_match_document       => JSON('{"sql": "select s.SID, s.SERIAL#, s.EVENT, s.SQL_ID, bs.sql_text FROM V$SESSION s,V$SQL bs where s.sid = :sid_filter and s.sql_id = bs.sql_id", "filters" : [{ "use_ner": True, "entity_type": "number", "filter_name": "sid_filter", "default_value": ""}]}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/
 
DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'List errors in database for last one day',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'This report queries v$diag_alert_ext, checks for ORA- errors in database alert log',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'What are errors in my database'
        ,'Show list of ORA- errors'
        ,'Show exceptions in database'
        ,'Show alert log errors'
        ,'How many errors in database?'
        ),
        p_match_document       => JSON('{"sql": "select ORIGINATING_TIMESTAMP, message_text from v$diag_alert_ext where ORIGINATING_TIMESTAMP > sysdate-1 and message_text like ''%ORA-%''", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/

DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Get sql for sql_id',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'This report shows SQL for give sql_id',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show sql for sql_id jhb098kjn'
        ,'Get details for sql id jhb098kjn'
        ,'Whats the sql for id jhb098kjn'
        ),
        p_match_document       => JSON('{"sql": "select sql_text from v$sql where sql_id=:sql_id_filter", "filters" : [{ "use_ner": True, "entity_type": "sql_id", "filter_name": "sql_id_filter", "default_value": "" }]}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/
 
DECLARE
  v_report_id      VARCHAR2(36);
  v_description_id VARCHAR2(36);
BEGIN
  lang_data_reports_pkg.create_report(
        p_title                => 'Get sql to kill a session',
        p_description_status   => 'Published',
        p_report_status        => 'Published',
        p_report_id            => v_report_id,
        p_description_text     => 'Return SQL for killing a session using sid and serial#',
        p_sample_queries       => SYS.ODCIVARCHAR2LIST(
        'Show sql to kill session'
        ,'show to kill a long running sql'
        ,'how to kill a session'
        ),
        p_match_document       => JSON('{"sql": "ALTER SYSTEM KILL SESSION ''SID,SERIAL#'' IMMEDIATE;", "filters" : []}'),
        p_description_id       => v_description_id,
        p_domain               => 'dbassist'
       );
   dbms_output.put_line('Report id: ' || v_report_id || ' , Description: ' || v_description_id);
EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE('Report creation failed.');
END;
/
 
-- @ask "list top 10 tables by size in tablespace LANGDATA"
